# Tinker: Software Tools for Molecular Design

<I>Please note with the release of Tinker 25 in late February 2025 the code contains a number of new features, and is not fully backward compatible with prior versions of Tinker. In particular, do not use older versions of parameter files with current Tinker executables. Similarly, parameter files from the current Tinker may give errors or incorrect results when used with executables from earlier "Tinker 8" versions.</I>

<H2><B>Introduction</B></H2>

Tinker is a complete and general package for molecular mechanics and dynamics, with some special features for biopolymers. Tinker has the ability to use any of several common parameter sets, such as Amber (ff94, ff96, ff98, ff99, ff99SB, ff14SB, ff19SB), CHARMM (19, 22, 27, 36m), Allinger MM (MM2-1991 and MM3-2000), OPLS (OPLS-UA, OPLS-AA, OPLS-AA/L), Merck Molecular Force Field (MMFF94, MMFF94s), Liam Dang's polarizable model, and the AMOEBA, AMOEBA+ and HIPPO polarizable atomic multipole force fields. Parameter sets for other widely-used force fields are under consideration for future releases.

The Tinker software contains a variety of interesting algorithms such as: flexible molecular dynamics (MD) simulation capability, support for atomic multipole-based electrostatics with explicit dipole polarizability, various continuum solvation treatments including several generalized Born (GB/SA) models, generalized Kirkwood implicit solvation for AMOEBA, an interface to APBS for Poisson-Boltzmann calculations, efficient truncated Newton (TNCG) local optimization, fast Alpha shapes-based surface areas and volumes with derivatives, free energy calculations via the Bennett Acceptance Ratio (BAR) method, normal mode vibrational analysis, minimization in Cartesian, torsional or rigid body space, symplectic RESPA multiple time step integration for efficient MD, velocity Verlet stochastic dynamics, several thermostats and barostats for MD temperature and pressure control, pairwise neighbor lists and splined spherical energy cutoff methods, particle mesh Ewald (PME) summation for partial charges and polarizable multipoles, a novel reaction field treatment of long range electrostatics, fast distance geometry metrization with better sampling than standard methods, Elber's reaction path algorithm, potential smoothing and search (PSS) methods for global optimization, Monte Carlo Minimization (MCM) for potential surface scanning, force field parameterization tools for fitting electrostatic potentials, multipole and polarization models to QM-based data, and more.

<H2><B>Current Release</B></H2>

Tinker is the major release of the Ponder Lab tool set for molecular mechanics and dynamics calculations. This version is for use on CPUs only, and is written entirely in a generic, extended Fortran 95 that builds on essentially any machine with a Fortran compiler. Use of modules and dynamic memory allocation allows Tinker to support very large molecular systems. The software implements OpenMP parallelization throughout the code. Features and improvements include parallel neighbor list building and updating, and reduction in the iterations needed to converge AMOEBA polarization via an efficient PCG solver. Other changes from previous Tinker versions include new and updated force field parameter sets and numerous generalizations and bug fixes, many of them suggested by users of the package. Please note that as with prior new releases, this version is neither backward nor forward compatible with earlier versions of Tinker. In particular, older versions of parameter files should not be used with current Tinker executables and vice versa. We strongly suggest users switch to the current release of Tinker.

<H2><B>Building from Source Code</B></H2>

Tinker is provided as a complete source distribution. After unpacking the release, you can build a set of Tinker executables on almost any machine with GNU gfortran or another modern Fortran compiler. Makefiles, a cmake configure script, as well as standalone scripts to compile, build object libraries, and link executables on a wide variety of machine-CPU-operating system combinations are provided. To build using the Tinker Makefile, just copy /make/Makefile into the /source area of the distribution. Small changes are needed near the top of the Makefile to set directory names and activate the appropriate operating system and compiler. Then issue the "make" command while in the /source directory.

Note the FFTW libraries must be available prior to building Tinker. Pre-built FFTW libraries for some operating system and compiler combinations are provided under the /lib subdirectory of the source distribution. Alternatively, the libraries can be built following instructions in /fftw/0README.
