/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.LinkedHashSet;
import org.jogamp.java3d.NodeRetained;
import org.jogamp.java3d.SceneGraphObjectRetained;
import org.jogamp.java3d.Shape3DRetained;

class NodeComponentRetained
extends SceneGraphObjectRetained {
    boolean duplicateOnCloneTree = false;
    int refCount = 0;
    int refCnt = 0;
    private boolean inImmCtx = false;
    LinkedHashSet<NodeRetained> users = new LinkedHashSet();
    NodeComponentRetained mirror = null;
    int changedFrequent = 0;
    int compChanged = 0;

    NodeComponentRetained() {
    }

    void doSetLive(boolean inBackgroundGroup, int refCount) {
        int oldRefCount = this.refCount;
        this.refCount += refCount;
        if (oldRefCount <= 0) {
            super.doSetLive(inBackgroundGroup);
            this.createMirrorObject();
        }
    }

    void setLive(boolean inBackgroundGroup, int refCount) {
        int oldRefCount = this.refCount;
        this.doSetLive(inBackgroundGroup, refCount);
        if (oldRefCount <= 0) {
            super.markAsLive();
        }
    }

    void clearLive(int refCount) {
        this.refCount -= refCount;
        if (this.refCount <= 0) {
            super.clearLive();
        }
    }

    synchronized void incRefCnt() {
        ++this.refCnt;
    }

    synchronized void decRefCnt() {
        --this.refCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAMirrorUser(Shape3DRetained ms) {
        LinkedHashSet<NodeRetained> linkedHashSet = this.mirror.users;
        synchronized (linkedHashSet) {
            this.mirror.users.remove(ms);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAMirrorUser(Shape3DRetained ms) {
        LinkedHashSet<NodeRetained> linkedHashSet = this.mirror.users;
        synchronized (linkedHashSet) {
            this.mirror.users.add(ms);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyMirrorUsers(NodeComponentRetained node) {
        LinkedHashSet<NodeRetained> linkedHashSet = this.mirror.users;
        synchronized (linkedHashSet) {
            LinkedHashSet<NodeRetained> linkedHashSet2 = node.mirror.users;
            synchronized (linkedHashSet2) {
                this.mirror.users.addAll(node.mirror.users);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMirrorUsers(NodeComponentRetained node) {
        LinkedHashSet<NodeRetained> linkedHashSet = this.mirror.users;
        synchronized (linkedHashSet) {
            LinkedHashSet<NodeRetained> linkedHashSet2 = node.mirror.users;
            synchronized (linkedHashSet2) {
                this.mirror.users.removeAll(node.mirror.users);
            }
        }
    }

    synchronized void removeUser(NodeRetained node) {
        if (node.source.isLive()) {
            this.users.remove(node);
        }
    }

    synchronized void addUser(NodeRetained node) {
        if (node.source.isLive()) {
            this.users.add(node);
        }
    }

    synchronized void notifyUsers() {
        if (this.source == null || !this.source.isLive()) {
            return;
        }
        for (NodeRetained nr : this.users) {
            nr.notifySceneGraphChanged(false);
        }
    }

    void setInImmCtx(boolean inCtx) {
        this.inImmCtx = inCtx;
    }

    boolean getInImmCtx() {
        return this.inImmCtx;
    }

    void setDuplicateOnCloneTree(boolean duplicate) {
        this.duplicateOnCloneTree = duplicate;
    }

    boolean getDuplicateOnCloneTree() {
        return this.duplicateOnCloneTree;
    }

    void initMirrorObject() {
    }

    void updateMirrorObject(int component, Object obj) {
    }

    void createMirrorObject() {
        this.initMirrorObject();
        this.mirror = null;
    }

    void setFrequencyChangeMask(int bit, int mask) {
        if (this.source.getCapabilityIsFrequent(bit)) {
            this.changedFrequent |= mask;
        } else if (!this.source.isLive()) {
            this.changedFrequent &= ~mask;
        }
    }

    @Override
    protected Object clone() {
        NodeComponentRetained ncr = (NodeComponentRetained)super.clone();
        ncr.changedFrequent = this.changedFrequent;
        return ncr;
    }

    protected void set(NodeComponentRetained nc) {
        this.changedFrequent = nc.changedFrequent;
    }
}

