/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.openal;

import com.jogamp.common.os.Platform;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.common.util.VersionNumberString;
import com.jogamp.openal.AL;
import com.jogamp.openal.ALC;
import com.jogamp.openal.ALCcontext;
import com.jogamp.openal.ALCdevice;
import com.jogamp.openal.ALFactory;

public class ALVersion {
    private final String vendor;
    private final String renderer;
    private final VersionNumberString version;
    private final VersionNumberString vendorVersion;

    private static final VersionNumberString getVendorVersion(VersionNumberString versionNumberString) {
        VersionNumberString versionNumberString2;
        int n;
        String string = versionNumberString.getVersionString().substring(versionNumberString.endOfStringMatch()).trim();
        while (string.length() > 0 && 0 < (n = (versionNumberString2 = new VersionNumberString(string, VersionNumber.getDefaultVersionNumberPattern())).endOfStringMatch())) {
            if (versionNumberString2.hasMajor() && versionNumberString2.hasMinor()) {
                return versionNumberString2;
            }
            string = string.substring(n).trim();
        }
        return VersionNumberString.zeroVersion;
    }

    public ALVersion(AL aL) {
        this.vendor = aL.alGetString(45057);
        this.renderer = aL.alGetString(45059);
        this.version = new VersionNumberString(aL.alGetString(45058));
        this.vendorVersion = ALVersion.getVendorVersion(this.version);
    }

    public ALVersion(ALC aLC) {
        ALCdevice aLCdevice = aLC.alcOpenDevice(null);
        ALCcontext aLCcontext = aLC.alcCreateContext(aLCdevice, null);
        aLC.alcMakeContextCurrent(aLCcontext);
        AL aL = ALFactory.getAL();
        this.vendor = aL.alGetString(45057);
        this.renderer = aL.alGetString(45059);
        this.version = new VersionNumberString(aL.alGetString(45058));
        this.vendorVersion = ALVersion.getVendorVersion(this.version);
        aLC.alcMakeContextCurrent(null);
        aLC.alcDestroyContext(aLCcontext);
        aLC.alcCloseDevice(aLCdevice);
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getRenderer() {
        return this.renderer;
    }

    public VersionNumberString getVersion() {
        return this.version;
    }

    public VersionNumberString getVendorVersion() {
        return this.vendorVersion;
    }

    public String toString() {
        return this.toString(false, null).toString();
    }

    public StringBuilder toString(boolean bl, StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        if (bl) {
            stringBuilder.append("AL_VENDOR      ").append(this.getVendor());
            stringBuilder.append(Platform.getNewline());
            stringBuilder.append("AL_RENDERER    ").append(this.getRenderer());
            stringBuilder.append(Platform.getNewline());
            stringBuilder.append("AL_VERSION     ").append(this.getVersion());
            stringBuilder.append(Platform.getNewline());
            stringBuilder.append("AL_VENDOR_VERS ").append(this.getVendorVersion());
            stringBuilder.append(Platform.getNewline());
        } else {
            stringBuilder.append("vendor ").append(this.getVendor());
            stringBuilder.append(", renderer ").append(this.getRenderer());
            stringBuilder.append(", version ").append(this.getVersion());
            stringBuilder.append(", vendorVersion ").append(this.getVendorVersion());
        }
        return stringBuilder;
    }
}

