/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.ColoringAttributes;
import org.jogamp.java3d.LineAttributes;
import org.jogamp.java3d.Material;
import org.jogamp.java3d.PointAttributes;
import org.jogamp.java3d.PolygonAttributes;
import org.jogamp.java3d.RenderingAttributes;
import org.jogamp.java3d.SceneGraphObject;
import org.jogamp.java3d.TexCoordGeneration;
import org.jogamp.java3d.Texture;
import org.jogamp.java3d.TextureAttributes;
import org.jogamp.java3d.TextureUnitState;
import org.jogamp.java3d.TransparencyAttributes;
import org.jogamp.java3d.utils.scenegraph.io.retained.Controller;
import org.jogamp.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.NodeComponentState;

public class AppearanceState
extends NodeComponentState {
    private int polygonAttributes = 0;
    private int renderingAttributes = 0;
    private int coloringAttributes = 0;
    private int lineAttributes = 0;
    private int material = 0;
    private int pointAttributes = 0;
    private int texCoordGeneration = 0;
    private int texture = 0;
    private int textureAttributes = 0;
    private int[] textureUnitState;
    private int transparencyAttributes = 0;

    public AppearanceState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
        if (this.node != null) {
            Appearance app = (Appearance)this.node;
            this.polygonAttributes = control.getSymbolTable().addReference((SceneGraphObject)app.getPolygonAttributes());
            this.renderingAttributes = control.getSymbolTable().addReference((SceneGraphObject)app.getRenderingAttributes());
            this.coloringAttributes = control.getSymbolTable().addReference((SceneGraphObject)app.getColoringAttributes());
            this.lineAttributes = control.getSymbolTable().addReference((SceneGraphObject)app.getLineAttributes());
            this.material = control.getSymbolTable().addReference((SceneGraphObject)app.getMaterial());
            this.pointAttributes = control.getSymbolTable().addReference((SceneGraphObject)app.getPointAttributes());
            this.texCoordGeneration = control.getSymbolTable().addReference((SceneGraphObject)app.getTexCoordGeneration());
            this.texture = control.getSymbolTable().addReference((SceneGraphObject)app.getTexture());
            this.textureAttributes = control.getSymbolTable().addReference((SceneGraphObject)app.getTextureAttributes());
            TextureUnitState[] texUnitState = app.getTextureUnitState();
            if (texUnitState != null) {
                this.textureUnitState = new int[texUnitState.length];
                int i = 0;
                while (i < texUnitState.length) {
                    this.textureUnitState[i] = control.getSymbolTable().addReference((SceneGraphObject)texUnitState[i]);
                    ++i;
                }
            } else {
                this.textureUnitState = new int[0];
            }
            this.transparencyAttributes = control.getSymbolTable().addReference((SceneGraphObject)app.getTransparencyAttributes());
        }
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        out.writeInt(this.polygonAttributes);
        out.writeInt(this.renderingAttributes);
        out.writeInt(this.coloringAttributes);
        out.writeInt(this.lineAttributes);
        out.writeInt(this.material);
        out.writeInt(this.pointAttributes);
        out.writeInt(this.texCoordGeneration);
        out.writeInt(this.texture);
        out.writeInt(this.textureAttributes);
        out.writeInt(this.textureUnitState.length);
        int i = 0;
        while (i < this.textureUnitState.length) {
            out.writeInt(this.textureUnitState[i]);
            ++i;
        }
        out.writeInt(this.transparencyAttributes);
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        this.polygonAttributes = in.readInt();
        this.renderingAttributes = in.readInt();
        this.coloringAttributes = in.readInt();
        this.lineAttributes = in.readInt();
        this.material = in.readInt();
        this.pointAttributes = in.readInt();
        this.texCoordGeneration = in.readInt();
        this.texture = in.readInt();
        this.textureAttributes = in.readInt();
        this.textureUnitState = new int[in.readInt()];
        int i = 0;
        while (i < this.textureUnitState.length) {
            this.textureUnitState[i] = in.readInt();
            ++i;
        }
        this.transparencyAttributes = in.readInt();
    }

    @Override
    public void addSubReference() {
        this.control.getSymbolTable().incNodeComponentRefCount(this.polygonAttributes);
        this.control.getSymbolTable().incNodeComponentRefCount(this.renderingAttributes);
        this.control.getSymbolTable().incNodeComponentRefCount(this.coloringAttributes);
        this.control.getSymbolTable().incNodeComponentRefCount(this.lineAttributes);
        this.control.getSymbolTable().incNodeComponentRefCount(this.material);
        this.control.getSymbolTable().incNodeComponentRefCount(this.pointAttributes);
        this.control.getSymbolTable().incNodeComponentRefCount(this.texCoordGeneration);
        this.control.getSymbolTable().incNodeComponentRefCount(this.textureAttributes);
        this.control.getSymbolTable().incNodeComponentRefCount(this.texture);
        int i = 0;
        while (i < this.textureUnitState.length) {
            this.control.getSymbolTable().incNodeComponentRefCount(this.textureUnitState[i]);
            ++i;
        }
        this.control.getSymbolTable().incNodeComponentRefCount(this.transparencyAttributes);
    }

    @Override
    public void buildGraph() {
        Appearance app = (Appearance)this.node;
        app.setPolygonAttributes((PolygonAttributes)this.control.getSymbolTable().getJ3dNode(this.polygonAttributes));
        app.setRenderingAttributes((RenderingAttributes)this.control.getSymbolTable().getJ3dNode(this.renderingAttributes));
        app.setColoringAttributes((ColoringAttributes)this.control.getSymbolTable().getJ3dNode(this.coloringAttributes));
        app.setLineAttributes((LineAttributes)this.control.getSymbolTable().getJ3dNode(this.lineAttributes));
        app.setMaterial((Material)this.control.getSymbolTable().getJ3dNode(this.material));
        app.setPointAttributes((PointAttributes)this.control.getSymbolTable().getJ3dNode(this.pointAttributes));
        app.setTexCoordGeneration((TexCoordGeneration)this.control.getSymbolTable().getJ3dNode(this.texCoordGeneration));
        app.setTextureAttributes((TextureAttributes)this.control.getSymbolTable().getJ3dNode(this.textureAttributes));
        app.setTexture((Texture)this.control.getSymbolTable().getJ3dNode(this.texture));
        TextureUnitState[] texUnitState = new TextureUnitState[this.textureUnitState.length];
        int i = 0;
        while (i < this.textureUnitState.length) {
            texUnitState[i] = (TextureUnitState)this.control.getSymbolTable().getJ3dNode(this.textureUnitState[i]);
            ++i;
        }
        if (texUnitState.length > 0) {
            app.setTextureUnitState(texUnitState);
        }
        app.setTransparencyAttributes((TransparencyAttributes)this.control.getSymbolTable().getJ3dNode(this.transparencyAttributes));
        super.buildGraph();
    }

    @Override
    protected SceneGraphObject createNode() {
        return new Appearance();
    }
}

