/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.geometry;

import org.jogamp.java3d.GeometryArray;
import org.jogamp.java3d.QuadArray;
import org.jogamp.java3d.TriangleArray;
import org.jogamp.java3d.TriangleFanArray;
import org.jogamp.java3d.TriangleStripArray;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.TexCoord2f;
import org.jogamp.vecmath.Vector3f;

class GeomBuffer {
    static final int QUAD_STRIP = 1;
    static final int TRIANGLES = 2;
    static final int QUADS = 4;
    static final int TRIANGLE_FAN = 16;
    static final int TRIANGLE_STRIP = 32;
    private int flags;
    Point3f[] pts = null;
    Vector3f[] normals = null;
    TexCoord2f[] tcoords = null;
    int currVertCnt;
    int currPrimCnt;
    int[] currPrimType = null;
    int[] currPrimStartVertex = null;
    int[] currPrimEndVertex = null;
    GeometryArray geometry;
    int numVerts = 0;
    int numTris = 0;
    int numTexUnit = 1;
    int[] texCoordSetMap = null;
    static final int debug = 0;

    GeomBuffer(int numVerts, int numTexUnit) {
        this.numTexUnit = numTexUnit;
        this.pts = new Point3f[numVerts];
        this.normals = new Vector3f[numVerts];
        this.tcoords = new TexCoord2f[numVerts];
        this.currPrimType = new int[numVerts / 3];
        this.currPrimStartVertex = new int[numVerts / 3];
        this.currPrimEndVertex = new int[numVerts / 3];
        this.currVertCnt = 0;
        this.currPrimCnt = 0;
        this.texCoordSetMap = new int[numTexUnit];
        int i = 0;
        while (i < numTexUnit) {
            this.texCoordSetMap[i] = 0;
            ++i;
        }
    }

    GeomBuffer(int numVerts) {
        this(numVerts, 1);
    }

    GeometryArray getGeom(int format) {
        GeometryArray obj = null;
        this.flags = format;
        this.numTris = 0;
        switch (this.currPrimType[0]) {
            case 2: {
                obj = this.processTriangles();
                break;
            }
            case 4: {
                obj = this.processQuads();
                break;
            }
            case 1: 
            case 32: {
                obj = this.processQuadStrips();
                break;
            }
            case 16: {
                obj = this.processTriangleFan();
            }
        }
        if (obj != null && (this.flags & 0x20) != 0) {
            obj.setCapability(18);
            obj.setCapability(17);
            obj.setCapability(8);
            obj.setCapability(0);
        }
        return obj;
    }

    void begin(int prim) {
        this.currPrimType[this.currPrimCnt] = prim;
        this.currPrimStartVertex[this.currPrimCnt] = this.currVertCnt;
    }

    void end() {
        this.currPrimEndVertex[this.currPrimCnt] = this.currVertCnt;
        ++this.currPrimCnt;
    }

    void vertex3d(double x, double y, double z) {
        this.pts[this.currVertCnt] = new Point3f((float)x, (float)y, (float)z);
        ++this.currVertCnt;
    }

    void normal3d(double x, double y, double z) {
        double sum = x * x + y * y + z * z;
        if (Math.abs(sum - 1.0) > 0.001) {
            double root = Math.sqrt(sum);
            if (root > 1.0E-6) {
                x /= root;
                y /= root;
                z /= root;
            } else {
                z = 0.0;
                y = 0.0;
                x = 1.0;
            }
        }
        this.normals[this.currVertCnt] = new Vector3f((float)x, (float)y, (float)z);
    }

    void texCoord2d(double s, double t) {
        this.tcoords[this.currVertCnt] = new TexCoord2f((float)s, (float)t);
    }

    TexCoord2f[] getTexCoords() {
        return this.tcoords;
    }

    GeometryArray getComputedGeometry() {
        return this.geometry;
    }

    int getNumTris() {
        return this.numTris;
    }

    int getNumVerts() {
        return this.numVerts;
    }

    private GeometryArray processQuadStrips() {
        TriangleStripArray obj = null;
        int totalVerts = 0;
        int[] stripCounts = new int[this.currPrimCnt];
        int i = 0;
        while (i < this.currPrimCnt) {
            stripCounts[i] = this.currPrimEndVertex[i] - this.currPrimStartVertex[i];
            totalVerts += stripCounts[i];
            ++i;
        }
        int tsaFlags = 1;
        if ((this.flags & 1) != 0) {
            tsaFlags |= 2;
        }
        if ((this.flags & 2) != 0) {
            tsaFlags |= 0x20;
        }
        obj = new TriangleStripArray(totalVerts, tsaFlags, 1, this.texCoordSetMap, stripCounts);
        Point3f[] newpts = new Point3f[totalVerts];
        Vector3f[] newnormals = new Vector3f[totalVerts];
        TexCoord2f[] newtcoords = new TexCoord2f[totalVerts];
        int currVert = 0;
        i = 0;
        while (i < this.currPrimCnt) {
            int j = this.currPrimStartVertex[i];
            while (j < this.currPrimEndVertex[i]) {
                this.outVertex(newpts, newnormals, newtcoords, currVert++, this.pts, this.normals, this.tcoords, j);
                ++j;
            }
            ++i;
        }
        this.numVerts = currVert;
        this.numTris += totalVerts - this.currPrimCnt * 2;
        obj.setCoordinates(0, newpts);
        if ((this.flags & 1) != 0) {
            obj.setNormals(0, newnormals);
        }
        if ((this.flags & 2) != 0) {
            obj.setTextureCoordinates(0, 0, newtcoords);
        }
        this.geometry = obj;
        return obj;
    }

    private GeometryArray processQuads() {
        QuadArray obj = null;
        int totalVerts = 0;
        int i = 0;
        while (i < this.currPrimCnt) {
            totalVerts += this.currPrimEndVertex[i] - this.currPrimStartVertex[i];
            ++i;
        }
        obj = (this.flags & 1) != 0 && (this.flags & 2) != 0 ? new QuadArray(totalVerts, 35, 1, this.texCoordSetMap) : ((this.flags & 1) == 0 && (this.flags & 2) != 0 ? new QuadArray(totalVerts, 33, 1, this.texCoordSetMap) : ((this.flags & 1) != 0 && (this.flags & 2) == 0 ? new QuadArray(totalVerts, 3) : new QuadArray(totalVerts, 1)));
        Point3f[] newpts = new Point3f[totalVerts];
        Vector3f[] newnormals = new Vector3f[totalVerts];
        TexCoord2f[] newtcoords = new TexCoord2f[totalVerts];
        int currVert = 0;
        i = 0;
        while (i < this.currPrimCnt) {
            int j = this.currPrimStartVertex[i];
            while (j < this.currPrimEndVertex[i] - 3) {
                this.outVertex(newpts, newnormals, newtcoords, currVert++, this.pts, this.normals, this.tcoords, j);
                this.outVertex(newpts, newnormals, newtcoords, currVert++, this.pts, this.normals, this.tcoords, j + 1);
                this.outVertex(newpts, newnormals, newtcoords, currVert++, this.pts, this.normals, this.tcoords, j + 2);
                this.outVertex(newpts, newnormals, newtcoords, currVert++, this.pts, this.normals, this.tcoords, j + 3);
                this.numTris += 2;
                j += 4;
            }
            ++i;
        }
        this.numVerts = currVert;
        obj.setCoordinates(0, newpts);
        if ((this.flags & 1) != 0) {
            obj.setNormals(0, newnormals);
        }
        if ((this.flags & 2) != 0) {
            obj.setTextureCoordinates(0, 0, newtcoords);
        }
        this.geometry = obj;
        return obj;
    }

    private GeometryArray processTriangles() {
        TriangleArray obj = null;
        int totalVerts = 0;
        int i = 0;
        while (i < this.currPrimCnt) {
            totalVerts += this.currPrimEndVertex[i] - this.currPrimStartVertex[i];
            ++i;
        }
        obj = (this.flags & 1) != 0 && (this.flags & 2) != 0 ? new TriangleArray(totalVerts, 35, 1, this.texCoordSetMap) : ((this.flags & 1) == 0 && (this.flags & 2) != 0 ? new TriangleArray(totalVerts, 33, 1, this.texCoordSetMap) : ((this.flags & 1) != 0 && (this.flags & 2) == 0 ? new TriangleArray(totalVerts, 3) : new TriangleArray(totalVerts, 1)));
        Point3f[] newpts = new Point3f[totalVerts];
        Vector3f[] newnormals = new Vector3f[totalVerts];
        TexCoord2f[] newtcoords = new TexCoord2f[totalVerts];
        int currVert = 0;
        i = 0;
        while (i < this.currPrimCnt) {
            int j = this.currPrimStartVertex[i];
            while (j < this.currPrimEndVertex[i] - 2) {
                this.outVertex(newpts, newnormals, newtcoords, currVert++, this.pts, this.normals, this.tcoords, j);
                this.outVertex(newpts, newnormals, newtcoords, currVert++, this.pts, this.normals, this.tcoords, j + 1);
                this.outVertex(newpts, newnormals, newtcoords, currVert++, this.pts, this.normals, this.tcoords, j + 2);
                ++this.numTris;
                j += 3;
            }
            ++i;
        }
        this.numVerts = currVert;
        obj.setCoordinates(0, newpts);
        if ((this.flags & 1) != 0) {
            obj.setNormals(0, newnormals);
        }
        if ((this.flags & 2) != 0) {
            obj.setTextureCoordinates(0, 0, newtcoords);
        }
        this.geometry = obj;
        return obj;
    }

    private GeometryArray processTriangleFan() {
        TriangleFanArray obj = null;
        int totalVerts = 0;
        int[] stripCounts = new int[this.currPrimCnt];
        int i = 0;
        while (i < this.currPrimCnt) {
            stripCounts[i] = this.currPrimEndVertex[i] - this.currPrimStartVertex[i];
            totalVerts += stripCounts[i];
            ++i;
        }
        int tfFlags = 1;
        if ((this.flags & 1) != 0) {
            tfFlags |= 2;
        }
        if ((this.flags & 2) != 0) {
            tfFlags |= 0x20;
        }
        obj = new TriangleFanArray(totalVerts, tfFlags, 1, this.texCoordSetMap, stripCounts);
        Point3f[] newpts = new Point3f[totalVerts];
        Vector3f[] newnormals = new Vector3f[totalVerts];
        TexCoord2f[] newtcoords = new TexCoord2f[totalVerts];
        int currVert = 0;
        i = 0;
        while (i < this.currPrimCnt) {
            int j = this.currPrimStartVertex[i];
            while (j < this.currPrimEndVertex[i]) {
                this.outVertex(newpts, newnormals, newtcoords, currVert++, this.pts, this.normals, this.tcoords, j);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < newpts.length) {
            ++i;
        }
        this.numVerts = currVert;
        this.numTris = totalVerts - this.currPrimCnt * 2;
        obj.setCoordinates(0, newpts);
        if ((this.flags & 1) != 0) {
            obj.setNormals(0, newnormals);
        }
        if ((this.flags & 2) != 0) {
            obj.setTextureCoordinates(0, 0, newtcoords);
        }
        this.geometry = obj;
        return obj;
    }

    void outVertex(Point3f[] dpts, Vector3f[] dnormals, TexCoord2f[] dtcoords, int dloc, Point3f[] spts, Vector3f[] snormals, TexCoord2f[] stcoords, int sloc) {
        dpts[dloc] = new Point3f(spts[sloc]);
        if ((this.flags & 1) != 0) {
            dnormals[dloc] = new Vector3f(snormals[sloc]);
        }
        if ((this.flags & 2) != 0) {
            dtcoords[dloc] = new TexCoord2f(stcoords[sloc]);
        }
    }
}

