/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.compression;

import org.jogamp.java3d.utils.compression.CommandStream;
import org.jogamp.java3d.utils.compression.CompressionStream;
import org.jogamp.java3d.utils.compression.HuffmanTable;

abstract class CompressionStreamElement {
    int length;
    int shift;
    boolean absolute;
    static final int[] quantizationMask = new int[]{-65536, Short.MIN_VALUE, -16384, -8192, -4096, -2048, -1024, -512, -256, -128, -64, -32, -16, -8, -4, -2, -1};
    static final long[] lengthMask;

    static {
        long[] lArray = new long[65];
        lArray[1] = 1L;
        lArray[2] = 3L;
        lArray[3] = 7L;
        lArray[4] = 15L;
        lArray[5] = 31L;
        lArray[6] = 63L;
        lArray[7] = 127L;
        lArray[8] = 255L;
        lArray[9] = 511L;
        lArray[10] = 1023L;
        lArray[11] = 2047L;
        lArray[12] = 4095L;
        lArray[13] = 8191L;
        lArray[14] = 16383L;
        lArray[15] = 32767L;
        lArray[16] = 65535L;
        lArray[17] = 131071L;
        lArray[18] = 262143L;
        lArray[19] = 524287L;
        lArray[20] = 1048575L;
        lArray[21] = 0x1FFFFFL;
        lArray[22] = 0x3FFFFFL;
        lArray[23] = 0x7FFFFFL;
        lArray[24] = 0xFFFFFFL;
        lArray[25] = 0x1FFFFFFL;
        lArray[26] = 0x3FFFFFFL;
        lArray[27] = 0x7FFFFFFL;
        lArray[28] = 0xFFFFFFFL;
        lArray[29] = 0x1FFFFFFFL;
        lArray[30] = 0x3FFFFFFFL;
        lArray[31] = Integer.MAX_VALUE;
        lArray[32] = 0xFFFFFFFFL;
        lArray[33] = 0x1FFFFFFFFL;
        lArray[34] = 0x3FFFFFFFFL;
        lArray[35] = 0x7FFFFFFFFL;
        lArray[36] = 0xFFFFFFFFFL;
        lArray[37] = 0x1FFFFFFFFFL;
        lArray[38] = 0x3FFFFFFFFFL;
        lArray[39] = 0x7FFFFFFFFFL;
        lArray[40] = 0xFFFFFFFFFFL;
        lArray[41] = 0x1FFFFFFFFFFL;
        lArray[42] = 0x3FFFFFFFFFFL;
        lArray[43] = 0x7FFFFFFFFFFL;
        lArray[44] = 0xFFFFFFFFFFFL;
        lArray[45] = 0x1FFFFFFFFFFFL;
        lArray[46] = 0x3FFFFFFFFFFFL;
        lArray[47] = 0x7FFFFFFFFFFFL;
        lArray[48] = 0xFFFFFFFFFFFFL;
        lArray[49] = 0x1FFFFFFFFFFFFL;
        lArray[50] = 0x3FFFFFFFFFFFFL;
        lArray[51] = 0x7FFFFFFFFFFFFL;
        lArray[52] = 0xFFFFFFFFFFFFFL;
        lArray[53] = 0x1FFFFFFFFFFFFFL;
        lArray[54] = 0x3FFFFFFFFFFFFFL;
        lArray[55] = 0x7FFFFFFFFFFFFFL;
        lArray[56] = 0xFFFFFFFFFFFFFFL;
        lArray[57] = 0x1FFFFFFFFFFFFFFL;
        lArray[58] = 0x3FFFFFFFFFFFFFFL;
        lArray[59] = 0x7FFFFFFFFFFFFFFL;
        lArray[60] = 0xFFFFFFFFFFFFFFFL;
        lArray[61] = 0x1FFFFFFFFFFFFFFFL;
        lArray[62] = 0x3FFFFFFFFFFFFFFFL;
        lArray[63] = Long.MAX_VALUE;
        lArray[64] = -1L;
        lengthMask = lArray;
    }

    CompressionStreamElement() {
    }

    abstract void quantize(CompressionStream var1, HuffmanTable var2);

    void outputCommand(HuffmanTable table, CommandStream output) {
    }

    private static final int getLength(int number) {
        if (number == 0) {
            return 0;
        }
        if ((number & 0x8000) > 0) {
            if ((number & 0x4000) == 0) {
                return 16;
            }
            if ((number & 0x2000) == 0) {
                return 15;
            }
            if ((number & 0x1000) == 0) {
                return 14;
            }
            if ((number & 0x800) == 0) {
                return 13;
            }
            if ((number & 0x400) == 0) {
                return 12;
            }
            if ((number & 0x200) == 0) {
                return 11;
            }
            if ((number & 0x100) == 0) {
                return 10;
            }
            if ((number & 0x80) == 0) {
                return 9;
            }
            if ((number & 0x40) == 0) {
                return 8;
            }
            if ((number & 0x20) == 0) {
                return 7;
            }
            if ((number & 0x10) == 0) {
                return 6;
            }
            if ((number & 8) == 0) {
                return 5;
            }
            if ((number & 4) == 0) {
                return 4;
            }
            if ((number & 2) == 0) {
                return 3;
            }
            if ((number & 1) == 0) {
                return 2;
            }
            return 1;
        }
        if ((number & 0x4000) > 0) {
            return 16;
        }
        if ((number & 0x2000) > 0) {
            return 15;
        }
        if ((number & 0x1000) > 0) {
            return 14;
        }
        if ((number & 0x800) > 0) {
            return 13;
        }
        if ((number & 0x400) > 0) {
            return 12;
        }
        if ((number & 0x200) > 0) {
            return 11;
        }
        if ((number & 0x100) > 0) {
            return 10;
        }
        if ((number & 0x80) > 0) {
            return 9;
        }
        if ((number & 0x40) > 0) {
            return 8;
        }
        if ((number & 0x20) > 0) {
            return 7;
        }
        if ((number & 0x10) > 0) {
            return 6;
        }
        if ((number & 8) > 0) {
            return 5;
        }
        if ((number & 4) > 0) {
            return 4;
        }
        if ((number & 2) > 0) {
            return 3;
        }
        return 2;
    }

    private static final int getShift(int number) {
        if (number == 0) {
            return 0;
        }
        if ((number & 1) > 0) {
            return 0;
        }
        if ((number & 2) > 0) {
            return 1;
        }
        if ((number & 4) > 0) {
            return 2;
        }
        if ((number & 8) > 0) {
            return 3;
        }
        if ((number & 0x10) > 0) {
            return 4;
        }
        if ((number & 0x20) > 0) {
            return 5;
        }
        if ((number & 0x40) > 0) {
            return 6;
        }
        if ((number & 0x80) > 0) {
            return 7;
        }
        if ((number & 0x100) > 0) {
            return 8;
        }
        if ((number & 0x200) > 0) {
            return 9;
        }
        if ((number & 0x400) > 0) {
            return 10;
        }
        if ((number & 0x800) > 0) {
            return 11;
        }
        if ((number & 0x1000) > 0) {
            return 12;
        }
        if ((number & 0x2000) > 0) {
            return 13;
        }
        if ((number & 0x4000) > 0) {
            return 14;
        }
        return 15;
    }

    final void computeLengthShift(int n0, int n1) {
        int s0 = n0 & 0x8000;
        int s1 = n1 & 0x8000;
        this.length = s0 == s1 ? (s0 == 0 ? CompressionStreamElement.getLength(n0 | n1) : CompressionStreamElement.getLength(n0 & n1)) : CompressionStreamElement.getMaximum(CompressionStreamElement.getLength(n0), CompressionStreamElement.getLength(n1));
        this.shift = CompressionStreamElement.getShift(n0 | n1);
    }

    final void computeLengthShift(int n0, int n1, int n2) {
        int s0 = n0 & 0x8000;
        int s1 = n1 & 0x8000;
        int s2 = n2 & 0x8000;
        this.length = s0 == s1 ? (s1 == s2 ? (s2 == 0 ? CompressionStreamElement.getLength(n0 | n1 | n2) : CompressionStreamElement.getLength(n0 & n1 & n2)) : (s1 == 0 ? CompressionStreamElement.getMaximum(CompressionStreamElement.getLength(n0 | n1), CompressionStreamElement.getLength(n2)) : CompressionStreamElement.getMaximum(CompressionStreamElement.getLength(n0 & n1), CompressionStreamElement.getLength(n2)))) : (s1 == s2 ? (s2 == 0 ? CompressionStreamElement.getMaximum(CompressionStreamElement.getLength(n1 | n2), CompressionStreamElement.getLength(n0)) : CompressionStreamElement.getMaximum(CompressionStreamElement.getLength(n1 & n2), CompressionStreamElement.getLength(n0))) : (s0 == 0 ? CompressionStreamElement.getMaximum(CompressionStreamElement.getLength(n0 | n2), CompressionStreamElement.getLength(n1)) : CompressionStreamElement.getMaximum(CompressionStreamElement.getLength(n0 & n2), CompressionStreamElement.getLength(n1))));
        this.shift = CompressionStreamElement.getShift(n0 | n1 | n2);
    }

    final void computeLengthShift(int n0, int n1, int n2, int n3) {
        this.length = CompressionStreamElement.getMaximum(CompressionStreamElement.getLength(n0), CompressionStreamElement.getLength(n1), CompressionStreamElement.getLength(n2), CompressionStreamElement.getLength(n3));
        this.shift = CompressionStreamElement.getShift(n0 | n1 | n2 | n3);
    }

    private static final int getMaximum(int x, int y) {
        if (x > y) {
            return x;
        }
        return y;
    }

    private static final int getMaximum(int x, int y, int z) {
        if (x > y) {
            if (x > z) {
                return x;
            }
            return z;
        }
        if (y > z) {
            return y;
        }
        return z;
    }

    private static final int getMaximum(int x, int y, int z, int w) {
        int n1;
        int n0 = x > y ? x : y;
        if (n0 > (n1 = z > w ? z : w)) {
            return n0;
        }
        return n1;
    }
}

