/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.behaviors.interpolators;

import org.jogamp.java3d.utils.behaviors.interpolators.KBKeyFrame;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Vector3f;

public class KBCubicSplineSegment {
    static final double[] modRoot = new double[]{0.046910077, 0.230765345, 0.5, 0.769234655, 0.953089922};
    static final double[] modCoeff = new double[]{0.118463442, 0.239314335, 0.284444444, 0.239314335, 0.118463442};
    KBKeyFrame[] keyFrame = new KBKeyFrame[4];
    Point3f c0;
    Point3f c1;
    Point3f c2;
    Point3f c3;
    Point3f e0;
    Point3f e1;
    Point3f e2;
    Point3f e3;
    float h0;
    float h1;
    float h2;
    float h3;
    float p0;
    float p1;
    float p2;
    float p3;
    float b0;
    float b1;
    float b2;
    float b3;
    float one_minus_t_in;
    float one_minus_c_in;
    float one_minus_b_in;
    float one_plus_c_in;
    float one_plus_b_in;
    float ddb;
    float dda;
    float one_minus_t_out;
    float one_minus_c_out;
    float one_minus_b_out;
    float one_plus_c_out;
    float one_plus_b_out;
    float dsb;
    float dsa;
    float length;
    int linear;

    KBCubicSplineSegment() {
        this.length = 0.0f;
    }

    KBCubicSplineSegment(KBKeyFrame kf0, KBKeyFrame kf1, KBKeyFrame kf2, KBKeyFrame kf3) {
        this.keyFrame[0] = new KBKeyFrame(kf0);
        this.keyFrame[1] = new KBKeyFrame(kf1);
        this.keyFrame[2] = new KBKeyFrame(kf2);
        this.keyFrame[3] = new KBKeyFrame(kf3);
        if (kf2.linear == 1) {
            this.linear = 1;
        } else {
            this.linear = 0;
            this.computeCommonCoefficients(kf0, kf1, kf2, kf3);
            this.computeHermiteCoefficients(kf0, kf1, kf2, kf3);
        }
        this.length = this.computeLength(1.0f);
    }

    private void computeCommonCoefficients(KBKeyFrame kf0, KBKeyFrame kf1, KBKeyFrame kf2, KBKeyFrame kf3) {
        float one_minus_t_in = 1.0f - kf1.tension;
        float one_minus_c_in = 1.0f - kf1.continuity;
        float one_minus_b_in = 1.0f - kf1.bias;
        float one_plus_c_in = 1.0f + kf1.continuity;
        float one_plus_b_in = 1.0f + kf1.bias;
        this.ddb = one_minus_t_in * one_minus_c_in * one_minus_b_in;
        this.dda = one_minus_t_in * one_plus_c_in * one_plus_b_in;
        float one_minus_t_out = 1.0f - kf2.tension;
        float one_minus_c_out = 1.0f - kf2.continuity;
        float one_minus_b_out = 1.0f - kf2.bias;
        float one_plus_c_out = 1.0f + kf2.continuity;
        float one_plus_b_out = 1.0f + kf2.bias;
        this.dsb = one_minus_t_in * one_plus_c_in * one_minus_b_in;
        this.dsa = one_minus_t_in * one_minus_c_in * one_plus_b_in;
    }

    private void computeHermiteCoefficients(KBKeyFrame kf0, KBKeyFrame kf1, KBKeyFrame kf2, KBKeyFrame kf3) {
        float ds_bank;
        float ds_pitch;
        float ds_heading;
        float dd_bank;
        float dd_pitch;
        float dd_heading;
        Point3f deltaP = new Point3f();
        Point3f deltaS = new Point3f();
        deltaP.x = kf2.position.x - kf1.position.x;
        deltaP.y = kf2.position.y - kf1.position.y;
        deltaP.z = kf2.position.z - kf1.position.z;
        deltaS.x = kf2.scale.x - kf1.scale.x;
        deltaS.y = kf2.scale.y - kf1.scale.y;
        deltaS.z = kf2.scale.z - kf1.scale.z;
        float deltaH = kf2.heading - kf1.heading;
        float deltaT = kf2.pitch - kf1.pitch;
        float deltaB = kf2.bank - kf1.bank;
        Point3f dd_pos = new Point3f();
        Point3f dd_scale = new Point3f();
        if (kf0.knot == kf1.knot) {
            float ddab = 0.5f * (this.dda + this.ddb);
            dd_pos.x = ddab * deltaP.x;
            dd_pos.y = ddab * deltaP.y;
            dd_pos.z = ddab * deltaP.z;
            dd_scale.x = ddab * deltaS.x;
            dd_scale.y = ddab * deltaS.y;
            dd_scale.z = ddab * deltaS.z;
            dd_heading = ddab * deltaH;
            dd_pitch = ddab * deltaT;
            dd_bank = ddab * deltaB;
        } else {
            float adj0 = (kf1.knot - kf0.knot) / (kf2.knot - kf0.knot);
            dd_pos.x = adj0 * (this.ddb * deltaP.x + this.dda * (kf1.position.x - kf0.position.x));
            dd_pos.y = adj0 * (this.ddb * deltaP.y + this.dda * (kf1.position.y - kf0.position.y));
            dd_pos.z = adj0 * (this.ddb * deltaP.z + this.dda * (kf1.position.z - kf0.position.z));
            dd_scale.x = adj0 * (this.ddb * deltaS.x + this.dda * (kf1.scale.x - kf0.scale.x));
            dd_scale.y = adj0 * (this.ddb * deltaS.y + this.dda * (kf1.scale.y - kf0.scale.y));
            dd_scale.z = adj0 * (this.ddb * deltaS.z + this.dda * (kf1.scale.z - kf0.scale.z));
            dd_heading = adj0 * (this.ddb * deltaH + this.dda * (kf1.heading - kf0.heading));
            dd_pitch = adj0 * (this.ddb * deltaT + this.dda * (kf1.pitch - kf0.pitch));
            dd_bank = adj0 * (this.ddb * deltaB + this.dda * (kf1.bank - kf0.bank));
        }
        Point3f ds_pos = new Point3f();
        Point3f ds_scale = new Point3f();
        if (kf2.knot == kf3.knot) {
            float dsab = 0.5f * (this.dsa + this.dsb);
            ds_pos.x = dsab * deltaP.x;
            ds_pos.y = dsab * deltaP.y;
            ds_pos.z = dsab * deltaP.z;
            ds_scale.x = dsab * deltaS.x;
            ds_scale.y = dsab * deltaS.y;
            ds_scale.z = dsab * deltaS.z;
            ds_heading = dsab * deltaH;
            ds_pitch = dsab * deltaT;
            ds_bank = dsab * deltaB;
        } else {
            float adj1 = (kf2.knot - kf1.knot) / (kf3.knot - kf1.knot);
            ds_pos.x = adj1 * (this.dsb * (kf3.position.x - kf2.position.x) + this.dsa * deltaP.x);
            ds_pos.y = adj1 * (this.dsb * (kf3.position.y - kf2.position.y) + this.dsa * deltaP.y);
            ds_pos.z = adj1 * (this.dsb * (kf3.position.z - kf2.position.z) + this.dsa * deltaP.z);
            ds_scale.x = adj1 * (this.dsb * (kf3.scale.x - kf2.scale.x) + this.dsa * deltaS.x);
            ds_scale.y = adj1 * (this.dsb * (kf3.scale.y - kf2.scale.y) + this.dsa * deltaS.y);
            ds_scale.z = adj1 * (this.dsb * (kf3.scale.z - kf2.scale.z) + this.dsa * deltaS.z);
            ds_heading = adj1 * (this.dsb * (kf3.heading - kf2.heading) + this.dsa * deltaH);
            ds_pitch = adj1 * (this.dsb * (kf3.pitch - kf2.pitch) + this.dsa * deltaT);
            ds_bank = adj1 * (this.dsb * (kf3.bank - kf2.bank) + this.dsa * deltaB);
        }
        this.c0 = new Point3f();
        this.c0.x = kf1.position.x;
        this.c0.y = kf1.position.y;
        this.c0.z = kf1.position.z;
        this.c1 = new Point3f();
        this.c1.x = dd_pos.x;
        this.c1.y = dd_pos.y;
        this.c1.z = dd_pos.z;
        this.c2 = new Point3f();
        this.c2.x = 3.0f * deltaP.x - 2.0f * dd_pos.x - ds_pos.x;
        this.c2.y = 3.0f * deltaP.y - 2.0f * dd_pos.y - ds_pos.y;
        this.c2.z = 3.0f * deltaP.z - 2.0f * dd_pos.z - ds_pos.z;
        this.c3 = new Point3f();
        this.c3.x = -2.0f * deltaP.x + dd_pos.x + ds_pos.x;
        this.c3.y = -2.0f * deltaP.y + dd_pos.y + ds_pos.y;
        this.c3.z = -2.0f * deltaP.z + dd_pos.z + ds_pos.z;
        this.e0 = new Point3f();
        this.e0.x = kf1.scale.x;
        this.e0.y = kf1.scale.y;
        this.e0.z = kf1.scale.z;
        this.e1 = new Point3f();
        this.e1.x = dd_scale.x;
        this.e1.y = dd_scale.y;
        this.e1.z = dd_scale.z;
        this.e2 = new Point3f();
        this.e2.x = 3.0f * deltaS.x - 2.0f * dd_scale.x - ds_scale.x;
        this.e2.y = 3.0f * deltaS.y - 2.0f * dd_scale.y - ds_scale.y;
        this.e2.z = 3.0f * deltaS.z - 2.0f * dd_scale.z - ds_scale.z;
        this.e3 = new Point3f();
        this.e3.x = -2.0f * deltaS.x + dd_scale.x + ds_scale.x;
        this.e3.y = -2.0f * deltaS.y + dd_scale.y + ds_scale.y;
        this.e3.z = -2.0f * deltaS.z + dd_scale.z + ds_scale.z;
        this.h0 = kf1.heading;
        this.p0 = kf1.pitch;
        this.b0 = kf1.bank;
        this.h1 = dd_heading;
        this.p1 = dd_pitch;
        this.b1 = dd_bank;
        this.h2 = 3.0f * deltaH - 2.0f * dd_heading - ds_heading;
        this.p2 = 3.0f * deltaT - 2.0f * dd_pitch - ds_pitch;
        this.b2 = 3.0f * deltaB - 2.0f * dd_bank - ds_bank;
        this.h3 = -2.0f * deltaH + dd_heading + ds_heading;
        this.p3 = -2.0f * deltaT + dd_pitch + ds_pitch;
        this.b3 = -2.0f * deltaB + dd_bank + ds_bank;
    }

    public float computeLength(float u) {
        float result = 0.0f;
        if (this.linear == 1) {
            result = u * this.keyFrame[2].position.distance(this.keyFrame[1].position);
        } else {
            int degree = 5;
            int i = 0;
            while (i < degree) {
                result += (float)modCoeff[i] * this.computeSpeed(u * (float)modRoot[i]);
                ++i;
            }
            result *= u;
        }
        return result;
    }

    private float computeSpeed(float u) {
        Point3f v = new Point3f();
        v.x = this.c1.x + u * (2.0f * this.c2.x + 3.0f * u * this.c3.x);
        v.y = this.c1.y + u * (2.0f * this.c2.y + 3.0f * u * this.c3.y);
        v.z = this.c1.z + u * (2.0f * this.c2.z + 3.0f * u * this.c3.z);
        return (float)Math.sqrt(v.x * v.x + v.y * v.y + v.z * v.z);
    }

    public void getInterpolatedScale(float u, Point3f newScale) {
        if (this.linear == 1) {
            newScale.x = this.keyFrame[1].scale.x + (this.keyFrame[2].scale.x - this.keyFrame[1].scale.x) * u;
            newScale.y = this.keyFrame[1].scale.y + (this.keyFrame[2].scale.y - this.keyFrame[1].scale.y) * u;
            newScale.z = this.keyFrame[1].scale.z + (this.keyFrame[2].scale.z - this.keyFrame[1].scale.z) * u;
        } else {
            newScale.x = this.e0.x + u * (this.e1.x + u * (this.e2.x + u * this.e3.x));
            newScale.y = this.e0.y + u * (this.e1.y + u * (this.e2.y + u * this.e3.y));
            newScale.z = this.e0.z + u * (this.e1.z + u * (this.e2.z + u * this.e3.z));
        }
    }

    public void getInterpolatedPosition(float u, Point3f newPos) {
        if (this.linear == 1) {
            newPos.x = this.keyFrame[1].position.x + (this.keyFrame[2].position.x - this.keyFrame[1].position.x) * u;
            newPos.y = this.keyFrame[1].position.y + (this.keyFrame[2].position.y - this.keyFrame[1].position.y) * u;
            newPos.z = this.keyFrame[1].position.z + (this.keyFrame[2].position.z - this.keyFrame[1].position.z) * u;
        } else {
            newPos.x = this.c0.x + u * (this.c1.x + u * (this.c2.x + u * this.c3.x));
            newPos.y = this.c0.y + u * (this.c1.y + u * (this.c2.y + u * this.c3.y));
            newPos.z = this.c0.z + u * (this.c1.z + u * (this.c2.z + u * this.c3.z));
        }
    }

    public void getInterpolatedPositionVector(float u, Vector3f newPos) {
        if (this.linear == 1) {
            newPos.x = this.keyFrame[1].position.x + (this.keyFrame[2].position.x - this.keyFrame[1].position.x) * u;
            newPos.y = this.keyFrame[1].position.y + (this.keyFrame[2].position.y - this.keyFrame[1].position.y) * u;
            newPos.z = this.keyFrame[1].position.z + (this.keyFrame[2].position.z - this.keyFrame[1].position.z) * u;
        } else {
            newPos.x = this.c0.x + u * (this.c1.x + u * (this.c2.x + u * this.c3.x));
            newPos.y = this.c0.y + u * (this.c1.y + u * (this.c2.y + u * this.c3.y));
            newPos.z = this.c0.z + u * (this.c1.z + u * (this.c2.z + u * this.c3.z));
        }
    }

    public float getInterpolatedHeading(float u) {
        float newHeading = this.linear == 1 ? this.keyFrame[1].heading + (this.keyFrame[2].heading - this.keyFrame[1].heading) * u : this.h0 + u * (this.h1 + u * (this.h2 + u * this.h3));
        return newHeading;
    }

    public float getInterpolatedPitch(float u) {
        float newPitch = this.linear == 1 ? this.keyFrame[1].pitch + (this.keyFrame[2].pitch - this.keyFrame[1].pitch) * u : this.p0 + u * (this.p1 + u * (this.p2 + u * this.p3));
        return newPitch;
    }

    public float getInterpolatedBank(float u) {
        float newBank = this.linear == 1 ? this.keyFrame[1].bank + (this.keyFrame[2].bank - this.keyFrame[1].bank) * u : this.b0 + u * (this.b1 + u * (this.b2 + u * this.b3));
        return newBank;
    }

    public float getInterpolatedValue(float u) {
        return this.computeLength(u) / this.length;
    }
}

