/*
 * Decompiled with CFR 0.152.
 */
package ffe.tinker;

import ffe.tinker.FFEMessage;
import java.io.Serializable;

public class TinkerUpdate
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static int NONE = 0;
    public static int SIMULATION = 1;
    public static int OPTIMIZATION = 2;
    public boolean read = true;
    public int type;
    public int numatoms;
    public double[][] coordinates = null;
    public double time = -0.1;
    public double temperature = 0.0;
    public double energy = 0.0;
    public double potential = 0.0;
    public double kinetic = 0.0;
    public double intermolecular = 0.0;
    public double pressure = 0.0;
    public double density = 0.0;
    public double[][] velocity = null;
    public double[][] acceleration = null;
    public int step = 0;
    public double[][] gradients = null;
    public boolean amoeba;
    public double[][] induced = null;

    public TinkerUpdate(int n, int t, boolean a) {
        this.numatoms = n;
        this.amoeba = a;
        this.type = t;
        this.coordinates = new double[3][this.numatoms];
        if (this.type == SIMULATION) {
            this.velocity = new double[3][this.numatoms];
            this.acceleration = new double[3][this.numatoms];
        } else if (this.type == OPTIMIZATION) {
            this.gradients = new double[3][this.numatoms];
        }
        if (this.amoeba) {
            this.induced = new double[3][this.numatoms];
        }
    }

    public boolean isNewer(FFEMessage message) {
        if (this.type == SIMULATION && this.time > message.getTime()) {
            return true;
        }
        return this.type == OPTIMIZATION && this.step > message.getStep();
    }

    public void print() {
        if (this.type == SIMULATION) {
            System.out.println("Time: " + this.time + " Energy: " + this.energy);
        } else {
            System.out.println("Step: " + this.step + " Energy: " + this.energy);
        }
    }
}

