/*
 * Decompiled with CFR 0.152.
 */
package ffe.tinker;

import ffe.tinker.FFEMessage;
import ffe.tinker.TinkerSystem;
import ffe.tinker.TinkerUpdate;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ListIterator;
import java.util.Vector;
import java.util.logging.Logger;

public class TinkerServer
implements Runnable {
    private Logger logger = Logger.getLogger("ffe");
    private static FFEMessage closing = new FFEMessage(FFEMessage.CLOSING);
    private ServerSocket server;
    private int serverPort = 2000;
    private int serverTimeout = 100;
    private Thread thread;
    private int sleepTime = 1;
    private boolean init = true;
    private int cycle = 0;
    private boolean shutdown = false;
    private boolean request = false;
    private Vector<Socket> clients = new Vector();
    private Vector<ObjectOutputStream> outputs = new Vector();
    private Vector<ObjectInputStream> inputs = new Vector();
    private TinkerSystem system = null;
    private TinkerUpdate update = null;

    public TinkerServer(TinkerSystem s) {
        this.system = s;
    }

    private void accept() {
        block6: {
            Socket client = null;
            ObjectInputStream oin = null;
            ObjectOutputStream oout = null;
            if (this.server != null) {
                try {
                    client = this.server.accept();
                    if (client != null && client.isConnected()) {
                        client.setTcpNoDelay(true);
                        this.clients.add(client);
                        oin = new ObjectInputStream(client.getInputStream());
                        this.inputs.add(oin);
                        oout = new ObjectOutputStream(client.getOutputStream());
                        this.outputs.add(oout);
                        Logger.getLogger("ffe").info("Client connected\n" + client.toString());
                    }
                }
                catch (Exception e) {
                    if (client != null) {
                        this.clients.remove(client);
                    }
                    if (oout != null) {
                        this.outputs.remove(oout);
                    }
                    if (oin == null) break block6;
                    this.inputs.remove(oin);
                }
            }
        }
    }

    private void closeClient(int index) {
        Socket client = this.clients.get(index);
        ObjectOutputStream oout = this.outputs.get(index);
        ObjectInputStream oin = this.inputs.get(index);
        try {
            oout.reset();
            oout.writeObject(closing);
            oout.flush();
        }
        catch (Exception e) {
            try {
                this.outputs.remove(index);
                this.inputs.remove(index);
                this.clients.remove(index);
                if (oout != null) {
                    oout.close();
                }
                if (oin != null) {
                    oin.close();
                }
                if (client != null) {
                    client.close();
                }
            }
            catch (Exception ex) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeServer() {
        for (int i = 0; i < this.clients.size(); ++i) {
            this.lastUpdate(i);
        }
        while (!this.clients.isEmpty()) {
            this.closeClient(0);
            try {
                TinkerServer i = this;
                synchronized (i) {
                    this.wait(10L);
                }
            }
            catch (Exception e) {
                Logger.getLogger("ffe").severe(e.toString());
            }
        }
        try {
            if (this.server != null) {
                this.server.close();
                this.server = null;
            }
        }
        catch (Exception e) {
            return;
        }
    }

    public boolean isAlive() {
        if (this.thread == null) {
            return false;
        }
        return this.thread.isAlive();
    }

    private void lastUpdate(int index) {
        try {
            ObjectOutputStream oout = this.outputs.get(index);
            Socket client = this.clients.get(index);
            if (client != null && client.isConnected() && oout != null) {
                FFEMessage last = new FFEMessage(FFEMessage.SYSTEM);
                if (this.system != null) {
                    oout.reset();
                    oout.writeObject(last);
                    oout.writeObject(this.system);
                    oout.flush();
                }
                if (this.update != null) {
                    oout.reset();
                    last.setMessage(FFEMessage.UPDATE);
                    oout.writeObject(last);
                    oout.writeObject(this.update);
                    oout.flush();
                }
                last.setMessage(FFEMessage.CLOSING);
                oout.reset();
                oout.writeObject(last);
                oout.flush();
            }
        }
        catch (Exception e) {
            this.logger.severe(String.valueOf(e));
        }
    }

    public void loadUpdate(TinkerUpdate u) {
        this.update = u;
    }

    public boolean needUpdate() {
        if (this.clients.size() == 0) {
            this.sleepTime = 1;
            return false;
        }
        if (!this.request) {
            return false;
        }
        this.sleepTime = 1;
        return true;
    }

    @Override
    public void run() {
        this.startServer();
        while (!this.shutdown) {
            this.accept();
            this.send();
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.init) continue;
            ++this.cycle;
            if (this.cycle < 10) continue;
            this.init = false;
        }
        this.accept();
        this.send();
        this.closeServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send() {
        if (this.system == null) {
            return;
        }
        if (this.clients.size() == 0) {
            return;
        }
        Vector<Socket> closed = new Vector<Socket>();
        ListIterator<ObjectOutputStream> lout = this.outputs.listIterator();
        ListIterator<ObjectInputStream> lin = this.inputs.listIterator();
        ListIterator<Socket> lclient = this.clients.listIterator();
        while (lout.hasNext()) {
            ObjectInputStream oin = lin.next();
            ObjectOutputStream oout = lout.next();
            Socket client = lclient.next();
            if (!client.isConnected() || client.isClosed()) {
                closed.add(client);
                continue;
            }
            try {
                Object o;
                FFEMessage message = null;
                while (oin != null && client.getInputStream().available() > 0) {
                    o = oin.readObject();
                    if (!(o instanceof FFEMessage) || (message = (FFEMessage)o).getMessage() != FFEMessage.CLOSING) continue;
                    closed.add(client);
                    message = null;
                    break;
                }
                if (message == null) continue;
                if (message.getMessage() == FFEMessage.SYSTEM) {
                    o = this.system;
                    synchronized (o) {
                        oout.reset();
                        oout.writeObject(message);
                        oout.writeObject(this.system);
                        oout.flush();
                        continue;
                    }
                }
                if (message.getMessage() != FFEMessage.UPDATE) continue;
                this.request = true;
                if (this.update == null || !this.update.isNewer(message)) continue;
                o = this.update;
                synchronized (o) {
                    oout.reset();
                    oout.writeObject(message);
                    oout.writeObject(this.update);
                    oout.flush();
                }
            }
            catch (Exception e) {
                closed.add(client);
            }
        }
        for (Socket s : closed) {
            int index = closed.indexOf(s);
            this.closeClient(index);
        }
    }

    public void setUpdated() {
        this.request = false;
    }

    public void start() {
        if (this.thread == null || !this.thread.isAlive()) {
            this.thread = new Thread(this);
            this.thread.setPriority(10);
            this.thread.start();
        }
    }

    private void startServer() {
        try {
            this.server = new ServerSocket();
            this.server.setSoTimeout(this.serverTimeout);
            this.server.setReuseAddress(true);
            this.server.bind(new InetSocketAddress(InetAddress.getLocalHost(), this.serverPort));
        }
        catch (Exception e) {
            try {
                this.server.bind(new InetSocketAddress(InetAddress.getByName(null), this.serverPort));
            }
            catch (Exception ex) {
                Logger.getLogger("ffe").severe("SERVER -- Could not start\n" + e.toString());
                return;
            }
        }
        Logger.getLogger("ffe").info("Tinker Server Address: " + String.valueOf(this.server.getLocalSocketAddress()));
    }

    public void stop() {
        this.shutdown = true;
    }
}

