/*
 * Decompiled with CFR 0.152.
 */
package ffe.tinker;

import ffe.lang.Atom;
import ffe.lang.Bond;
import ffe.lang.MolecularAssembly;
import ffe.lang.Utilities;
import ffe.mm.AtomType;
import ffe.parsers.SystemFilter;
import ffe.tinker.TinkerSystem;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

public final class SimulationFilter
extends SystemFilter {
    TinkerSystem system;
    Hashtable<Integer, AtomType> atomTypes = new Hashtable();

    public SimulationFilter(TinkerSystem sys, MolecularAssembly m) {
        super(m);
        this.system = sys;
        this.setType(Utilities.FileType.SIM);
        this.setFileRead(false);
    }

    @Override
    public boolean readFile() {
        int i;
        this.molecularAssembly.setFileType(Utilities.FileType.SIM);
        for (int i2 = 0; i2 < this.system.numatoms; ++i2) {
            AtomType atomType = this.atomTypes.get(this.system.types[i2]);
            if (atomType != null) continue;
            atomType = new AtomType(this.system.types[i2], -1, this.system.name[i2], this.system.story[i2], this.system.atomic[i2], this.system.mass[i2], 0);
            this.atomTypes.put(this.system.types[i2], atomType);
        }
        this.atomList = new ArrayList();
        Vector<Integer> bonds1 = new Vector<Integer>();
        Vector<Integer> bonds2 = new Vector<Integer>();
        double[] d = new double[3];
        int[] b = new int[4];
        for (i = 0; i < this.system.numatoms; ++i) {
            d[0] = this.system.coordinates[0][i];
            d[1] = this.system.coordinates[1][i];
            d[2] = this.system.coordinates[2][i];
            int s = this.system.types[i];
            AtomType atomType = this.atomTypes.get(s);
            int aNum = i + 1;
            String aStr = new String("" + atomType.type);
            Atom a = new Atom(i + 1, new String("" + atomType.type), atomType, d);
            this.atomList.add(a);
            int b1 = i + 1;
            b[0] = this.system.connectivity[0][i];
            b[1] = this.system.connectivity[1][i];
            b[2] = this.system.connectivity[2][i];
            b[3] = this.system.connectivity[3][i];
            for (int j = 0; j < 4 && b[j] != 0; ++j) {
                int b2 = b[j];
                bonds1.add(b1);
                bonds2.add(b2);
            }
        }
        this.bondList = new ArrayList();
        for (i = 0; i < bonds1.size(); ++i) {
            int a2;
            int a1 = (Integer)bonds1.get(i);
            if (a1 >= (a2 = ((Integer)bonds2.get(i)).intValue())) continue;
            Atom atom1 = (Atom)this.atomList.get(a1 - 1);
            Atom atom2 = (Atom)this.atomList.get(a2 - 1);
            this.bondList.add(new Bond(atom1, atom2, 1));
        }
        this.setFileRead(true);
        return true;
    }

    @Override
    public boolean writeFile() {
        return false;
    }
}

