/*
 * Decompiled with CFR 0.152.
 */
package ffe.tinker;

import ffe.tinker.FFEMessage;
import ffe.tinker.TinkerSystem;
import ffe.tinker.TinkerUpdate;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.logging.Logger;

public class FFEClient {
    private static final Logger logger = Logger.getLogger("ffe");
    private Socket client;
    private InetSocketAddress address;
    private InputStream in;
    private ObjectInputStream oin;
    private OutputStream out;
    private ObjectOutputStream oout;
    private TinkerSystem system;
    private TinkerUpdate update;
    private FFEMessage message;
    private int retryCount = 0;
    private int retryLimit = 10000;
    private boolean connectionMade = false;
    private boolean closed = false;

    public FFEClient() {
        this.address = new InetSocketAddress(2000);
    }

    public FFEClient(InetSocketAddress a) {
        this.address = a;
    }

    public FFEClient(int port) {
        this.address = new InetSocketAddress(port);
    }

    public void connect() {
        if (this.isConnected()) {
            this.release();
        }
        this.closed = false;
        this.connectionMade = false;
        this.client = new Socket();
        try {
            this.client.connect(this.address, 100);
            this.client.setTcpNoDelay(true);
            this.out = this.client.getOutputStream();
            this.oout = new ObjectOutputStream(this.out);
            this.in = this.client.getInputStream();
            this.oin = new ObjectInputStream(this.in);
            this.connectionMade = true;
            logger.info("Connected to Tinker Server: " + String.valueOf(this.client));
        }
        catch (Exception e) {
            this.connectionMade = false;
            logger.info("Connection to Tinker Server Failed: " + String.valueOf(this.client));
            this.client = null;
        }
        finally {
            if (!this.isConnected()) {
                this.release();
            }
        }
    }

    public TinkerSystem getSystem() {
        this.readSocket();
        return this.system;
    }

    public TinkerUpdate getUpdate() {
        this.readSocket();
        return this.update;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isConnected() {
        return this.client != null && this.client.isConnected();
    }

    public void readSocket() {
        try {
            while (this.oin != null && this.in.available() > 0) {
                Object o = this.oin.readObject();
                if (!(o instanceof FFEMessage)) continue;
                this.message = (FFEMessage)o;
                if (this.message.getMessage() == FFEMessage.SYSTEM) {
                    this.system = (TinkerSystem)this.oin.readObject();
                    this.system.read = false;
                    continue;
                }
                if (this.message.getMessage() == FFEMessage.UPDATE) {
                    this.update = (TinkerUpdate)this.oin.readObject();
                    this.update.read = false;
                    continue;
                }
                if (this.message.getMessage() != FFEMessage.CLOSING) continue;
                this.closed = true;
                this.release();
            }
            if (this.system == null) {
                this.message = new FFEMessage(FFEMessage.SYSTEM);
                this.oout.reset();
                this.oout.writeObject(this.message);
                this.oout.flush();
            } else if (this.update == null || this.update.read) {
                this.message = new FFEMessage(FFEMessage.UPDATE);
                if (this.update != null) {
                    if (this.update.type == TinkerUpdate.SIMULATION) {
                        this.message.setTime(this.update.time);
                    } else {
                        this.message.setStep(this.update.step);
                    }
                }
                this.oout.reset();
                this.oout.writeObject(this.message);
                this.oout.flush();
            }
        }
        catch (Exception e) {
            logger.warning("Exception reading data from Tinker\n" + e.toString());
            this.release();
        }
    }

    public void release() {
        if (this.client == null) {
            return;
        }
        ++this.retryCount;
        if (this.retryCount > this.retryLimit || this.connectionMade) {
            this.closed = true;
        }
        if (this.client != null && this.client.isConnected() && this.oout != null) {
            try {
                FFEMessage close = new FFEMessage(FFEMessage.CLOSING);
                this.oout.reset();
                this.oout.writeObject(close);
                this.oout.flush();
            }
            catch (Exception e) {
                this.oout = null;
            }
        }
        try {
            if (this.oin != null) {
                this.oin.close();
            }
            if (this.in != null) {
                this.in.close();
            }
            if (this.oout != null) {
                this.oout.close();
            }
            if (this.out != null) {
                this.out.close();
            }
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (Exception e) {
            this.client = null;
        }
        finally {
            this.in = null;
            this.oin = null;
            this.out = null;
            this.oout = null;
            this.client = null;
        }
    }
}

