/*
 * Decompiled with CFR 0.152.
 */
package ffe.properties;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public class FFELocale {
    private Logger logger = Logger.getLogger("ffe");
    private Locale currentLocale;
    private PropertyResourceBundle ffeLabels;
    private Hashtable<String, String> reverseLookUp = new Hashtable();

    public FFELocale() {
        this.currentLocale = Locale.getDefault();
        this.ffeLabels = (PropertyResourceBundle)ResourceBundle.getBundle("ffe.properties.StringBundle", this.currentLocale);
        this.loadHashtable();
    }

    public FFELocale(String language, String country) {
        this.setLocale(language, country);
    }

    public String getKey(String string) {
        return this.reverseLookUp.get(string);
    }

    public String getValue(String key) {
        return this.ffeLabels.getString(key).trim();
    }

    public void list() {
        for (String value : this.reverseLookUp.keySet()) {
            String key = this.reverseLookUp.get(value);
            this.logger.info("key = " + key + ", value = " + value);
        }
    }

    private void loadHashtable() {
        this.reverseLookUp.clear();
        Enumeration<String> e = this.ffeLabels.getKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            String value = this.getValue(key);
            this.reverseLookUp.put(value, key);
        }
    }

    public boolean setLocale(String language, String country) {
        Locale locale = new Locale(language, country);
        try {
            this.ffeLabels = (PropertyResourceBundle)ResourceBundle.getBundle("ffe.properties.StringBundle", locale);
        }
        catch (Exception ex) {
            Logger.getLogger("ffe").severe(String.valueOf(ex));
            return false;
        }
        this.loadHashtable();
        this.currentLocale = locale;
        return true;
    }
}

