/*
 * Decompiled with CFR 0.152.
 */
package ffe.parsers;

import ffe.lang.Atom;
import ffe.lang.Bond;
import ffe.lang.MolecularAssembly;
import ffe.lang.Utilities;
import ffe.mm.ForceField;
import java.io.File;
import java.util.ArrayList;

public abstract class SystemFilter {
    protected MolecularAssembly molecularAssembly = null;
    protected Utilities.FileType fileType = Utilities.FileType.UNK;
    protected ArrayList<Atom> atomList = null;
    protected ArrayList<Bond> bondList = null;
    protected ForceField forceField = null;
    protected boolean fileRead = false;

    public static File version(File file) {
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            return file;
        }
        String fileName = file.getAbsolutePath();
        int dot = file.getAbsolutePath().lastIndexOf(".");
        int under = file.getAbsolutePath().lastIndexOf("_");
        File newFile = file;
        if (under > dot) {
            String name = fileName.substring(0, under);
            newFile = new File(name);
        }
        File oldFile = newFile;
        int i = 1;
        while (newFile.exists()) {
            newFile = oldFile;
            int thousand = ++i / 1000;
            int hundred = (i - 1000 * thousand) / 100;
            int tens = (i - 1000 * thousand - 100 * hundred) / 10;
            int ones = i - 1000 * thousand - 100 * hundred - 10 * tens;
            StringBuffer newFileString = new StringBuffer(oldFile.getAbsolutePath());
            if (thousand != 0) {
                newFileString.append('_').append(thousand).append(hundred).append(tens).append(ones);
            } else if (hundred != 0) {
                newFileString.append('_').append(hundred).append(tens).append(ones);
            } else if (tens != 0) {
                newFileString.append('_').append(tens).append(ones);
            } else {
                newFileString.append('_').append(ones);
            }
            newFile = new File(newFileString.toString());
        }
        return newFile;
    }

    public static File previousVersion(File file) {
        if (file == null) {
            return null;
        }
        String fileName = file.getAbsolutePath();
        int dot = file.getAbsolutePath().lastIndexOf(".");
        int under = file.getAbsolutePath().lastIndexOf("_");
        File newFile = file;
        if (under > dot) {
            String name = fileName.substring(0, under);
            newFile = new File(name);
        }
        File baseFile = newFile;
        File previousFile = null;
        int i = 1;
        while (newFile.exists()) {
            previousFile = newFile;
            newFile = baseFile;
            int thousand = ++i / 1000;
            int hundred = (i - 1000 * thousand) / 100;
            int tens = (i - 1000 * thousand - 100 * hundred) / 10;
            int ones = i - 1000 * thousand - 100 * hundred - 10 * tens;
            StringBuffer newFileString = new StringBuffer(baseFile.getAbsolutePath());
            if (thousand != 0) {
                newFileString.append('_').append(thousand).append(hundred).append(tens).append(ones);
            } else if (hundred != 0) {
                newFileString.append('_').append(hundred).append(tens).append(ones);
            } else if (tens != 0) {
                newFileString.append('_').append(tens).append(ones);
            } else {
                newFileString.append('_').append(ones);
            }
            newFile = new File(newFileString.toString());
        }
        return previousFile;
    }

    public SystemFilter() {
    }

    public SystemFilter(MolecularAssembly f) {
        this.molecularAssembly = f;
    }

    public SystemFilter(MolecularAssembly f, ForceField mm) {
        this(f);
        this.forceField = mm;
    }

    public boolean fileRead() {
        return this.fileRead;
    }

    public int getAtomCount() {
        if (this.atomList == null) {
            return 0;
        }
        return this.atomList.size();
    }

    public ArrayList<Atom> getAtomList() {
        return this.atomList;
    }

    public int getBondCount() {
        if (this.bondList == null) {
            return 0;
        }
        return this.bondList.size();
    }

    public MolecularAssembly getMolecularSystem() {
        return this.molecularAssembly;
    }

    public Utilities.FileType getType() {
        return this.fileType;
    }

    public abstract boolean readFile();

    public void setFileRead(boolean b) {
        this.fileRead = b;
    }

    public void setForceField(ForceField f) {
        this.forceField = f;
    }

    public void setMolecularSystem(MolecularAssembly f) {
        this.molecularAssembly = f;
    }

    public void setType(Utilities.FileType fileType) {
        this.fileType = fileType;
    }

    public abstract boolean writeFile();
}

