/*
 * Decompiled with CFR 0.152.
 */
package ffe.parsers;

import ffe.lang.Atom;
import ffe.lang.MolecularAssembly;
import ffe.lang.Polymer;
import ffe.lang.Residue;
import ffe.lang.Utilities;
import ffe.mm.AtomType;
import ffe.parsers.SystemFilter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public final class PDBFilter
extends SystemFilter {
    private static Pattern p = Pattern.compile("\\d");
    static Hashtable<String, AtomType> atomTypes = new Hashtable();
    private String pdbURL = null;

    public static AtomType getAtomType(String s) {
        String c = s.toLowerCase();
        if (c.startsWith("h")) {
            return atomTypes.get("H");
        }
        if (c.startsWith("c")) {
            return atomTypes.get("C");
        }
        if (c.startsWith("n")) {
            return atomTypes.get("N");
        }
        if (c.startsWith("o")) {
            return atomTypes.get("O");
        }
        if (c.startsWith("p")) {
            return atomTypes.get("P");
        }
        if (c.startsWith("s")) {
            return atomTypes.get("S");
        }
        if (p.matcher(s.substring(0, 1)).matches()) {
            return PDBFilter.getAtomType(s.substring(1, s.length()));
        }
        return atomTypes.get("X");
    }

    public PDBFilter() {
    }

    public PDBFilter(MolecularAssembly f) {
        super(f);
    }

    public PDBFilter(MolecularAssembly f, String pdb) {
        super(f);
        this.pdbURL = pdb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean readFile() {
        fw = null;
        br = null;
        bw = null;
        logger = Logger.getLogger("ffe");
        this.molecularAssembly.setFileType(Utilities.FileType.PDB);
        try {
            this.setFileRead(false);
            if (this.pdbURL == null) {
                pdbFile = this.molecularAssembly.getFile();
                if (pdbFile == null) return false;
                if (pdbFile.exists() == false) return false;
                if (!pdbFile.canRead()) {
                    return false;
                }
                fr = new FileReader(pdbFile);
                br = new BufferedReader(fr);
                logger.info("  Opening " + pdbFile.getName());
            } else {
                try {
                    url = new URL(this.pdbURL);
                    br = new BufferedReader(new InputStreamReader(url.openStream()));
                    for (retry = 0; !br.ready() && retry < 10; ++retry) {
                        var7_11 = this;
                        synchronized (var7_11) {
                            logger.info("Waiting on Network");
                            this.wait(50L);
                            continue;
                        }
                    }
                }
                catch (Exception e) {
                    logger.severe(e.toString() + "\n");
                    return false;
                }
                pdbFile = this.molecularAssembly.getFile();
                if (pdbFile != null && !pdbFile.exists()) {
                    fw = new FileWriter(pdbFile);
                    bw = new BufferedWriter(fw);
                    logger.info("  Opening " + pdbFile.getName());
                }
            }
            rawdata = br.readLine();
            atomnum = 1;
            a = null;
            d = new double[3];
            link = false;
            links = new ArrayList<String[]>();
            structs = new Vector<String[]>();
            residue = null;
            polymer = null;
            while (rawdata != null && !rawdata.startsWith("END")) {
                len = rawdata.length();
                if (len > 6) {
                    len = 6;
                }
                if ((identity = rawdata.substring(0, len).trim().toUpperCase().intern()) == "ATOM" || identity == "HETATM") {
                    altloc = rawdata.substring(16, 17).toUpperCase();
                    if (!altloc.equals(" ")) {
                        this.molecularAssembly.addAltLocation(altloc);
                    }
                    if (altloc.equals(" ") || altloc.equals("A")) {
                        type = rawdata.substring(12, 16).trim().intern();
                        residueType = rawdata.substring(17, 20).trim().intern();
                        residueNum = Integer.decode(rawdata.substring(22, 26).trim());
                        polymerType = rawdata.substring(21, 22).intern();
                        if (polymerType.equalsIgnoreCase(" ")) {
                            polymerType = "Blank".intern();
                        }
                        d[0] = Double.valueOf(rawdata.substring(30, 38).trim());
                        d[1] = Double.valueOf(rawdata.substring(38, 46).trim());
                        d[2] = Double.valueOf(rawdata.substring(46, 54).trim());
                        atomType = PDBFilter.getAtomType(type);
                        a = new Atom(atomnum++, type, atomType, d, residueType, residueNum, polymerType);
                        if (residue != null && polymer != null && residue.getResidueNumber() == residueNum && residue.getName() == residueType && polymer.getName() == polymerType) {
                            residue.addMSNode(a);
                        } else {
                            this.molecularAssembly.addMSNode(a);
                            residue = (Residue)a.getMSNode(Residue.class);
                            polymer = (Polymer)a.getMSNode(Polymer.class);
                        }
                    }
                } else if (identity == "CONECT") {
                    link = true;
                    connect = new String[]{new String(rawdata.substring(7, 11).trim()), new String(rawdata.substring(12, 16).trim())};
                    links.add(connect);
                } else if (identity == "SSBOND") {
                    link = true;
                    connect = new String[]{new String(rawdata.substring(15, 16)), new String(rawdata.substring(29, 30)), new String(rawdata.substring(17, 21).trim()), new String(rawdata.substring(31, 35).trim()), new String("SG"), new String("SG")};
                    links.add(connect);
                } else if (identity == "LINK") {
                    link = true;
                    connect = new String[]{new String(rawdata.substring(21, 22)), new String(rawdata.substring(51, 52)), new String(rawdata.substring(22, 26).trim()), new String(rawdata.substring(52, 56).trim()), new String(rawdata.substring(12, 16).trim()), new String(rawdata.substring(42, 46).trim())};
                    links.add(connect);
                } else if (identity == "HELIX") {
                    struct = new String[]{new String(rawdata.substring(0, 6).trim()), new String(rawdata.substring(19, 20)), new String(rawdata.substring(31, 32)), new String(rawdata.substring(21, 25).trim()), new String(rawdata.substring(33, 37).trim()), new String(rawdata.substring(38, 40).trim())};
                    structs.add(struct);
                } else if (identity == "SHEET") {
                    struct = new String[]{new String(rawdata.substring(0, 6).trim()), new String(rawdata.substring(21, 22)), new String(rawdata.substring(32, 33)), new String(rawdata.substring(22, 26).trim()), new String(rawdata.substring(33, 37).trim()), new String(rawdata.substring(38, 40).trim())};
                    structs.add(struct);
                } else if (identity == "TURN") {
                    struct = new String[6];
                    struct[0] = new String(rawdata.substring(0, 6).trim());
                    struct[1] = new String(rawdata.substring(19, 20));
                    struct[2] = new String(rawdata.substring(30, 31));
                    struct[3] = new String(rawdata.substring(20, 24).trim());
                    struct[4] = new String(rawdata.substring(31, 35).trim());
                    structs.add(struct);
                }
                if (bw != null) {
                    bw.write(rawdata);
                    bw.newLine();
                }
                rawdata = br.readLine();
            }
            if (bw != null) {
                bw.flush();
                bw.close();
            }
            br.close();
            logger.info("  Read " + --atomnum + " atoms");
            var23_28 = structs.iterator();
            block8: while (true) {
                if (!var23_28.hasNext()) {
                    this.setFileRead(true);
                    return true;
                }
                s = (String[])var23_28.next();
                if (s[1].equalsIgnoreCase(" ")) {
                    s[1] = "Blank".intern();
                }
                if ((p = this.molecularAssembly.getPolymer(s[1], false)) == null) continue;
                i = Integer.parseInt(s[3]);
                while (true) {
                    if (i <= Integer.parseInt(s[4])) ** break;
                    continue block8;
                    r = p.getResidue(i);
                    if (r != null) {
                        r.setSSType(Residue.SSType.valueOf(s[0]));
                    }
                    ++i;
                }
                break;
            }
        }
        catch (IOException e) {
            logger.severe("Exception opening: " + this.molecularAssembly.getFile().getName());
            return false;
        }
    }

    @Override
    public boolean writeFile() {
        return false;
    }

    static {
        atomTypes.put("H", new AtomType(1, -1, "H", "Hydrogen", 1, 12.0, 4));
        atomTypes.put("C", new AtomType(6, -1, "C", "Carbon", 6, 12.0, 4));
        atomTypes.put("N", new AtomType(7, -1, "N", "Nitrogen", 7, 14.0, 3));
        atomTypes.put("O", new AtomType(8, -1, "O", "Oxygen", 8, 16.0, 2));
        atomTypes.put("P", new AtomType(15, -1, "P", "Phosphorus", 15, 31.0, 4));
        atomTypes.put("S", new AtomType(16, -1, "S", "Sulfur", 16, 32.0, 2));
        atomTypes.put("X", new AtomType(0, -1, "X", "X", 3, 1.0, 4));
    }
}

