/*
 * Decompiled with CFR 0.152.
 */
package ffe.parsers;

import ffe.lang.Keyword;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.logging.Logger;

public class KeyFilter {
    private static Logger logger = Logger.getLogger("ffe");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable<String, Keyword> open(File keyFile) {
        Hashtable<String, Keyword> hashtable;
        if (keyFile == null || !keyFile.exists() || !keyFile.canRead()) {
            return null;
        }
        Hashtable<String, Keyword> keywordHash = new Hashtable<String, Keyword>();
        FileReader fr = null;
        BufferedReader br = null;
        try {
            fr = new FileReader(keyFile);
            br = new BufferedReader(fr);
            Keyword comments = new Keyword("COMMENTS");
            keywordHash.put("COMMENTS", comments);
            while (br.ready()) {
                String data;
                String keyword;
                String s = br.readLine();
                if (s == null) continue;
                s = s.trim();
                s = s.replace("\t", " ");
                if ((s = s.replace("~", System.getProperty("user.home"))).equals("")) continue;
                if (s.startsWith("#") || s.toUpperCase().startsWith("ECHO")) {
                    comments.append(s);
                    continue;
                }
                int firstspace = s.indexOf(" ");
                if (firstspace == -1) {
                    keyword = s.trim().toUpperCase();
                    data = keyword.equalsIgnoreCase("RATTLE") ? "RATTLE" : null;
                } else {
                    keyword = s.substring(0, firstspace).toUpperCase();
                    data = s.substring(firstspace).trim();
                }
                Keyword kd = keywordHash.get(keyword);
                if (kd == null) {
                    kd = new Keyword(keyword);
                    keywordHash.put(keyword, kd);
                }
                if (data != null) {
                    kd.append(data);
                }
                if (keyword.equalsIgnoreCase("MULTIPOLE")) {
                    int[] mnum = new int[]{3, 1, 2, 3};
                    for (int i = 0; i < 4; ++i) {
                        if (!br.ready()) {
                            System.out.println("Check for an invalid MULTIPOLE keyword.");
                            Hashtable<String, Keyword> hashtable2 = null;
                            return hashtable2;
                        }
                        s = br.readLine();
                        if (s == null) {
                            logger.warning("MULTIPOLE format error.");
                            Hashtable<String, Keyword> hashtable3 = null;
                            return hashtable3;
                        }
                        if ((s = s.trim()).split("\\s+").length != mnum[i]) {
                            logger.warning("MULTIPOLE format error.");
                            Hashtable<String, Keyword> hashtable4 = null;
                            return hashtable4;
                        }
                        kd.append(s);
                    }
                    continue;
                }
                if (!keyword.equalsIgnoreCase("TORTORS")) continue;
                String[] res = data.split("\\s+");
                if (res == null || res.length < 7) {
                    logger.warning("TORTORS format error.");
                    Hashtable<String, Keyword> i = null;
                    return i;
                }
                int xres = Integer.parseInt(res[5]);
                int yres = Integer.parseInt(res[6]);
                for (int i = 0; i < xres * yres; ++i) {
                    if (!br.ready()) {
                        System.out.println("Check for an invalid TORTORS keyword.");
                        Hashtable<String, Keyword> hashtable5 = null;
                        return hashtable5;
                    }
                    s = br.readLine();
                    if (s == null) {
                        logger.warning("TORTORS format error.");
                        Hashtable<String, Keyword> hashtable6 = null;
                        return hashtable6;
                    }
                    if ((s = s.trim()).split("\\s+").length != 3) {
                        logger.warning("TORTORS format error.");
                        Hashtable<String, Keyword> hashtable7 = null;
                        return hashtable7;
                    }
                    kd.append(s);
                }
            }
            hashtable = keywordHash;
            return hashtable;
        }
        catch (IOException e) {
            System.err.println("Error reading Key File: " + String.valueOf(e));
            hashtable = null;
            return hashtable;
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

