/*
 * Decompiled with CFR 0.152.
 */
package ffe.parsers;

import ffe.lang.Atom;
import ffe.lang.MolecularAssembly;
import ffe.lang.VectorMath;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.logging.Logger;

public class InducedFilter {
    MolecularAssembly fsystem;
    File file;
    private Logger logger = Logger.getLogger("ffe");

    public InducedFilter(MolecularAssembly s, File f) {
        this.fsystem = s;
        this.file = f;
    }

    public boolean read() {
        if (!this.file.exists() || !this.file.canRead()) {
            return false;
        }
        try {
            FileReader fr = new FileReader(this.file);
            BufferedReader br = new BufferedReader(fr);
            String data = br.readLine();
            String[] tokens = data.trim().split("\\s+");
            if (tokens.length == 0) {
                return false;
            }
            int numatoms = Integer.parseInt(tokens[0]);
            if (numatoms != this.fsystem.getAtomList().size()) {
                return false;
            }
            double[][] x = new double[numatoms][3];
            for (int i = 0; i < numatoms; ++i) {
                data = br.readLine().trim();
                tokens = data.split("\\s+");
                if (tokens.length != 5) {
                    return false;
                }
                x[i][0] = Double.parseDouble(tokens[2]);
                x[i][1] = Double.parseDouble(tokens[3]);
                x[i][2] = Double.parseDouble(tokens[4]);
            }
            ArrayList<Atom> atoms = this.fsystem.getAtomList();
            double max = 0.0;
            for (Atom a : atoms) {
                int j = a.getXYZIndex() - 1;
                a.setInducedDipole(-x[j][0], -x[j][1], -x[j][2]);
                double r = VectorMath.r(x[j]);
                if (!(r > max)) continue;
                max = r;
            }
            Atom.setMaxInduced(max);
            this.logger.warning("Max Induced: " + max);
            br.close();
            fr.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

