/*
 * Decompiled with CFR 0.152.
 */
package ffe.parsers;

import ffe.lang.Atom;
import ffe.lang.Bond;
import ffe.lang.MolecularAssembly;
import ffe.lang.Utilities;
import ffe.lang.VectorMath;
import ffe.mm.AtomType;
import ffe.mm.ForceField;
import ffe.parsers.SystemFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Logger;

public class INTFilter
extends SystemFilter {
    private Logger logger = Logger.getLogger("ffe");
    private static double[] x = new double[3];
    private static double[] zcos = new double[2];
    private static double[] zsin = new double[2];
    private static double[] xa = new double[3];
    private static double[] xb = new double[3];
    private static double[] xc = new double[3];
    private static double[] xab = new double[3];
    private static double[] xba = new double[3];
    private static double[] xbc = new double[3];
    private static double[] xac = new double[3];
    private static double[] xt = new double[3];
    private static double[] xu = new double[3];
    private static double rab;
    private static double cosb;
    private static double sinb;
    private static double cosg;
    private static double sing;
    private static double sine;
    private static double sine2;
    private static double cosine;
    private static double a;
    private static double b;
    private static double c;
    private static double xtmp;
    private static double ztmp;
    private static double eps;

    public INTFilter() {
        this.setType(Utilities.FileType.INT);
    }

    public INTFilter(MolecularAssembly sys) {
        super(sys);
        this.setType(Utilities.FileType.INT);
    }

    public INTFilter(MolecularAssembly sys, ForceField forceField) {
        super(sys, forceField);
        this.setType(Utilities.FileType.INT);
    }

    public void intxyz(ArrayList<Atom> atoms, Atom atom, int[] zi, double[] zv) {
        zv[1] = Math.toRadians(zv[1]);
        zv[2] = Math.toRadians(zv[2]);
        INTFilter.zcos[0] = Math.cos(zv[1]);
        INTFilter.zcos[1] = Math.cos(zv[2]);
        INTFilter.zsin[0] = Math.sin(zv[1]);
        INTFilter.zsin[1] = Math.sin(zv[2]);
        if (zi[0] == 0) {
            atom.moveTo(0.0, 0.0, 0.0);
            return;
        }
        if (zi[1] == 0) {
            atoms.get(zi[0] - 1).getXYZ(xa);
            xa[2] = xa[2] + zv[0];
            atom.moveTo(xa);
            return;
        }
        if (zi[2] == 0) {
            atoms.get(zi[0] - 1).getXYZ(xa);
            atoms.get(zi[1] - 1).getXYZ(xb);
            VectorMath.diff(xa, xb, xab);
            rab = VectorMath.r(xab);
            VectorMath.norm(xab, xab);
            cosb = xab[2];
            sinb = Math.sqrt(xab[0] * xab[0] + xab[1] * xab[1]);
            if (sinb == 0.0) {
                cosg = 1.0;
                sing = 0.0;
            } else {
                cosg = xab[1] / sinb;
                sing = xab[0] / sinb;
            }
            xtmp = zv[0] * zsin[0];
            ztmp = rab - zv[0] * zcos[0];
            INTFilter.x[0] = xb[0] + xtmp * cosg + ztmp * sing * sinb;
            INTFilter.x[1] = xb[1] - xtmp * sing + ztmp * cosg * sinb;
            INTFilter.x[2] = xb[2] + ztmp * cosb;
            atom.moveTo(x);
            return;
        }
        if (zi[3] == 0) {
            atoms.get(zi[0] - 1).getXYZ(xa);
            atoms.get(zi[1] - 1).getXYZ(xb);
            atoms.get(zi[2] - 1).getXYZ(xc);
            VectorMath.diff(xa, xb, xab);
            VectorMath.norm(xab, xab);
            VectorMath.diff(xb, xc, xbc);
            VectorMath.norm(xbc, xbc);
            INTFilter.xt[0] = xab[2] * xbc[1] - xab[1] * xbc[2];
            INTFilter.xt[1] = xab[0] * xbc[2] - xab[2] * xbc[0];
            INTFilter.xt[2] = xab[1] * xbc[0] - xab[0] * xbc[1];
            cosine = xab[0] * xbc[0] + xab[1] * xbc[1] + xab[2] * xbc[2];
            sine = Math.sqrt(Math.max(1.0 - cosine * cosine, eps));
            if (Math.abs(cosine) >= 1.0) {
                this.logger.warning("Undefined Dihedral");
            }
            VectorMath.scalar(xt, 1.0 / sine, xt);
            INTFilter.xu[0] = xt[1] * xab[2] - xt[2] * xab[1];
            INTFilter.xu[1] = xt[2] * xab[0] - xt[0] * xab[2];
            INTFilter.xu[2] = xt[0] * xab[1] - xt[1] * xab[0];
            INTFilter.x[0] = xa[0] + zv[0] * (xu[0] * zsin[0] * zcos[1] + xt[0] * zsin[0] * zsin[1] - xab[0] * zcos[0]);
            INTFilter.x[1] = xa[1] + zv[0] * (xu[1] * zsin[0] * zcos[1] + xt[1] * zsin[0] * zsin[1] - xab[1] * zcos[0]);
            INTFilter.x[2] = xa[2] + zv[0] * (xu[2] * zsin[0] * zcos[1] + xt[2] * zsin[0] * zsin[1] - xab[2] * zcos[0]);
            atom.moveTo(x);
            return;
        }
        if (Math.abs(zi[3]) == 1) {
            atoms.get(zi[0] - 1).getXYZ(xa);
            atoms.get(zi[1] - 1).getXYZ(xb);
            atoms.get(zi[2] - 1).getXYZ(xc);
            VectorMath.diff(xb, xa, xba);
            VectorMath.norm(xba, xba);
            VectorMath.diff(xa, xc, xac);
            VectorMath.norm(xac, xac);
            INTFilter.xt[0] = xba[2] * xac[1] - xba[1] * xac[2];
            INTFilter.xt[1] = xba[0] * xac[2] - xba[2] * xac[0];
            INTFilter.xt[2] = xba[1] * xac[0] - xba[0] * xac[1];
            cosine = xba[0] * xac[0] + xba[1] * xac[1] + xba[2] * xac[2];
            sine2 = Math.max(1.0 - cosine * cosine, eps);
            if (Math.abs(cosine) >= 1.0) {
                this.logger.warning("Defining Atom Colinear");
            }
            if ((c = (1.0 + (a = (-zcos[1] - cosine * zcos[0]) / sine2) * zcos[1] - (b = (zcos[0] + cosine * zcos[1]) / sine2) * zcos[0]) / sine2) > eps) {
                c = (double)zi[3] * Math.sqrt(c);
            } else if (c < -eps) {
                c = Math.sqrt((a * xac[0] + b * xba[0]) * (a * xac[0] + b * xba[0]) + (a * xac[1] + b * xba[1]) * (a * xac[1] + b * xba[1]) + (a * xac[2] + b * xba[2]) * (a * xac[2] + b * xba[2]));
                a /= c;
                b /= c;
                c = 0.0;
            } else {
                c = 0.0;
            }
            INTFilter.x[0] = xa[0] + zv[0] * (a * xac[0] + b * xba[0] + c * xt[0]);
            INTFilter.x[1] = xa[1] + zv[0] * (a * xac[1] + b * xba[1] + c * xt[1]);
            INTFilter.x[2] = xa[2] + zv[0] * (a * xac[2] + b * xba[2] + c * xt[2]);
            atom.moveTo(x);
        }
    }

    @Override
    public boolean readFile() {
        Logger logger = Logger.getLogger("ffe");
        File intFile = this.molecularAssembly.getFile();
        if (this.forceField == null) {
            logger.warning("No force field is associated with " + intFile.toString());
            return false;
        }
        try {
            int i;
            int numberOfAtoms;
            FileReader fr = new FileReader(intFile);
            BufferedReader br = new BufferedReader(fr);
            String data = br.readLine().trim();
            while (data != null && data.length() == 0) {
                data = br.readLine().trim();
            }
            if (data == null) {
                logger.warning("Empty file: " + intFile.toString());
                return false;
            }
            String[] tokens = data.trim().split("\\s+");
            try {
                numberOfAtoms = Integer.parseInt(tokens[0]);
                if (numberOfAtoms < 1) {
                    logger.warning("Invalid number of atoms: " + numberOfAtoms);
                    return false;
                }
            }
            catch (Exception e) {
                logger.severe("Error parsing the number of atoms.\n" + String.valueOf(e));
                return false;
            }
            if (tokens.length >= 2) {
                tokens = data.trim().split(" +", 2);
                this.molecularAssembly.setName(tokens[1]);
            }
            logger.info("  Opening " + intFile.getName() + " with " + numberOfAtoms + " atoms");
            double[] d = new double[]{0.0, 0.0, 0.0};
            int[][] zi = new int[numberOfAtoms][4];
            double[][] zv = new double[numberOfAtoms][3];
            Vector<int[]> zadd = new Vector<int[]>();
            Vector<int[]> zdel = new Vector<int[]>();
            this.atomList = new ArrayList();
            for (i = 0; i < numberOfAtoms; ++i) {
                if (!br.ready()) {
                    return false;
                }
                data = br.readLine();
                if (data == null) {
                    logger.severe("  Check atom " + (i + 1) + " in " + this.molecularAssembly.getFile().getName());
                    return false;
                }
                tokens = data.trim().split("\\s+");
                if (tokens == null || tokens.length < 3) {
                    logger.severe("  Check atom " + (i + 1) + " in " + this.molecularAssembly.getFile().getName());
                    return false;
                }
                String name = tokens[1];
                int type = Integer.parseInt(tokens[2]);
                AtomType atomType = (AtomType)this.forceField.getForceFieldType(ForceField.ForceFieldType.ATOM, String.valueOf(type));
                if (atomType == null) {
                    logger.severe("  Check atom " + (i + 1) + " in " + this.molecularAssembly.getFile().getName());
                    return false;
                }
                Atom a = new Atom(i + 1, name, atomType, d);
                this.atomList.add(a);
                if (tokens.length >= 5) {
                    zi[i][0] = Integer.parseInt(tokens[3]);
                    zv[i][0] = Double.parseDouble(tokens[4]);
                } else {
                    zi[i][0] = 0;
                    zv[i][0] = 0.0;
                }
                if (tokens.length >= 7) {
                    zi[i][1] = Integer.parseInt(tokens[5]);
                    zv[i][1] = Double.parseDouble(tokens[6]);
                } else {
                    zi[i][1] = 0;
                    zv[i][1] = 0.0;
                }
                if (tokens.length >= 10) {
                    zi[i][2] = Integer.parseInt(tokens[7]);
                    zv[i][2] = Double.parseDouble(tokens[8]);
                    zi[i][3] = Integer.parseInt(tokens[9]);
                    continue;
                }
                zi[i][2] = 0;
                zv[i][2] = 0.0;
                zi[i][3] = 0;
            }
            if (br.ready() && (data = br.readLine()).trim().equalsIgnoreCase("")) {
                int[] pair;
                boolean blank = false;
                while (br.ready() && !blank) {
                    data = br.readLine();
                    if (data.trim().equalsIgnoreCase("")) {
                        blank = true;
                        continue;
                    }
                    tokens = data.trim().split("\\s+");
                    if (tokens.length != 2) {
                        logger.severe("  Check Additional Bond Pair: " + (zadd.size() + 1) + " in " + this.molecularAssembly.getFile().getName());
                        return false;
                    }
                    pair = new int[]{Integer.parseInt(tokens[0]), Integer.parseInt(tokens[1])};
                    zadd.add(pair);
                }
                while (br.ready()) {
                    data = br.readLine();
                    tokens = data.trim().split("\\s+");
                    if (tokens.length != 2) {
                        logger.severe("  Check Bond Pair to Remove: " + (zadd.size() + 1) + " in " + this.molecularAssembly.getFile().getName());
                        return false;
                    }
                    pair = new int[]{Integer.parseInt(tokens[0]), Integer.parseInt(tokens[1])};
                    zdel.add(pair);
                }
            }
            br.close();
            fr.close();
            if (this.atomList.size() == numberOfAtoms) {
                this.bondList = new ArrayList();
                for (i = 1; i < numberOfAtoms; ++i) {
                    int partner = zi[i][0];
                    boolean del = false;
                    for (int j = 0; j < zdel.size(); ++j) {
                        int[] pair = (int[])zdel.get(j);
                        if (pair[0] == i + 1 && pair[1] == partner) {
                            del = true;
                        }
                        if (pair[1] != i + 1 || pair[0] != partner) continue;
                        del = true;
                    }
                    if (del) continue;
                    Atom atom1 = (Atom)this.atomList.get(i);
                    Atom atom2 = (Atom)this.atomList.get(partner - 1);
                    this.bondList.add(new Bond(atom1, atom2, 1));
                }
                for (i = 0; i < zadd.size(); ++i) {
                    int[] pair = (int[])zadd.get(i);
                    Atom atom1 = (Atom)this.atomList.get(pair[0] - 1);
                    Atom atom2 = (Atom)this.atomList.get(pair[1] - 1);
                    this.bondList.add(new Bond(atom1, atom2, 1));
                }
                for (i = 0; i < numberOfAtoms; ++i) {
                    this.intxyz(this.atomList, (Atom)this.atomList.get(i), zi[i], zv[i]);
                }
                return true;
            }
            logger.warning("Reported number of Atoms: " + numberOfAtoms + "\nNumber of Atoms Found: " + this.atomList.size());
        }
        catch (IOException e) {
            logger.severe(e.toString());
        }
        return false;
    }

    @Override
    public boolean writeFile() {
        return false;
    }

    static {
        eps = 1.0E-7;
    }
}

