/*
 * Decompiled with CFR 0.152.
 */
package ffe.parsers;

import ffe.mm.AngleType;
import ffe.mm.AtomType;
import ffe.mm.BioType;
import ffe.mm.BondType;
import ffe.mm.ChargeType;
import ffe.mm.ForceField;
import ffe.mm.MultipoleType;
import ffe.mm.OutOfPlaneBendType;
import ffe.mm.PiTorsionType;
import ffe.mm.PolarizeType;
import ffe.mm.StretchBendType;
import ffe.mm.TorsionTorsionType;
import ffe.mm.TorsionType;
import ffe.mm.UreyBradleyType;
import ffe.mm.VDWType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.logging.Logger;

public class ForceFieldFilter {
    public static final Hashtable<String, String> aminoAcidLookup = new Hashtable();
    private ForceField forceField = null;
    private Logger logger = Logger.getLogger("ffe");

    public ForceFieldFilter(File forceFieldFile, File keyFile) {
        this.forceField = new ForceField(forceFieldFile, keyFile);
    }

    public ForceField parse() {
        if (this.forceField.forceFieldFile != null) {
            this.parse(this.forceField.forceFieldFile);
        }
        if (this.forceField.keyFile != null) {
            this.parse(this.forceField.keyFile);
        }
        return this.forceField;
    }

    private void parse(File file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            block24: while (br.ready()) {
                String input = br.readLine();
                String[] tokens = input.trim().split("\\s+");
                if (tokens == null) continue;
                String keyword = tokens[0].toUpperCase().replaceAll("-", "_");
                try {
                    ForceField.ForceFieldString forceFieldString = ForceField.ForceFieldString.valueOf(keyword);
                    this.forceField.addForceFieldString(forceFieldString, tokens[1]);
                }
                catch (Exception e) {
                    try {
                        ForceField.ForceFieldDouble forceFieldDouble = ForceField.ForceFieldDouble.valueOf(keyword);
                        double value = Double.parseDouble(tokens[1]);
                        this.forceField.addForceFieldDouble(forceFieldDouble, value);
                    }
                    catch (Exception e2) {
                        try {
                            ForceField.ForceFieldType type = ForceField.ForceFieldType.valueOf(tokens[0].toUpperCase());
                            switch (type) {
                                case ATOM: {
                                    this.parseAtom(input, tokens);
                                    continue block24;
                                }
                                case ANGLE: {
                                    this.parseAngle(input, tokens);
                                    continue block24;
                                }
                                case BIOTYPE: {
                                    this.parseBioType(input, tokens);
                                    continue block24;
                                }
                                case BOND: {
                                    this.parseBond(input, tokens);
                                    continue block24;
                                }
                                case CHARGE: {
                                    this.parseCharge(input, tokens);
                                    continue block24;
                                }
                                case MULTIPOLE: {
                                    this.parseMultipole(input, tokens, br);
                                    continue block24;
                                }
                                case OPBEND: {
                                    this.parseOPBend(input, tokens);
                                    continue block24;
                                }
                                case STRBND: {
                                    this.parseStrBnd(input, tokens);
                                    continue block24;
                                }
                                case PITORS: {
                                    this.parsePiTorsion(input, tokens);
                                    continue block24;
                                }
                                case TORSION: {
                                    this.parseTorsion(input, tokens);
                                    continue block24;
                                }
                                case TORTORS: {
                                    this.parseTorsionTorsion(input, tokens, br);
                                    continue block24;
                                }
                                case UREYBRAD: {
                                    this.parseUreyBradley(input, tokens);
                                    continue block24;
                                }
                                case VDW: {
                                    this.parseVDW(input, tokens);
                                    continue block24;
                                }
                                case POLARIZE: {
                                    this.parsePolarize(input, tokens);
                                    continue block24;
                                }
                            }
                            this.logger.warning("ForceField type recognized, but not stored:" + String.valueOf((Object)type));
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            br.close();
            fis.close();
        }
        catch (Exception e) {
            this.logger.warning("Error parsing force field parameters from: " + String.valueOf(file) + "\n" + String.valueOf(e));
        }
    }

    private void parseAngle(String input, String[] tokens) {
        double[] bondAngle;
        int i;
        double forceConstant;
        int[] atomClasses;
        block5: {
            if (tokens.length < 6) {
                this.logger.warning("Invalid ANGLE type:\n" + input);
                return;
            }
            atomClasses = new int[3];
            forceConstant = 0.0;
            i = 0;
            int angles = 0;
            bondAngle = null;
            try {
                atomClasses[0] = Integer.parseInt(tokens[1]);
                atomClasses[1] = Integer.parseInt(tokens[2]);
                atomClasses[2] = Integer.parseInt(tokens[3]);
                forceConstant = Double.parseDouble(tokens[4]);
                angles = tokens.length - 5;
                bondAngle = new double[angles];
                for (i = 0; i < angles; ++i) {
                    bondAngle[i] = Double.parseDouble(tokens[5 + i]);
                }
            }
            catch (Exception e) {
                if (tokens[5 + i].startsWith("!!")) break block5;
                this.logger.warning("Exception parsing ANGLE type:\n" + input + "\n" + String.valueOf(e));
            }
        }
        double[] newBondAngle = new double[i];
        for (int j = 0; j < i; ++j) {
            newBondAngle[j] = bondAngle[i];
        }
        AngleType angleType = new AngleType(atomClasses, forceConstant, newBondAngle);
        this.forceField.addForceFieldType(angleType);
    }

    private void parseAtom(String input, String[] tokens) {
        if (tokens.length < 7) {
            this.logger.warning("Invalid ATOM type:\n" + input);
            return;
        }
        try {
            int index = 1;
            int type = Integer.parseInt(tokens[index++]);
            int atomClass = -1;
            try {
                atomClass = Integer.parseInt(tokens[index]);
            }
            catch (Exception e) {
                atomClass = -1;
            }
            int n = ++index;
            ++index;
            String name = tokens[n].intern();
            int first = input.indexOf("\"");
            int last = input.lastIndexOf("\"");
            if (first >= last) {
                this.logger.warning("Invalid ATOM type:\n" + input);
                return;
            }
            String environment = input.substring(first, last + 1).intern();
            tokens = input.substring(last + 1).trim().split("\\s+");
            index = 0;
            int atomicNumber = Integer.parseInt(tokens[index++]);
            double mass = Double.parseDouble(tokens[index++]);
            int hybridization = Integer.parseInt(tokens[index++]);
            AtomType atomType = new AtomType(type, atomClass, name, environment, atomicNumber, mass, hybridization);
            this.forceField.addForceFieldType(atomType);
        }
        catch (Exception e) {
            this.logger.warning("Exception parsing CHARGE type:\n" + input + "\n" + String.valueOf(e));
        }
    }

    private void parseBioType(String input, String[] tokens) {
        if (tokens.length < 5) {
            this.logger.warning("Invalid BIOTYPE type:\n" + input);
            return;
        }
        try {
            int index = Integer.parseInt(tokens[1]);
            String PDB = tokens[2];
            int first = input.indexOf("\"");
            int last = input.lastIndexOf("\"");
            if (first >= last) {
                this.logger.warning("Invalid BIOTYPE type:\n" + input);
                return;
            }
            String residue = input.substring(first, last + 1).intern();
            tokens = input.substring(last + 1).trim().split("\\s+");
            int atomType = Integer.parseInt(tokens[0]);
            BioType bioType = new BioType(index, PDB, residue, atomType);
            this.forceField.addForceFieldType(bioType);
        }
        catch (Exception e) {
            this.logger.warning("Exception parsing BIOTYPE type:\n" + input + "\n" + String.valueOf(e));
        }
    }

    private void parseBond(String input, String[] tokens) {
        if (tokens.length < 5) {
            this.logger.warning("Invalid BOND type:\n" + input);
            return;
        }
        try {
            int[] atomClasses = new int[]{Integer.parseInt(tokens[1]), Integer.parseInt(tokens[2])};
            double forceConstant = Double.parseDouble(tokens[3]);
            double distance = Double.parseDouble(tokens[4]);
            BondType bondType = new BondType(atomClasses, forceConstant, distance);
            this.forceField.addForceFieldType(bondType);
        }
        catch (Exception e) {
            this.logger.warning("Exception parsing BOND type:\n" + input + "\n" + String.valueOf(e));
        }
    }

    private void parseCharge(String input, String[] tokens) {
        if (tokens.length < 3) {
            this.logger.warning("Invalid CHARGE type:\n" + input);
            return;
        }
        try {
            int atomType = Integer.parseInt(tokens[1]);
            double partialCharge = Double.parseDouble(tokens[2]);
            ChargeType chargeType = new ChargeType(atomType, partialCharge);
            this.forceField.addForceFieldType(chargeType);
        }
        catch (Exception e) {
            this.logger.warning("Exception parsing CHARGE type:\n" + input + "\n" + String.valueOf(e));
        }
    }

    private void parseMultipole(String input, String[] tokens, BufferedReader br) {
        if (tokens.length < 5) {
            this.logger.warning("Invalid MULTIPOLE type:\n" + input);
            return;
        }
        try {
            MultipoleType.MultipoleFrameDefinition frameDefinition = MultipoleType.MultipoleFrameDefinition.ZTHENX;
            int numTypes = tokens.length - 2;
            int[] atomTypes = new int[numTypes];
            for (int i = 0; i < numTypes; ++i) {
                atomTypes[i] = Integer.parseInt(tokens[i + 1]);
                if (atomTypes[i] >= 0) continue;
                frameDefinition = MultipoleType.MultipoleFrameDefinition.BISECTOR;
                atomTypes[i] = Math.abs(atomTypes[i]);
            }
            double c = Double.parseDouble(tokens[1 + numTypes]);
            input = br.readLine();
            tokens = input.trim().split("\\s+");
            if (tokens.length != 3) {
                this.logger.warning("Invalid MULTIPOLE type:\n" + input);
                return;
            }
            double[] dipole = new double[]{Double.parseDouble(tokens[0]), Double.parseDouble(tokens[1]), Double.parseDouble(tokens[2])};
            input = br.readLine();
            tokens = input.trim().split("\\s+");
            if (tokens.length != 1) {
                this.logger.warning("Invalid MULTIPOLE type:\n" + input);
                return;
            }
            double[][] quadrupole = new double[3][3];
            quadrupole[0][0] = Double.parseDouble(tokens[0]);
            input = br.readLine();
            tokens = input.trim().split("\\s+");
            if (tokens.length != 2) {
                this.logger.warning("Invalid MULTIPOLE type:\n" + input);
                return;
            }
            quadrupole[1][0] = Double.parseDouble(tokens[0]);
            quadrupole[1][1] = Double.parseDouble(tokens[1]);
            input = br.readLine();
            tokens = input.trim().split("\\s+");
            if (tokens.length != 3) {
                this.logger.warning("Invalid MULTIPOLE type:\n" + input);
                return;
            }
            quadrupole[2][0] = Double.parseDouble(tokens[0]);
            quadrupole[2][1] = Double.parseDouble(tokens[1]);
            quadrupole[2][2] = Double.parseDouble(tokens[2]);
            quadrupole[0][1] = quadrupole[1][0];
            quadrupole[0][2] = quadrupole[2][0];
            quadrupole[1][2] = quadrupole[2][1];
            MultipoleType multipoleType = new MultipoleType(c, dipole, quadrupole, atomTypes, frameDefinition);
            this.forceField.addForceFieldType(multipoleType);
        }
        catch (Exception e) {
            this.logger.warning("Exception parsing MULTIPOLE type:\n" + input + "\n" + e.toString());
        }
    }

    private void parseOPBend(String input, String[] tokens) {
        if (tokens.length < 4) {
            this.logger.warning("Invalid OPBEND type:\n" + input);
            return;
        }
        try {
            int[] atomClasses = new int[]{Integer.parseInt(tokens[1]), Integer.parseInt(tokens[2])};
            double forceConstant = Double.parseDouble(tokens[3]);
            OutOfPlaneBendType opbendType = new OutOfPlaneBendType(atomClasses, forceConstant);
            this.forceField.addForceFieldType(opbendType);
        }
        catch (Exception e) {
            this.logger.warning("Exception parsing OPBEND type:\n" + input + "\n" + String.valueOf(e));
        }
    }

    private void parsePiTorsion(String input, String[] tokens) {
        if (tokens.length < 4) {
            this.logger.warning("Invalid PITORS type:\n" + input);
            return;
        }
        try {
            int[] atomClasses = new int[]{Integer.parseInt(tokens[1]), Integer.parseInt(tokens[2])};
            double forceConstant = Double.parseDouble(tokens[3]);
            PiTorsionType piTorsionType = new PiTorsionType(atomClasses, forceConstant);
            this.forceField.addForceFieldType(piTorsionType);
        }
        catch (Exception e) {
            this.logger.warning("Exception parsing PITORS type:\n" + input + "\n" + String.valueOf(e));
        }
    }

    private void parsePolarize(String input, String[] tokens) {
        if (tokens.length < 4) {
            this.logger.warning("Invalid POLARIZE type:\n" + input);
        }
        try {
            int atomType = Integer.parseInt(tokens[1]);
            double polarizability = Double.parseDouble(tokens[2]);
            double thole = Double.parseDouble(tokens[3]);
            int entries = tokens.length - 4;
            int[] polarizationGroup = null;
            if (entries > 0) {
                polarizationGroup = new int[entries];
                for (int i = 4; i < tokens.length; ++i) {
                    polarizationGroup[i - 4] = Integer.parseInt(tokens[i]);
                }
            }
            PolarizeType polarizeType = new PolarizeType(atomType, polarizability, thole, polarizationGroup);
            this.forceField.addForceFieldType(polarizeType);
        }
        catch (Exception e) {
            this.logger.warning("Exception parsing POLARIZE type:\n" + input + "\n" + String.valueOf(e));
        }
    }

    private void parseStrBnd(String input, String[] tokens) {
        if (tokens.length < 5) {
            this.logger.warning("Invalid STRBND type:\n" + input);
            return;
        }
        try {
            int[] atomClasses = new int[]{Integer.parseInt(tokens[1]), Integer.parseInt(tokens[2]), Integer.parseInt(tokens[3])};
            double[] forceConstants = new double[]{Double.parseDouble(tokens[4]), Double.parseDouble(tokens[5])};
            StretchBendType strbndType = new StretchBendType(atomClasses, forceConstants);
            this.forceField.addForceFieldType(strbndType);
        }
        catch (Exception e) {
            this.logger.warning("Exception parsing STRBND type:\n" + input + "\n" + String.valueOf(e));
        }
    }

    private void parseTorsion(String input, String[] tokens) {
        if (tokens.length < 5) {
            this.logger.warning("Invalid TORSION type:\n" + input);
            return;
        }
        try {
            int[] atomClasses = new int[]{Integer.parseInt(tokens[1]), Integer.parseInt(tokens[2]), Integer.parseInt(tokens[3]), Integer.parseInt(tokens[4])};
            int terms = (tokens.length - 5) / 3;
            double[] amplitude = new double[terms];
            double[] phase = new double[terms];
            int[] periodicity = new int[terms];
            int index = 5;
            for (int i = 0; i < terms; ++i) {
                amplitude[i] = Double.parseDouble(tokens[index++]);
                phase[i] = Double.parseDouble(tokens[index++]);
                periodicity[i] = Integer.parseInt(tokens[index++]);
            }
            TorsionType torsionType = new TorsionType(atomClasses, amplitude, phase, periodicity);
            this.forceField.addForceFieldType(torsionType);
        }
        catch (Exception e) {
            this.logger.warning("Exception parsing TORSION type:\n" + input + "\n" + String.valueOf(e));
        }
    }

    private void parseTorsionTorsion(String input, String[] tokens, BufferedReader br) {
        if (tokens.length < 8) {
            this.logger.warning("Invalid TORTORS type:\n" + input);
            return;
        }
        try {
            int[] atomClasses = new int[5];
            for (int i = 0; i < 5; ++i) {
                atomClasses[i] = Integer.parseInt(tokens[i + 1]);
            }
            int[] gridPoints = new int[]{Integer.parseInt(tokens[6]), Integer.parseInt(tokens[7])};
            int points = gridPoints[0] * gridPoints[1];
            double[] torsion1 = new double[points];
            double[] torsion2 = new double[points];
            double[] energy = new double[points];
            for (int i = 0; i < points; ++i) {
                input = br.readLine();
                tokens = input.trim().split("\\s+");
                if (tokens.length != 3) {
                    this.logger.warning("Invalid TORTORS type:\n" + input);
                    return;
                }
                torsion1[i] = Double.parseDouble(tokens[0]);
                torsion2[i] = Double.parseDouble(tokens[1]);
                energy[i] = Double.parseDouble(tokens[2]);
            }
            TorsionTorsionType torsionTorsionType = new TorsionTorsionType(atomClasses, gridPoints, torsion1, torsion2, energy);
            this.forceField.addForceFieldType(torsionTorsionType);
        }
        catch (Exception e) {
            this.logger.warning("Exception parsing TORTORS type:\n" + input + "\n" + String.valueOf(e));
        }
    }

    private void parseUreyBradley(String input, String[] tokens) {
        if (tokens.length < 5) {
            this.logger.warning("Invalid UREYBRAD type:\n" + input);
            return;
        }
        try {
            int[] atomClasses = new int[]{Integer.parseInt(tokens[1]), Integer.parseInt(tokens[2]), Integer.parseInt(tokens[3])};
            double forceConstant = Double.parseDouble(tokens[4]);
            double distance = Double.parseDouble(tokens[5]);
            UreyBradleyType ureyType = new UreyBradleyType(atomClasses, forceConstant, distance);
            this.forceField.addForceFieldType(ureyType);
        }
        catch (Exception e) {
            this.logger.warning("Exception parsing UREYBRAD type:\n" + input + "\n" + String.valueOf(e));
        }
    }

    private void parseVDW(String input, String[] tokens) {
        if (tokens.length < 4) {
            this.logger.warning("Invalid VDW type:\n" + input);
            return;
        }
        try {
            int atomType = Integer.parseInt(tokens[1]);
            double radius = Double.parseDouble(tokens[2]);
            double wellDepth = Double.parseDouble(tokens[3]);
            double reductionFactor = -1.0;
            if (tokens.length == 5) {
                reductionFactor = Double.parseDouble(tokens[4]);
            }
            VDWType vdwType = new VDWType(atomType, radius, wellDepth, reductionFactor);
            this.forceField.addForceFieldType(vdwType);
        }
        catch (Exception e) {
            this.logger.warning("Exception parsing VDW type:\n" + input + "\n" + String.valueOf(e));
        }
    }

    static {
        aminoAcidLookup.put("GLY", "Glycine");
        aminoAcidLookup.put("ALA", "Alanine");
        aminoAcidLookup.put("VAL", "Valine");
        aminoAcidLookup.put("LEU", "Leucine");
        aminoAcidLookup.put("ILE", "Isoleucine");
        aminoAcidLookup.put("SER", "Serine");
        aminoAcidLookup.put("THR", "Threonine");
        aminoAcidLookup.put("CYS", "Cystine (-SS-)");
        aminoAcidLookup.put("PRO", "Proline");
        aminoAcidLookup.put("PHE", "Phenylalanine");
        aminoAcidLookup.put("TYR", "Tyrosine");
        aminoAcidLookup.put("TRP", "Tryptophan");
        aminoAcidLookup.put("HIS", "Histidine (HD)");
        aminoAcidLookup.put("ASP", "Aspartic Acid");
        aminoAcidLookup.put("ASN", "Asparagine");
        aminoAcidLookup.put("GLU", "Glutamic Acid");
        aminoAcidLookup.put("GLN", "Glutamine");
        aminoAcidLookup.put("MET", "Methionine");
        aminoAcidLookup.put("LYS", "Lysine");
        aminoAcidLookup.put("ARG", "Arginine");
        aminoAcidLookup.put("A", "Adenine");
        aminoAcidLookup.put("T", "Thymine");
        aminoAcidLookup.put("G", "Guanine");
        aminoAcidLookup.put("C", "Cytosine");
        aminoAcidLookup.put("HOH", "HOH");
        aminoAcidLookup.put("HEM", "HEM");
    }
}

