/*
 * Decompiled with CFR 0.152.
 */
package ffe.parsers;

import ffe.lang.Atom;
import ffe.lang.MolecularAssembly;
import ffe.lang.VectorMath;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;

public class DYNFilter {
    MolecularAssembly fsystem;
    File file;

    public DYNFilter(MolecularAssembly s, File f) {
        this.fsystem = s;
        this.file = f;
    }

    public boolean read() {
        if (!this.file.exists() || !this.file.canRead()) {
            return false;
        }
        try {
            double r;
            int j;
            FileReader fr = new FileReader(this.file);
            BufferedReader br = new BufferedReader(fr);
            br.readLine();
            String data = br.readLine().trim();
            String[] tokens = data.split("\\s+");
            if (tokens.length == 0) {
                return false;
            }
            int numatoms = Integer.parseInt(tokens[0]);
            if (numatoms != this.fsystem.getAtomList().size()) {
                return false;
            }
            br.readLine();
            data = br.readLine().trim();
            tokens = data.split("\\s+");
            if (tokens.length != 3) {
                return false;
            }
            double[] d = new double[]{Double.parseDouble(tokens[0]), Double.parseDouble(tokens[1]), Double.parseDouble(tokens[2])};
            this.fsystem.setBox(d);
            data = br.readLine().trim();
            tokens = data.split("\\s+");
            if (tokens.length != 3) {
                return false;
            }
            d[0] = Double.parseDouble(tokens[0]);
            d[1] = Double.parseDouble(tokens[1]);
            d[2] = Double.parseDouble(tokens[2]);
            this.fsystem.setAngle(d);
            br.readLine();
            double[][] x = new double[numatoms][3];
            for (int i = 0; i < numatoms; ++i) {
                data = br.readLine().trim();
                tokens = data.split("\\s+");
                if (tokens.length != 3) {
                    return false;
                }
                x[i][0] = Double.parseDouble(tokens[0]);
                x[i][1] = Double.parseDouble(tokens[1]);
                x[i][2] = Double.parseDouble(tokens[2]);
            }
            ArrayList<Atom> atoms = this.fsystem.getAtomList();
            for (Atom a : atoms) {
                int j2 = a.getXYZIndex() - 1;
                a.moveTo(x[j2][0], x[j2][1], x[j2][2]);
            }
            br.readLine();
            for (int i = 0; i < numatoms; ++i) {
                data = br.readLine().trim();
                tokens = data.split("\\s+");
                if (tokens.length != 3) {
                    return false;
                }
                x[i][0] = Double.parseDouble(tokens[0]);
                x[i][1] = Double.parseDouble(tokens[1]);
                x[i][2] = Double.parseDouble(tokens[2]);
            }
            double max = 0.0;
            for (Atom a : atoms) {
                j = a.getXYZIndex() - 1;
                a.setVeclocity(x[j][0], x[j][1], x[j][2]);
                r = VectorMath.r(x[j]);
                if (!(r > max)) continue;
                max = r;
            }
            Atom.setMaxVelocity(max);
            br.readLine();
            for (int i = 0; i < numatoms; ++i) {
                data = br.readLine().trim();
                tokens = data.split("\\s+");
                if (tokens.length != 3) {
                    return false;
                }
                x[i][0] = Double.parseDouble(tokens[0]);
                x[i][1] = Double.parseDouble(tokens[1]);
                x[i][2] = Double.parseDouble(tokens[2]);
            }
            max = 0.0;
            for (Atom a : atoms) {
                j = a.getXYZIndex() - 1;
                a.setAcceleration(x[j][0], x[j][1], x[j][2]);
                r = VectorMath.r(x[j]);
                if (!(r > max)) continue;
                max = r;
            }
            Atom.setMaxAcceleration(max);
            br.close();
            fr.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

