/*
 * Decompiled with CFR 0.152.
 */
package ffe.mm;

import ffe.mm.BaseType;
import ffe.mm.ForceField;

public final class VDWType
extends BaseType {
    public final int atomClass;
    public final double radius;
    public final double wellDepth;
    public final double reductionFactor;

    public VDWType(int atomClass, double radius, double wellDepth, double reductionFactor) {
        super(ForceField.ForceFieldType.VDW, new String("" + atomClass));
        this.atomClass = atomClass;
        this.radius = radius;
        this.wellDepth = wellDepth;
        this.reductionFactor = reductionFactor;
    }

    public String toString() {
        String vdwString = this.reductionFactor <= 0.0 ? String.format("vdw  %5d  %11.9f  %11.9f", this.atomClass, this.radius, this.wellDepth) : String.format("vdw  %5d  %11.9f  %11.9f  %5.3f", this.atomClass, this.radius, this.wellDepth, this.reductionFactor);
        return vdwString;
    }

    public static enum RadiusType {
        RMIN,
        SIGMA;

    }

    public static enum RadiusSize {
        RADIUS,
        DIAMETER;

    }
}

