/*
 * Decompiled with CFR 0.152.
 */
package ffe.mm;

import ffe.mm.BaseType;
import ffe.mm.ForceField;

public final class TorsionType
extends BaseType {
    public final int[] atomClasses;
    public final double[] amplitude;
    public final double[] phase;
    public final int[] periodicity;

    public TorsionType(int[] atomClasses, double[] amplitude, double[] phase, int[] periodicity) {
        super(ForceField.ForceFieldType.TORSION, new String(atomClasses[0] + " " + atomClasses[1] + " " + atomClasses[2] + " " + atomClasses[3]));
        this.atomClasses = atomClasses;
        this.amplitude = amplitude;
        this.phase = phase;
        this.periodicity = periodicity;
    }

    public String toString() {
        StringBuffer torsionBuffer = new StringBuffer("torsion");
        for (int i : this.atomClasses) {
            torsionBuffer.append(String.format("  %5d", i));
        }
        for (int i = 0; i < this.amplitude.length; ++i) {
            torsionBuffer.append(String.format("  % 5.3f  %5.3f  %1d", this.amplitude[i], this.phase[i], this.periodicity[i]));
        }
        return torsionBuffer.toString();
    }
}

