/*
 * Decompiled with CFR 0.152.
 */
package ffe.mm;

import ffe.mm.BaseType;
import ffe.mm.ForceField;

public final class TorsionTorsionType
extends BaseType {
    public final int[] atomClasses;
    public final int[] gridPoints;
    public final double[] torsion1;
    public final double[] torsion2;
    public final double[] energy;

    public TorsionTorsionType(int[] atomClasses, int[] gridPoints, double[] torsion1, double[] torsion2, double[] energy) {
        super(ForceField.ForceFieldType.TORTORS, new String(atomClasses[0] + " " + atomClasses[1] + " " + atomClasses[2] + " " + atomClasses[3] + " " + atomClasses[4]));
        this.atomClasses = atomClasses;
        this.gridPoints = gridPoints;
        this.torsion1 = torsion1;
        this.torsion2 = torsion2;
        this.energy = energy;
    }

    public String toString() {
        StringBuffer tortorBuffer = new StringBuffer("tortors");
        for (int i : this.atomClasses) {
            tortorBuffer.append(String.format("  %5d", i));
        }
        tortorBuffer.append(String.format("  %2d  %2d", this.gridPoints[0], this.gridPoints[1]));
        for (int i = 0; i < this.energy.length; ++i) {
            tortorBuffer.append(String.format("\n  % 6.1f  % 6.1f  % 8.5f", this.torsion1[i], this.torsion2[i], this.energy[i]));
        }
        return tortorBuffer.toString();
    }
}

