/*
 * Decompiled with CFR 0.152.
 */
package ffe.mm;

import ffe.mm.BaseType;
import ffe.mm.ForceField;

public final class MultipoleType
extends BaseType {
    public static final double DEBYE = 4.8033324;
    public static final double BUCKINGHAM = 23.072002144889765;
    public static final double BOHR = 0.5291772083;
    public static final double BOHR2 = 0.28002851778418164;
    public final double charge;
    public final double[] dipole;
    public final double[][] quadrupole;
    public final MultipoleFrameDefinition frameDefinition;
    public final int[] frameAtomTypes;

    public MultipoleType(double charge, double[] dipole, double[][] quadrupole, int[] multipoleFrameTypes, MultipoleFrameDefinition frameDefinition) {
        super(ForceField.ForceFieldType.MULTIPOLE, multipoleFrameTypes);
        this.charge = charge;
        this.dipole = dipole;
        this.quadrupole = quadrupole;
        this.frameAtomTypes = multipoleFrameTypes;
        this.frameDefinition = frameDefinition;
        this.initMultipole();
    }

    private void initMultipole() {
        double check = Math.abs(this.quadrupole[0][1] - this.quadrupole[1][0]);
        if (check > 1.0E-6) {
            this.logger.warning("Multipole component Qxy != Qyx");
            this.print();
        }
        if ((check = Math.abs(this.quadrupole[0][2] - this.quadrupole[2][0])) > 1.0E-6) {
            this.logger.warning("Multipole component Qxz != Qzx");
            this.print();
        }
        if ((check = Math.abs(this.quadrupole[1][2] - this.quadrupole[2][1])) > 1.0E-6) {
            this.logger.warning("Multipole component Qyz != Qzy");
            this.print();
        }
        int i = 0;
        while (i < 3) {
            int n = i++;
            this.dipole[n] = this.dipole[n] * 0.5291772083;
        }
        for (i = 0; i < 3; ++i) {
            int j = 0;
            while (j < 3) {
                double[] dArray = this.quadrupole[i];
                int n = j++;
                dArray[n] = dArray[n] * 0.28002851778418164;
            }
        }
        double sum = this.quadrupole[0][0] + this.quadrupole[1][1] + this.quadrupole[2][2];
        if (Math.abs(sum) > 1.0E-5) {
            String warn = String.format("Multipole is not traceless: %7.5f", sum);
            this.logger.warning(warn + "\n" + this.toBohrString());
        }
    }

    @Override
    public void print() {
        this.logger.info(this.toBohrString());
    }

    public String toBohrString() {
        StringBuffer multipoleBuffer = new StringBuffer("multipole");
        for (int i : this.frameAtomTypes) {
            multipoleBuffer.append(String.format("  %5d", i));
        }
        if (this.frameAtomTypes.length == 3) {
            multipoleBuffer.append("       ");
        }
        multipoleBuffer.append(String.format("  % 7.5f\n%11$s % 7.5f % 7.5f % 7.5f\n%11$s % 7.5f\n%11$s % 7.5f % 7.5f\n%11$s % 7.5f % 7.5f % 7.5f", this.charge, this.dipole[0] / 0.5291772083, this.dipole[1] / 0.5291772083, this.dipole[2] / 0.5291772083, this.quadrupole[0][0] / 0.28002851778418164, this.quadrupole[1][0] / 0.28002851778418164, this.quadrupole[1][1] / 0.28002851778418164, this.quadrupole[2][0] / 0.28002851778418164, this.quadrupole[2][1] / 0.28002851778418164, this.quadrupole[2][2] / 0.28002851778418164, "                                      "));
        return multipoleBuffer.toString();
    }

    public String toDebyeString() {
        StringBuffer multipoleBuffer = new StringBuffer("multipole");
        for (int i : this.frameAtomTypes) {
            multipoleBuffer.append(String.format("  %5d", i));
        }
        if (this.frameAtomTypes.length == 3) {
            multipoleBuffer.append("       ");
        }
        multipoleBuffer.append(String.format("  % 7.5f\n%11$s % 7.5f % 7.5f % 7.5f\n%11$s % 7.5f\n%11$s % 7.5f % 7.5f\n%11$s % 7.5f % 7.5f % 7.5f", this.charge, this.dipole[0] * 4.8033324, this.dipole[1] * 4.8033324, this.dipole[2] * 4.8033324, this.quadrupole[0][0] * 23.072002144889765, this.quadrupole[1][0] * 23.072002144889765, this.quadrupole[1][1] * 23.072002144889765, this.quadrupole[2][0] * 23.072002144889765, this.quadrupole[2][1] * 23.072002144889765, this.quadrupole[2][2] * 23.072002144889765, "                                      "));
        return multipoleBuffer.toString();
    }

    public String toString() {
        return this.toBohrString();
    }

    public static enum MultipoleFrameDefinition {
        ZTHENX,
        BISECTOR;

    }
}

