/*
 * Decompiled with CFR 0.152.
 */
package ffe.mm;

import ffe.mm.AngleType;
import ffe.mm.AtomType;
import ffe.mm.BaseType;
import ffe.mm.BioType;
import ffe.mm.BondType;
import ffe.mm.ChargeType;
import ffe.mm.MultipoleType;
import ffe.mm.OutOfPlaneBendType;
import ffe.mm.PiTorsionType;
import ffe.mm.PolarizeType;
import ffe.mm.StretchBendType;
import ffe.mm.TorsionTorsionType;
import ffe.mm.TorsionType;
import ffe.mm.UreyBradleyType;
import ffe.mm.VDWType;
import java.io.File;
import java.util.TreeMap;
import java.util.logging.Logger;

public class ForceField {
    public File forceFieldFile;
    public File keyFile;
    private final Logger logger;
    private final TreeMap<String, AngleType> angle;
    private final TreeMap<String, AtomType> atom;
    private final TreeMap<String, BondType> bond;
    private final TreeMap<String, BioType> biotype;
    private final TreeMap<String, ChargeType> charge;
    private final TreeMap<String, MultipoleType> multipole;
    private final TreeMap<String, OutOfPlaneBendType> opbend;
    private final TreeMap<String, PolarizeType> polarize;
    private final TreeMap<String, StretchBendType> strbnd;
    private final TreeMap<String, PiTorsionType> pitors;
    private final TreeMap<String, TorsionType> torsion;
    private final TreeMap<String, TorsionTorsionType> tortor;
    private final TreeMap<String, UreyBradleyType> ureybrad;
    private final TreeMap<String, VDWType> vdw;
    private final TreeMap<ForceFieldType, TreeMap> types;
    private final TreeMap<ForceFieldString, String> keyString;
    private final TreeMap<ForceFieldDouble, Double> keyDouble;

    public ForceField(File forceFieldFile, File keyFile) {
        this.forceFieldFile = forceFieldFile;
        this.keyFile = keyFile;
        this.logger = Logger.getLogger("ffe");
        this.angle = new TreeMap();
        this.atom = new TreeMap();
        this.bond = new TreeMap();
        this.biotype = new TreeMap();
        this.charge = new TreeMap();
        this.opbend = new TreeMap();
        this.multipole = new TreeMap();
        this.pitors = new TreeMap();
        this.polarize = new TreeMap();
        this.strbnd = new TreeMap();
        this.torsion = new TreeMap();
        this.tortor = new TreeMap();
        this.ureybrad = new TreeMap();
        this.vdw = new TreeMap();
        this.types = new TreeMap();
        this.types.put(ForceFieldType.ANGLE, this.angle);
        this.types.put(ForceFieldType.ATOM, this.atom);
        this.types.put(ForceFieldType.BOND, this.bond);
        this.types.put(ForceFieldType.BIOTYPE, this.biotype);
        this.types.put(ForceFieldType.CHARGE, this.charge);
        this.types.put(ForceFieldType.OPBEND, this.opbend);
        this.types.put(ForceFieldType.MULTIPOLE, this.multipole);
        this.types.put(ForceFieldType.PITORS, this.pitors);
        this.types.put(ForceFieldType.POLARIZE, this.polarize);
        this.types.put(ForceFieldType.STRBND, this.strbnd);
        this.types.put(ForceFieldType.TORSION, this.torsion);
        this.types.put(ForceFieldType.TORTORS, this.tortor);
        this.types.put(ForceFieldType.UREYBRAD, this.ureybrad);
        this.types.put(ForceFieldType.VDW, this.vdw);
        this.keyString = new TreeMap();
        this.keyDouble = new TreeMap();
    }

    public void addForceFieldDouble(ForceFieldDouble keyword, double value) {
        if (this.keyDouble.containsKey((Object)keyword)) {
            String oldValue = this.keyString.get((Object)keyword);
            this.logger.warning("Old " + String.valueOf((Object)keyword) + " value: " + oldValue + "\nReplaced with: " + value);
        }
        this.keyDouble.put(keyword, value);
    }

    public void addForceFieldString(ForceFieldString keyword, String newEntry) {
        if (this.keyString.containsKey((Object)keyword)) {
            String oldValue = this.keyString.get((Object)keyword);
            this.logger.warning("Old " + String.valueOf((Object)keyword) + " value: " + oldValue + "\nReplaced with: " + newEntry);
        }
        this.keyString.put(keyword, newEntry);
    }

    public void addForceFieldType(BaseType type) {
        if (type == null) {
            this.logger.info("Force field type is NULL.");
            return;
        }
        TreeMap treeMap = this.types.get((Object)type.forceFieldType);
        if (treeMap == null) {
            this.logger.info("Unrecognized Force Field Type: " + String.valueOf((Object)type.forceFieldType));
            type.print();
        }
        if (treeMap.containsKey(type.key)) {
            this.logger.fine("A force field entry of type " + String.valueOf((Object)type.forceFieldType) + " already exists with the key: " + type.key + "\nThe (discarded) old entry:\n" + treeMap.get(type.key).toString() + "\nThe new entry:\n" + type.toString());
        }
        Class<?> baseTypeClass = type.getClass();
        treeMap.put(type.key, baseTypeClass.cast(type));
    }

    public BaseType getForceFieldType(ForceFieldType type, String key) {
        TreeMap treeMap = this.types.get((Object)type);
        if (treeMap == null) {
            this.logger.warning("Unrecognized Force Field Type: " + String.valueOf((Object)type));
            return null;
        }
        return (BaseType)treeMap.get(key);
    }

    public int getForceFieldTypeCount(ForceFieldType type) {
        TreeMap treeMap = this.types.get((Object)type);
        if (treeMap == null) {
            this.logger.warning("Unrecognized Force Field Type: " + String.valueOf((Object)type));
            return 0;
        }
        return treeMap.size();
    }

    public void print() {
        for (ForceFieldString forceFieldString : this.keyString.keySet()) {
            this.print(forceFieldString.toString());
        }
        for (ForceFieldDouble forceFieldDouble : this.keyDouble.keySet()) {
            this.print(forceFieldDouble.toString());
        }
        for (ForceFieldType forceFieldType : this.types.keySet()) {
            this.print(forceFieldType.toString());
        }
    }

    public void print(String keyword) {
        String string = this.toString(keyword);
        if (string == null) {
            this.logger.warning(keyword + " was not recognized");
            return;
        }
        this.logger.info(string);
    }

    public String toString(String keyword) {
        keyword = keyword.toUpperCase().replaceAll("-", "_");
        try {
            ForceFieldString forceFieldString = ForceFieldString.valueOf(keyword);
            String value = this.keyString.get((Object)forceFieldString);
            if (value == null) {
                return null;
            }
            String string = String.format("%-25s  %s", keyword.toLowerCase().replaceAll("_", "-"), value.toUpperCase());
            return string;
        }
        catch (Exception e) {
            try {
                ForceFieldDouble forceFieldDouble = ForceFieldDouble.valueOf(keyword);
                Double value = this.keyDouble.get((Object)forceFieldDouble);
                if (value == null) {
                    return null;
                }
                String string = String.format("%-25s  %g", keyword.toLowerCase().replaceAll("_", "-"), (double)value);
                return string;
            }
            catch (Exception e2) {
                try {
                    ForceFieldType type = ForceFieldType.valueOf(keyword);
                    StringBuffer stringBuffer = new StringBuffer();
                    TreeMap t = this.types.get((Object)type);
                    for (Object o : t.values()) {
                        stringBuffer.append(o.toString() + "\n");
                    }
                    return stringBuffer.toString();
                }
                catch (Exception e3) {
                    return null;
                }
            }
        }
    }

    public static enum ForceFieldType {
        ATOM,
        ANGLE,
        BIOTYPE,
        BOND,
        CHARGE,
        MULTIPOLE,
        OPBEND,
        PITORS,
        POLARIZE,
        STRBND,
        TORSION,
        TORTORS,
        UREYBRAD,
        VDW;

    }

    public static enum ForceFieldString {
        EPSILONRULE,
        FORCEFIELD,
        RADIUSRULE,
        RADIUSSIZE,
        RADIUSTYPE,
        POLARIZATION,
        VDWTYPE;

    }

    public static enum ForceFieldDouble {
        ANGLE_CUBIC,
        ANGLE_QUARTIC,
        ANGLE_PENTIC,
        ANGLE_SEXTIC,
        BOND_CUBIC,
        BOND_QUARTIC,
        OPBENDUNIT,
        TORSIONUNIT,
        DIELECTRIC,
        POLAR_DAMP,
        VDW_13_SCALE,
        VDW_14_SCALE,
        VDW_15_SCALE,
        MPOLE_11_SCALE,
        MPOLE_12_SCALE,
        MPOLE_13_SCALE,
        MPOLE_14_SCALE,
        MPOLE_15_SCALE,
        POLAR_11_SCALE,
        POLAR_12_SCALE,
        POLAR_13_SCALE,
        POLAR_14_SCALE,
        POLAR_15_SCALE,
        DIRECT_11_SCALE,
        DIRECT_12_SCALE,
        DIRECT_13_SCALE,
        DIRECT_14_SCALE,
        MUTUAL_11_SCALE,
        MUTUAL_12_SCALE,
        MUTUAL_13_SCALE,
        MUTUAL_14_SCALE;

    }
}

