/*
 * Decompiled with CFR 0.152.
 */
package ffe.lang;

import java.util.logging.Logger;

public final class VectorMath {
    private static Logger logger = Logger.getLogger("ffe");
    private static final float[] fa = new float[3];
    private static final float[] fb = new float[3];
    private static final float[] fc = new float[3];
    private static final float[] fd = new float[3];
    private static final float[] fba = new float[3];
    private static final float[] fcb = new float[3];
    private static final float[] fdc = new float[3];
    private static final float[] ft = new float[3];
    private static final float[] fu = new float[3];
    private static final float[] ftu = new float[3];
    private static final double[] da = new double[3];
    private static final double[] db = new double[3];
    private static final double[] dc = new double[3];
    private static final double[] dd = new double[3];
    private static final double[] dba = new double[3];
    private static final double[] dcb = new double[3];
    private static final double[] ddc = new double[3];
    private static final double[] dt = new double[3];
    private static final double[] du = new double[3];
    private static final double[] dtu = new double[3];

    public static double angle(double[] i, double[] j) {
        VectorMath.norm(i, da);
        VectorMath.norm(j, db);
        double x = VectorMath.dot(da, db);
        if (Math.abs(x) > 1.0) {
            x = x > 0.0 ? 1.0 : -1.0;
        }
        return Math.acos(x);
    }

    public static float angle(float[] i, float[] j) {
        VectorMath.norm(i, fa);
        VectorMath.norm(j, fb);
        float x = VectorMath.dot(fa, fb);
        if (Math.abs(x) > 1.0f) {
            Logger.getLogger("ffe").warning("angle: abs(dot) > 1 " + x);
            x = x > 0.0f ? 1.0f : -1.0f;
        }
        return (float)Math.acos(x);
    }

    public static long binomial(long n, long k) {
        return VectorMath.factorial(n) / (VectorMath.factorial(n - k) * VectorMath.factorial(k));
    }

    public static double bondAngle(double[] i, double[] j, double[] k) {
        VectorMath.diff(i, j, da);
        VectorMath.diff(k, j, db);
        VectorMath.norm(da, dc);
        VectorMath.norm(db, dd);
        double x = VectorMath.dot(dc, dd);
        if (Math.abs(x) > 1.0) {
            x = x > 0.0 ? 1.0 : -1.0;
        }
        return Math.acos(x);
    }

    public static float bondAngle(float[] i, float[] j, float[] k) {
        VectorMath.diff(i, j, fa);
        VectorMath.diff(k, j, fb);
        VectorMath.norm(fa, fc);
        VectorMath.norm(fb, fd);
        float x = VectorMath.dot(fc, fd);
        if (Math.abs(x) > 1.0f) {
            Logger.getLogger("ffe").warning("bondAngle: abs(dot) > 1 " + x);
            x = x > 0.0f ? 1.0f : -1.0f;
        }
        return (float)Math.acos(x);
    }

    public static void cross(double[] a, double[] b, double[] ret) {
        ret[0] = a[1] * b[2] - a[2] * b[1];
        ret[1] = a[2] * b[0] - a[0] * b[2];
        ret[2] = a[0] * b[1] - a[1] * b[0];
    }

    public static void cross(float[] a, float[] b, float[] ret) {
        ret[0] = a[1] * b[2] - a[2] * b[1];
        ret[1] = a[2] * b[0] - a[0] * b[2];
        ret[2] = a[0] * b[1] - a[1] * b[0];
    }

    public static void diff(double[] a, double[] b, double[] ret) {
        ret[0] = a[0] - b[0];
        ret[1] = a[1] - b[1];
        ret[2] = a[2] - b[2];
    }

    public static void diff(float[] a, float[] b, float[] ret) {
        ret[0] = a[0] - b[0];
        ret[1] = a[1] - b[1];
        ret[2] = a[2] - b[2];
    }

    public static double dihedralAngle(double[] a, double[] b, double[] c, double[] d) {
        VectorMath.diff(b, a, dba);
        VectorMath.diff(c, b, dcb);
        VectorMath.diff(d, c, ddc);
        VectorMath.cross(dba, dcb, dt);
        VectorMath.cross(dcb, ddc, du);
        VectorMath.cross(dt, du, dtu);
        double rt = VectorMath.dot(dt, dt);
        double ru = VectorMath.dot(du, du);
        double rtu = Math.sqrt(rt * ru);
        if (rtu != 0.0) {
            double rcb = VectorMath.r(dcb);
            double cosine = VectorMath.dot(dt, du) / rtu;
            double sine = VectorMath.dot(dcb, dtu) / (rcb * rtu);
            cosine = Math.min(1.0, Math.max(-1.0, cosine));
            double angle = Math.acos(cosine);
            if (sine < 0.0) {
                angle = -angle;
            }
            return angle;
        }
        return 0.0;
    }

    public static float dihedralAngle(float[] a, float[] b, float[] c, float[] d) {
        VectorMath.diff(b, a, fba);
        VectorMath.diff(c, b, fcb);
        VectorMath.diff(d, c, fdc);
        VectorMath.cross(fba, fcb, ft);
        VectorMath.cross(fcb, fdc, fu);
        VectorMath.cross(ft, fu, ftu);
        float rt = VectorMath.dot(ft, ft);
        float ru = VectorMath.dot(fu, fu);
        float rtu = (float)Math.sqrt(rt * ru);
        if ((double)rtu != 0.0) {
            float rcb = VectorMath.r(fcb);
            float cosine = VectorMath.dot(ft, fu) / rtu;
            float sine = VectorMath.dot(fcb, ftu) / (rcb * rtu);
            cosine = Math.min(1.0f, Math.max(-1.0f, cosine));
            float angle = (float)Math.acos(cosine);
            if ((double)sine < 0.0) {
                angle = -angle;
            }
            return angle;
        }
        return 0.0f;
    }

    public static double dist(double[] a, double[] b) {
        double x = (a[0] - b[0]) * (a[0] - b[0]);
        x += (a[1] - b[1]) * (a[1] - b[1]);
        return Math.sqrt(x += (a[2] - b[2]) * (a[2] - b[2]));
    }

    public static float dist(float[] a, float[] b) {
        float x = (a[0] - b[0]) * (a[0] - b[0]);
        x += (a[1] - b[1]) * (a[1] - b[1]);
        return (float)Math.sqrt(x += (a[2] - b[2]) * (a[2] - b[2]));
    }

    public static double dot(double[] a, double[] b) {
        return a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
    }

    public static float dot(float[] a, float[] b) {
        return a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
    }

    public static long doublefactorial(long n) {
        if (n < -1L) {
            throw new RuntimeException("Underflow error in doublefactorial");
        }
        if (n == 0L || n == 1L || n == -1L) {
            return 1L;
        }
        return n * VectorMath.doublefactorial(n - 2L);
    }

    public static long factorial(long n) {
        if (n < 0L) {
            throw new RuntimeException("Underflow error in factorial");
        }
        if (n > 20L) {
            throw new RuntimeException("Overflow error in factorial");
        }
        if (n == 0L) {
            return 1L;
        }
        return n * VectorMath.factorial(n - 1L);
    }

    public static void norm(double[] n, double[] ret) {
        double length = VectorMath.r(n);
        ret[0] = n[0] / length;
        ret[1] = n[1] / length;
        ret[2] = n[2] / length;
    }

    public static void norm(float[] n, float[] ret) {
        float length = VectorMath.r(n);
        ret[0] = n[0] / length;
        ret[1] = n[1] / length;
        ret[2] = n[2] / length;
    }

    public static void printVector(double[] v) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < v.length; ++i) {
            sb.append(String.format("%g ", v[i]));
        }
        logger.info("Vector ( " + sb.toString() + ")");
    }

    public static double r(double[] d) {
        return Math.sqrt(d[0] * d[0] + d[1] * d[1] + d[2] * d[2]);
    }

    public static float r(float[] d) {
        return (float)Math.sqrt(d[0] * d[0] + d[1] * d[1] + d[2] * d[2]);
    }

    public static void scalar(double[] n, double a, double[] ret) {
        ret[0] = n[0] * a;
        ret[1] = n[1] * a;
        ret[2] = n[2] * a;
    }

    public static void scalar(float[] n, float a, float[] ret) {
        ret[0] = n[0] * a;
        ret[1] = n[1] * a;
        ret[2] = n[2] * a;
    }

    public static void sum(double[] a, double[] b, double[] ret) {
        ret[0] = a[0] + b[0];
        ret[1] = a[1] + b[1];
        ret[2] = a[2] + b[2];
    }

    public static void sum(float[] a, float[] b, float[] ret) {
        ret[0] = a[0] + b[0];
        ret[1] = a[1] + b[1];
        ret[2] = a[2] + b[2];
    }
}

