/*
 * Decompiled with CFR 0.152.
 */
package ffe.lang;

import ffe.lang.Atom;
import ffe.lang.Bond;
import ffe.lang.HashCodeUtil;
import ffe.lang.MSNode;
import ffe.lang.RendererCache;
import ffe.lang.ValenceType;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Logger;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Material;
import org.jogamp.vecmath.Color3f;

public abstract class ValenceTerm
extends MSNode {
    private Logger logger = Logger.getLogger("ffe");
    private static StringBuffer idtemp = new StringBuffer();
    private static StringBuffer keytemp = new StringBuffer();
    private String id;
    private String key;
    protected Atom[] atoms;
    protected Bond[] bonds;
    private double value;
    private ValenceType valenceType;

    public ValenceTerm() {
        super("", 1);
        this.setAllowsChildren(false);
    }

    public ValenceTerm(String i) {
        this();
        this.id = i;
    }

    @Override
    public boolean destroy() {
        super.destroy();
        this.id = null;
        this.key = null;
        this.value = 0.0;
        this.valenceType = null;
        return true;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ValenceTerm other = (ValenceTerm)object;
        return this.getID() == other.getID();
    }

    public Atom getAtom(int index) {
        if (index >= 0 && index < this.atoms.length) {
            return this.atoms[index];
        }
        return null;
    }

    public Bond getBond(int index) {
        if (index >= 0 && index < this.atoms.length) {
            return this.bonds[index];
        }
        return null;
    }

    public String getID() {
        return new String(this.id);
    }

    public String getKey() {
        return new String(this.key);
    }

    public ValenceType getMM() {
        return this.valenceType;
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public final int hashCode() {
        return HashCodeUtil.hash(6028, this.getID().hashCode());
    }

    @Override
    public void print() {
        this.logger.info(this.toString());
    }

    public void setAtoms(Atom[] a) {
        this.atoms = a;
    }

    public void setBonds(Bond[] b) {
        this.bonds = b;
    }

    @Override
    public void setColor(RendererCache.ColorModel newColorModel, Color3f color, Material mat) {
        if (this.atoms == null) {
            return;
        }
        for (Atom atom : this.atoms) {
            atom.setColor(newColorModel, color, mat);
        }
    }

    public void setID(String i) {
        this.id = new String(i);
    }

    public final void setID_Key(boolean reverse) {
        if (idtemp.length() > 0) {
            idtemp.delete(0, idtemp.length() - 1);
        }
        if (keytemp.length() > 0) {
            keytemp.delete(0, keytemp.length() - 1);
        }
        if (this.atoms != null) {
            if (!reverse) {
                for (int i = 0; i < this.atoms.length; ++i) {
                    Atom a = this.atoms[i];
                    if (i != 0) {
                        idtemp.append("-").append(a.getID());
                    } else {
                        idtemp.append(a.getID());
                    }
                    keytemp.append(a.getKey());
                }
            } else {
                for (int i = 0; i < this.atoms.length; ++i) {
                    Atom a = this.atoms[i];
                    if (i != 0) {
                        idtemp.append("-").append(a.getID());
                    } else {
                        idtemp.append(a.getID());
                    }
                    keytemp.append(a.getKey());
                }
            }
            this.id = idtemp.substring(1).toString().intern();
            this.key = keytemp.toString().intern();
        }
    }

    public void setKey(String k) {
        this.key = new String(k);
    }

    public void setMM(Hashtable data) {
        this.valenceType = (ValenceType)data.get(this.key);
        if (this.valenceType == null) {
            this.setID_Key(true);
            this.valenceType = (ValenceType)data.get(this.key);
        }
    }

    public void setMM(ValenceType mmterm) {
        this.valenceType = mmterm;
    }

    @Override
    public void setSelected(boolean b) {
        super.setSelected(b);
        if (this.atoms == null) {
            return;
        }
        for (Atom atom : this.atoms) {
            atom.setSelected(b);
        }
        if (!(this instanceof Bond)) {
            if (this.bonds == null) {
                return;
            }
            for (MSNode mSNode : this.bonds) {
                ((ValenceTerm)mSNode).setSelected(b);
            }
        }
    }

    public void setValue(double v) {
        this.value = v;
    }

    @Override
    public void setView(RendererCache.ViewModel newViewModel, List<BranchGroup> newShapes) {
        if (this.atoms == null) {
            return;
        }
        for (Atom atom : this.atoms) {
            atom.setView(newViewModel, newShapes);
        }
        if (this.bonds == null) {
            return;
        }
        for (MSNode mSNode : this.bonds) {
            ((Bond)mSNode).setView(newViewModel, newShapes);
        }
    }

    @Override
    public String toString() {
        return String.format("%s: %7.1f", this.id, this.value);
    }

    @Override
    public abstract void update();
}

