/*
 * Decompiled with CFR 0.152.
 */
package ffe.lang;

import ffe.lang.Angle;
import ffe.lang.Atom;
import ffe.lang.Bond;
import ffe.lang.MolecularAssembly;
import ffe.lang.Molecule;
import ffe.lang.Polymer;
import ffe.lang.Residue;
import ffe.lang.VectorMath;
import ffe.mm.AtomType;
import ffe.mm.ForceField;
import ffe.mm.MultipoleType;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Utilities {
    public static List<List<Atom>> atomListPool = new ArrayList<List<Atom>>();
    static int count = 0;
    public static final int[] AAPATTERN = new int[]{7, 6, 6};
    public static final int[] NAPATTERN = new int[]{8, 6, 6, 6, 8};
    private static Logger logger = Logger.getLogger("ffe");
    private static Hashtable<String, String> sidechainStoichiometry = new Hashtable();
    private static final double[] localOrigin = new double[3];
    private static final double[] zaxis = new double[3];
    private static final double[] xaxis = new double[3];
    private static final double[][] rotmat = new double[3][3];
    private static final double[] dipole = new double[3];
    private static final double[][] quadrupole = new double[3][3];
    private static final double p4 = 15.236;
    private static final double p5 = 1.254;
    private static final double p5inv = 0.7974481658692185;
    private static final double pip5 = 3.9395571876016007;
    private static final double convert = -166.02691;
    private static final double[] x1 = new double[3];
    private static final double[] x2 = new double[3];

    public static void addAtomListToPool(List<Atom> a) {
        a.clear();
        atomListPool.add(a);
    }

    public static void addCap(Atom end, Atom seed, Residue residue) {
        List<Atom> cap = Utilities.getAtomListFromPool();
        cap.add(end);
        Utilities.collectAtoms(seed, cap);
        cap.remove(0);
        cap.remove(0);
        for (Atom a : cap) {
            residue.addMSNode(a);
        }
    }

    public static void addPhosphate(Atom phosphate, Residue residue) {
        if (phosphate == null) {
            return;
        }
        residue.addMSNode(phosphate);
        for (Bond b : phosphate.getBonds()) {
            Atom oxygen = b.get1_2(phosphate);
            if (Utilities.numberOfBondsWith(oxygen, 6) != 0) continue;
            residue.addMSNode(oxygen);
            Atom hydrogen = Utilities.findBondWith(oxygen, 1);
            if (hydrogen == null) continue;
            residue.addMSNode(hydrogen);
        }
    }

    private static boolean assignMultipole(Atom atom, ForceField forceField) {
        String key3;
        Atom atom3;
        String key2;
        Atom atom2;
        AtomType atomType = atom.getAtomType();
        if (atomType == null) {
            logger.warning("Multipoles can only be assigned to atoms that have been typed");
            return false;
        }
        MultipoleType multipoleType = null;
        String key = null;
        key = atomType.key + " 0 0";
        multipoleType = (MultipoleType)forceField.getForceFieldType(ForceField.ForceFieldType.MULTIPOLE, key);
        if (multipoleType != null) {
            atom.setMultipoleType(multipoleType, null);
            return true;
        }
        ArrayList<Bond> bonds = atom.getBonds();
        if (bonds == null || bonds.size() < 1) {
            logger.warning("Multipoles can only be assigned after bonded relationships are defined");
            return false;
        }
        for (Bond b : bonds) {
            atom2 = b.get1_2(atom);
            key = atomType.key + " " + atom2.getAtomType().key + " 0";
            multipoleType = (MultipoleType)forceField.getForceFieldType(ForceField.ForceFieldType.MULTIPOLE, key);
            if (multipoleType == null) continue;
            Atom[] multipoleReferenceAtoms = new Atom[]{atom2};
            atom.setMultipoleType(multipoleType, multipoleReferenceAtoms);
            return true;
        }
        for (Bond b : bonds) {
            atom2 = b.get1_2(atom);
            key2 = atom2.getAtomType().key;
            for (Bond b2 : bonds) {
                if (b == b2) continue;
                atom3 = b2.get1_2(atom);
                key3 = atom3.getAtomType().key;
                key = atomType.key + " " + key2 + " " + key3;
                multipoleType = (MultipoleType)forceField.getForceFieldType(ForceField.ForceFieldType.MULTIPOLE, key);
                if (multipoleType == null) continue;
                Atom[] multipoleReferenceAtoms = new Atom[]{atom2, atom3};
                atom.setMultipoleType(multipoleType, multipoleReferenceAtoms);
                return true;
            }
        }
        for (Bond b : bonds) {
            atom2 = b.get1_2(atom);
            key2 = atom2.getAtomType().key;
            for (Bond b2 : bonds) {
                if (b == b2) continue;
                atom3 = b2.get1_2(atom);
                key3 = atom3.getAtomType().key;
                for (Bond bond : bonds) {
                    if (b == bond || b2 == bond) continue;
                    Atom atom4 = bond.get1_2(atom);
                    String key4 = atom4.getAtomType().key;
                    key = atomType.key + " " + key2 + " " + key3 + " " + key4;
                    multipoleType = (MultipoleType)forceField.getForceFieldType(ForceField.ForceFieldType.MULTIPOLE, key);
                    if (multipoleType == null) continue;
                    Atom[] multipoleReferenceAtoms = new Atom[]{atom2, atom3, atom4};
                    atom.setMultipoleType(multipoleType, multipoleReferenceAtoms);
                    return true;
                }
                ArrayList<Angle> angles = atom.getAngles();
                for (Angle angle : angles) {
                    String key4;
                    Atom atom4 = angle.get1_3(atom);
                    if (atom4 == null || (multipoleType = (MultipoleType)forceField.getForceFieldType(ForceField.ForceFieldType.MULTIPOLE, key = atomType.key + " " + key2 + " " + key3 + " " + (key4 = atom4.getAtomType().key))) == null) continue;
                    Atom[] multipoleReferenceAtoms = new Atom[]{atom2, atom3, atom4};
                    atom.setMultipoleType(multipoleType, multipoleReferenceAtoms);
                    return true;
                }
            }
        }
        for (Bond b : bonds) {
            atom2 = b.get1_2(atom);
            key2 = atom2.getAtomType().key;
            ArrayList<Angle> angles = atom.getAngles();
            for (Angle angle : angles) {
                String key32;
                Atom atom32 = angle.get1_3(atom);
                if (atom32 == null || (multipoleType = (MultipoleType)forceField.getForceFieldType(ForceField.ForceFieldType.MULTIPOLE, key = atomType.key + " " + key2 + " " + (key32 = atom32.getAtomType().key))) == null) continue;
                Atom[] atomArray = new Atom[]{atom2, atom32};
                atom.setMultipoleType(multipoleType, atomArray);
                return true;
            }
        }
        return false;
    }

    public static void assignMultipoles(List<Atom> atoms, ForceField forceField) {
        if (forceField == null) {
            logger.warning("Could not assign multipoles due to null ForceField");
            return;
        }
        if (forceField.getForceFieldTypeCount(ForceField.ForceFieldType.MULTIPOLE) < 1) {
            logger.warning("Force Field has no multipole types");
            return;
        }
        if (atoms == null || atoms.size() < 1) {
            logger.warning("Could not assign multipoles due to null atom list");
            return;
        }
        for (Atom atom : atoms) {
            if (!Utilities.assignMultipole(atom, forceField)) {
                logger.warning("No multipole could be assigned to atom:\n" + String.valueOf(atom) + "\nOf type:\n" + String.valueOf(atom.getAtomType()));
                continue;
            }
            if (!logger.isLoggable(Level.FINEST)) continue;
            Atom[] ref = atom.getMultipoleReferenceSites();
            StringBuffer refBuffer = new StringBuffer();
            if (ref != null) {
                refBuffer.append("\nReference Sites:\n");
                for (Atom a : ref) {
                    refBuffer.append(a.toString() + " " + a.getAtomType().toString() + "\n");
                }
            }
            logger.finest("Atom " + atom.toString() + "\nof type: " + atom.getAtomType().toString() + "\nassigned multipole:\n" + atom.getMultipoleType().toString() + refBuffer.toString());
        }
    }

    private static Residue assignResidue(List<Atom> backbone, int start, List<Atom> atoms, List<Atom> sidePolymer) {
        String resname;
        Atom a;
        int[] bins = new int[5];
        char[] chars = new char[]{'S', 'P', 'O', 'N', 'C'};
        ListIterator<Atom> li = sidePolymer.listIterator();
        block12: while (li.hasNext()) {
            a = li.next();
            int atomicnum = a.getAtomicNumber();
            switch (atomicnum) {
                case 1: {
                    continue block12;
                }
                case 6: {
                    bins[4] = bins[4] + 1;
                    continue block12;
                }
                case 7: {
                    bins[3] = bins[3] + 1;
                    continue block12;
                }
                case 8: {
                    bins[2] = bins[2] + 1;
                    continue block12;
                }
                case 15: {
                    bins[1] = bins[1] + 1;
                    continue block12;
                }
                case 16: {
                    bins[0] = bins[0] + 1;
                    continue block12;
                }
            }
            return null;
        }
        StringBuffer key = new StringBuffer();
        int atomCount = 0;
        for (int i = 0; i < 5; ++i) {
            if (bins[i] == 0) continue;
            atomCount += bins[i];
            key.append(chars[i]);
            key.append(Integer.toString(bins[i]));
        }
        if (atomCount == 0) {
            key.append("H");
        }
        if ((resname = (resname = sidechainStoichiometry.get(key.toString())) == null ? "Unknown" : resname.intern()) == "1" || resname == "2") {
            Bond abond;
            Atom alpha = backbone.get(start + 1);
            Atom carbonyl = backbone.get(start + 2);
            Atom beta = null;
            ArrayList<Bond> alphabonds = alpha.getBonds();
            ListIterator li2 = alphabonds.listIterator();
            while (li2.hasNext() && ((beta = (abond = (Bond)li2.next()).get1_2(alpha)).getAtomicNumber() == 7 || beta.getAtomicNumber() == 1 || beta == carbonyl)) {
                beta = null;
            }
            if (beta == null) {
                return null;
            }
            ArrayList<Bond> betabonds = beta.getBonds();
            int carboncount = 0;
            ListIterator li3 = betabonds.listIterator();
            while (li3.hasNext()) {
                abond = (Bond)li3.next();
                Atom gamma = abond.get1_2(beta);
                if (gamma.getAtomicNumber() != 6) continue;
                ++carboncount;
            }
            resname = resname == "1" ? (carboncount == 2 ? "PRO" : "VAL") : (carboncount == 2 ? "LEU" : "ILE");
        } else if (resname == "3") {
            Atom c3 = backbone.get(start + 3);
            int num = Utilities.countCO(c3);
            resname = num == 2 ? "A" : "DG";
        }
        Residue residue = null;
        try {
            Residue.NA3.valueOf(resname.toUpperCase());
            residue = new Residue(resname, true, Residue.ResidueType.NA);
        }
        catch (Exception num) {
            // empty catch block
        }
        if (residue == null) {
            try {
                Residue.AA3.valueOf(resname.toUpperCase());
                residue = new Residue(resname, true, Residue.ResidueType.AA);
            }
            catch (Exception num) {
                // empty catch block
            }
        }
        if (residue == null) {
            residue = new Residue(resname, true, Residue.ResidueType.UNK);
        }
        ListIterator<Atom> li4 = atoms.listIterator();
        while (li4.hasNext()) {
            a = li4.next();
            residue.addMSNode(a);
        }
        return residue;
    }

    public static void biochemistry(MolecularAssembly m, List<Atom> atoms) {
        Atom seed = null;
        int num = 0;
        int waterNum = 0;
        int ionNum = 0;
        int heteroNum = 0;
        while (atoms.size() > 0) {
            Atom atom;
            Atom a;
            Iterator<Atom> iterator = atoms.iterator();
            while (iterator.hasNext() && (seed = (a = iterator.next())).getAtomicNumber() != 7) {
            }
            if (seed.getAtomicNumber() != 7) {
                while (atoms.size() > 0) {
                    atom = atoms.get(0);
                    if (atom.getNumBonds() == 0) {
                        Molecule ion = new Molecule(atom.getName() + ": " + ++ionNum, true);
                        ion.addMSNode(atom);
                        atoms.remove(0);
                        m.addMSNode(ion);
                        continue;
                    }
                    if (atom.getAtomicNumber() == 8 && Utilities.isWaterOxygen(atom)) {
                        Molecule water = new Molecule("H2O: " + ++waterNum, true);
                        water.addMSNode(atom);
                        atoms.remove(0);
                        ArrayList<Bond> bonds = atom.getBonds();
                        Iterator iterator2 = bonds.iterator();
                        while (iterator2.hasNext()) {
                            Bond b = (Bond)iterator2.next();
                            Atom o = b.get1_2(atom);
                            water.addMSNode(o);
                            atoms.remove(o);
                        }
                        m.addMSNode(water);
                        continue;
                    }
                    Molecule hetero = new Molecule("Hetero: " + ++heteroNum, true);
                    List<Atom> resatoms = Utilities.getAtomListFromPool();
                    Utilities.collectAtoms(atoms.get(0), resatoms);
                    while (resatoms.size() > 0) {
                        atom = resatoms.get(0);
                        resatoms.remove(0);
                        hetero.addMSNode(atom);
                        atoms.remove(atom);
                    }
                    hetero.setName(String.format("Hetero %7.1f: %6d", hetero.getMW(), heteroNum));
                    m.addMSNode(hetero);
                }
                seed = null;
                break;
            }
            List<Atom> backbone = Utilities.findPolymer(atoms, seed, null);
            if (backbone.size() > 0) {
                ListIterator<Atom> li = backbone.listIterator(backbone.size());
                while (li.hasPrevious() && (seed = li.previous()).getAtomicNumber() != 7) {
                }
                backbone = Utilities.findPolymer(atoms, seed, null);
            }
            Polymer c = new Polymer(Utilities.polymerLookup(num), true, true);
            if (backbone.size() > 2 && Utilities.divideBackbone(backbone, c)) {
                for (Atom a2 : c.getAtomList()) {
                    atoms.remove(a2);
                }
                logger.info("Sequenced Chain: " + c.getName());
                m.addMSNode(c);
                ++num;
                continue;
            }
            Molecule hetero = new Molecule("Hetero: " + ++heteroNum, true);
            atom = backbone.get(0);
            List<Atom> heteroAtomList = Utilities.getAtomListFromPool();
            Utilities.collectAtoms(atom, heteroAtomList);
            for (Atom a3 : heteroAtomList) {
                hetero.addMSNode(a3);
            }
            for (Atom a3 : hetero.getAtomList()) {
                atoms.remove(a3);
            }
            hetero.setName(String.format("Hetero %7.1f: %6d", hetero.getMW(), heteroNum));
            m.addMSNode(hetero);
        }
    }

    private static void collectAtoms(Atom seed, List<Atom> atoms) {
        if (seed == null) {
            return;
        }
        atoms.add(seed);
        for (Bond b : seed.getBonds()) {
            Atom nextAtom = b.get1_2(seed);
            if (nextAtom.getParent() != null || nextAtom.getAtomicNumber() == 16 && seed.getAtomicNumber() == 16 || atoms.contains(nextAtom)) continue;
            Utilities.collectAtoms(nextAtom, atoms);
        }
    }

    public static int countCO(Atom adjacent) {
        int total = 0;
        for (Bond b : adjacent.getBonds()) {
            Atom carbonyl = b.get1_2(adjacent);
            if (carbonyl.getAtomicNumber() != 6) continue;
            for (Bond b2 : carbonyl.getBonds()) {
                Atom oxygen = b2.get1_2(carbonyl);
                if (oxygen.getAtomicNumber() != 8) continue;
                ++total;
            }
        }
        return total;
    }

    public static boolean divideBackbone(List<Atom> backbone, Polymer c) {
        Residue res;
        int i;
        PolymerType type;
        int length = backbone.size();
        int p = 0;
        int n = 0;
        for (Atom match : backbone) {
            int an = match.getAtomicNumber();
            if (an == 15) {
                ++p;
                continue;
            }
            if (an != 7) continue;
            ++n;
        }
        if (p >= n && p > 1) {
            type = PolymerType.NUCLEICACID;
        } else if (n > p && n > 2) {
            type = PolymerType.AMINOACID;
        } else {
            return false;
        }
        int start = -1;
        for (i = 0; i < length; ++i) {
            Object carbon5;
            res = Utilities.patternMatch(i, backbone, type);
            if (res == null) continue;
            for (Atom a : res.getAtomList()) {
                a.setParent(null);
            }
            if (res.getName() == "Unknown") continue;
            start = i;
            if (type != PolymerType.NUCLEICACID || Utilities.numberOfBondsWith((Atom)(carbon5 = backbone.get(start + 1)), 6) == 1) break;
            start = -1;
            break;
        }
        if (start == -1) {
            backbone = Utilities.reverseAtomList(backbone);
            for (i = 0; i < length; ++i) {
                res = Utilities.patternMatch(i, backbone, type);
                if (res == null) continue;
                for (Atom a : res.getAtomList()) {
                    a.setParent(null);
                }
                if (res.getName() == "Unknown") continue;
                start = i;
                break;
            }
        }
        if (start == -1) {
            return false;
        }
        if (type == PolymerType.AMINOACID) {
            Atom carbonyl2;
            Atom nitrogen;
            Atom alpha;
            Atom carbonyl = null;
            Residue aa = null;
            int lastRes = 0;
            int firstRes = -1;
            ArrayList<Residue> aaArray = new ArrayList<Residue>();
            while (start < length) {
                aa = Utilities.patternMatch(start, backbone, PolymerType.AMINOACID);
                if (aa != null) {
                    if (firstRes == -1) {
                        firstRes = start;
                        carbonyl = Utilities.findCarbonyl(backbone.get(start));
                    }
                    aaArray.add(aa);
                    lastRes = start;
                }
                start += 3;
            }
            aa = null;
            if (carbonyl != null && (alpha = Utilities.findAlphaCarbon(carbonyl)) != null && (nitrogen = Utilities.findBondWith(alpha, 7)) != null) {
                Atom nitrogen2 = Utilities.findBondWith(carbonyl, 7);
                List<Atom> firstAtoms = Utilities.getAtomListFromPool();
                firstAtoms.add(nitrogen);
                firstAtoms.add(alpha);
                firstAtoms.add(carbonyl);
                firstAtoms.add(nitrogen2);
                aa = Utilities.patternMatch(0, firstAtoms, PolymerType.AMINOACID);
                Utilities.addAtomListToPool(firstAtoms);
                if (aa != null) {
                    Utilities.addCap(alpha, nitrogen, aa);
                    aaArray.add(0, aa);
                }
            }
            if (aa == null) {
                nitrogen = backbone.get(firstRes);
                alpha = backbone.get(firstRes + 1);
                Utilities.addCap(alpha, nitrogen, (Residue)aaArray.get(0));
            }
            aa = null;
            carbonyl = Utilities.findCarbonyl(backbone.get(lastRes + 1));
            if (carbonyl != null && (nitrogen = Utilities.findBondWith(carbonyl, 7)) != null && (alpha = Utilities.findAlphaCarbon(nitrogen)) != null && (carbonyl2 = Utilities.findCarbonyl(alpha)) != null) {
                List<Atom> lastAtoms = Utilities.getAtomListFromPool();
                lastAtoms.add(carbonyl);
                lastAtoms.add(nitrogen);
                lastAtoms.add(alpha);
                lastAtoms.add(carbonyl2);
                aa = Utilities.patternMatch(1, lastAtoms, PolymerType.AMINOACID);
                Utilities.addAtomListToPool(lastAtoms);
                if (aa != null) {
                    Utilities.addCap(alpha, carbonyl2, aa);
                    aaArray.add(aa);
                }
            }
            if (aa == null) {
                carbonyl = backbone.get(lastRes + 2);
                alpha = backbone.get(lastRes + 1);
                Utilities.addCap(alpha, carbonyl, (Residue)aaArray.get(aaArray.size() - 1));
            }
            int index = 1;
            for (Residue r : aaArray) {
                r.setNumber(index++);
                c.addMSNode(r);
            }
        } else if (type == PolymerType.NUCLEICACID) {
            Atom o3;
            Atom c3;
            Atom c2;
            Atom c1;
            Atom o2;
            int lastRes = 0;
            boolean firstBase = true;
            Atom phos = null;
            Atom oxygen1 = null;
            Atom phosphate1 = null;
            ArrayList<Residue> na = new ArrayList<Residue>();
            while (start < length) {
                Residue base = Utilities.patternMatch(start, backbone, PolymerType.NUCLEICACID);
                if (base != null) {
                    phos = backbone.get(start - 1);
                    if (phos != null && phos.getAtomicNumber() == 15) {
                        Utilities.addPhosphate(phos, base);
                    }
                    na.add(base);
                    if (firstBase) {
                        firstBase = false;
                        phosphate1 = backbone.get(start - 1);
                        oxygen1 = backbone.get(start);
                    }
                    lastRes = start;
                }
                start += 6;
            }
            if (phosphate1 != null && oxygen1 != null && (o2 = Utilities.findOtherOxygen(phosphate1, oxygen1)) != null && (c1 = Utilities.findBondWith(o2, 6)) != null && (c2 = Utilities.findCO(c1)) != null && (c3 = Utilities.findC5(c2)) != null && (o3 = Utilities.findBondWith(c3, 8)) != null) {
                List<Atom> firstAtoms = Utilities.getAtomListFromPool();
                firstAtoms.add(o3);
                firstAtoms.add(c3);
                firstAtoms.add(c2);
                firstAtoms.add(c1);
                firstAtoms.add(o2);
                firstAtoms.add(phosphate1);
                Residue base = Utilities.patternMatch(0, firstAtoms, type);
                if (base != null) {
                    Utilities.addCap(c3, o3, base);
                    na.add(0, base);
                }
            }
            oxygen1 = backbone.get(lastRes + 4);
            phosphate1 = backbone.get(lastRes + 5);
            if (phosphate1 != null && oxygen1 != null && (o2 = Utilities.findOtherOxygen(phosphate1, oxygen1)) != null && (c1 = Utilities.findBondWith(o2, 6)) != null && (c2 = Utilities.findBondWith(c1, 6)) != null && (c3 = Utilities.findCCO(c2)) != null && (o3 = Utilities.findBondWith(c3, 8)) != null) {
                List<Atom> lastAtoms = Utilities.getAtomListFromPool();
                lastAtoms.add(phosphate1);
                lastAtoms.add(o2);
                lastAtoms.add(c1);
                lastAtoms.add(c2);
                lastAtoms.add(c3);
                lastAtoms.add(o3);
                Residue base = Utilities.patternMatch(1, lastAtoms, type);
                if (base != null) {
                    Utilities.addPhosphate(phosphate1, base);
                    Utilities.addCap(c3, o3, base);
                    na.add(base);
                }
            }
            int index = 1;
            for (Residue r : na) {
                r.setNumber(index++);
                c.addMSNode(r);
            }
        } else {
            return false;
        }
        return true;
    }

    public static Atom findAlphaCarbon(Atom a) {
        for (Bond b : a.getBonds()) {
            Atom alpha = b.get1_2(a);
            if (alpha.getAtomicNumber() != 6 || Utilities.findCO(alpha) == null || !Utilities.formsBondsWith(alpha, 7)) continue;
            return alpha;
        }
        return null;
    }

    public static Atom findBondWith(Atom a, int atomicNumber) {
        for (Bond b : a.getBonds()) {
            Atom other = b.get1_2(a);
            if (other.getAtomicNumber() != atomicNumber) continue;
            return other;
        }
        return null;
    }

    public static Atom findC5(Atom adjacent) {
        for (Bond b : adjacent.getBonds()) {
            Atom carbon = b.get1_2(adjacent);
            if (carbon.getAtomicNumber() != 6 || Utilities.numberOfBondsWith(carbon, 6) != 1 || Utilities.numberOfBondsWith(carbon, 8) != 1) continue;
            return carbon;
        }
        return null;
    }

    public static Atom findCarbonyl(Atom adjacent) {
        for (Bond b : adjacent.getBonds()) {
            Atom carbonyl = b.get1_2(adjacent);
            if (carbonyl.getAtomicNumber() != 6) continue;
            for (Bond b2 : carbonyl.getBonds()) {
                Atom oxygen = b2.get1_2(carbonyl);
                if (oxygen.getAtomicNumber() != 8 || oxygen.getBonds().size() != 1) continue;
                return carbonyl;
            }
        }
        return null;
    }

    public static Atom findCCO(Atom adjacent) {
        for (Bond b : adjacent.getBonds()) {
            Atom carbon = b.get1_2(adjacent);
            if (carbon.getAtomicNumber() != 6 || Utilities.numberOfBondsWith(carbon, 6) != 2 || Utilities.numberOfBondsWith(carbon, 8) < 1) continue;
            return carbon;
        }
        return null;
    }

    public static Atom findCO(Atom adjacent) {
        for (Bond b : adjacent.getBonds()) {
            Atom carbon = b.get1_2(adjacent);
            if (carbon.getAtomicNumber() != 6 || !Utilities.formsBondsWith(carbon, 8)) continue;
            return carbon;
        }
        return null;
    }

    public static Atom findOtherOxygen(Atom p, Atom o) {
        for (Bond b : p.getBonds()) {
            Atom oxygen = b.get1_2(p);
            if (oxygen.getAtomicNumber() != 8 || oxygen == o || !Utilities.formsBondsWith(oxygen, 6)) continue;
            return oxygen;
        }
        return null;
    }

    public static List<Atom> findPolymer(List<Atom> atoms, Atom currentAtom, List<Atom> path) {
        ArrayList<Bond> bonds;
        if (currentAtom.getBonds() == null) {
            path = Utilities.getAtomListFromPool();
            path.add(currentAtom);
            return path;
        }
        if (currentAtom.getParent() != null) {
            return null;
        }
        int anum = currentAtom.getAtomicNumber();
        if (anum != 6 && anum != 7 && anum != 8 && anum != 15) {
            return null;
        }
        if (path != null && path.size() > 7) {
            int anum4;
            int anum3;
            int size;
            Atom a;
            int anum2;
            if (anum == 8) {
                if (!Utilities.formsBondsWith(currentAtom, 15)) {
                    return null;
                }
            } else if (anum == 7) {
                Atom carbonyl = Utilities.findCarbonyl(currentAtom);
                if (carbonyl == null) {
                    return null;
                }
                Atom alphaCarbon = Utilities.findAlphaCarbon(currentAtom);
                if (alphaCarbon == null) {
                    return null;
                }
            } else if (anum == 6 && (anum2 = (a = path.get((size = path.size()) - 1)).getAtomicNumber()) == 6 && (anum3 = (a = path.get(size - 2)).getAtomicNumber()) == 6 && (anum4 = (a = path.get(size - 3)).getAtomicNumber()) == 6) {
                return null;
            }
        }
        Atom previousAtom = null;
        if (path != null) {
            previousAtom = path.get(path.size() - 1);
        }
        if ((bonds = currentAtom.getBonds()).size() == 1 && previousAtom != null) {
            return null;
        }
        if (path == null) {
            path = Utilities.getAtomListFromPool();
            previousAtom = null;
        } else {
            List<Atom> pathclone = Utilities.getAtomListFromPool();
            pathclone.addAll(path);
            path = pathclone;
        }
        path.add(currentAtom);
        List<Atom> maxPolymer = Utilities.getAtomListFromPool();
        for (Bond b : bonds) {
            List<Atom> newPolymer;
            Atom nextAtom = b.get1_2(currentAtom);
            if (nextAtom == previousAtom || path.contains(nextAtom) || (newPolymer = Utilities.findPolymer(atoms, nextAtom, path)) == null) continue;
            if (Utilities.haveCommonAtom(newPolymer, maxPolymer)) {
                if (newPolymer.size() >= maxPolymer.size()) continue;
                Utilities.addAtomListToPool(maxPolymer);
                maxPolymer = newPolymer;
                continue;
            }
            if (newPolymer.size() <= maxPolymer.size()) continue;
            Utilities.addAtomListToPool(maxPolymer);
            maxPolymer = newPolymer;
        }
        maxPolymer.add(0, currentAtom);
        return maxPolymer;
    }

    public static Atom findSeed(Atom end, Atom other) {
        for (Bond b : end.getBonds()) {
            Atom seed = b.get1_2(end);
            if (seed == other) continue;
            return seed;
        }
        return null;
    }

    public static boolean formsBondsWith(Atom a, int atomicNumber) {
        for (Bond b : a.getBonds()) {
            Atom other = b.get1_2(a);
            if (other.getAtomicNumber() != atomicNumber) continue;
            return true;
        }
        return false;
    }

    public static List<Atom> getAtomListFromPool() {
        if (atomListPool.isEmpty()) {
            return new ArrayList<Atom>();
        }
        return atomListPool.remove(0);
    }

    private static boolean haveCommonAtom(List<Atom> list1, List<Atom> list2) {
        if (list1 == null || list2 == null) {
            return false;
        }
        for (Atom a : list1) {
            if (!list2.contains(a)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWaterOxygen(Atom a) {
        if (a.getAtomicNumber() != 8) {
            return false;
        }
        for (Bond b : a.getBonds()) {
            Atom h = b.get1_2(a);
            if (h.getAtomicNumber() == 1) continue;
            return false;
        }
        return true;
    }

    public static int numberOfBondsWith(Atom a, int atomicNumber) {
        int total = 0;
        for (Bond b : a.getBonds()) {
            Atom other = b.get1_2(a);
            if (other.getAtomicNumber() != atomicNumber) continue;
            ++total;
        }
        return total;
    }

    private static Residue patternMatch(int start, List<Atom> backbone, PolymerType type) {
        int i;
        int[] pattern;
        if (type == PolymerType.AMINOACID) {
            pattern = AAPATTERN;
            if (backbone.size() < start + pattern.length) {
                return null;
            }
            Atom a = backbone.get(start + 1);
            if (Utilities.formsBondsWith(a, 8)) {
                return null;
            }
            a = backbone.get(start + 2);
            if (!Utilities.formsBondsWith(a, 8)) {
                return null;
            }
        } else if (type == PolymerType.NUCLEICACID) {
            pattern = NAPATTERN;
            if (backbone.size() < start + pattern.length) {
                return null;
            }
        } else {
            return null;
        }
        int length = pattern.length;
        List<Atom> atoms = Utilities.getAtomListFromPool();
        List<Atom> sidePolymer = Utilities.getAtomListFromPool();
        for (i = 0; i < length; ++i) {
            Atom a = backbone.get(start + i);
            sidePolymer.add(a);
            if (a.getAtomicNumber() == pattern[i]) continue;
            return null;
        }
        if (start > 0) {
            atoms.add(backbone.get(start - 1));
        }
        if (start + length < backbone.size()) {
            atoms.add(backbone.get(start + length));
        }
        Utilities.collectAtoms(backbone.get(start), atoms);
        if (start > 0) {
            atoms.remove(0);
        }
        if (start + length < backbone.size()) {
            atoms.remove(0);
        }
        if (type == PolymerType.AMINOACID) {
            Utilities.collectAtoms(sidePolymer.get(1), sidePolymer);
        } else if (type == PolymerType.NUCLEICACID) {
            Atom seed = null;
            for (Atom a : atoms) {
                if (a.getAtomicNumber() != 7) continue;
                seed = a;
                break;
            }
            if (seed != null && seed.getAtomicNumber() == 7) {
                sidePolymer.add(seed);
                Utilities.collectAtoms(seed, sidePolymer);
            } else {
                return null;
            }
        }
        for (i = 0; i <= length; ++i) {
            sidePolymer.remove(0);
        }
        Residue res = Utilities.assignResidue(backbone, start, atoms, sidePolymer);
        return res;
    }

    public static String polymerLookup(int i) {
        if (i > 25) {
            int repeat = i / 25;
            return String.valueOf((char)((i %= 25) + 65)) + repeat;
        }
        return String.valueOf((char)(i + 65));
    }

    private static List<Atom> reverseAtomList(List<Atom> atomList) {
        List<Atom> reversedList = Utilities.getAtomListFromPool();
        for (Atom a : atomList) {
            reversedList.add(0, a);
        }
        return reversedList;
    }

    public static double RMSCoordDev(MolecularAssembly m1, MolecularAssembly m2) {
        int n2;
        if (m1 == null || m2 == null) {
            return 0.0;
        }
        int n1 = m1.getAtomList().size();
        if (n1 != (n2 = m2.getAtomList().size())) {
            return 0.0;
        }
        double[] d = new double[3];
        double[] da = new double[3];
        double[] db = new double[3];
        double rms = 0.0;
        ListIterator<Atom> li = m1.getAtomList().listIterator();
        ListIterator<Atom> lj = m2.getAtomList().listIterator();
        while (li.hasNext()) {
            Atom a1 = li.next();
            Atom a2 = lj.next();
            a1.getXYZ(da);
            a2.getXYZ(db);
            VectorMath.diff(da, db, d);
            rms += d[0] * d[0] + d[1] * d[1] + d[2] * d[2];
        }
        return Math.sqrt(rms / (double)n1);
    }

    public static void rotateMulitpoles(List<Atom> atoms) {
        for (Atom atom : atoms) {
            MultipoleType multipoleType = atom.getMultipoleType();
            if (multipoleType == null) {
                logger.warning("No multipole assigned to: " + String.valueOf(atom) + "\nOf type:\n" + String.valueOf(atom.getAtomType()));
                continue;
            }
            atom.getXYZ(localOrigin);
            Atom[] referenceSites = atom.getMultipoleReferenceSites();
            for (int i = 0; i < 3; ++i) {
                Utilities.zaxis[i] = 0.0;
                Utilities.xaxis[i] = 0.0;
                Utilities.dipole[i] = 0.0;
                for (int j = 0; j < 3; ++j) {
                    Utilities.quadrupole[i][j] = 0.0;
                }
            }
            if (referenceSites != null) {
                if (referenceSites.length == 1) {
                    referenceSites[0].getXYZ(zaxis);
                } else if (referenceSites.length == 2) {
                    referenceSites[0].getXYZ(zaxis);
                    referenceSites[1].getXYZ(xaxis);
                }
            }
            VectorMath.diff(zaxis, localOrigin, zaxis);
            VectorMath.norm(zaxis, zaxis);
            VectorMath.diff(xaxis, localOrigin, xaxis);
            if (multipoleType.frameDefinition == MultipoleType.MultipoleFrameDefinition.ZTHENX) {
                Utilities.rotmat[0][2] = zaxis[0];
                Utilities.rotmat[1][2] = zaxis[1];
                Utilities.rotmat[2][2] = zaxis[2];
            } else {
                VectorMath.norm(xaxis, xaxis);
                VectorMath.sum(zaxis, xaxis, zaxis);
                VectorMath.norm(zaxis, zaxis);
                Utilities.rotmat[0][2] = zaxis[0];
                Utilities.rotmat[1][2] = zaxis[1];
                Utilities.rotmat[2][2] = zaxis[2];
            }
            double dot = VectorMath.dot(zaxis, xaxis);
            VectorMath.scalar(zaxis, dot, zaxis);
            VectorMath.diff(xaxis, zaxis, xaxis);
            VectorMath.norm(xaxis, xaxis);
            Utilities.rotmat[0][0] = xaxis[0];
            Utilities.rotmat[1][0] = xaxis[1];
            Utilities.rotmat[2][0] = xaxis[2];
            Utilities.rotmat[0][1] = rotmat[2][0] * rotmat[1][2] - rotmat[1][0] * rotmat[2][2];
            Utilities.rotmat[1][1] = rotmat[0][0] * rotmat[2][2] - rotmat[2][0] * rotmat[0][2];
            Utilities.rotmat[2][1] = rotmat[1][0] * rotmat[0][2] - rotmat[0][0] * rotmat[1][2];
            double[] localDipole = multipoleType.dipole;
            double[][] localQuadrupole = multipoleType.quadrupole;
            for (int i = 0; i < 3; ++i) {
                double[] rotmati = rotmat[i];
                double[] quadrupolei = quadrupole[i];
                for (int j = 0; j < 3; ++j) {
                    double[] rotmatj = rotmat[j];
                    int n = i;
                    dipole[n] = dipole[n] + rotmati[j] * localDipole[j];
                    if (j < i) {
                        quadrupolei[j] = quadrupole[j][i];
                        continue;
                    }
                    for (int k = 0; k < 3; ++k) {
                        double[] localQuadrupolek = localQuadrupole[k];
                        int n2 = j;
                        quadrupolei[n2] = quadrupolei[n2] + rotmati[k] * (rotmatj[0] * localQuadrupolek[0] + rotmatj[1] * localQuadrupolek[1] + rotmatj[2] * localQuadrupolek[2]);
                    }
                }
            }
            atom.setGlobalMultipole(dipole, quadrupole);
            if (!logger.isLoggable(Level.FINEST)) continue;
            logger.finest(atom.toMultipoleString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void stillBornRadii(List<Atom> atoms) {
        if (atoms == null || atoms.size() < 1) {
            logger.warning("No Born radii computed due to empty an atom list");
            return;
        }
        int numberOfAtoms = atoms.size();
        int[] skip = new int[numberOfAtoms + 1];
        double ccf = 0.0;
        for (int i = 0; i < numberOfAtoms; ++i) {
            void var13_10;
            Atom a1 = atoms.get(i);
            a1.getXYZ(x1);
            double vdw1 = a1.getRDielectric();
            double gpi = a1.getGPol();
            ArrayList<Bond> bonds = a1.getBonds();
            for (Bond bond : bonds) {
                int other = bond.get1_2(a1).getXYZIndex();
                skip[other] = i + 1;
            }
            ArrayList<Angle> angles = a1.getAngles();
            for (Angle a : angles) {
                Atom other = a.get1_3(a1);
                if (other == null) continue;
                int i13 = other.getXYZIndex();
                skip[i13] = i + 1;
            }
            boolean bl = false;
            while (var13_10 < numberOfAtoms) {
                if (skip[var13_10] != i + 1) {
                    Atom a2 = atoms.get((int)var13_10);
                    a2.getXYZ(x2);
                    VectorMath.diff(x2, x1, x2);
                    double r2 = x2[0] * x2[0] + x2[1] * x2[1] + x2[2] * x2[2];
                    double r4 = r2 * r2;
                    double rvdw = vdw1 + a2.getRDielectric();
                    double ratio = r2 / (rvdw * rvdw);
                    if (ratio > 0.7974481658692185) {
                        ccf = 1.0;
                    } else {
                        double term = 0.5 * (1.0 - Math.cos(ratio * 3.9395571876016007));
                        ccf = term * term;
                    }
                    gpi += 15.236 * ccf * a2.getBornVolume() / r4;
                }
                ++var13_10;
            }
            a1.setBornRadius(-166.02691 / gpi);
        }
    }

    static {
        sidechainStoichiometry.put("S1C3", "MET");
        sidechainStoichiometry.put("S1C1", "CYS");
        sidechainStoichiometry.put("O1C1", "SER");
        sidechainStoichiometry.put("O1C2", "THR");
        sidechainStoichiometry.put("O1C7", "TYR");
        sidechainStoichiometry.put("O2C2", "ASP");
        sidechainStoichiometry.put("O2C3", "GLU");
        sidechainStoichiometry.put("O1N1C2", "ASN");
        sidechainStoichiometry.put("O1N1C3", "GLN");
        sidechainStoichiometry.put("N3C4", "ARG");
        sidechainStoichiometry.put("N2C4", "HIS");
        sidechainStoichiometry.put("N1C9", "TRP");
        sidechainStoichiometry.put("N1C4", "LYS");
        sidechainStoichiometry.put("C7", "PHE");
        sidechainStoichiometry.put("H", "GLY");
        sidechainStoichiometry.put("C1", "ALA");
        sidechainStoichiometry.put("O2N3C6", "DC");
        sidechainStoichiometry.put("O1N5C7", "DA");
        sidechainStoichiometry.put("O3N2C7", "DT");
        sidechainStoichiometry.put("O3N5C7", "G");
        sidechainStoichiometry.put("O3N3C6", "C");
        sidechainStoichiometry.put("O4N2C6", "U");
        sidechainStoichiometry.put("C3", "1");
        sidechainStoichiometry.put("C4", "2");
        sidechainStoichiometry.put("O2N5C7", "3");
    }

    public static enum PolymerType {
        AMINOACID,
        NUCLEICACID,
        UNKNOWN;

    }

    public static enum FileType {
        XYZ,
        INT,
        ARC,
        PDB,
        ANY,
        SIM,
        UNK;

    }
}

