/*
 * Decompiled with CFR 0.152.
 */
package ffe.lang;

import ffe.lang.Atom;
import ffe.lang.VectorMath;
import ffe.mm.MultipoleType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;

public final class Simulation {
    private static final double[][] rotmat = new double[3][3];
    private static final double[][] oldQuad = new double[3][3];
    private final int numberOfAtoms;
    private final double[][] x;
    private final int[] localMultipoleIndex;
    private final MultipoleType.MultipoleFrameDefinition[] frameDefinition;
    private final int[][] multipoleReference;
    private final double[][] localDipole;
    private final double[][] localQuadrupole;
    private final int numberOfMultipoles;
    private final int[] iMultipole;
    private final double[] charge;
    private final double[][] dipole;
    private final double[][] quadrupole;
    private final Logger logger = Logger.getLogger("ffe");

    public static void rotateMultipoles(int numberOfMultipoles, double[][] x, int[][] multipoleReference, int[] multipoleIndex, MultipoleType.MultipoleFrameDefinition[] frameDefinition, double[][] localDipole, double[][] localQuadrupole, double[][] dipole, double[][] quadrupole) {
        for (int a = 0; a < numberOfMultipoles; ++a) {
            double[] localOrigin = x[a];
            double[] zaxis = x[multipoleReference[a][0]];
            double[] xaxis = x[multipoleReference[a][1]];
            int index = multipoleIndex[a];
            MultipoleType.MultipoleFrameDefinition frame = frameDefinition[index];
            double[] oldDipole = localDipole[index];
            double[] oldQuadRef = localQuadrupole[index];
            Simulation.oldQuad[0][0] = oldQuadRef[0];
            Simulation.oldQuad[0][1] = oldQuadRef[1];
            Simulation.oldQuad[0][2] = oldQuadRef[3];
            Simulation.oldQuad[1][0] = oldQuadRef[1];
            Simulation.oldQuad[1][1] = oldQuadRef[2];
            Simulation.oldQuad[1][2] = oldQuadRef[4];
            Simulation.oldQuad[2][0] = oldQuadRef[3];
            Simulation.oldQuad[2][1] = oldQuadRef[4];
            Simulation.oldQuad[2][2] = oldQuadRef[5];
            double[] newDipole = dipole[a];
            double[] newQuadrupole = quadrupole[a];
            newDipole[0] = 0.0;
            newDipole[1] = 0.0;
            newDipole[2] = 0.0;
            newQuadrupole[0] = 0.0;
            newQuadrupole[1] = 0.0;
            newQuadrupole[2] = 0.0;
            newQuadrupole[3] = 0.0;
            newQuadrupole[4] = 0.0;
            newQuadrupole[5] = 0.0;
            VectorMath.diff(zaxis, localOrigin, zaxis);
            VectorMath.norm(zaxis, zaxis);
            VectorMath.diff(xaxis, localOrigin, xaxis);
            switch (frame) {
                case ZTHENX: {
                    Simulation.rotmat[0][2] = zaxis[0];
                    Simulation.rotmat[1][2] = zaxis[1];
                    Simulation.rotmat[2][2] = zaxis[2];
                    break;
                }
                case BISECTOR: {
                    VectorMath.norm(xaxis, xaxis);
                    VectorMath.sum(zaxis, xaxis, zaxis);
                    VectorMath.norm(zaxis, zaxis);
                    Simulation.rotmat[0][2] = zaxis[0];
                    Simulation.rotmat[1][2] = zaxis[1];
                    Simulation.rotmat[2][2] = zaxis[2];
                }
            }
            double dot = VectorMath.dot(zaxis, xaxis);
            VectorMath.scalar(zaxis, dot, zaxis);
            VectorMath.diff(xaxis, zaxis, xaxis);
            VectorMath.norm(xaxis, xaxis);
            Simulation.rotmat[0][0] = xaxis[0];
            Simulation.rotmat[1][0] = xaxis[1];
            Simulation.rotmat[2][0] = xaxis[2];
            Simulation.rotmat[0][1] = rotmat[2][0] * rotmat[1][2] - rotmat[1][0] * rotmat[2][2];
            Simulation.rotmat[1][1] = rotmat[0][0] * rotmat[2][2] - rotmat[2][0] * rotmat[0][2];
            Simulation.rotmat[2][1] = rotmat[1][0] * rotmat[0][2] - rotmat[0][0] * rotmat[1][2];
            for (int i = 0; i < 3; ++i) {
                double[] rotmati = rotmat[i];
                for (int j = 0; j < 3; ++j) {
                    double[] rotmatj = rotmat[j];
                    int n = i;
                    newDipole[n] = newDipole[n] + rotmati[j] * oldDipole[j];
                    if (j > i) continue;
                    int newIndex = i + j;
                    for (int k = 0; k < 3; ++k) {
                        double[] oldQuadrupolek = oldQuad[k];
                        int n2 = newIndex;
                        newQuadrupole[n2] = newQuadrupole[n2] + rotmati[k] * (rotmatj[0] * oldQuadrupolek[0] + rotmatj[1] * oldQuadrupolek[1] + rotmatj[2] * oldQuadrupolek[2]);
                    }
                }
            }
        }
    }

    public Simulation(List<Atom> atoms) {
        MultipoleType multipoleType2;
        this.numberOfAtoms = atoms.size();
        this.x = new double[this.numberOfAtoms][3];
        HashMap<MultipoleType, Integer> localMultipoleMap = new HashMap<MultipoleType, Integer>();
        int multipoleIndex = 0;
        ArrayList<Integer> multipoleSites = new ArrayList<Integer>();
        ArrayList<Atom> multipoleAtoms = new ArrayList<Atom>();
        for (int i = 0; i < this.numberOfAtoms; ++i) {
            Atom atom = atoms.get(i);
            int atomIndex = atom.getXYZIndex() - 1;
            atom.getXYZ(this.x[atomIndex]);
            multipoleType2 = atom.getMultipoleType();
            if (multipoleType2 == null) continue;
            multipoleSites.add(i);
            multipoleAtoms.add(atom);
        }
        this.numberOfMultipoles = multipoleSites.size();
        this.iMultipole = new int[this.numberOfMultipoles];
        this.localMultipoleIndex = new int[this.numberOfMultipoles];
        this.multipoleReference = new int[this.numberOfMultipoles][4];
        this.charge = new double[this.numberOfMultipoles];
        this.dipole = new double[this.numberOfMultipoles][3];
        this.quadrupole = new double[this.numberOfMultipoles][6];
        int index = 0;
        for (Integer i : multipoleSites) {
            this.iMultipole[index++] = i;
        }
        for (int i = 0; i < this.numberOfMultipoles; ++i) {
            Atom atom = (Atom)multipoleAtoms.get(i);
            multipoleType2 = atom.getMultipoleType();
            int atomIndex = atom.getXYZIndex() - 1;
            atom.getXYZ(this.x[atomIndex]);
            int referenceIndex = 0;
            for (Atom referenceAtom : atom.getMultipoleReferenceSites()) {
                this.multipoleReference[i][referenceIndex++] = referenceAtom.getXYZIndex() - 1;
            }
            if (!localMultipoleMap.containsKey(multipoleType2)) {
                this.localMultipoleIndex[i] = multipoleIndex;
                localMultipoleMap.put(multipoleType2, multipoleIndex++);
            } else {
                this.localMultipoleIndex[i] = (Integer)localMultipoleMap.get(multipoleType2);
            }
            this.charge[atomIndex] = multipoleType2.charge;
        }
        int mapSize = localMultipoleMap.size();
        this.localDipole = new double[mapSize][3];
        this.localQuadrupole = new double[mapSize][6];
        this.frameDefinition = new MultipoleType.MultipoleFrameDefinition[mapSize];
        for (MultipoleType multipoleType2 : localMultipoleMap.keySet()) {
            index = (Integer)localMultipoleMap.get(multipoleType2);
            this.frameDefinition[index] = multipoleType2.frameDefinition;
            this.localDipole[index][0] = multipoleType2.dipole[0];
            this.localDipole[index][1] = multipoleType2.dipole[1];
            this.localDipole[index][2] = multipoleType2.dipole[2];
            this.localQuadrupole[index][0] = multipoleType2.quadrupole[0][0];
            this.localQuadrupole[index][1] = multipoleType2.quadrupole[1][0];
            this.localQuadrupole[index][2] = multipoleType2.quadrupole[1][1];
            this.localQuadrupole[index][3] = multipoleType2.quadrupole[2][0];
            this.localQuadrupole[index][4] = multipoleType2.quadrupole[2][1];
            this.localQuadrupole[index][5] = multipoleType2.quadrupole[2][2];
        }
        long start = System.currentTimeMillis();
        Simulation.rotateMultipoles(this.numberOfAtoms, this.x, this.multipoleReference, this.localMultipoleIndex, this.frameDefinition, this.localDipole, this.localQuadrupole, this.dipole, this.quadrupole);
        long done = System.currentTimeMillis();
        this.logger.info(String.format("Rotation time: %d (msec)", done - start));
    }
}

