/*
 * Decompiled with CFR 0.152.
 */
package ffe.lang;

import ffe.lang.Atom;
import ffe.lang.HashCodeUtil;
import ffe.lang.MSGroup;
import ffe.lang.MSNode;
import ffe.lang.RendererCache;
import java.util.EnumSet;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.logging.Logger;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.J3DGraphics2D;
import org.jogamp.java3d.Material;
import org.jogamp.java3d.Node;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Point2d;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Tuple3d;
import org.jogamp.vecmath.Vector3d;

public class Residue
extends MSGroup {
    private Logger logger = Logger.getLogger("ffe");
    private static final long serialVersionUID = 1L;
    static StringBuffer s;
    private static Point3d point3d;
    private static Point2d point2d;
    public static EnumSet NA1Set;
    public static EnumSet NA3Set;
    public static EnumSet NASet;
    public static Hashtable<NA1, NA3> NA1toNA3;
    public static Hashtable<NA3, Color3f> NA3Color;
    public static EnumSet AA1Set;
    public static EnumSet AA3Set;
    public static EnumSet AASet;
    public static Hashtable<AA1, AA3> AA1toAA3;
    public static Hashtable<AA3, Color3f> AA3Color;
    public static Hashtable<SSType, Color3f> SSTypeColor;
    public static String[] Ramachandran;
    private int resNumber;
    private SSType ssType = SSType.NONE;
    private ResidueType residueType = ResidueType.UNK;
    private AA3 aa;
    private NA3 na;
    private String chainName;

    public Residue(int num, ResidueType rt) {
        this.resNumber = num;
        this.residueType = rt;
        this.assignResidueType();
    }

    public Residue(String name, boolean bk, ResidueType rt) {
        super(name, bk);
        this.residueType = rt;
        this.assignResidueType();
    }

    public Residue(String name, int num, boolean bk, ResidueType rt) {
        this(name, bk, rt);
        this.resNumber = num;
    }

    public Residue(String name, int num, MSNode atoms, boolean bk, ResidueType rt) {
        super(name, atoms, bk);
        this.resNumber = num;
        this.residueType = rt;
        this.assignResidueType();
        this.finalize(true);
    }

    @Override
    public void addMSNode(MSNode o) {
        if (o instanceof Atom) {
            this.getAtomNode().add(o);
            this.setFinalized(false);
        } else {
            this.logger.warning("Can't add MSNode to Residue, not of type Atom");
        }
    }

    private void assignResidueType() {
        String name = this.getName().toUpperCase();
        switch (this.residueType) {
            case AA: {
                this.aa = null;
                try {
                    if (name.length() == 3) {
                        this.aa = AA3.valueOf(name);
                        break;
                    }
                    if (name.length() != 1) break;
                    AA1 aa1 = AA1.valueOf(name);
                    this.aa = AA1toAA3.get((Object)aa1);
                }
                catch (Exception e) {
                    this.aa = AA3.UNK;
                }
                break;
            }
            case NA: {
                this.na = null;
                try {
                    if (name.length() == 2 || name.length() == 3) {
                        this.na = NA3.valueOf(name);
                        break;
                    }
                    if (name.length() != 1) break;
                    NA1 na1 = NA1.valueOf(name);
                    this.na = NA1toNA3.get((Object)na1);
                    break;
                }
                catch (Exception e) {
                    this.na = NA3.UNK;
                }
            }
        }
    }

    @Override
    public void drawLabel(Canvas3D canvas, J3DGraphics2D g2d, Node node) {
        if (RendererCache.labelResidues) {
            double[] d = this.getCenter();
            Residue.point3d.x = d[0];
            Residue.point3d.y = d[1];
            Residue.point3d.z = d[2];
            RendererCache.getScreenCoordinate(canvas, node, point3d, point2d);
            g2d.drawString(this.getName(), (float)Residue.point2d.x, (float)Residue.point2d.y);
        }
        if (RendererCache.labelAtoms) {
            super.drawLabel(canvas, g2d, node);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Residue other = (Residue)object;
        if (this.getParent() == null || other.getParent() == null) {
            return this.getResidueNumber() == other.getResidueNumber();
        }
        if (this.getParent() == other.getParent()) {
            return this.getResidueNumber() == other.getResidueNumber();
        }
        return false;
    }

    @Override
    public void finalize(boolean finalizeGeometry) {
        this.setFinalized(false);
        this.getAtomNode().setName("Atoms: " + this.getAtomList().size());
        if (finalizeGeometry) {
            if (!this.getBondsKnown()) {
                this.constructValenceTerms();
            } else {
                this.collectValenceTerms();
            }
            this.removeLeaves();
        }
        this.setCenter(this.getMultiScaleCenter(false));
        this.setFinalized(true);
    }

    public Vector3d getAlpha3d() {
        Atom a = (Atom)this.getAtomNode("CA");
        if (a == null) {
            return null;
        }
        Vector3d temp = new Vector3d();
        a.getV3D(temp);
        return temp;
    }

    public String getPolymer() {
        return new String(this.chainName);
    }

    public int getResidueNumber() {
        return this.resNumber;
    }

    @Override
    public final int hashCode() {
        int hash = HashCodeUtil.hash(3025, this.getParent().hashCode());
        return HashCodeUtil.hash(hash, this.getResidueNumber());
    }

    @Override
    public void print() {
        this.logger.info(this.toString());
        super.print();
    }

    public void printSideChainCOM() {
        Vector3d v = new Vector3d();
        Vector3d v2 = new Vector3d();
        int count = 0;
        ListIterator<Atom> li = this.getAtomList().listIterator();
        while (li.hasNext()) {
            Atom a = li.next();
            String id = a.getID();
            if (!(id.equals("CA") || id.equals("N") || id.equals("C") || id.equals("O"))) {
                a.getV3D(v2);
                v.add((Tuple3d)v2);
                ++count;
                continue;
            }
            if (!id.equals("CA")) continue;
            a.print();
        }
        v.scale((double)(1.0f / (float)count));
        this.logger.info(this.getName() + " " + v.toString());
    }

    @Override
    public void setColor(RendererCache.ColorModel newColorModel, Color3f color, Material mat) {
        if (newColorModel == RendererCache.ColorModel.RESIDUE) {
            switch (this.residueType) {
                case AA: {
                    color = AA3Color.get((Object)this.aa);
                    break;
                }
                case NA: {
                    color = NA3Color.get((Object)this.na);
                    break;
                }
                default: {
                    color = null;
                }
            }
            if (color == null) {
                return;
            }
            mat = RendererCache.materialFactory(color);
        } else if (newColorModel == RendererCache.ColorModel.STRUCTURE) {
            color = SSTypeColor.get((Object)this.ssType);
            mat = RendererCache.materialFactory(color);
        }
        super.setColor(newColorModel, color, mat);
    }

    public void setNumber(int n) {
        this.resNumber = n;
    }

    public void setPolymer(String n) {
        this.chainName = new String(n);
    }

    public void setSSType(SSType ss) {
        this.ssType = ss;
    }

    @Override
    public String toString() {
        if (s.length() > 0) {
            s.replace(0, s.length(), this.getName());
        } else {
            s.append(this.getName());
        }
        s.append(": " + this.resNumber + " ");
        return s.toString();
    }

    static {
        int i;
        s = new StringBuffer();
        point3d = new Point3d();
        point2d = new Point2d();
        NA1Set = EnumSet.allOf(NA1.class);
        NA3Set = EnumSet.allOf(NA3.class);
        NASet = EnumSet.allOf(NA.class);
        NA1toNA3 = new Hashtable();
        NA3Color = new Hashtable();
        AA1Set = EnumSet.allOf(AA1.class);
        AA3Set = EnumSet.allOf(AA3.class);
        AASet = EnumSet.allOf(AA.class);
        AA1toAA3 = new Hashtable();
        AA3Color = new Hashtable();
        SSTypeColor = new Hashtable();
        Ramachandran = new String[17];
        NA1[] na1 = NA1.values();
        NA3[] na3 = NA3.values();
        for (i = 0; i < NA1.values().length; ++i) {
            NA1toNA3.put(na1[i], na3[i]);
        }
        NA3Color.put(NA3.A, RendererCache.RED);
        NA3Color.put(NA3.C, RendererCache.MAGENTA);
        NA3Color.put(NA3.G, RendererCache.BLUE);
        NA3Color.put(NA3.U, RendererCache.YELLOW);
        NA3Color.put(NA3.DA, RendererCache.RED);
        NA3Color.put(NA3.DC, RendererCache.MAGENTA);
        NA3Color.put(NA3.DG, RendererCache.BLUE);
        NA3Color.put(NA3.DT, RendererCache.ORANGE);
        NA3Color.put(NA3.MPO, RendererCache.GREEN);
        NA3Color.put(NA3.DPO, RendererCache.GREEN);
        NA3Color.put(NA3.TPO, RendererCache.GREEN);
        NA3Color.put(NA3.UNK, RendererCache.CYAN);
        AA1[] aa1 = AA1.values();
        AA3[] aa3 = AA3.values();
        for (i = 0; i < AA1.values().length; ++i) {
            AA1toAA3.put(aa1[i], aa3[i]);
        }
        AA3Color.put(AA3.ALA, RendererCache.GRAY);
        AA3Color.put(AA3.ARG, RendererCache.BLUE);
        AA3Color.put(AA3.ASN, RendererCache.BLUE);
        AA3Color.put(AA3.ASP, RendererCache.RED);
        AA3Color.put(AA3.CYS, RendererCache.YELLOW);
        AA3Color.put(AA3.GLN, RendererCache.BLUE);
        AA3Color.put(AA3.GLU, RendererCache.RED);
        AA3Color.put(AA3.GLY, RendererCache.GRAY);
        AA3Color.put(AA3.ILE, RendererCache.GRAY);
        AA3Color.put(AA3.LEU, RendererCache.GRAY);
        AA3Color.put(AA3.LYS, RendererCache.BLUE);
        AA3Color.put(AA3.MET, RendererCache.YELLOW);
        AA3Color.put(AA3.PHE, RendererCache.GREEN);
        AA3Color.put(AA3.PRO, RendererCache.ORANGE);
        AA3Color.put(AA3.SER, RendererCache.BLUE);
        AA3Color.put(AA3.THR, RendererCache.BLUE);
        AA3Color.put(AA3.TRP, RendererCache.GREEN);
        AA3Color.put(AA3.TYR, RendererCache.GREEN);
        AA3Color.put(AA3.VAL, RendererCache.GRAY);
        AA3Color.put(AA3.HIS, RendererCache.BLUE);
        AA3Color.put(AA3.HIE, RendererCache.BLUE);
        AA3Color.put(AA3.HID, RendererCache.BLUE);
        AA3Color.put(AA3.ORN, RendererCache.ORANGE);
        AA3Color.put(AA3.AIB, RendererCache.ORANGE);
        AA3Color.put(AA3.PCA, RendererCache.ORANGE);
        AA3Color.put(AA3.FOR, RendererCache.RED);
        AA3Color.put(AA3.ACE, RendererCache.RED);
        AA3Color.put(AA3.NH2, RendererCache.BLUE);
        AA3Color.put(AA3.NME, RendererCache.BLUE);
        AA3Color.put(AA3.UNK, RendererCache.MAGENTA);
        SSTypeColor.put(SSType.NONE, RendererCache.WHITE);
        SSTypeColor.put(SSType.SHEET, RendererCache.PINK);
        SSTypeColor.put(SSType.HELIX, RendererCache.BLUE);
        SSTypeColor.put(SSType.TURN, RendererCache.YELLOW);
        Residue.Ramachandran[0] = "Default (Extended)       [-135.0  135.0]";
        Residue.Ramachandran[1] = "Alpha Helix (R)          [ -57.0  -47.0]";
        Residue.Ramachandran[2] = "Alpha Helix (L)          [  57.0   47.0]";
        Residue.Ramachandran[3] = "3-10 Helix               [ -49.0  -26.0]";
        Residue.Ramachandran[4] = "Pi Helix                 [ -57.0  -70.0]";
        Residue.Ramachandran[5] = "Polyproline II Helix     [ -79.0  149.0]";
        Residue.Ramachandran[6] = "Parallel Beta Strand     [-119.0  113.0]";
        Residue.Ramachandran[7] = "Antiparallel Beta Strand [-139.0  135.0]";
        Residue.Ramachandran[8] = "Beta-Hairpin 2' (i+1)    [  90.0 -170.0]";
        Residue.Ramachandran[9] = "Beta-Hairpin 2' (i+2)    [ -80.0  -10.0]";
        Residue.Ramachandran[10] = "Beta-Hairpin 1' (i+1)    [  57.0   47.0]";
        Residue.Ramachandran[11] = "Beta-Hairpin 1' (i+2)    [  57.0   47.0]";
        Residue.Ramachandran[12] = "Beta-Hairpin 1  (i+1)    [ -57.0  -47.0]";
        Residue.Ramachandran[13] = "Beta-Hairpin 1  (i+2)    [ -57.0  -47.0]";
        Residue.Ramachandran[14] = "Beta-Hairpin 1  (i+3)    [  90.0 -170.0]";
        Residue.Ramachandran[15] = "Beta-Hairpin 3' (i+1)    [  57.0   47.0]";
        Residue.Ramachandran[16] = "Beta-Hairpin 3' (i+2)    [ -80.0  -10.0]";
    }

    public static enum SSType {
        NONE,
        HELIX,
        SHEET,
        TURN;

    }

    public static enum ResidueType {
        NA,
        AA,
        UNK;

    }

    public static enum NA3 {
        A,
        C,
        G,
        U,
        DA,
        DC,
        DG,
        DT,
        MPO,
        DPO,
        TPO,
        UNK;

    }

    public static enum NA1 {
        A,
        C,
        G,
        U,
        D,
        I,
        B,
        T,
        P,
        Q,
        R,
        X;

    }

    public static enum NA {
        ADENINE,
        CYTOSINE,
        GUANINE,
        URACIL,
        DEOXYADENINE,
        DEOXYCYTOSINE,
        DEOXYGUANINE,
        THYMINE,
        MONOPHOSPHATE,
        DIPHOSPHATE,
        TRIPHOSPHATE;

    }

    public static enum AA3 {
        GLY,
        ALA,
        VAL,
        LEU,
        ILE,
        SER,
        THR,
        CYS,
        PRO,
        PHE,
        TYR,
        TRP,
        ASP,
        ASN,
        GLU,
        GLN,
        MET,
        LYS,
        ARG,
        HIS,
        HID,
        HIE,
        ORN,
        AIB,
        PCA,
        FOR,
        ACE,
        NH2,
        NME,
        UNK;

    }

    public static enum AA1 {
        G,
        A,
        V,
        L,
        I,
        S,
        T,
        C,
        P,
        F,
        Y,
        W,
        D,
        N,
        E,
        Q,
        M,
        K,
        R,
        H,
        U,
        Z,
        O,
        B,
        J,
        f,
        a,
        n,
        m,
        X;

    }

    public static enum AA {
        GLYCINE,
        ALANINE,
        VALINE,
        LEUCINE,
        ILLUECINE,
        SERINE,
        THREONINE,
        CYSTIENE,
        PROLINE,
        PHENYLALANINE,
        TYROSINE,
        TYPTOPHAN,
        ASPARTATE,
        ASPARTAMINE,
        GLUTAMATE,
        GLUTAMINE,
        METHIONINE,
        LYSINE,
        ARGININE,
        HISTIDINE;

    }
}

