/*
 * Decompiled with CFR 0.152.
 */
package ffe.lang;

import ffe.lang.Atom;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Logger;
import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.ColoringAttributes;
import org.jogamp.java3d.Geometry;
import org.jogamp.java3d.LineAttributes;
import org.jogamp.java3d.Material;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.PointAttributes;
import org.jogamp.java3d.PolygonAttributes;
import org.jogamp.java3d.RenderingAttributes;
import org.jogamp.java3d.ShaderAppearance;
import org.jogamp.java3d.ShaderProgram;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.TransparencyAttributes;
import org.jogamp.java3d.utils.geometry.Cone;
import org.jogamp.java3d.utils.geometry.Cylinder;
import org.jogamp.java3d.utils.geometry.Sphere;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Point2d;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Vector3d;

public class RendererCache {
    private static Logger logger = Logger.getLogger("ffe");
    public static final LineAttributes lineAttributes = new LineAttributes();
    public static final PointAttributes pointAttributes = new PointAttributes();
    public static final ColoringAttributes coloringAttributes = new ColoringAttributes();
    public static final RenderingAttributes renderingAttributes = new RenderingAttributes();
    public static final TransparencyAttributes transparencyAttributes = new TransparencyAttributes();
    public static final PolygonAttributes fillPolygonAttributes = new PolygonAttributes();
    public static final PolygonAttributes pointPolygonAttributes = new PolygonAttributes();
    public static final PolygonAttributes linePolygonAttributes = new PolygonAttributes();
    public static final Color3f ORANGE = new Color3f(Color.orange.getRGBColorComponents(null));
    public static final Color3f RED = new Color3f(Color.red.getRGBColorComponents(null));
    public static final Color3f BLUE = new Color3f(Color.blue.getRGBColorComponents(null));
    public static final Color3f GRAY = new Color3f(Color.lightGray.getRGBColorComponents(null));
    public static final Color3f YELLOW = new Color3f(Color.yellow.getRGBColorComponents(null));
    public static final Color3f CYAN = new Color3f(Color.cyan.getRGBColorComponents(null));
    public static final Color3f GREEN = new Color3f(Color.green.getRGBColorComponents(null));
    public static final Color3f WHITE = new Color3f(Color.white.getRGBColorComponents(null));
    public static final Color3f PINK = new Color3f(Color.pink.getRGBColorComponents(null));
    public static final Color3f MAGENTA = new Color3f(Color.magenta.getRGBColorComponents(null));
    public static final Color3f BLACK = new Color3f(Color.black.getRGBColorComponents(null));
    public static final Color3f NULLColor = new Color3f(Color.darkGray.getRGBColorComponents(null));
    public static final Color bgColor = Color.black;
    public static ColorModel colorModel = ColorModel.CPK;
    public static ViewModel viewModel = ViewModel.WIREFRAME;
    public static int detail = 3;
    public static double radius = 1.0;
    public static double bondRadius = 1.0;
    public static double vectorScale = 1.8;
    public static int bondwidth = 3;
    public static boolean highlightSelections = false;
    public static boolean labelAtoms = false;
    public static boolean labelResidues = false;
    public static Color3f pickingColor = MAGENTA;
    public static Color3f selectionColor = YELLOW;
    public static Color3f userColor = WHITE;
    public static final Hashtable<String, ViewModel> viewModelHash = new Hashtable();
    public static final Hashtable<String, ColorModel> colorModelHash = new Hashtable();
    private static final Transform3D localToVworld = new Transform3D();
    private static final Transform3D worldToImagePlate = new Transform3D();
    private static final Hashtable<Color3f, Material> materials = new Hashtable();
    private static List<Transform3D> transform3DPool = Collections.synchronizedList(new ArrayList());
    protected static List<BranchGroup> spherePool = Collections.synchronizedList(new ArrayList());
    private static List<BranchGroup> doubleCylinderPool = Collections.synchronizedList(new ArrayList());
    private static final Geometry[] sphereGeom = new Geometry[11];
    private static final Geometry[][] cylgeom = new Geometry[3][11];
    private static final Geometry[][] conegeom = new Geometry[2][4];
    private static final Hashtable<Color3f, Appearance> pointAppearances = new Hashtable();
    private static final Hashtable<Color3f, Appearance> lineAppearances = new Hashtable();
    private static final Hashtable<Color3f, Appearance> fillAppearances = new Hashtable();
    private static ShaderProgram shaderProgram = null;
    private static final Color3f[] negCharge = new Color3f[1000];
    private static final Color3f[] posCharge = new Color3f[1000];
    public static final Appearance nullAp;

    protected static Appearance appearanceFactory(Color3f col, ViewModel polygonType) {
        if (col == null) {
            return null;
        }
        Appearance ap = polygonType == ViewModel.FILL ? fillAppearances.get(col) : (polygonType == ViewModel.POINTS ? pointAppearances.get(col) : lineAppearances.get(col));
        if (ap == null) {
            ap = RendererCache.createAppearance(col, polygonType);
        }
        return ap;
    }

    protected static Shape3D coneFactory(Appearance ap, int res) {
        if (res > 3) {
            res = 3;
        }
        Shape3D cone = new Shape3D();
        cone.setAppearance(ap);
        cone.setCapability(12);
        cone.setCapability(13);
        cone.setCapability(15);
        cone.setCapability(6);
        cone.addGeometry(RendererCache.getConeGeom(0, res));
        cone.addGeometry(RendererCache.getConeGeom(1, res));
        return cone;
    }

    private static Appearance createAppearance(Color3f col, ViewModel polygonType) {
        Appearance ap = null;
        if (shaderProgram != null) {
            ShaderAppearance sap = new ShaderAppearance();
            sap.setShaderProgram(shaderProgram);
            ap = sap;
        }
        if (ap == null) {
            ap = new Appearance();
        }
        Material mat = RendererCache.materialFactory(col);
        ap.setMaterial(mat);
        ap.setRenderingAttributes(renderingAttributes);
        ap.setColoringAttributes(coloringAttributes);
        ap.setLineAttributes(lineAttributes);
        ap.setPointAttributes(pointAttributes);
        if (polygonType == ViewModel.FILL) {
            ap.setPolygonAttributes(fillPolygonAttributes);
            fillAppearances.put(col, ap);
        } else if (polygonType == ViewModel.POINTS) {
            ap.setPolygonAttributes(pointPolygonAttributes);
            pointAppearances.put(col, ap);
        } else {
            ap.setPolygonAttributes(linePolygonAttributes);
            lineAppearances.put(col, ap);
        }
        return ap;
    }

    protected static final Shape3D createCylinder(Appearance ap, int res) {
        if (res < 0) {
            res = 0;
        }
        if (res > 10) {
            res = 10;
        }
        Shape3D cyl = new Shape3D();
        cyl.setAppearance(ap);
        cyl.addGeometry(RendererCache.getCylinderGeom(0, res));
        cyl.addGeometry(RendererCache.getCylinderGeom(1, res));
        cyl.addGeometry(RendererCache.getCylinderGeom(2, res));
        cyl.setCapability(12);
        cyl.setCapability(13);
        cyl.setCapability(15);
        cyl.setCapability(14);
        cyl.setCapability(1);
        cyl.setCapability(6);
        return cyl;
    }

    private static Shape3D createSphere(Appearance ap, int div) {
        Shape3D shape3d = new Shape3D();
        shape3d.setAppearance(ap);
        shape3d.addGeometry(RendererCache.getSphereGeom(div));
        shape3d.setCapability(12);
        shape3d.setCapability(13);
        shape3d.setCapability(15);
        shape3d.setCapability(14);
        shape3d.setCapability(1);
        shape3d.setCapability(6);
        return shape3d;
    }

    private static final TransformGroup createTransformGroup(Transform3D transform3D) {
        TransformGroup transformGroup = transform3D == null ? new TransformGroup() : new TransformGroup(transform3D);
        transformGroup.setCapability(17);
        transformGroup.setCapability(18);
        transformGroup.setCapability(12);
        return transformGroup;
    }

    protected static final BranchGroup doubleCylinderFactory(Atom a1, Atom a2, int div) {
        BranchGroup branchGroup;
        if (doubleCylinderPool.size() > 0 && (branchGroup = doubleCylinderPool.remove(0)) != null) {
            TransformGroup cy1tg = (TransformGroup)branchGroup.getChild(0);
            Shape3D cy1 = (Shape3D)cy1tg.getChild(0);
            cy1.setAppearance(a1.getAtomAppearance());
            cy1.setUserData((Object)a1);
            TransformGroup cy2tg = (TransformGroup)branchGroup.getChild(1);
            Shape3D cy2 = (Shape3D)cy2tg.getChild(0);
            cy2.setUserData((Object)a2);
            cy2.setAppearance(a2.getAtomAppearance());
            return branchGroup;
        }
        branchGroup = new BranchGroup();
        branchGroup.setCapability(17);
        branchGroup.setCapability(12);
        branchGroup.setCapability(1);
        TransformGroup cy1tg = RendererCache.createTransformGroup(null);
        Shape3D cy1 = RendererCache.createCylinder(a1.getAtomAppearance(), div);
        cy1.setUserData((Object)a1);
        cy1tg.addChild((Node)cy1);
        branchGroup.addChild((Node)cy1tg);
        TransformGroup cy2tg = RendererCache.createTransformGroup(null);
        Shape3D cy2 = RendererCache.createCylinder(a2.getAtomAppearance(), div);
        cy2.setUserData((Object)a2);
        cy2tg.addChild((Node)cy2);
        branchGroup.addChild((Node)cy2tg);
        branchGroup.compile();
        return branchGroup;
    }

    protected static final Color3f getColor(Atom a, ColorModel mode) {
        switch (mode) {
            case CPK: {
                return Atom.AtomColor.get(a.getAtomicNumber());
            }
            case PICK: {
                return pickingColor;
            }
            case SELECT: {
                return selectionColor;
            }
            case PARTIALCHARGE: {
                int index = 0;
                double charge = a.getCharge();
                if (charge < 0.0) {
                    float c = (float)(charge * 1000.0);
                    index = -1 * Math.round(c);
                    if (index > 999) {
                        index = 999;
                    }
                    if (negCharge[index] == null) {
                        float value = (float)index * 0.001f;
                        RendererCache.negCharge[index] = new Color3f(1.0f, 1.0f - value, 1.0f - value);
                    }
                    return negCharge[index];
                }
                if (charge == 0.0) {
                    return WHITE;
                }
                float c = (float)(charge * 1000.0);
                index = Math.round(c);
                if (index > 999) {
                    index = 999;
                }
                if (posCharge[index] == null) {
                    float value = (float)index * 0.001f;
                    RendererCache.posCharge[index] = new Color3f(1.0f - value, 1.0f - value, 1.0f);
                }
                return posCharge[index];
            }
            case VECTORMAGNITUDE: {
                int index = 0;
                double mag = a.getRelativeLength();
                if (mag > 0.0) {
                    index = (int)Math.round(mag * 1000.0);
                    if (index < 0) {
                        logger.info(String.valueOf(a) + " " + mag);
                        return WHITE;
                    }
                    if (index > 999) {
                        index = 999;
                    }
                    if (negCharge[index] == null) {
                        float value = (float)index * 0.001f;
                        RendererCache.negCharge[index] = new Color3f(1.0f, 1.0f - value, 1.0f - value);
                    }
                    return negCharge[index];
                }
                return NULLColor;
            }
        }
        return NULLColor;
    }

    protected static Geometry getConeGeom(int num, int res) {
        if (res > 3) {
            res = 3;
        }
        if (conegeom[num][res] == null) {
            RendererCache.initConeGeom(res);
        }
        return conegeom[num][res];
    }

    protected static final Geometry getCylinderGeom(int num, int res) {
        if (res < 0) {
            res = 0;
        }
        if (res > 10) {
            res = 10;
        }
        if (cylgeom[num][res] == null) {
            RendererCache.initCylinderGeom(res);
        }
        return cylgeom[num][res];
    }

    protected static final Geometry getPolarGeom(int res) {
        return RendererCache.getSphereGeom(res);
    }

    protected static void getScreenCoordinate(Canvas3D canvas, Node node, Point3d point3d, Point2d point) {
        if (point == null) {
            return;
        }
        node.getLocalToVworld(localToVworld);
        canvas.getVworldToImagePlate(worldToImagePlate);
        localToVworld.transform(point3d);
        worldToImagePlate.transform(point3d);
        canvas.getPixelLocationFromImagePlate(point3d, point);
    }

    protected static final Geometry getSphereGeom(int res) {
        if (res < 0) {
            res = 0;
        }
        if (res > 10) {
            res = 10;
        }
        if (sphereGeom[res] == null) {
            RendererCache.initSphereGeom(res);
        }
        return sphereGeom[res];
    }

    private static void initConeGeom(int res) {
        Cone cone = new Cone(1.0f, 1.0f, 97, (res + 1) * 4, 1, nullAp);
        for (int i = 0; i < 2; ++i) {
            RendererCache.conegeom[i][res] = cone.getShape(i).getGeometry();
        }
    }

    private static void initCylinderGeom(int res) {
        Appearance ap = new Appearance();
        Cylinder cyl = new Cylinder(1.0f, 1.0f, 97, 2 + res, 1, ap);
        for (int i = 0; i < 3; ++i) {
            RendererCache.cylgeom[i][res] = cyl.getShape(i).getGeometry();
            try {
                cylgeom[i][res].setCapability(18);
                cylgeom[i][res].setCapability(17);
                cylgeom[i][res].setCapability(8);
                cylgeom[i][res].setCapability(0);
                continue;
            }
            catch (Exception e) {
                return;
            }
        }
    }

    private static void initSphereGeom(int res) {
        Appearance ap = new Appearance();
        Sphere sphere = new Sphere(1.0f, 97, 4 + 3 * res, ap);
        RendererCache.sphereGeom[res] = sphere.getShape().getGeometry();
    }

    protected static Material materialFactory(Color3f col) {
        if (col == null) {
            return null;
        }
        Material mat = materials.get(col);
        if (mat == null) {
            mat = new Material(col, BLACK, col, WHITE, 75.0f);
            mat.setLightingEnable(true);
            materials.put(col, mat);
        }
        return mat;
    }

    protected static void poolDoubleCylinder(BranchGroup branchGroup) {
        if (branchGroup != null) {
            doubleCylinderPool.add(branchGroup);
        }
    }

    protected static void poolSphere(BranchGroup tg) {
        if (tg != null) {
            spherePool.add(tg);
        }
    }

    protected static void poolTransform3D(Transform3D transform3D) {
        if (transform3D != null) {
            transform3DPool.add(transform3D);
        }
    }

    protected static final BranchGroup sphereFactory(Appearance ap, int div, Transform3D transform3D) {
        BranchGroup branchGroup;
        if (spherePool.size() > 0 && (branchGroup = spherePool.remove(0)) != null) {
            TransformGroup transformGroup = (TransformGroup)branchGroup.getChild(0);
            transformGroup.setTransform(transform3D);
            Shape3D sphere = (Shape3D)transformGroup.getChild(0);
            sphere.setAppearance(ap);
            return branchGroup;
        }
        branchGroup = new BranchGroup();
        branchGroup.setCapability(17);
        branchGroup.setCapability(12);
        branchGroup.setCapability(14);
        TransformGroup transformGroup = RendererCache.createTransformGroup(transform3D);
        Shape3D sphere = RendererCache.createSphere(ap, div);
        transformGroup.addChild((Node)sphere);
        branchGroup.addChild((Node)transformGroup);
        branchGroup.compile();
        return branchGroup;
    }

    protected static final Color3f toAtomColor(String s) {
        String c = s.toLowerCase();
        if (c.startsWith("h")) {
            return WHITE;
        }
        if (c.startsWith("c")) {
            return GRAY;
        }
        if (c.startsWith("n")) {
            return BLUE;
        }
        if (c.startsWith("o")) {
            return RED;
        }
        if (c.startsWith("p")) {
            return GREEN;
        }
        if (c.startsWith("s")) {
            return YELLOW;
        }
        return NULLColor;
    }

    protected static final Transform3D transform3DFactory() {
        Transform3D transform3D;
        if (transform3DPool.size() > 0 && (transform3D = transform3DPool.get(0)) != null) {
            return transform3D;
        }
        transform3D = new Transform3D();
        return transform3D;
    }

    protected static final Transform3D transform3DFactory(Vector3d position, double scale) {
        Transform3D transform3D;
        if (transform3DPool.size() > 0 && (transform3D = transform3DPool.get(0)) != null) {
            transform3D.setTranslation(position);
            transform3D.setScale(scale);
            return transform3D;
        }
        transform3D = new Transform3D();
        transform3D.setTranslation(position);
        transform3D.setScale(scale);
        return transform3D;
    }

    public RendererCache() {
    }

    public RendererCache(ViewModel v, ColorModel c) {
        viewModel = v;
        colorModel = c;
    }

    static {
        coloringAttributes.setShadeModel(1);
        coloringAttributes.setColor(new Color3f());
        lineAttributes.setLineAntialiasingEnable(true);
        lineAttributes.setLinePattern(0);
        lineAttributes.setLineWidth(1.0f);
        pointAttributes.setPointAntialiasingEnable(true);
        pointAttributes.setPointSize(1.0f);
        fillPolygonAttributes.setPolygonMode(2);
        fillPolygonAttributes.setCullFace(1);
        linePolygonAttributes.setPolygonMode(1);
        pointPolygonAttributes.setPolygonMode(0);
        renderingAttributes.setVisible(true);
        renderingAttributes.setDepthBufferEnable(true);
        renderingAttributes.setDepthBufferWriteEnable(true);
        renderingAttributes.setIgnoreVertexColors(true);
        transparencyAttributes.setTransparencyMode(4);
        Enum[] values = ViewModel.values();
        for (Enum value : values) {
            viewModelHash.put(value.toString(), (ViewModel)value);
        }
        values = ColorModel.values();
        for (Enum value : values) {
            colorModelHash.put(value.toString(), (ColorModel)value);
        }
        nullAp = new Appearance();
        RenderingAttributes ra = new RenderingAttributes();
        ra.setVisible(false);
        nullAp.setRenderingAttributes(ra);
    }

    public static enum ViewModel {
        WIREFRAME,
        BALLANDSTICK,
        SPACEFILL,
        RMIN,
        TUBE,
        RIBBON,
        INVISIBLE,
        RESTRICT,
        DETAIL,
        SHOWHYDROGENS,
        HIDEHYDROGENS,
        INDUCEDDIPOLE,
        FORCE,
        VELOCITY,
        ACCELERATION,
        HIDEVECTORS,
        UNIT,
        RELATIVE,
        ABSOLUTE,
        POINTS,
        LINES,
        FILL,
        DESTROY;

    }

    public static enum ColorModel {
        CPK,
        GROUP,
        POLYMER,
        RESIDUE,
        MOLECULE,
        PICK,
        SELECT,
        REVERT,
        PARTIALCHARGE,
        STRUCTURE,
        VECTORMAGNITUDE,
        USERCOLOR,
        APPLYUSERCOLOR,
        MONOCHROME;

    }
}

