/*
 * Decompiled with CFR 0.152.
 */
package ffe.lang;

import ffe.lang.MSNode;
import ffe.lang.MSRoot;
import ffe.lang.MolecularAssembly;
import ffe.lang.ROLSP;
import ffe.lang.RendererCache;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.tree.TreeNode;
import org.jogamp.java3d.Behavior;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.WakeupCondition;
import org.jogamp.java3d.WakeupOnBehaviorPost;

public class Renderer
extends Behavior {
    private Logger logger = Logger.getLogger("ffe");
    private static long occupiedMemory;
    private static long time;
    private static long frameNumber;
    private static long frameDuration;
    private ArrayList<MSNode> nodesToUpdate = null;
    private ArrayList<MSNode> nodesCache = null;
    private boolean doTransform;
    private boolean doView;
    private boolean doColor;
    private boolean doTransformCache;
    private boolean doViewCache;
    private boolean doColorCache;
    private JLabel statusBar = null;
    private RendererCache.ViewModel viewModel;
    private RendererCache.ViewModel viewModelCache;
    private RendererCache.ColorModel colorModel;
    private RendererCache.ColorModel colorModelCache;
    private WakeupOnBehaviorPost postid;
    private boolean timer = false;
    private boolean gc = false;

    public Renderer(Bounds b, JLabel s) {
        this.setSchedulingBounds(b);
        this.statusBar = s;
        if (System.getProperty("ffe.timer", "false").equalsIgnoreCase("true")) {
            this.timer = true;
            if (System.getProperty("ffe.timer.gc", "false").equalsIgnoreCase("true")) {
                this.gc = true;
            }
        }
    }

    public void arm(ArrayList<MSNode> nodes, boolean t, boolean v, RendererCache.ViewModel vtype, boolean c, RendererCache.ColorModel ctype) {
        if (this.nodesToUpdate != null) {
            this.nodesCache = nodes;
            this.doTransformCache = t;
            this.doViewCache = v;
            this.viewModelCache = vtype;
            this.doColorCache = c;
            this.colorModelCache = ctype;
        } else {
            this.nodesToUpdate = nodes;
            this.doTransform = t;
            this.doView = v;
            this.viewModel = vtype;
            this.doColor = c;
            this.colorModel = ctype;
            this.postId(1);
        }
    }

    public void arm(MSNode node, boolean t, boolean v, RendererCache.ViewModel vtype, boolean c, RendererCache.ColorModel ctype) {
        ArrayList<MSNode> temp = new ArrayList<MSNode>();
        temp.add(node);
        this.arm(temp, t, v, vtype, c, ctype);
    }

    public void initialize() {
        this.postid = new WakeupOnBehaviorPost((Behavior)this, 1);
        this.wakeupOn((WakeupCondition)this.postid);
    }

    public boolean isArmed() {
        return this.nodesToUpdate != null;
    }

    public boolean isCacheFull() {
        return this.nodesCache != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processStimulus(Iterator parm1) {
        ArrayList newShapes;
        if (this.getView().getFrameNumber() == frameNumber) {
            System.out.print(".");
            this.wakeupOn((WakeupCondition)this.postid);
            this.postId(1);
            return;
        }
        String viewString = null;
        String colorString = null;
        if (this.viewModel != null) {
            try {
                viewString = this.viewModel.toString();
            }
            catch (Exception e) {
                this.statusBar.setText("Unknown ViewModel: " + String.valueOf((Object)this.viewModel));
                return;
            }
        }
        if (this.colorModel != null) {
            try {
                colorString = this.colorModel.toString();
            }
            catch (Exception e) {
                this.statusBar.setText("Unknown ColorModel: " + String.valueOf((Object)this.colorModel));
                return;
            }
        }
        if (this.timer) {
            this.startTimer();
            if (viewString != null) {
                this.logger.info("Applying ViewModel Change: " + viewString);
            }
            if (colorString != null) {
                System.out.println("Applying ColorModel Change: " + colorString);
            }
        }
        ArrayList<ArrayList> newChildren = new ArrayList<ArrayList>();
        for (MSNode nodeToUpdate : this.nodesToUpdate) {
            if (nodeToUpdate == null) continue;
            if (this.doTransform) {
                nodeToUpdate.update();
            }
            if (this.doColor) {
                nodeToUpdate.setColor(this.colorModel, null, null);
                if (this.statusBar != null) {
                    this.statusBar.setText("  Color by \"" + colorString + "\" applied to " + nodeToUpdate.toString());
                }
            }
            if (!this.doView) continue;
            newShapes = new ArrayList();
            newChildren.add(newShapes);
            nodeToUpdate.setView(this.viewModel, newShapes);
            if (this.statusBar == null) continue;
            this.statusBar.setText("  Style \"" + viewString + "\" applied to " + nodeToUpdate.toString());
        }
        try {
            if (ROLSP.GO_PARALLEL && ROLSP.parallelNotDone > 0) {
                this.logger.info("Renderer waiting for " + ROLSP.parallelNotDone + " processes...");
            }
            while (ROLSP.GO_PARALLEL && ROLSP.parallelNotDone > 0) {
                Object object = this;
                synchronized (object) {
                    ((Object)((Object)this)).wait(10L);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception Waiting for Parallel MultiScale Methods to Finish");
        }
        finally {
            for (int i = 0; i < this.nodesToUpdate.size() && !newChildren.isEmpty(); ++i) {
                Enumeration<TreeNode> e;
                MolecularAssembly ma;
                MSNode nodeToUpdate;
                nodeToUpdate = this.nodesToUpdate.get(i);
                if (nodeToUpdate == null) continue;
                if (nodeToUpdate instanceof MolecularAssembly) {
                    ma = (MolecularAssembly)nodeToUpdate;
                    ma.sceneGraphChange(null);
                    continue;
                }
                if (nodeToUpdate instanceof ROLSP) {
                    ma = (MolecularAssembly)nodeToUpdate.getChildAt(0);
                    ma.sceneGraphChange(null);
                    continue;
                }
                if (nodeToUpdate instanceof MSRoot) {
                    e = nodeToUpdate.children();
                } else {
                    newShapes = (ArrayList)newChildren.get(i);
                    if (newShapes.isEmpty()) continue;
                    MolecularAssembly ma2 = (MolecularAssembly)nodeToUpdate.getMSNode(MolecularAssembly.class);
                    ma2.sceneGraphChange(newShapes);
                    continue;
                }
                while (e.hasMoreElements()) {
                    MolecularAssembly ma3;
                    MSNode updatedNode = (MSNode)e.nextElement();
                    if (updatedNode instanceof ROLSP) {
                        ma3 = (MolecularAssembly)updatedNode.getChildAt(0);
                        ma3.sceneGraphChange(null);
                        continue;
                    }
                    ma3 = (MolecularAssembly)updatedNode;
                    ma3.sceneGraphChange(null);
                }
            }
        }
        if (this.timer) {
            this.stopTimer();
        }
        this.nodesToUpdate = null;
        this.wakeupOn((WakeupCondition)this.postid);
        if (this.nodesCache != null) {
            this.nodesToUpdate = this.nodesCache;
            this.doTransform = this.doTransformCache;
            this.doView = this.doViewCache;
            this.viewModel = this.viewModelCache;
            this.doColor = this.doColorCache;
            this.colorModel = this.colorModelCache;
            this.nodesCache = null;
            this.postId(1);
        }
    }

    private void startTimer() {
        Runtime runtime = Runtime.getRuntime();
        frameDuration = this.getView().getLastFrameDuration();
        if (this.gc) {
            System.out.print("Running Finalization and GC for acccurate memory usage...");
            runtime.runFinalization();
            runtime.gc();
            this.logger.info(" Done\nProceeding with graphics operation...");
        }
        occupiedMemory = runtime.totalMemory() - runtime.freeMemory();
        time = System.currentTimeMillis();
    }

    private void stopTimer() {
        Runtime runtime = Runtime.getRuntime();
        long currentTime = System.currentTimeMillis();
        frameNumber = this.getView().getFrameNumber();
        frameDuration = this.getView().getLastFrameDuration();
        this.logger.info("Frame Duration After Op: " + frameDuration / 1000L);
        if (this.gc) {
            runtime.runFinalization();
            runtime.gc();
            this.logger.info(" Done");
            long l = runtime.totalMemory() - runtime.freeMemory() - occupiedMemory;
        }
        occupiedMemory = runtime.totalMemory() - runtime.freeMemory();
    }

    static {
        frameNumber = 0L;
    }
}

