/*
 * Decompiled with CFR 0.152.
 */
package ffe.lang;

import ffe.lang.HashCodeUtil;
import ffe.lang.MSNode;
import ffe.lang.ROLS;
import ffe.lang.RendererCache;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.tree.TreeNode;
import org.jogamp.java3d.BranchGroup;

public class ROLSP
extends MSNode
implements ROLS,
Runnable {
    private Logger logger = Logger.getLogger("ffe");
    private static final long serialVersionUID = 1L;
    public static boolean GO_PARALLEL = false;
    public static int parallelNotDone = 0;
    private PARALLELMETHOD parallelMethod = PARALLELMETHOD.NONE;
    private Thread thread = null;
    private long startTime = 0L;
    private long threadTime = 0L;
    private RendererCache.ViewModel viewModel = null;
    private List<BranchGroup> newShapes = null;

    public ROLSP() {
        super("Parallel Node");
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public int hashCode() {
        MSNode child = (MSNode)this.getChildAt(0);
        if (child == null) {
            return HashCodeUtil.hash(2024, "none".hashCode());
        }
        return HashCodeUtil.hash(7029, child.hashCode());
    }

    @Override
    public void run() {
        switch (this.parallelMethod) {
            case SETVIEW: {
                this.setView(this.viewModel, this.newShapes);
                break;
            }
            default: {
                return;
            }
        }
        this.threadTime = System.currentTimeMillis() - this.startTime;
        this.logger.info("Start Time: " + this.startTime + " Total Time: " + this.threadTime);
        --parallelNotDone;
    }

    @Override
    public void setView(RendererCache.ViewModel viewModel, List<BranchGroup> newShapes) {
        if (this.parallelMethod == PARALLELMETHOD.NONE) {
            this.startTime = System.currentTimeMillis();
            this.viewModel = viewModel;
            this.newShapes = newShapes;
            this.parallelMethod = PARALLELMETHOD.SETVIEW;
            this.thread = new Thread(this);
            this.thread.setName(this.getParent().toString() + ": Parallel setView MSM");
            this.thread.setPriority(10);
            ++parallelNotDone;
            this.thread.start();
        } else if (this.parallelMethod == PARALLELMETHOD.SETVIEW) {
            Enumeration<TreeNode> e = this.children();
            while (e.hasMoreElements()) {
                MSNode node = (MSNode)e.nextElement();
                node.setView(viewModel, newShapes);
            }
            this.parallelMethod = PARALLELMETHOD.NONE;
            this.thread = null;
            viewModel = null;
            newShapes = null;
        } else {
            this.logger.info("Parallel setView method called by: " + String.valueOf((Object)this.parallelMethod));
            return;
        }
    }

    @Override
    public String toString() {
        if (this.threadTime != 0L) {
            return "Parallel Node " + this.threadTime + " (msec)";
        }
        return "Parallel Node";
    }

    static {
        try {
            boolean b;
            GO_PARALLEL = b = Boolean.parseBoolean(System.getProperty("ffe.lang.parallel", "false"));
        }
        catch (Exception e) {
            GO_PARALLEL = false;
        }
    }

    public static enum PARALLELMETHOD {
        SETVIEW,
        NONE;

    }
}

