/*
 * Decompiled with CFR 0.152.
 */
package ffe.lang;

import ffe.lang.Atom;
import ffe.lang.Bond;
import ffe.lang.Dihedral;
import ffe.lang.HashCodeUtil;
import ffe.lang.Joint;
import ffe.lang.MSGroup;
import ffe.lang.MSNode;
import ffe.lang.RendererCache;
import ffe.lang.Residue;
import ffe.lang.VectorMath;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.tree.TreeNode;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Material;
import org.jogamp.vecmath.Color3f;

public class Polymer
extends MSGroup {
    private Logger logger = Logger.getLogger("ffe");
    private static final long serialVersionUID = 1L;
    public static final int MultiScaleLevel = 3;
    private static int count = 0;
    private static double[] da = new double[3];
    private static double[] db = new double[3];
    public static Hashtable<Integer, Color3f> polymerColor = new Hashtable();
    private boolean link = false;
    private int polymerNumber = ++count;

    public Polymer() {
    }

    public Polymer(String n, boolean bk) {
        super(n, bk);
    }

    public Polymer(String n, boolean bk, boolean l) {
        this(n, bk);
        this.link = l;
    }

    public Polymer(String n, MSNode residues, boolean bk) {
        super(n, residues, bk);
    }

    @Override
    public void addMSNode(MSNode o) {
        if (!(o instanceof Residue)) {
            this.logger.warning("Polymer can not contain nodes of type: " + String.valueOf(o.getClass()));
        } else {
            this.getAtomNode().add(o);
        }
    }

    public Joint createJoint(Residue residue1, Residue residue2) {
        Joint joint = null;
        Enumeration<TreeNode> e = residue1.getAtomNode().children();
        while (e.hasMoreElements()) {
            Atom a1 = (Atom)e.nextElement();
            a1.getXYZ(da);
            Enumeration<TreeNode> e2 = residue2.getAtomNode().children();
            while (e2.hasMoreElements()) {
                double d2;
                Atom a2 = (Atom)e2.nextElement();
                a2.getXYZ(db);
                double d1 = VectorMath.dist(da, db);
                if (!(d1 < (d2 = (double)0.7f + a1.getVDWR() / 2.0 + a2.getVDWR() / 2.0))) continue;
                Bond b = new Bond(a1, a2, 1);
                Joint newJoint = this.createJoint(b, residue1, residue2);
                if (joint != null) {
                    joint.merge(newJoint);
                    continue;
                }
                joint = newJoint;
            }
        }
        return joint;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Polymer other = (Polymer)object;
        return this.getName() == other.getName();
    }

    @Override
    public void finalize(boolean finalizeGroups) {
        ListIterator li;
        ArrayList res = this.getAtomNodeList();
        this.setFinalized(false);
        if (finalizeGroups) {
            li = res.listIterator();
            while (li.hasNext()) {
                ((Residue)li.next()).finalize(true);
            }
        }
        if (this.link) {
            this.getAtomNode().setName("Residues (" + res.size() + ")");
            MSNode joints = this.getTerms();
            joints.removeAllChildren();
            ArrayList<Atom> atoms = this.getAtomList();
            if (this.getBondsKnown()) {
                li = atoms.listIterator();
                while (li.hasNext()) {
                    Atom a = (Atom)li.next();
                    if (a.getNumBonds() <= 0) continue;
                    ListIterator<Bond> lj = a.getBonds().listIterator();
                    while (lj.hasNext()) {
                        Bond b = lj.next();
                        if (b.sameGroup() || b.getParent() != null) continue;
                        Residue r1 = (Residue)a.getMSNode(Residue.class);
                        Residue r2 = (Residue)b.get1_2(a).getMSNode(Residue.class);
                        Joint j = this.createJoint(b, r1, r2);
                        joints.add(j);
                    }
                }
            } else {
                Residue next = this.getResidue(0);
                Residue current = null;
                for (int i = 1; i <= this.getAtomNode().getChildCount(); ++i) {
                    Joint j;
                    current = next;
                    next = this.getResidue(i);
                    if (current == null || next == null || (j = this.createJoint(current, next)) == null) continue;
                    joints.add(j);
                }
            }
            this.getTerms().setName("Linkages (" + joints.getChildCount() + ")");
        } else {
            this.getAtomNode().setName("Sub-Groups (" + res.size() + ")");
            if (this.getTerms().getParent() != null) {
                this.remove(this.getTerms());
            }
        }
        this.removeLeaves();
        this.setFinalized(true);
    }

    public boolean getLink() {
        return this.link;
    }

    public Vector<ArrayList<Dihedral>> getPhiPsiList() {
        Vector<ArrayList<Dihedral>> phipsi = new Vector<ArrayList<Dihedral>>();
        ArrayList<Dihedral> phi = new ArrayList<Dihedral>();
        ArrayList<Dihedral> psi = new ArrayList<Dihedral>();
        phipsi.add(phi);
        phipsi.add(psi);
        MSNode joints = this.getTerms();
        ListIterator<MSNode> li = joints.getChildListIterator();
        while (li.hasNext()) {
            MSNode dihedrals = ((Joint)li.next()).getDihedrals();
            ListIterator<MSNode> lj = dihedrals.getChildListIterator();
            while (lj.hasNext()) {
                Dihedral d = (Dihedral)lj.next();
                String s = d.getKey();
                if (s == "C-N-CA-C".intern() || s == "C-CA-N-C".intern()) {
                    phi.add(d);
                    continue;
                }
                if (s != "N-C-CA-N".intern() && s != "N-CA-C-N".intern()) continue;
                psi.add(d);
            }
        }
        return phipsi;
    }

    public Residue getResidue(int resNum) {
        Residue r;
        if (resNum > 0 && this.getAtomNode().getChildCount() >= resNum && (r = (Residue)this.getAtomNode().getChildAt(resNum - 1)).getResidueNumber() == resNum) {
            return r;
        }
        Enumeration<TreeNode> e = this.getAtomNode().children();
        while (e.hasMoreElements()) {
            Residue r2 = (Residue)e.nextElement();
            if (r2.getResidueNumber() != resNum) continue;
            return r2;
        }
        return null;
    }

    public Residue getResidue(String resName, int resNum, boolean create) {
        Residue r;
        if (resNum > 0 && this.getAtomNode().getChildCount() >= resNum && (r = (Residue)this.getAtomNode().getChildAt(resNum - 1)).getResidueNumber() == resNum && r.getName().equalsIgnoreCase(resName)) {
            return r;
        }
        Enumeration<TreeNode> e = this.getAtomNode().children();
        while (e.hasMoreElements()) {
            Residue r2 = (Residue)e.nextElement();
            if (r2.getResidueNumber() != resNum || !r2.getName().equalsIgnoreCase(resName)) continue;
            return r2;
        }
        if (!create) {
            return null;
        }
        Residue residue = null;
        if ((resName = resName.toUpperCase()).length() == 1) {
            try {
                Residue.NA1.valueOf(resName);
                residue = new Residue(resName, resNum, false, Residue.ResidueType.NA);
            }
            catch (Exception e2) {
                try {
                    Residue.AA1.valueOf(resName);
                    residue = new Residue(resName, resNum, false, Residue.ResidueType.AA);
                }
                catch (Exception exception) {}
            }
        } else if (resName.length() == 2 || resName.length() == 3) {
            try {
                Residue.NA3.valueOf(resName);
                residue = new Residue(resName, resNum, false, Residue.ResidueType.NA);
            }
            catch (Exception e3) {
                try {
                    Residue.AA3.valueOf(resName);
                    residue = new Residue(resName, resNum, false, Residue.ResidueType.AA);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (residue == null) {
            residue = new Residue(resName, resNum, false, Residue.ResidueType.UNK);
        }
        this.addMSNode(residue);
        return residue;
    }

    @Override
    public int hashCode() {
        return HashCodeUtil.hash(4026, this.polymerNumber);
    }

    @Override
    public void setColor(RendererCache.ColorModel newColorModel, Color3f color, Material mat) {
        if (newColorModel == RendererCache.ColorModel.POLYMER) {
            int index = this.polymerNumber % 10;
            color = polymerColor.get(index);
            mat = RendererCache.materialFactory(color);
        }
        ListIterator li = this.getAtomNodeList().listIterator();
        while (li.hasNext()) {
            MSGroup atomGroup = (MSGroup)li.next();
            atomGroup.setColor(newColorModel, color, mat);
        }
        Enumeration<TreeNode> e = this.getTerms().children();
        while (e.hasMoreElements()) {
            Joint joint = (Joint)e.nextElement();
            joint.setColor(newColorModel);
        }
    }

    public void setLink(boolean t) {
        this.link = t;
    }

    @Override
    public void setView(RendererCache.ViewModel newViewModel, List<BranchGroup> newShapes) {
        ListIterator li = this.getAtomNodeList().listIterator();
        while (li.hasNext()) {
            MSGroup atomGroup = (MSGroup)li.next();
            atomGroup.setView(newViewModel, newShapes);
        }
        Enumeration<TreeNode> e = this.getTerms().children();
        while (e.hasMoreElements()) {
            Joint joint = (Joint)e.nextElement();
            joint.setView(newViewModel, newShapes);
        }
    }

    static {
        polymerColor.put(0, RendererCache.RED);
        polymerColor.put(1, RendererCache.ORANGE);
        polymerColor.put(2, RendererCache.YELLOW);
        polymerColor.put(3, RendererCache.GREEN);
        polymerColor.put(4, RendererCache.BLUE);
        polymerColor.put(5, RendererCache.MAGENTA);
        polymerColor.put(6, RendererCache.CYAN);
        polymerColor.put(7, RendererCache.WHITE);
        polymerColor.put(8, RendererCache.GRAY);
        polymerColor.put(9, RendererCache.PINK);
    }
}

