/*
 * Decompiled with CFR 0.152.
 */
package ffe.lang;

import ffe.lang.VectorMath;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MultipoleTensorRecursion {
    private static final Logger logger = Logger.getLogger("ffe");
    private static double[] T000 = null;
    private final double[] work;
    private final int order;
    private final double[] t000j_Constants;
    private final int o1;
    private final int il;
    private final int im;
    private final int in;

    public static void main(String[] args) throws Exception {
        int order = 5;
        if (args.length > 0) {
            order = Integer.parseInt(args[0]);
        }
        int maxOrder = 5;
        if (args.length > 1) {
            maxOrder = Integer.parseInt(args[1]);
        }
        int loops = 2;
        if (args.length > 2) {
            loops = Integer.parseInt(args[2]);
        }
        int n = 10000;
        if (args.length > 3) {
            n = Integer.parseInt(args[3]);
        }
        double[] r = new double[]{1.1, 1.2, 1.3};
        while (order <= maxOrder) {
            MultipoleTensorRecursion multipoleTensor = new MultipoleTensorRecursion(order);
            logger.setLevel(Level.FINE);
            for (int l = 1; l <= loops; ++l) {
                int size = (int)VectorMath.binomial(order + 3, 3L);
                double[] tensor = new double[size];
                int niter = n * (int)Math.log(n);
                long start = System.currentTimeMillis();
                for (int i = 0; i < niter; ++i) {
                    multipoleTensor.tensorRecursion(r, tensor);
                }
                long done = System.currentTimeMillis() - start;
                logger.info("Tensor Recursion - Order           : " + order + " n " + niter + " time " + done + " size " + size);
            }
            ++order;
        }
    }

    public static int tensorIndex(int dx, int dy, int dz, int order) {
        int size = (order + 1) * (order + 2) * (order + 3) / 6;
        int top = order + 1 - dz;
        top = top * (top + 1) * (top + 2) / 6;
        int zindex = size - top;
        int yindex = dy * (order + 1) - dy * (dy - 1) / 2;
        return dx + yindex + zindex;
    }

    private static double Tlmnj(int l, int m, int n, int j, double[] r, double[] T000) {
        if (m == 0 && n == 0) {
            if (l > 1) {
                return r[0] * MultipoleTensorRecursion.Tlmnj(l - 1, 0, 0, j + 1, r, T000) + (double)(l - 1) * MultipoleTensorRecursion.Tlmnj(l - 2, 0, 0, j + 1, r, T000);
            }
            if (l == 1) {
                return r[0] * MultipoleTensorRecursion.Tlmnj(0, 0, 0, j + 1, r, T000);
            }
            return T000[j];
        }
        if (n == 0) {
            if (m > 1) {
                return r[1] * MultipoleTensorRecursion.Tlmnj(l, m - 1, 0, j + 1, r, T000) + (double)(m - 1) * MultipoleTensorRecursion.Tlmnj(l, m - 2, 0, j + 1, r, T000);
            }
            return r[1] * MultipoleTensorRecursion.Tlmnj(l, 0, 0, j + 1, r, T000);
        }
        if (n > 1) {
            return r[2] * MultipoleTensorRecursion.Tlmnj(l, m, n - 1, j + 1, r, T000) + (double)(n - 1) * MultipoleTensorRecursion.Tlmnj(l, m, n - 2, j + 1, r, T000);
        }
        return r[2] * MultipoleTensorRecursion.Tlmnj(l, m, 0, j + 1, r, T000);
    }

    public MultipoleTensorRecursion(int order) {
        if (order == 0) {
            logger.warning("The tensor recursion requires order > 0");
            this.work = null;
            this.t000j_Constants = null;
            this.o1 = 0;
            this.il = 0;
            this.im = 0;
            this.in = 0;
            this.order = order;
            return;
        }
        this.il = this.o1 = order + 1;
        this.im = this.il * this.o1;
        this.in = this.im * this.o1;
        this.work = new double[this.in * this.o1];
        this.t000j_Constants = new double[this.o1];
        for (int j = 0; j <= order; ++j) {
            this.t000j_Constants[j] = Math.pow(-1.0, j) * (double)VectorMath.doublefactorial(2 * j - 1);
        }
        this.order = order;
    }

    public void noStorageTensorRecursion(double[] r, double[] tensor) {
        if (tensor == null) {
            return;
        }
        if (T000 == null) {
            T000 = new double[this.order + 1];
        }
        double rr = 1.0 / VectorMath.r(r);
        double rr2 = rr * rr;
        for (int j = 0; j <= this.order; ++j) {
            MultipoleTensorRecursion.T000[j] = this.t000j_Constants[j] * rr;
            rr *= rr2;
        }
        tensor[0] = T000[0];
        if (this.order == 0) {
            return;
        }
        int index = 1;
        for (int l = 1; l <= this.order; ++l) {
            tensor[index++] = MultipoleTensorRecursion.Tlmnj(l, 0, 0, 0, r, T000);
        }
        for (int m = 1; m <= this.order; ++m) {
            int ldone = this.order - m;
            for (int l = 0; l <= ldone; ++l) {
                tensor[index++] = MultipoleTensorRecursion.Tlmnj(l, m, 0, 0, r, T000);
            }
        }
        for (int n = 1; n <= this.order; ++n) {
            int mdone = this.order - n;
            for (int m = 0; m <= mdone; ++m) {
                int ldone = this.order - m - n;
                for (int l = 0; l <= ldone; ++l) {
                    tensor[index++] = MultipoleTensorRecursion.Tlmnj(l, m, n, 0, r, T000);
                }
            }
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "No Storage Tensor Recursion (order: " + this.order + ")");
            logger.log(Level.FINEST, String.format("|r|: %9.6f, {%9.6f,%9.6f,%9.6f}", VectorMath.r(r), r[0], r[1], r[2]));
            double sum = 0.0;
            for (int i = 0; i < tensor.length; ++i) {
                sum += tensor[i];
            }
            logger.log(Level.FINEST, String.format("No Storage Tensor Sum: %18.16E", sum));
            System.out.println(String.format("No Storage Tensor Sum: %18.16E", sum));
        }
    }

    public void tensorRecursion(double[] r, double[] tensor) {
        int m;
        int a;
        int iw;
        double current;
        int l;
        double x = r[0];
        double y = r[1];
        double z = r[2];
        double rr2 = 1.0 / (x * x + y * y + z * z);
        double rr = Math.sqrt(rr2);
        for (int j = 0; j < this.o1; ++j) {
            this.work[j] = this.t000j_Constants[j] * rr;
            rr *= rr2;
        }
        tensor[0] = this.work[0];
        int index = 1;
        double previous = this.work[1];
        tensor[index++] = x * previous;
        for (l = 2; l < this.o1; ++l) {
            current = x * this.work[l];
            iw = this.il + l - 1;
            this.work[iw] = current;
            for (a = 1; a < l - 1; ++a) {
                current = x * current + (double)a * this.work[iw - this.il];
                this.work[iw += this.il - 1] = current;
            }
            tensor[index++] = x * current + (double)(l - 1) * previous;
            previous = current;
        }
        for (l = 0; l < this.order; ++l) {
            previous = this.work[l * this.il + 1];
            tensor[index++] = y * previous;
            m = 2;
            while (m + l < this.o1) {
                iw = l * this.il + m;
                current = y * this.work[iw];
                this.work[iw += this.im - 1] = current;
                for (a = 1; a < m - 1; ++a) {
                    current = y * current + (double)a * this.work[iw - this.im];
                    this.work[iw += this.im - 1] = current;
                }
                tensor[index++] = y * current + (double)(m - 1) * previous;
                previous = current;
                ++m;
            }
        }
        for (l = 0; l < this.order; ++l) {
            m = 0;
            while (m + l < this.order) {
                int lm = m + l;
                int lilmim = l * this.il + m * this.im;
                previous = this.work[lilmim + 1];
                tensor[index++] = z * previous;
                int n = 2;
                while (lm + n < this.o1) {
                    int iw2 = lilmim + n;
                    current = z * this.work[iw2];
                    this.work[iw2 += this.in - 1] = current;
                    int n1 = n - 1;
                    for (a = 1; a < n1; ++a) {
                        current = z * current + (double)a * this.work[iw2 - this.in];
                        this.work[iw2 += this.in - 1] = current;
                    }
                    tensor[index++] = z * current + (double)n1 * previous;
                    previous = current;
                    ++n;
                }
                ++m;
            }
        }
    }
}

