/*
 * Decompiled with CFR 0.152.
 */
package ffe.lang;

import ffe.lang.Atom;
import ffe.lang.Bond;
import ffe.lang.MSGroup;
import ffe.lang.MSNode;
import ffe.lang.Molecule;
import ffe.lang.Polymer;
import ffe.lang.ROLS;
import ffe.lang.RendererCache;
import ffe.lang.Residue;
import ffe.lang.Utilities;
import ffe.lang.VectorMath;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import java.util.logging.Logger;
import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.BoundingSphere;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.ColoringAttributes;
import org.jogamp.java3d.Geometry;
import org.jogamp.java3d.LineArray;
import org.jogamp.java3d.LineAttributes;
import org.jogamp.java3d.Material;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.RenderingAttributes;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.Switch;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Matrix3d;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Tuple3d;
import org.jogamp.vecmath.Vector3d;

public class MolecularAssembly
extends MSGroup {
    private static final long serialVersionUID = 1L;
    private Logger logger = Logger.getLogger("ffe");
    public static final int MultiScaleLevel = 4;
    public static final double KCAL_TO_KJ = 4.184;
    private static double[] a = new double[3];
    private File file;
    private Vector3d offset;
    private Utilities.FileType fileType;
    private int cycles = 1;
    private int currentCycle = 1;
    private Vector<String> altLoc = null;
    private MSNode ions = new MSNode("Ions");
    private MSNode water = new MSNode("Water");
    private MSNode molecules = new MSNode("Hetero Molecules");
    private Vector3d box = new Vector3d();
    private Vector3d angle = new Vector3d();
    private BranchGroup branchGroup;
    private TransformGroup originToRot;
    private Transform3D originToRotT3D;
    private Vector3d originToRotV3D;
    private TransformGroup rotToCOM;
    private Transform3D rotToCOMT3D;
    private Vector3d rotToCOMV3D;
    private BranchGroup base;
    private Switch switchGroup;
    private Shape3D wire;
    private BranchGroup childNodes;
    private Atom[] atomLookUp;
    private LineAttributes lineAttributes;
    private boolean visible = false;
    private ArrayList<ROLS> bondList = null;
    private ArrayList<Atom> atomList = null;
    private final ArrayList<BranchGroup> myNewShapes = new ArrayList();

    public MolecularAssembly(String name, boolean bk) {
        super(name, bk);
        this.getAtomNode().setName("MacroMolecules");
        this.add(this.molecules);
        this.add(this.ions);
        this.add(this.water);
    }

    public MolecularAssembly(String name, MSNode Polymers, boolean bk) {
        super(name, Polymers, bk);
    }

    public void addAltLocation(String s) {
        if (this.altLoc == null) {
            this.altLoc = new Vector();
        }
        if (!this.altLoc.contains(s)) {
            this.altLoc.add(s);
        }
    }

    @Override
    public void addMSNode(MSNode o) {
        ArrayList Polymers = this.getAtomNodeList();
        if (o instanceof Atom) {
            Atom atom = (Atom)o;
            Residue res = this.getResidue(atom.getChain(), atom.getResidueNumber(), atom.getResidueName(), true);
            if (res == null) {
                this.logger.warning("Atom with no home");
                return;
            }
            res.addMSNode(atom);
        } else if (o instanceof Residue) {
            Residue g = (Residue)o;
            String key = g.getPolymer();
            int index = Polymers.indexOf(new Polymer(key, this.getBondsKnown()));
            if (index != -1) {
                Polymer c = (Polymer)Polymers.get(index);
                c.addMSNode(g);
                this.setFinalized(false);
            } else {
                Polymer newc = new Polymer(key, this.getBondsKnown());
                newc.addMSNode(g);
                this.getAtomNode().add(newc);
                this.setFinalized(false);
            }
        } else if (o instanceof Polymer) {
            Polymer c = (Polymer)o;
            int index = Polymers.indexOf(c);
            if (index == -1) {
                this.getAtomNode().add(c);
                this.setFinalized(false);
            }
        } else if (o instanceof Molecule) {
            Molecule m = (Molecule)o;
            if (m.getAtomNode().getChildCount() == 1) {
                this.ions.add(m);
            } else if (Utilities.isWaterOxygen((Atom)m.getAtomNode().getChildAt(0))) {
                this.water.add(m);
            } else {
                this.molecules.add(m);
            }
        }
    }

    public void center() {
        double[] center = this.getMultiScaleCenter(false);
        this.offset = new Vector3d(center);
        this.offset.negate();
        this.originToRotV3D.set((Tuple3d)this.offset);
        this.originToRotT3D.setTranslation(this.originToRotV3D);
        this.originToRot.setTransform(this.originToRotT3D);
        this.rotToCOMT3D.setIdentity();
        this.rotToCOM.setTransform(this.rotToCOMT3D);
        this.offset.negate();
        this.rotateAbout(this.offset);
        this.originToRotT3D.get(this.offset);
    }

    public void centerAt(double[] d) {
        double[] Rc = new double[]{0.0, 0.0, 0.0};
        double[] c = new double[3];
        int num = this.getAtomList().size();
        ListIterator<Atom> li = this.getAtomList().listIterator();
        while (li.hasNext()) {
            li.next().getXYZ(a);
            Rc[0] = Rc[0] + a[0];
            Rc[1] = Rc[1] + a[1];
            Rc[2] = Rc[2] + a[2];
        }
        int i = 0;
        while (i < 3) {
            int n = i++;
            Rc[n] = Rc[n] / (double)num;
        }
        VectorMath.diff(d, Rc, c);
        li = this.getAtomList().listIterator();
        while (li.hasNext()) {
            li.next().move(c);
        }
    }

    public void centerView(boolean rot, boolean trans) {
        this.originToRot.getTransform(this.originToRotT3D);
        if (rot) {
            Matrix3d m3d = new Matrix3d();
            m3d.setIdentity();
            this.originToRotT3D.setRotation(m3d);
        }
        if (trans) {
            this.originToRotV3D.set((Tuple3d)this.offset);
            this.originToRotT3D.set(this.originToRotV3D);
        }
        this.originToRot.setTransform(this.originToRotT3D);
    }

    public void createBox() {
        int vertices = 8;
        LineArray la = new LineArray(4 * vertices, 15);
        la.setCapability(1);
        la.setCapability(0);
        la.setCapability(3);
        la.setCapability(8);
        la.setCapability(18);
        la.setCapability(17);
        ColoringAttributes cola = new ColoringAttributes(new Color3f(), 3);
        Appearance app = new Appearance();
        this.lineAttributes = new LineAttributes();
        this.lineAttributes.setLineWidth((float)RendererCache.bondwidth);
        this.lineAttributes.setCapability(1);
        this.lineAttributes.setLineAntialiasingEnable(true);
        app.setLineAttributes(this.lineAttributes);
        app.setCapability(16);
        app.setCapability(17);
        RenderingAttributes ra = new RenderingAttributes();
        ra.setAlphaTestValue(0.1f);
        ra.setAlphaTestFunction(6);
        ra.setDepthBufferEnable(true);
        ra.setDepthBufferWriteEnable(true);
        app.setRenderingAttributes(ra);
        app.setColoringAttributes(cola);
        Shape3D wireframe = new Shape3D((Geometry)la, app);
        wireframe.setUserData((Object)this);
        wireframe.setBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 10.0));
        try {
            wireframe.setBoundsAutoCompute(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        wireframe.setCapability(12);
        wireframe.setCapability(14);
    }

    public BranchGroup createScene(boolean zero) {
        this.originToRotT3D = new Transform3D();
        this.originToRotV3D = new Vector3d();
        this.originToRot = new TransformGroup(this.originToRotT3D);
        this.branchGroup = new BranchGroup();
        this.rotToCOM = new TransformGroup();
        this.rotToCOMT3D = new Transform3D();
        this.rotToCOMV3D = new Vector3d();
        this.branchGroup.setCapability(17);
        this.originToRot.setCapability(18);
        this.originToRot.setCapability(17);
        this.originToRot.setCapability(1);
        this.rotToCOM.setCapability(17);
        this.rotToCOM.setCapability(18);
        if (zero) {
            this.originToRotV3D.set(0.0, 0.0, 0.0);
            this.originToRotT3D.set(this.originToRotV3D);
            this.originToRot.setTransform(this.originToRotT3D);
        }
        this.wire = this.renderWire();
        this.switchGroup = new Switch(-1);
        this.switchGroup.setCapability(18);
        this.base = new BranchGroup();
        this.base.setCapability(14);
        this.base.setCapability(13);
        this.childNodes = new BranchGroup();
        this.childNodes.setCapability(17);
        this.childNodes.setCapability(14);
        this.childNodes.setCapability(13);
        this.switchGroup.addChild((Node)this.base);
        if (this.wire != null) {
            this.base.addChild((Node)this.wire);
        }
        this.switchGroup.setWhichChild(-2);
        this.rotToCOM.addChild((Node)this.switchGroup);
        this.originToRot.addChild((Node)this.rotToCOM);
        this.branchGroup.addChild((Node)this.originToRot);
        this.branchGroup.compile();
        return this.branchGroup;
    }

    @Override
    public boolean destroy() {
        this.detach();
        return super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach() {
        MolecularAssembly molecularAssembly = this;
        synchronized (molecularAssembly) {
            if (this.branchGroup != null && this.branchGroup.isLive()) {
                this.branchGroup.detach();
            }
        }
    }

    @Override
    public void finalize(boolean finalizeGroups) {
        this.setFinalized(false);
        if (finalizeGroups) {
            Molecule molecule;
            ArrayList Polymers = this.getAtomNodeList();
            ListIterator li = Polymers.listIterator();
            while (li.hasNext()) {
                MSGroup group = (MSGroup)li.next();
                group.finalize(true);
            }
            for (MSNode m : this.molecules.getChildList()) {
                molecule = (Molecule)m;
                molecule.finalize(true);
            }
            for (MSNode m : this.water.getChildList()) {
                molecule = (Molecule)m;
                molecule.finalize(true);
            }
            for (MSNode m : this.ions.getChildList()) {
                molecule = (Molecule)m;
                molecule.finalize(true);
            }
        }
        this.createScene(!finalizeGroups);
        this.center();
        this.removeLeaves();
        this.setFinalized(true);
    }

    public String[] getAltLocations() {
        if (this.altLoc == null || this.altLoc.size() == 0) {
            return null;
        }
        String[] names = new String[this.altLoc.size()];
        int i = 0;
        for (String s : this.altLoc) {
            names[i++] = s;
        }
        return names;
    }

    public Atom getAtomFromWireVertex(int i) {
        if (this.atomLookUp != null && this.atomLookUp.length > i) {
            return this.atomLookUp[i];
        }
        return null;
    }

    @Override
    public ArrayList<Atom> getAtomList() {
        if (this.atomList != null) {
            return this.atomList;
        }
        this.atomList = super.getAtomList();
        return this.atomList;
    }

    public ArrayList<Atom> getBackBoneAtoms() {
        ArrayList<Atom> backbone = new ArrayList<Atom>();
        Atom ca = new Atom("CA");
        ArrayList<ROLS> atoms = this.getList(Atom.class, new ArrayList<ROLS>());
        for (ROLS m : atoms) {
            Atom atom = (Atom)m;
            if (!atom.equals(ca)) continue;
            backbone.add(atom);
        }
        return backbone;
    }

    @Override
    public ArrayList<ROLS> getBondList() {
        if (this.bondList != null) {
            return this.bondList;
        }
        this.bondList = super.getBondList();
        return this.bondList;
    }

    public BranchGroup getBranchGroup() {
        return this.branchGroup;
    }

    public String[] getChainNames() {
        ArrayList<String> temp = new ArrayList<String>();
        ListIterator li = this.getAtomNodeList().listIterator();
        while (li.hasNext()) {
            MSNode node = (MSNode)li.next();
            if (!(node instanceof Polymer)) continue;
            temp.add(((Polymer)node).getName());
        }
        if (temp.size() == 0) {
            return null;
        }
        String[] names = new String[temp.size()];
        for (int i = 0; i < temp.size(); ++i) {
            names[i] = (String)temp.get(i);
        }
        return names;
    }

    public int getCurrentCycle() {
        return this.currentCycle;
    }

    public int getCycles() {
        return this.cycles;
    }

    @Override
    public double getExtent() {
        double[] Rc = new double[]{0.0, 0.0, 0.0};
        int num = this.getAtomList().size();
        ListIterator<Atom> li = this.getAtomList().listIterator();
        while (li.hasNext()) {
            li.next().getXYZ(a);
            Rc[0] = Rc[0] + a[0];
            Rc[1] = Rc[1] + a[1];
            Rc[2] = Rc[2] + a[2];
        }
        int i = 0;
        while (i < 3) {
            int n = i++;
            Rc[n] = Rc[n] / (double)num;
        }
        double d = 0.0;
        double[] xyz = new double[3];
        ListIterator<Atom> li2 = this.getAtomList().listIterator();
        while (li2.hasNext()) {
            li2.next().getXYZ(xyz);
            VectorMath.diff(xyz, Rc, xyz);
            double r = VectorMath.r(xyz);
            if (!(d < r)) continue;
            d = r;
        }
        return d;
    }

    public File getFile() {
        return this.file;
    }

    public Utilities.FileType getFileType() {
        return this.fileType;
    }

    public Vector3d getOffset() {
        return this.offset;
    }

    public TransformGroup getOriginToRot() {
        return this.originToRot;
    }

    public Polymer getPolymer(String chainName, boolean create) {
        ListIterator li = this.getAtomNodeList().listIterator();
        while (li.hasNext()) {
            MSNode node = (MSNode)li.next();
            if (!(node instanceof Polymer) || !node.getName().equals(chainName)) continue;
            return (Polymer)node;
        }
        if (create) {
            Polymer polymer = new Polymer(chainName, false, true);
            this.addMSNode(polymer);
            return polymer;
        }
        return null;
    }

    private Residue getResidue(String chainName, int resNum, String resName, boolean create) {
        Polymer polymer = this.getPolymer(chainName, create);
        if (polymer == null) {
            return null;
        }
        return polymer.getResidue(resName, resNum, create);
    }

    public ArrayList<Residue> getResidueList() {
        ArrayList<Residue> residues = new ArrayList<Residue>();
        ListIterator li = this.getAtomNodeList().listIterator();
        while (li.hasNext()) {
            MSNode o = (MSNode)li.next();
            if (!(o instanceof Polymer)) continue;
            Polymer c = (Polymer)o;
            ListIterator lj = c.getAtomNodeList().listIterator();
            while (lj.hasNext()) {
                o = (MSNode)lj.next();
                if (!(o instanceof Residue)) continue;
                residues.add((Residue)o);
            }
        }
        return residues;
    }

    public TransformGroup getTransformGroup() {
        return this.originToRot;
    }

    public Node getWireFrame() {
        return this.wire;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void moveCenter(double[] d) {
        ListIterator<Atom> li = this.getAtomList().listIterator();
        while (li.hasNext()) {
            li.next().move(d);
        }
    }

    @Override
    protected void removeLeaves() {
        super.removeLeaves();
        MSNode macroNode = this.getAtomNode();
        if (macroNode != null && macroNode.getChildCount() > 0) {
            this.getAtomNode().setName("Macromolecules (" + macroNode.getChildCount() + ")");
        } else {
            this.remove(macroNode);
        }
        if (this.molecules.getChildCount() == 0) {
            this.remove(this.molecules);
        } else {
            this.molecules.setName("Hetero Molecules (" + this.molecules.getChildCount() + ")");
        }
        if (this.ions.getChildCount() == 0) {
            this.remove(this.ions);
        } else {
            this.ions.setName("Ions (" + this.ions.getChildCount() + ")");
        }
        if (this.water.getChildCount() == 0) {
            this.remove(this.water);
        } else {
            this.water.setName("Water (" + this.water.getChildCount() + ")");
        }
    }

    private Shape3D renderWire() {
        ArrayList<ROLS> bonds = this.getBondList();
        int numbonds = bonds.size();
        if (numbonds < 1) {
            return null;
        }
        Vector3d bondmidpoint = new Vector3d();
        double[] mid = new double[]{0.0, 0.0, 0.0};
        Vector3d v1 = new Vector3d();
        Vector3d v2 = new Vector3d();
        float[] a1 = new float[]{0.0f, 0.0f, 0.0f};
        float[] a2 = new float[]{0.0f, 0.0f, 0.0f};
        float[] col = new float[4];
        LineArray la = new LineArray(4 * numbonds, 15);
        la.setCapability(1);
        la.setCapability(0);
        la.setCapability(3);
        la.setCapability(8);
        la.setCapability(18);
        la.setCapability(17);
        this.atomLookUp = new Atom[4 * numbonds];
        int i = 0;
        col[3] = 0.9f;
        ListIterator<ROLS> li = this.bondList.listIterator();
        while (li.hasNext()) {
            Bond bond = (Bond)li.next();
            bond.setWire(la, i);
            Atom atom1 = bond.getAtom(0);
            Atom atom2 = bond.getAtom(1);
            atom1.getV3D(v1);
            atom2.getV3D(v2);
            a1[0] = (float)v1.x;
            a1[1] = (float)v1.y;
            a1[2] = (float)v1.z;
            a2[0] = (float)v2.x;
            a2[1] = (float)v2.y;
            a2[2] = (float)v2.z;
            bondmidpoint.add((Tuple3d)v1, (Tuple3d)v2);
            bondmidpoint.scale(0.5);
            bondmidpoint.get(mid);
            Atom.AtomColor.get(atom1.getAtomicNumber()).get(col);
            this.atomLookUp[i] = atom1;
            la.setCoordinate(i, a1);
            la.setColor(i, col);
            la.setNormal(i, a2);
            this.atomLookUp[++i] = atom1;
            la.setCoordinate(i, mid);
            la.setColor(i, col);
            la.setNormal(i, a2);
            Atom.AtomColor.get(atom2.getAtomicNumber()).get(col);
            this.atomLookUp[++i] = atom2;
            la.setCoordinate(i, a2);
            la.setColor(i, col);
            la.setNormal(i, a1);
            this.atomLookUp[++i] = atom2;
            la.setCoordinate(i, mid);
            la.setColor(i, col);
            la.setNormal(i, a1);
            ++i;
        }
        ColoringAttributes cola = new ColoringAttributes(new Color3f(), 3);
        Appearance app = new Appearance();
        this.lineAttributes = new LineAttributes();
        this.lineAttributes.setLineWidth((float)RendererCache.bondwidth);
        this.lineAttributes.setCapability(1);
        this.lineAttributes.setLineAntialiasingEnable(true);
        app.setLineAttributes(this.lineAttributes);
        app.setCapability(16);
        app.setCapability(17);
        RenderingAttributes ra = new RenderingAttributes();
        ra.setAlphaTestValue(0.1f);
        ra.setAlphaTestFunction(6);
        ra.setDepthBufferEnable(true);
        ra.setDepthBufferWriteEnable(true);
        app.setRenderingAttributes(ra);
        app.setColoringAttributes(cola);
        Shape3D wireframe = new Shape3D((Geometry)la, app);
        wireframe.setUserData((Object)this);
        wireframe.setBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000.0));
        try {
            wireframe.setBoundsAutoCompute(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        wireframe.setCapability(12);
        wireframe.setCapability(14);
        wireframe.setCapability(11);
        return wireframe;
    }

    public void rotateAbout(Vector3d v) {
        Vector3d newRotPoint = new Vector3d(v);
        this.originToRot.getTransform(this.originToRotT3D);
        this.originToRotT3D.get(this.originToRotV3D);
        this.originToRotT3D.setTranslation(new Vector3d(0.0, 0.0, 0.0));
        this.rotToCOM.getTransform(this.rotToCOMT3D);
        this.rotToCOMT3D.get(this.rotToCOMV3D);
        newRotPoint.add((Tuple3d)this.rotToCOMV3D);
        this.originToRotT3D.transform(newRotPoint);
        newRotPoint.add((Tuple3d)this.originToRotV3D);
        this.originToRotT3D.setTranslation(newRotPoint);
        this.rotToCOMV3D.set((Tuple3d)v);
        this.rotToCOMV3D.negate();
        this.rotToCOMT3D.setTranslation(this.rotToCOMV3D);
        this.originToRot.setTransform(this.originToRotT3D);
        this.rotToCOM.setTransform(this.rotToCOMT3D);
    }

    public void sceneGraphChange(List<BranchGroup> newShapes) {
        if (newShapes == null) {
            newShapes = this.myNewShapes;
        }
        if (newShapes.isEmpty()) {
            return;
        }
        boolean reCompile = false;
        ListIterator<BranchGroup> li = newShapes.listIterator();
        while (li.hasNext()) {
            BranchGroup group = li.next();
            li.remove();
            if (group.getUserData() != null) {
                this.logger.info(String.valueOf(group) + " " + String.valueOf(group.getUserData()));
                continue;
            }
            group.setUserData((Object)this);
            if (!reCompile) {
                if (this.childNodes.isLive()) {
                    this.childNodes.detach();
                }
                reCompile = true;
            }
            this.childNodes.addChild((Node)group);
        }
        if (reCompile) {
            this.childNodes.compile();
            this.base.addChild((Node)this.childNodes);
        }
    }

    public void setAngle(double[] a) {
        if (a == null) {
            return;
        }
        if (this.angle == null) {
            this.angle = new Vector3d();
        }
        this.angle.set(a);
    }

    public void setBox(double[] b) {
        if (b == null) {
            return;
        }
        if (this.box == null) {
            this.box = new Vector3d();
        }
        this.box.set(b);
    }

    @Override
    public void setColor(RendererCache.ColorModel newColorModel, Color3f color, Material mat) {
        ListIterator li = this.getAtomNodeList().listIterator();
        while (li.hasNext()) {
            MSGroup group = (MSGroup)li.next();
            group.setColor(newColorModel, color, mat);
        }
        for (MSNode m : this.molecules.getChildList()) {
            m.setColor(newColorModel, color, mat);
        }
        for (MSNode m : this.water.getChildList()) {
            m.setColor(newColorModel, color, mat);
        }
        for (MSNode m : this.ions.getChildList()) {
            m.setColor(newColorModel, color, mat);
        }
    }

    public void setCurrentCycle(int c) {
        if (c <= this.cycles && c > 0) {
            this.currentCycle = c;
            ListIterator<Atom> li = this.getAtomList().listIterator();
            while (li.hasNext()) {
                li.next().setCurrentCycle(this.currentCycle);
            }
        }
    }

    public void setCycles(int c) {
        this.cycles = c;
    }

    public void setFile(File f) {
        if (f == null) {
            return;
        }
        this.file = f;
    }

    public void setFileType(Utilities.FileType fileType) {
        this.fileType = fileType;
    }

    public void setOffset(Vector3d o) {
        this.offset = o;
    }

    @Override
    public void setView(RendererCache.ViewModel newViewModel, List<BranchGroup> newShapes) {
        if (newViewModel == RendererCache.ViewModel.DESTROY) {
            this.switchGroup.setWhichChild(-1);
            this.visible = false;
        } else {
            this.setWireWidth(RendererCache.bondwidth);
            if (newViewModel == RendererCache.ViewModel.DETAIL && this.childNodes.isLive()) {
                this.childNodes.detach();
            }
            super.setView(newViewModel, this.myNewShapes);
            ArrayList<ROLS> moleculeList = this.getList(Molecule.class, new ArrayList<ROLS>());
            for (ROLS rOLS : moleculeList) {
                rOLS.setView(newViewModel, this.myNewShapes);
            }
            for (MSNode mSNode : this.molecules.getChildList()) {
                mSNode.setView(newViewModel, this.myNewShapes);
            }
            for (MSNode mSNode : this.water.getChildList()) {
                mSNode.setView(newViewModel, this.myNewShapes);
            }
            for (MSNode mSNode : this.ions.getChildList()) {
                mSNode.setView(newViewModel, this.myNewShapes);
            }
            if (newViewModel == RendererCache.ViewModel.INVISIBLE) {
                this.switchGroup.setWhichChild(0);
            }
            if (newViewModel == RendererCache.ViewModel.DETAIL) {
                this.childNodes.compile();
                this.base.addChild((Node)this.childNodes);
            }
        }
    }

    public void setWireWidth(float f) {
        if (this.wire == null) {
            return;
        }
        this.lineAttributes.setLineWidth(f);
    }

    public void sidePolymerCOM() {
        ArrayList<Residue> residues = this.getResidueList();
        ListIterator<Residue> li = residues.listIterator();
        while (li.hasNext()) {
            Residue r = li.next();
            r.printSideChainCOM();
        }
    }
}

