/*
 * Decompiled with CFR 0.152.
 */
package ffe.lang;

import ffe.lang.Atom;
import ffe.lang.Bond;
import ffe.lang.HashCodeUtil;
import ffe.lang.ROLS;
import ffe.lang.RendererCache;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.J3DGraphics2D;
import org.jogamp.java3d.Material;
import org.jogamp.java3d.Node;
import org.jogamp.vecmath.Color3f;

public class MSNode
extends DefaultMutableTreeNode
implements ROLS {
    private static final long serialVersionUID = 1L;
    public static boolean UNIT_TESTING = false;
    public final int MultiScaleLevel;
    private String name;
    protected boolean selected = false;

    public MSNode() {
        this.name = null;
        this.MultiScaleLevel = 5;
    }

    public MSNode(String n) {
        this.name = n;
        this.MultiScaleLevel = 5;
    }

    public MSNode(String n, int multiScaleLevel) {
        this.name = n;
        this.MultiScaleLevel = multiScaleLevel;
    }

    public boolean canBeChild(Class c) {
        try {
            int multiScaleLevel = c.getDeclaredField("MultiScaleLevel").getInt(null);
            if (multiScaleLevel >= this.MultiScaleLevel) {
                return false;
            }
        }
        catch (Exception e) {
            return true;
        }
        return true;
    }

    public boolean destroy() {
        if (this.getParent() != null) {
            this.removeFromParent();
        }
        this.name = null;
        this.selected = false;
        return true;
    }

    @Override
    public void drawLabel(Canvas3D graphics, J3DGraphics2D g2d, Node node) {
        if (!this.isSelected()) {
            return;
        }
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            MSNode dataNode = (MSNode)e.nextElement();
            dataNode.drawLabel(graphics, g2d, node);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MSNode other = (MSNode)object;
        return this.name == other.getName();
    }

    public ArrayList<Atom> getAtomList() {
        ArrayList<Atom> arrayList = new ArrayList<Atom>();
        Enumeration<TreeNode> e = this.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            MSNode dataNode = (MSNode)e.nextElement();
            if (!(dataNode instanceof Atom)) continue;
            arrayList.add((Atom)dataNode);
        }
        return arrayList;
    }

    public ArrayList<ROLS> getBondList() {
        ArrayList<ROLS> arrayList = new ArrayList<ROLS>();
        return this.getList(Bond.class, arrayList);
    }

    @Override
    public double[] getCenter(boolean w) {
        double[] Rc = new double[]{0.0, 0.0, 0.0};
        double sum = 0.0;
        double mass = 1.0;
        ArrayList<Atom> atomList = this.getAtomList();
        for (Atom a : atomList) {
            if (w) {
                mass = a.getMass();
                sum += mass;
            }
            Rc[0] = Rc[0] + mass * a.getX();
            Rc[1] = Rc[1] + mass * a.getY();
            Rc[2] = Rc[2] + mass * a.getZ();
        }
        if (!w) {
            sum = atomList.size();
        }
        int i = 0;
        while (i < 3) {
            int n = i++;
            Rc[n] = Rc[n] / sum;
        }
        return Rc;
    }

    public ArrayList<MSNode> getChildList() {
        ArrayList<MSNode> l = new ArrayList<MSNode>();
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            l.add((MSNode)e.nextElement());
        }
        return l;
    }

    public ListIterator<MSNode> getChildListIterator() {
        return this.getChildList().listIterator();
    }

    public double getExtent() {
        double extent = 0.0;
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            MSNode node = (MSNode)e.nextElement();
            double temp = node.getExtent();
            if (!(temp > extent)) continue;
            extent = temp;
        }
        return extent;
    }

    @Override
    public ArrayList<ROLS> getList(Class c, ArrayList<ROLS> nodes) {
        if (c.isInstance(this)) {
            nodes.add(this);
        }
        if (this.isLeaf() || !this.canBeChild(c)) {
            return nodes;
        }
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            ROLS node = (ROLS)((Object)e.nextElement());
            node.getList(c, nodes);
        }
        return nodes;
    }

    @Override
    public long getMSCount(Class c, long count) {
        if (c.isInstance(this)) {
            ++count;
        }
        if (!this.canBeChild(c)) {
            return count;
        }
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            MSNode node = (MSNode)e.nextElement();
            count += node.getMSCount(c, count);
        }
        return count;
    }

    @Override
    public ROLS getMSNode(Class c) {
        TreeNode[] nodes;
        for (TreeNode n : nodes = this.getPath()) {
            if (!c.isInstance(n)) continue;
            ROLS msm = (ROLS)((Object)n);
            return msm;
        }
        return null;
    }

    public int getMultiScaleLevel() {
        return this.MultiScaleLevel;
    }

    @Override
    public double getMW() {
        double weight = 0.0;
        ListIterator<Atom> li = this.getAtomList().listIterator();
        while (li.hasNext()) {
            weight += li.next().getMass();
        }
        return weight;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return HashCodeUtil.hash(2024, this.name.hashCode());
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void print() {
        System.out.println(this.name);
    }

    @Override
    public void setColor(RendererCache.ColorModel colorModel, Color3f color, Material mat) {
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            MSNode node = (MSNode)e.nextElement();
            node.setColor(colorModel, color, mat);
        }
    }

    public void setName(String n) {
        this.name = n;
    }

    public void setSelected(boolean b) {
        this.selected = b;
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            MSNode node = (MSNode)e.nextElement();
            node.setSelected(b);
        }
    }

    @Override
    public void setView(RendererCache.ViewModel viewModel, List<BranchGroup> newShapes) {
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            MSNode node = (MSNode)e.nextElement();
            node.setView(viewModel, newShapes);
        }
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public void update() {
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            MSNode node = (MSNode)e.nextElement();
            node.update();
        }
    }

    static {
        try {
            boolean b;
            UNIT_TESTING = b = Boolean.parseBoolean(System.getProperty("ffe.junit", "false"));
        }
        catch (Exception e) {
            UNIT_TESTING = false;
        }
    }
}

