/*
 * Decompiled with CFR 0.152.
 */
package ffe.lang;

import ffe.lang.Angle;
import ffe.lang.Atom;
import ffe.lang.Bond;
import ffe.lang.Dihedral;
import ffe.lang.Joint;
import ffe.lang.MSNode;
import ffe.lang.ROLS;
import ffe.lang.RendererCache;
import ffe.lang.VectorMath;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Material;
import org.jogamp.vecmath.Color3f;

public abstract class MSGroup
extends MSNode {
    private static double[] da = new double[3];
    private static double[] db = new double[3];
    private Logger logger = Logger.getLogger("ffe");
    private MSNode atomNode = new MSNode("Atoms");
    private MSNode termNode = new MSNode("Connectivity");
    private MSNode bondNode = new MSNode("Bonds");
    private MSNode angleNode = new MSNode("Angles");
    private MSNode dihedralNode = new MSNode("Dihedrals");
    private boolean bondsKnown = true;
    private boolean finalized = false;
    private double[] center;
    private ArrayList<Atom> dangelingatoms;

    public MSGroup() {
        super("", 2);
        this.termNode.add(this.bondNode);
        this.termNode.add(this.angleNode);
        this.termNode.add(this.dihedralNode);
        this.add(this.atomNode);
        this.add(this.termNode);
    }

    public MSGroup(String n, boolean bk) {
        this();
        this.setName(n);
        this.bondsKnown = bk;
    }

    public MSGroup(String n, MSNode node, boolean bk) {
        this(n, bk);
        this.atomNode = node;
        this.add(this.atomNode);
    }

    public abstract void addMSNode(MSNode var1);

    public void collectValenceTerms() {
        MSNode b = new MSNode("Bonds");
        MSNode a = new MSNode("Angles");
        MSNode d = new MSNode("Dihedrals");
        ArrayList<Bond> newBonds = new ArrayList<Bond>();
        for (Atom a1 : this.getAtomList()) {
            if (a1.getNumBonds() == 0) continue;
            for (Bond bond : a1.getBonds()) {
                if (!bond.sameGroup() || bond.getParent() != null) continue;
                b.add(bond);
                newBonds.add(bond);
            }
        }
        b.setName("Bonds (" + b.getChildCount() + ")");
        this.setBonds(b);
        ArrayList<Angle> angleAL = new ArrayList<Angle>();
        for (Atom a1 : this.getAtomList()) {
            int index = 0;
            if (a1.getBonds() == null) continue;
            for (Bond b1 : a1.getBonds()) {
                ListIterator<Bond> li = a1.getBonds().listIterator(++index);
                while (li.hasNext()) {
                    Bond b2 = li.next();
                    Angle an1 = new Angle(b1, b2);
                    a.insert(an1, 0);
                    angleAL.add(an1);
                }
            }
        }
        a.setName("Angles (" + a.getChildCount() + ")");
        this.setAngles(a);
        for (Bond b1 : newBonds) {
            Atom a1 = b1.getAtom(0);
            Atom a2 = b1.getAtom(1);
            ArrayList<Bond> a1Bonds = a1.getBonds();
            ArrayList<Bond> a2Bonds = a2.getBonds();
            if (a1Bonds == null || a2Bonds == null) continue;
            for (Bond b2 : a1.getBonds()) {
                if (b2 == b1) continue;
                for (Bond b3 : a2.getBonds()) {
                    if (b3 == b1) continue;
                    d.add(new Dihedral(b2, b1, b3));
                }
            }
        }
        d.setName("Dihedrals (" + d.getChildCount() + ")");
        this.setDihedrals(d);
    }

    public void constructValenceTerms() {
        MSNode b = new MSNode("Bonds");
        MSNode a = new MSNode("Angles");
        MSNode d = new MSNode("Dihedrals");
        int index = 0;
        ArrayList<Atom> atomList = this.getAtomList();
        for (Atom a1 : atomList) {
            ListIterator<Atom> li = atomList.listIterator(++index);
            while (li.hasNext()) {
                double d2;
                Atom a2 = li.next();
                a1.getXYZ(da);
                a2.getXYZ(db);
                double d1 = VectorMath.dist(da, db);
                if (!(d1 < (d2 = (double)0.7f + a1.getVDWR() / 2.0 + a2.getVDWR() / 2.0))) continue;
                ArrayList<Bond> adjunctBonds = new ArrayList<Bond>();
                if (a1.getNumBonds() > 0) {
                    adjunctBonds.addAll(a1.getBonds());
                }
                if (a2.getNumBonds() > 0) {
                    adjunctBonds.addAll(a2.getBonds());
                }
                Bond newbond = new Bond(a1, a2, 1);
                b.add(newbond);
                for (Bond adjunctBond : adjunctBonds) {
                    if (newbond == adjunctBond) {
                        this.logger.info("New Bond = Adjunct Bond");
                        continue;
                    }
                    Angle newangle = new Angle(newbond, adjunctBond);
                    a.add(newangle);
                    Atom atom13 = adjunctBond.getOtherAtom(newbond);
                    for (Bond bond14 : atom13.getBonds()) {
                        if (bond14 == adjunctBond) continue;
                        d.add(new Dihedral(newangle, bond14));
                    }
                }
            }
        }
        this.setBonds(b);
        this.setAngles(a);
        this.setDihedrals(d);
    }

    public Joint createJoint(Bond bond, MSGroup g1, MSGroup g2) {
        MSNode b = new MSNode("Bonds");
        MSNode a = new MSNode("Angles");
        MSNode d = new MSNode("Dihedrals");
        b.add(bond);
        b.setName("Bonds (" + b.getChildCount() + ")");
        ArrayList<Angle> angleAL = new ArrayList<Angle>();
        Atom a1 = bond.getAtom(0);
        for (ROLS rOLS : a1.getBonds()) {
            Bond bond2 = (Bond)rOLS;
            if (bond == bond2 || bond.getOtherAtom(bond2) == null) continue;
            Angle an1 = new Angle(bond, bond2);
            a.add(an1);
            angleAL.add(an1);
        }
        Atom a2 = bond.getAtom(1);
        for (ROLS rOLS : a2.getBonds()) {
            Bond b2 = (Bond)rOLS;
            if (bond == b2 || bond.getOtherAtom(b2) == null) continue;
            Angle an1 = new Angle(bond, b2);
            a.add(an1);
            angleAL.add(an1);
        }
        a.setName("Angles (" + a.getChildCount() + ")");
        Joint joint = new Joint(g1, g2, b, a, d);
        return joint;
    }

    public Joint createJoint(MSGroup m1, MSGroup m2) {
        Joint joint = null;
        for (Atom a1 : m1.getAtomList()) {
            a1.getXYZ(da);
            for (Atom a2 : m2.getAtomList()) {
                double d2;
                a2.getXYZ(db);
                double d1 = VectorMath.dist(da, db);
                if (!(d1 < (d2 = (double)0.7f + a1.getVDWR() / 2.0 + a2.getVDWR() / 2.0))) continue;
                Bond b = new Bond(a1, a2, 1);
                Joint newJoint = this.createJoint(b, m1, m2);
                if (joint != null) {
                    joint.merge(newJoint);
                    continue;
                }
                joint = newJoint;
            }
        }
        return joint;
    }

    public abstract void finalize(boolean var1);

    public void findDangelingAtoms() {
        ArrayList<Atom> d = new ArrayList<Atom>();
        for (Atom a : this.getAtomList()) {
            if (!a.isDangeling()) continue;
            d.add(a);
        }
        this.setDangelingAtoms(d);
    }

    public MSNode getAngles() {
        return this.angleNode;
    }

    public MSNode getAtomNode() {
        return this.atomNode;
    }

    public MSNode getAtomNode(int index) {
        return (MSNode)this.getAtomNodeList().get(index);
    }

    public MSNode getAtomNode(String n) {
        int i = this.getAtomNodeList().indexOf(new MSNode(n));
        if (i == -1) {
            return null;
        }
        return (MSNode)this.getAtomNodeList().get(i);
    }

    public ArrayList getAtomNodeList() {
        return this.atomNode.getChildList();
    }

    public Bond getBond(int index) {
        return (Bond)this.bondNode.getChildAt(index);
    }

    public Bond getBond(String id) {
        int i = this.bondNode.getIndex(new Bond(id));
        if (i == -1) {
            return null;
        }
        return (Bond)this.bondNode.getChildAt(i);
    }

    public MSNode getBonds() {
        return this.bondNode;
    }

    public boolean getBondsKnown() {
        return this.bondsKnown;
    }

    public double[] getCenter() {
        return this.center;
    }

    public ArrayList getDangelingAtoms() {
        return this.dangelingatoms;
    }

    public MSNode getDihedrals() {
        return this.dihedralNode;
    }

    public double[] getMultiScaleCenter(boolean w) {
        double[] Rc = new double[]{0.0, 0.0, 0.0};
        ArrayList<Atom> atoms = this.getAtomList();
        if (atoms == null) {
            return Rc;
        }
        double sum = 0.0;
        if (w) {
            for (Atom a : atoms) {
                double mass = a.getMass();
                Rc[0] = Rc[0] + mass * a.getX();
                Rc[1] = Rc[1] + mass * a.getY();
                Rc[2] = Rc[2] + mass * a.getZ();
                sum += mass;
            }
        } else {
            for (Atom a : atoms) {
                Rc[0] = Rc[0] + a.getX();
                Rc[1] = Rc[1] + a.getY();
                Rc[2] = Rc[2] + a.getZ();
            }
            sum = atoms.size();
        }
        Rc[0] = Rc[0] / sum;
        Rc[1] = Rc[1] / sum;
        Rc[2] = Rc[2] / sum;
        return Rc;
    }

    public MSNode getTerms() {
        return this.termNode;
    }

    public boolean isFinalized() {
        return this.finalized;
    }

    @Override
    public void print() {
        super.print();
        for (Atom a : this.atomNode.getAtomList()) {
            a.print();
        }
        for (ROLS m : this.bondNode.getBondList()) {
            Bond b = (Bond)m;
            b.print();
        }
    }

    protected void removeLeaves() {
        if (this.termNode.getParent() == null) {
            return;
        }
        if (this.bondNode.getChildCount() == 0 && this.bondNode.getParent() != null) {
            this.termNode.remove(this.bondNode);
        }
        if (this.angleNode.getChildCount() == 0 && this.angleNode.getParent() != null) {
            this.termNode.remove(this.angleNode);
        }
        if (this.dihedralNode.getChildCount() == 0 && this.dihedralNode.getParent() != null) {
            this.termNode.remove(this.dihedralNode);
        }
        if (this.termNode.getChildCount() == 0) {
            this.remove(this.termNode);
        }
    }

    public void setAngles(MSNode t) {
        this.termNode.remove(this.angleNode);
        this.angleNode = t;
        this.termNode.add(this.angleNode);
    }

    public void setAtomNode(MSNode t) {
        this.remove(this.atomNode);
        this.atomNode = t;
        this.add(this.atomNode);
    }

    public void setBonds(MSNode t) {
        this.termNode.remove(this.bondNode);
        this.bondNode.removeAllChildren();
        this.bondNode = t;
        this.termNode.add(this.bondNode);
    }

    public void setBondsKnown(boolean b) {
        this.bondsKnown = b;
    }

    public void setCenter(double[] d) {
        this.center = d;
    }

    @Override
    public void setColor(RendererCache.ColorModel newColorModel, Color3f color, Material mat) {
        if (newColorModel == RendererCache.ColorModel.MOLECULE && (color == null || mat == null)) {
            return;
        }
        this.atomNode.setColor(newColorModel, color, mat);
    }

    public void setDangelingAtoms(ArrayList<Atom> a) {
        this.dangelingatoms = a;
    }

    public void setDihedrals(MSNode t) {
        this.termNode.remove(this.dihedralNode);
        this.dihedralNode = t;
        this.termNode.add(this.dihedralNode);
    }

    public void setFinalized(boolean t) {
        this.finalized = t;
    }

    public void setTerms(MSNode t) {
        this.remove(this.termNode);
        this.termNode = t;
        this.add(this.termNode);
    }

    @Override
    public void setView(RendererCache.ViewModel newViewModel, List<BranchGroup> newShapes) {
        this.atomNode.setView(newViewModel, newShapes);
        this.bondNode.setView(newViewModel, newShapes);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public void update() {
        this.updateAtoms();
        this.updateBonds();
    }

    public void updateAtoms() {
        for (Atom a : this.getAtomList()) {
            a.update();
        }
    }

    public void updateBonds() {
        for (ROLS b : this.getBondList()) {
            b.update();
        }
    }
}

