/*
 * Decompiled with CFR 0.152.
 */
package ffe.lang;

import ffe.lang.Angle;
import ffe.lang.Bond;
import ffe.lang.Dihedral;
import ffe.lang.MSGroup;
import ffe.lang.MSNode;
import ffe.lang.RendererCache;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.jogamp.java3d.BranchGroup;

public class Joint
extends MSNode {
    private static final long serialVersionUID = 1L;
    public MSGroup m1;
    public MSGroup m2;

    public Joint() {
        super("Joint");
        this.m2 = null;
        this.m1 = null;
    }

    public Joint(MSGroup m1, MSGroup m2, MSNode b, MSNode a, MSNode d) {
        super(m1.toString() + "-" + m2.toString());
        this.m1 = m1;
        this.m2 = m2;
        if (b.getChildCount() != 0) {
            this.add(b);
        }
        if (a.getChildCount() != 0) {
            this.add(a);
        }
        if (d.getChildCount() != 0) {
            this.add(d);
        }
        this.refresh(null, null, null);
    }

    public MSNode getAngles() {
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            MSNode m = (MSNode)e.nextElement();
            TreeNode node = m.getChildAt(0);
            if (!(node instanceof Angle)) continue;
            return m;
        }
        return null;
    }

    public MSNode getBonds() {
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            MSNode m = (MSNode)e.nextElement();
            TreeNode node = m.getChildAt(0);
            if (!(node instanceof Bond)) continue;
            return m;
        }
        return null;
    }

    public MSNode getDihedrals() {
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            MSNode m = (MSNode)e.nextElement();
            TreeNode node = m.getChildAt(0);
            if (!(node instanceof Dihedral)) continue;
            return m;
        }
        return null;
    }

    public void merge(Joint j) {
        if (!(this.m1 == j.m1 && this.m2 == j.m2 || this.m2 == j.m1 && this.m1 == j.m2)) {
            return;
        }
        this.refresh(j.getBonds(), j.getAngles(), j.getDihedrals());
    }

    private void refresh(MSNode bonds, MSNode angles, MSNode dihedrals) {
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            Enumeration<TreeNode> e2;
            MSNode jointChild = (MSNode)e.nextElement();
            if (jointChild.getChildCount() == 0) {
                jointChild.removeFromParent();
                continue;
            }
            MSNode node = (MSNode)jointChild.getChildAt(0);
            if (node instanceof Bond) {
                jointChild.setName("Bonds (" + jointChild.getChildCount() + ")");
                if (bonds != null) {
                    e2 = bonds.children();
                    while (e2.hasMoreElements()) {
                        jointChild.add((MSNode)e2.nextElement());
                    }
                }
                bonds = null;
                continue;
            }
            if (node instanceof Angle) {
                jointChild.setName("Angles (" + jointChild.getChildCount() + ")");
                if (angles != null) {
                    e2 = angles.children();
                    while (e2.hasMoreElements()) {
                        jointChild.add((MSNode)e2.nextElement());
                    }
                }
                angles = null;
                continue;
            }
            if (!(node instanceof Dihedral)) continue;
            jointChild.setName("Dihedrals (" + jointChild.getChildCount() + ")");
            if (dihedrals != null) {
                e2 = dihedrals.children();
                while (e2.hasMoreElements()) {
                    jointChild.add((MSNode)e2.nextElement());
                }
            }
            dihedrals = null;
        }
        if (bonds != null) {
            this.add(bonds);
        }
        if (angles != null) {
            this.add(angles);
        }
        if (dihedrals != null) {
            this.add(dihedrals);
        }
    }

    public void setColor(RendererCache.ColorModel newColorModel) {
        MSNode bonds = this.getBonds();
        if (bonds == null) {
            return;
        }
        Enumeration<TreeNode> e = bonds.children();
        while (e.hasMoreElements()) {
            Bond b = (Bond)e.nextElement();
            b.setColor(b.getAtom(0));
            b.setColor(b.getAtom(1));
        }
    }

    @Override
    public void setView(RendererCache.ViewModel newViewModel, List<BranchGroup> newShapes) {
        MSNode bonds = this.getBonds();
        if (bonds == null) {
            return;
        }
        Enumeration<TreeNode> e = bonds.children();
        while (e.hasMoreElements()) {
            Bond b = (Bond)e.nextElement();
            b.setView(newViewModel, newShapes);
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

