/*
 * Decompiled with CFR 0.152.
 */
package ffe.lang;

import ffe.lang.Angle;
import ffe.lang.Atom;
import ffe.lang.Bond;
import ffe.lang.ValenceTerm;
import ffe.lang.ValenceType;
import java.util.Hashtable;
import java.util.ListIterator;
import org.jogamp.vecmath.Tuple3d;
import org.jogamp.vecmath.Vector3d;

public class Improper
extends ValenceTerm {
    private static final long serialVersionUID = 1L;
    private static Vector3d vi = new Vector3d();
    private static Vector3d vj = new Vector3d();
    private static Vector3d vk = new Vector3d();
    private static Vector3d vl = new Vector3d();
    private static Vector3d vij = new Vector3d();
    private static Vector3d vkj = new Vector3d();
    private static Vector3d vlk = new Vector3d();
    private static Vector3d dr = new Vector3d();
    private static Vector3d ds = new Vector3d();
    private static double dotij;
    private static double dotlk;
    private static double cosphi;
    private Angle an1;
    private Angle an2;

    public Improper(Angle a1, Angle a2, Hashtable mmdi) {
        this.an1 = a1;
        this.an2 = a2;
        this.bonds = new Bond[3];
        this.bonds[1] = this.an1.getCommonBond(this.an2);
        this.bonds[0] = this.an1.getOtherBond(this.bonds[1]);
        this.bonds[2] = this.an2.getOtherBond(this.bonds[1]);
        this.atoms = new Atom[4];
        this.atoms[2] = this.bonds[0].getCommonAtom(this.bonds[1]);
        this.atoms[1] = this.bonds[0].get1_2(this.atoms[2]);
        this.atoms[0] = this.bonds[1].get1_2(this.atoms[2]);
        this.atoms[3] = this.bonds[2].get1_2(this.atoms[1]);
        this.setMM(mmdi);
    }

    public final void setID_Key(int combo) {
        String[] id = new String[4];
        String[] key = new String[4];
        int i = 0;
        ListIterator<Atom> li = this.getAtomList().listIterator();
        while (li.hasNext()) {
            Atom a = li.next();
            id[i] = new String(a.getID());
            key[i++] = new String(a.getKey());
        }
        switch (combo) {
            case 0: {
                this.setID(new String(id[0] + id[1] + id[2] + id[3]));
                this.setKey(new String(key[0] + key[1] + key[2] + key[3]));
                break;
            }
            case 1: {
                this.setID(new String(id[1] + id[0] + id[2] + id[3]));
                this.setKey(new String(key[1] + key[0] + key[2] + key[3]));
                break;
            }
            case 2: {
                this.setID(new String(id[3] + id[1] + id[2] + id[0]));
                this.setKey(new String(key[3] + key[1] + key[2] + key[0]));
                break;
            }
            case 3: {
                this.setID(new String(id[1] + id[3] + id[2] + id[0]));
                this.setKey(new String(key[1] + key[3] + key[2] + key[0]));
                break;
            }
            case 4: {
                this.setID(new String(id[3] + id[0] + id[2] + id[1]));
                this.setKey(new String(key[3] + key[0] + key[2] + key[1]));
                break;
            }
            case 5: {
                this.setID(new String(id[0] + id[3] + id[2] + id[1]));
                this.setKey(new String(key[0] + key[3] + key[2] + key[1]));
            }
        }
    }

    @Override
    public void setMM(Hashtable data) {
        for (int i = 0; i < 6; ++i) {
            this.setID_Key(i);
            ValenceType mmterm = (ValenceType)data.get(this.getKey());
            if (mmterm == null) continue;
            this.setMM(mmterm);
            return;
        }
    }

    @Override
    public void update() {
        this.atoms[0].getV3D(vi);
        this.atoms[1].getV3D(vj);
        this.atoms[2].getV3D(vk);
        this.atoms[3].getV3D(vl);
        vij.sub((Tuple3d)vi, (Tuple3d)vj);
        vkj.sub((Tuple3d)vk, (Tuple3d)vj);
        vlk.sub((Tuple3d)vl, (Tuple3d)vk);
        vkj.normalize();
        dotij = vij.dot(vkj);
        dotlk = vlk.dot(vkj);
        dr.scaleAdd(-dotij, (Tuple3d)vkj, (Tuple3d)vij);
        ds.scaleAdd(-dotlk, (Tuple3d)vkj, (Tuple3d)vlk);
        dr.normalize();
        ds.normalize();
        cosphi = dr.dot(ds);
        this.setValue(Math.toDegrees(Math.acos(cosphi)));
    }
}

