/*
 * Decompiled with CFR 0.152.
 */
package ffe.lang;

import ffe.lang.Angle;
import ffe.lang.Atom;
import ffe.lang.Bond;
import ffe.lang.ValenceTerm;
import ffe.lang.VectorMath;

public class Dihedral
extends ValenceTerm {
    private static final long serialVersionUID = 1L;
    private static double[] vi = new double[3];
    private static double[] vj = new double[3];
    private static double[] vk = new double[3];
    private static double[] vl = new double[3];

    public Dihedral(Angle an1, Angle an2) {
        this.bonds = new Bond[3];
        this.bonds[1] = an1.getCommonBond(an2);
        this.bonds[0] = an1.getOtherBond(this.bonds[1]);
        this.bonds[2] = an2.getOtherBond(this.bonds[1]);
        this.Initialize();
    }

    public Dihedral(Angle a, Bond b) {
        this.bonds = new Bond[3];
        this.bonds[0] = b;
        this.bonds[1] = a.getBond(0);
        this.bonds[2] = a.getBond(1);
        Atom atom = this.bonds[1].getCommonAtom(b);
        if (atom == null) {
            Bond temp = this.bonds[1];
            this.bonds[1] = this.bonds[2];
            this.bonds[2] = temp;
        }
        this.Initialize();
    }

    public Dihedral(Bond b1, Bond b2, Bond b3) {
        this.bonds = new Bond[3];
        this.bonds[0] = b1;
        this.bonds[1] = b2;
        this.bonds[2] = b3;
        this.Initialize();
    }

    public Dihedral(String n) {
        super(n);
    }

    private void Initialize() {
        this.atoms = new Atom[4];
        this.atoms[1] = this.bonds[0].getCommonAtom(this.bonds[1]);
        this.atoms[0] = this.bonds[0].get1_2(this.atoms[1]);
        this.atoms[2] = this.bonds[1].get1_2(this.atoms[1]);
        this.atoms[3] = this.bonds[2].get1_2(this.atoms[2]);
        this.atoms[0].setDihedral(this);
        this.atoms[1].setDihedral(this);
        this.atoms[2].setDihedral(this);
        this.atoms[3].setDihedral(this);
        this.setID_Key(false);
    }

    @Override
    public void update() {
        this.atoms[0].getXYZ(vi);
        this.atoms[1].getXYZ(vj);
        this.atoms[2].getXYZ(vk);
        this.atoms[3].getXYZ(vl);
        this.setValue(Math.toDegrees(VectorMath.dihedralAngle(vi, vj, vk, vl)));
    }
}

