/*
 * Decompiled with CFR 0.152.
 */
package ffe.lang;

import ffe.lang.Atom;
import ffe.lang.RendererCache;
import ffe.lang.ValenceTerm;
import ffe.lang.VectorMath;
import java.util.ArrayList;
import java.util.List;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Geometry;
import org.jogamp.java3d.LineArray;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.vecmath.AxisAngle4d;
import org.jogamp.vecmath.Vector3d;

public class Bond
extends ValenceTerm {
    private static final long serialVersionUID = 1L;
    public static final float BUFF = 0.7f;
    private static final float[] a0col = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    private static final float[] f4a = new float[]{0.0f, 0.0f, 0.0f, 0.9f};
    private static final float[] f4b = new float[]{0.0f, 0.0f, 0.0f, 0.9f};
    private static float[] f16 = new float[]{0.0f, 0.0f, 0.0f, 0.9f, 0.0f, 0.0f, 0.0f, 0.9f, 0.0f, 0.0f, 0.0f, 0.9f, 0.0f, 0.0f, 0.0f, 0.9f};
    private static double d;
    private static double[] a13d;
    private static double[] a23d;
    private static double[] mid;
    private static double[] diff3d;
    private static double[] sum3d;
    private static double[] coord;
    private static double[] y;
    private static AxisAngle4d axisAngle;
    private static double[] bcross;
    private static double[] cstart;
    private static Vector3d pos3d;
    private static double angle;
    private ArrayList<Bond> formsAngleWith = new ArrayList();
    private int order;
    private RendererCache.ViewModel viewModel = RendererCache.ViewModel.INVISIBLE;
    private BranchGroup branchGroup;
    private TransformGroup cy1tg;
    private TransformGroup cy2tg;
    private Transform3D cy1t3d;
    private Transform3D cy2t3d;
    private Shape3D cy1;
    private Shape3D cy2;
    private Vector3d scale;
    private int detail = 3;
    private LineArray la;
    private int lineIndex;
    private boolean wireVisible = true;

    public Bond(Atom a1, Atom a2, int ord) {
        this.atoms = new Atom[2];
        this.atoms[0] = a1;
        this.atoms[1] = a2;
        this.order = ord;
        a1.setBond(this);
        a2.setBond(this);
        this.setID_Key(false);
        this.viewModel = RendererCache.ViewModel.WIREFRAME;
    }

    public Bond(String n) {
        super(n);
    }

    public boolean formsAngleWith(Bond b) {
        for (Bond bond : this.formsAngleWith) {
            if (b != bond) continue;
            return true;
        }
        return false;
    }

    public Atom get1_2(Atom a) {
        if (a == this.atoms[0]) {
            return this.atoms[1];
        }
        if (a == this.atoms[1]) {
            return this.atoms[0];
        }
        return null;
    }

    public Atom getCommonAtom(Bond b) {
        if (b == this || b == null) {
            return null;
        }
        if (b.atoms[0] == this.atoms[0]) {
            return this.atoms[0];
        }
        if (b.atoms[0] == this.atoms[1]) {
            return this.atoms[1];
        }
        if (b.atoms[1] == this.atoms[0]) {
            return this.atoms[0];
        }
        if (b.atoms[1] == this.atoms[1]) {
            return this.atoms[1];
        }
        return null;
    }

    public Atom getOtherAtom(Bond b) {
        if (b == this || b == null) {
            return null;
        }
        if (b.atoms[0] == this.atoms[0]) {
            return this.atoms[1];
        }
        if (b.atoms[0] == this.atoms[1]) {
            return this.atoms[0];
        }
        if (b.atoms[1] == this.atoms[0]) {
            return this.atoms[1];
        }
        if (b.atoms[1] == this.atoms[1]) {
            return this.atoms[0];
        }
        return null;
    }

    private void initJ3D(List<BranchGroup> newShapes) {
        this.detail = RendererCache.detail;
        this.branchGroup = RendererCache.doubleCylinderFactory(this.atoms[0], this.atoms[1], this.detail);
        this.cy1tg = (TransformGroup)this.branchGroup.getChild(0);
        this.cy2tg = (TransformGroup)this.branchGroup.getChild(1);
        this.cy1 = (Shape3D)this.cy1tg.getChild(0);
        this.cy2 = (Shape3D)this.cy2tg.getChild(0);
        newShapes.add(this.branchGroup);
        this.cy1t3d = RendererCache.transform3DFactory();
        this.cy2t3d = RendererCache.transform3DFactory();
        this.update();
    }

    @Override
    public void removeFromParent() {
        super.removeFromParent();
        this.cy1 = null;
        this.cy2 = null;
        this.cy1tg = null;
        this.cy2tg = null;
        if (this.cy1t3d != null) {
            RendererCache.poolTransform3D(this.cy1t3d);
            RendererCache.poolTransform3D(this.cy2t3d);
            this.cy1t3d = null;
            this.cy2t3d = null;
        }
        if (this.branchGroup != null) {
            this.branchGroup.detach();
            this.branchGroup.setUserData(null);
            RendererCache.poolDoubleCylinder(this.branchGroup);
            this.branchGroup = null;
        }
    }

    public boolean sameGroup() {
        return this.atoms[0].getParent() == this.atoms[1].getParent();
    }

    public void setAngleWith(Bond b) {
        this.formsAngleWith.add(b);
    }

    public void setBondTransform3d(Transform3D t3d, double[] pos, double[] orient, double len, boolean newRot) {
        if (newRot) {
            angle = VectorMath.angle(orient, y);
            VectorMath.cross(y, orient, bcross);
            Bond.bcross[3] = angle - Math.PI;
            axisAngle.set(bcross);
        }
        VectorMath.scalar(orient, len / 4.0, cstart);
        VectorMath.sum(cstart, pos, cstart);
        pos3d.set(cstart);
        t3d.setTranslation(pos3d);
        t3d.setRotation(axisAngle);
        t3d.setScale(this.scale);
    }

    public void setColor(Atom a) {
        if (this.viewModel != RendererCache.ViewModel.INVISIBLE && this.viewModel != RendererCache.ViewModel.WIREFRAME && this.branchGroup != null) {
            if (a == this.atoms[0]) {
                this.cy1.setAppearance(a.getAtomAppearance());
            } else if (a == this.atoms[1]) {
                this.cy2.setAppearance(a.getAtomAppearance());
            }
        }
        this.setWireVisible(this.wireVisible);
    }

    public void setCylinderVisible(boolean visible, List<BranchGroup> newShapes) {
        if (!visible) {
            if (this.branchGroup != null) {
                this.cy1.setPickable(false);
                this.cy1.setAppearance(RendererCache.nullAp);
                this.cy2.setPickable(false);
                this.cy2.setAppearance(RendererCache.nullAp);
            }
        } else if (this.branchGroup == null) {
            this.initJ3D(newShapes);
        } else {
            this.cy1t3d.setScale(this.scale);
            this.cy1tg.setTransform(this.cy1t3d);
            this.cy2t3d.setScale(this.scale);
            this.cy2tg.setTransform(this.cy2t3d);
            this.cy1.setAppearance(this.atoms[0].getAtomAppearance());
            this.cy2.setAppearance(this.atoms[1].getAtomAppearance());
        }
    }

    @Override
    public void setView(RendererCache.ViewModel newViewModel, List<BranchGroup> newShapes) {
        switch (newViewModel) {
            case WIREFRAME: {
                this.viewModel = RendererCache.ViewModel.WIREFRAME;
                this.setWireVisible(true);
                this.setCylinderVisible(false, newShapes);
                break;
            }
            case SPACEFILL: 
            case INVISIBLE: 
            case RMIN: {
                this.viewModel = RendererCache.ViewModel.INVISIBLE;
                this.setWireVisible(false);
                this.setCylinderVisible(false, newShapes);
                break;
            }
            case RESTRICT: {
                if (this.atoms[0].isSelected() && this.atoms[1].isSelected()) break;
                this.viewModel = RendererCache.ViewModel.INVISIBLE;
                this.setWireVisible(false);
                this.setCylinderVisible(false, newShapes);
                break;
            }
            case BALLANDSTICK: 
            case TUBE: {
                this.viewModel = newViewModel;
                double len = this.getValue() / 2.0;
                double rad = this.viewModel == RendererCache.ViewModel.BALLANDSTICK ? 0.1 * RendererCache.radius : 0.2 * RendererCache.radius;
                if (this.scale == null) {
                    this.scale = new Vector3d();
                }
                this.scale.set(rad, len, rad);
                this.setWireVisible(false);
                this.setCylinderVisible(true, newShapes);
                break;
            }
            case DETAIL: {
                double newRadius;
                int res = RendererCache.detail;
                if (res != this.detail) {
                    this.detail = res;
                    if (this.branchGroup != null) {
                        Geometry g1 = RendererCache.getCylinderGeom(0, this.detail);
                        Geometry g2 = RendererCache.getCylinderGeom(1, this.detail);
                        Geometry g3 = RendererCache.getCylinderGeom(2, this.detail);
                        this.cy1.removeAllGeometries();
                        this.cy2.removeAllGeometries();
                        this.cy1.addGeometry(g1);
                        this.cy1.addGeometry(g2);
                        this.cy1.addGeometry(g3);
                        this.cy2.addGeometry(g1);
                        this.cy2.addGeometry(g2);
                        this.cy2.addGeometry(g3);
                    }
                }
                if (this.scale == null) {
                    this.scale = new Vector3d();
                }
                if (this.viewModel == RendererCache.ViewModel.BALLANDSTICK) {
                    newRadius = 0.1 * RendererCache.radius;
                } else {
                    if (this.viewModel != RendererCache.ViewModel.TUBE) break;
                    newRadius = 0.2 * RendererCache.radius;
                }
                if (newRadius == this.scale.x) break;
                this.scale.x = newRadius;
                this.scale.y = newRadius;
                if (this.branchGroup == null) break;
                this.setView(this.viewModel, newShapes);
                break;
            }
            case SHOWHYDROGENS: {
                if (this.atoms[0].getAtomicNumber() != 1 && this.atoms[1].getAtomicNumber() != 1) break;
                this.setView(this.viewModel, newShapes);
                break;
            }
            case HIDEHYDROGENS: {
                if (this.atoms[0].getAtomicNumber() != 1 && this.atoms[1].getAtomicNumber() != 1) break;
                this.viewModel = RendererCache.ViewModel.INVISIBLE;
                this.setWireVisible(false);
                this.setCylinderVisible(false, newShapes);
                break;
            }
            case FILL: 
            case POINTS: 
            case LINES: {
                if (this.branchGroup == null || this.viewModel == RendererCache.ViewModel.INVISIBLE) break;
                this.cy1.setAppearance(this.atoms[0].getAtomAppearance());
                this.cy2.setAppearance(this.atoms[1].getAtomAppearance());
            }
        }
    }

    public void setWire(LineArray l, int i) {
        this.la = l;
        this.lineIndex = i;
    }

    public void setWireVisible(boolean visible) {
        if (!visible) {
            this.wireVisible = false;
            this.la.setColors(this.lineIndex, a0col);
        } else {
            this.wireVisible = true;
            float[] cols = f16;
            float[] col1 = f4a;
            float[] col2 = f4b;
            this.atoms[0].getAtomColor().get(col1);
            this.atoms[1].getAtomColor().get(col2);
            for (int i = 0; i < 3; ++i) {
                cols[i] = col1[i];
                cols[4 + i] = col1[i];
                cols[8 + i] = col2[i];
                cols[12 + i] = col2[i];
            }
            this.la.setColors(this.lineIndex, cols);
        }
    }

    @Override
    public void update() {
        this.atoms[0].getXYZ(a13d);
        this.atoms[1].getXYZ(a23d);
        VectorMath.diff(a13d, a23d, diff3d);
        d = VectorMath.r(diff3d);
        this.setValue(d);
        VectorMath.sum(a13d, a23d, sum3d);
        VectorMath.scalar(sum3d, 0.5, mid);
        if (this.la != null) {
            for (int i = 0; i < 3; ++i) {
                Bond.coord[i] = a13d[i];
                Bond.coord[3 + i] = mid[i];
                Bond.coord[6 + i] = mid[i];
                Bond.coord[9 + i] = a23d[i];
            }
            this.la.setCoordinates(this.lineIndex, coord);
        }
        if (this.branchGroup != null) {
            VectorMath.norm(diff3d, diff3d);
            this.scale.y = d / 2.0;
            this.setBondTransform3d(this.cy1t3d, mid, diff3d, d, true);
            VectorMath.scalar(diff3d, -1.0, diff3d);
            this.setBondTransform3d(this.cy2t3d, mid, diff3d, d, false);
            this.cy1tg.setTransform(this.cy1t3d);
            this.cy2tg.setTransform(this.cy2t3d);
        }
    }

    static {
        a13d = new double[3];
        a23d = new double[3];
        mid = new double[3];
        diff3d = new double[3];
        sum3d = new double[3];
        coord = new double[12];
        y = new double[]{0.0, 1.0, 0.0};
        axisAngle = new AxisAngle4d();
        bcross = new double[4];
        cstart = new double[3];
        pos3d = new Vector3d();
    }

    public static enum BondCharacter {
        SINGLEBOND,
        DOUBLEBOND,
        TRIPLEBOND;

    }
}

