/*
 * Decompiled with CFR 0.152.
 */
package ffe.lang;

import ffe.lang.Angle;
import ffe.lang.Bond;
import ffe.lang.Dihedral;
import ffe.lang.HashCodeUtil;
import ffe.lang.MSNode;
import ffe.lang.Polymer;
import ffe.lang.RendererCache;
import ffe.lang.Residue;
import ffe.lang.VectorMath;
import ffe.mm.AtomType;
import ffe.mm.ChargeType;
import ffe.mm.MultipoleType;
import ffe.mm.VDWType;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Logger;
import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.Geometry;
import org.jogamp.java3d.J3DGraphics2D;
import org.jogamp.java3d.Material;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.vecmath.AxisAngle4d;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Point2d;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Tuple3d;
import org.jogamp.vecmath.Vector3d;

public class Atom
extends MSNode {
    private static final long serialVersionUID = 1L;
    private Logger logger = Logger.getLogger("ffe");
    private static double maxInduced;
    private static double maxVel;
    private static double maxAccel;
    private static double maxForce;
    private static Appearance vectorAppearance;
    private static Point3d point3d;
    private static Point2d point2d;
    private static double[] y;
    private static double[] ycrossv;
    private static double[] shapeVector;
    private static Vector3d scaleV3D;
    private static Vector3d transV3D;
    private static AxisAngle4d axisAngle;
    private static double angle;
    public static Hashtable<Integer, Color3f> AtomColor;
    public static Hashtable<Integer, Float> AtomVDW;
    public static final int SP = 2;
    public static final int SP2 = 3;
    public static final int SP3 = 4;
    public static final Hashtable<String, Integer> hybridTable;
    public int xyzindex;
    private String id = null;
    private String residue = null;
    private int residueNumber = -1;
    private String chain = null;
    private double occupancy = 1.0;
    private double bfactor = 2.0;
    private Vector3d positionVector3d;
    private ArrayList<Vector3d> trajectory;
    private AtomType atomType = null;
    private VDWType vdwType = null;
    private ChargeType chargeType = null;
    private MultipoleType multipoleType = null;
    private Atom[] multipoleReferenceSites = null;
    private double[] globalDipole = null;
    private double[][] globalQuadrupole = null;
    private double bornRadius;
    private double[] induced;
    private double inducedMag;
    private double[] velocity;
    private double velMag;
    private double[] acceleration;
    private double accelMag;
    private double[] force;
    private double forceMag;
    private double[] currentVector = null;
    private double currentMag = 0.0;
    private double currentMax = 1.0;
    private double currentLength = 0.0;
    private ArrayList<Bond> bonds;
    private ArrayList<Angle> angles;
    private ArrayList<Dihedral> dihedrals;
    private RendererCache.ViewModel viewModel = RendererCache.ViewModel.INVISIBLE;
    private RendererCache.ViewModel vectorType = RendererCache.ViewModel.HIDEVECTORS;
    private RendererCache.ViewModel vectorLength = RendererCache.ViewModel.RELATIVE;
    private RendererCache.ViewModel polygonType = RendererCache.ViewModel.FILL;
    private RendererCache.ColorModel colorModel = RendererCache.ColorModel.CPK;
    private Shape3D sphere;
    private Shape3D cylinder;
    private Shape3D cone;
    private BranchGroup branchGroup;
    private BranchGroup vectorBranchGroup;
    private TransformGroup transformGroup;
    private TransformGroup cylTG;
    private TransformGroup coneTG;
    private Transform3D transform3D;
    private Transform3D cylT3D;
    private Transform3D coneT3D;
    private Appearance appearance;
    private Color3f currentCol;
    private Color3f previousCol;
    private Color3f userColor = RendererCache.userColor;
    private int detail = RendererCache.detail;
    private double radius = RendererCache.radius;
    private double scale = 1.0;
    private boolean stale = false;

    public static double getMaxAcceleration() {
        return maxAccel;
    }

    public static double getMaxForce() {
        return maxForce;
    }

    public static double getMaxInduced() {
        return maxInduced;
    }

    public static double getMaxVelocity() {
        return maxVel;
    }

    public static void setMaxAcceleration(double f) {
        maxAccel = f;
    }

    public static void setMaxForce(double f) {
        maxForce = f;
    }

    public static void setMaxInduced(double f) {
        maxInduced = f;
    }

    public static void setMaxVelocity(double f) {
        maxVel = f;
    }

    public Atom(int xyznum, String id, AtomType atomType, double[] d) {
        this(id, atomType, d);
        this.xyzindex = xyznum;
    }

    public Atom(int index, String id, AtomType atomType, double[] d, String r, int n, String c) {
        this(index, id, atomType, d);
        this.residue = r;
        this.residueNumber = n;
        this.chain = c;
    }

    public Atom(String s) {
        super(s, 1);
        this.id = s;
        this.currentCol = this.previousCol = RendererCache.toAtomColor(this.id);
        this.colorModel = RendererCache.ColorModel.CPK;
    }

    public Atom(String id, AtomType atomType, double[] d) {
        this(id);
        this.atomType = atomType;
        this.positionVector3d = new Vector3d(d);
        this.setAllowsChildren(false);
        if (atomType != null) {
            this.currentCol = this.previousCol = AtomColor.get(atomType.atomicNumber);
        }
    }

    public void addTrajectoryCoords(Vector3d coords, int position) {
        if (this.trajectory == null) {
            this.trajectory = new ArrayList();
            this.trajectory.add(0, this.positionVector3d);
        }
        this.trajectory.add(position, coords);
    }

    @Override
    public void drawLabel(Canvas3D canvas, J3DGraphics2D g2d, Node node) {
        if (RendererCache.labelAtoms) {
            Atom.point3d.x = this.getX();
            Atom.point3d.y = this.getY();
            Atom.point3d.z = this.getZ();
            RendererCache.getScreenCoordinate(canvas, node, point3d, point2d);
            g2d.drawString(this.toShortString(), (float)Atom.point2d.x, (float)Atom.point2d.y);
        }
    }

    @Override
    public final boolean equals(Object object) {
        return this == object;
    }

    public void getAcceleration(double[] t) {
        if (this.acceleration == null || t == null) {
            return;
        }
        t[0] = this.acceleration[0];
        t[1] = this.acceleration[1];
        t[2] = this.acceleration[2];
    }

    public ArrayList<Angle> getAngles() {
        return this.angles;
    }

    public Appearance getAtomAppearance() {
        if (this.appearance == null) {
            this.appearance = RendererCache.appearanceFactory(this.currentCol, this.polygonType);
        }
        return this.appearance;
    }

    public Color3f getAtomColor() {
        return this.currentCol;
    }

    public int getAtomicNumber() {
        return this.atomType.atomicNumber;
    }

    @Override
    public ArrayList<Atom> getAtomList() {
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        atoms.add(this);
        return atoms;
    }

    public AtomType getAtomType() {
        return this.atomType;
    }

    public Bond getBond(Atom a) {
        if (this.bonds == null) {
            return null;
        }
        for (Bond bond : this.bonds) {
            if (bond.get1_2(a) != this) continue;
            return bond;
        }
        return null;
    }

    public ArrayList<Bond> getBonds() {
        return this.bonds;
    }

    public double getBornRadius() {
        return this.bornRadius;
    }

    public double getBornVolume() {
        return 2.0;
    }

    public String getChain() {
        if (this.chain != null) {
            return this.chain;
        }
        Polymer p = (Polymer)this.getMSNode(Polymer.class);
        if (p == null) {
            return null;
        }
        this.chain = p.getName();
        return this.chain;
    }

    public double getCharge() {
        return 1.0;
    }

    public ArrayList<Dihedral> getDihedrals() {
        return this.dihedrals;
    }

    public double getEpsilon() {
        return 1.0;
    }

    public void getForce(double[] t) {
        if (this.force == null || t == null) {
            return;
        }
        t[0] = this.force[0];
        t[1] = this.force[1];
        t[2] = this.force[2];
    }

    public double getGPol() {
        return 2.0;
    }

    public int getHybridization() {
        return this.atomType.hybridization;
    }

    public String getID() {
        return this.id;
    }

    public String getIdent() {
        String s = new String(this.atomType.environment);
        return s;
    }

    public void getInducedDipole(double[] t) {
        if (this.induced == null || t == null) {
            return;
        }
        t[0] = this.induced[0];
        t[1] = this.induced[1];
        t[2] = this.induced[2];
    }

    public String getKey() {
        if (this.atomType != null) {
            return this.atomType.key;
        }
        return null;
    }

    public double getMass() {
        return this.atomType.mass;
    }

    public Atom[] getMultipoleReferenceSites() {
        return this.multipoleReferenceSites;
    }

    public MultipoleType getMultipoleType() {
        return this.multipoleType;
    }

    public final int getNumAngles() {
        if (this.angles == null) {
            return 0;
        }
        return this.angles.size();
    }

    public final int getNumBonds() {
        if (this.bonds == null) {
            return 0;
        }
        return this.bonds.size();
    }

    public final int getNumDihedrals() {
        if (this.dihedrals == null) {
            return 0;
        }
        return this.dihedrals.size();
    }

    public double getRDielectric() {
        return 2.0;
    }

    public double getRelativeLength() {
        return this.currentMag / this.currentMax;
    }

    public String getResidueName() {
        if (this.residue != null) {
            return this.residue;
        }
        Residue r = (Residue)this.getMSNode(Residue.class);
        return r.getName();
    }

    public int getResidueNumber() {
        return this.residueNumber;
    }

    public double getSigma() {
        return 1.0;
    }

    public Vector3d getTrajectoryCoords(int position) {
        return this.trajectory.get(position);
    }

    public int getTrajectoryLength() {
        return this.trajectory.size();
    }

    public int getType() {
        return this.atomType.type;
    }

    public void getV3D(Vector3d temp) {
        temp.set((Tuple3d)this.positionVector3d);
    }

    public double getVDWR() {
        return 1.0;
    }

    public double getVectorLength() {
        return this.currentLength;
    }

    public void getVelocity(double[] t) {
        if (this.velocity == null || t == null) {
            return;
        }
        t[0] = this.velocity[0];
        t[1] = this.velocity[1];
        t[2] = this.velocity[2];
    }

    public double getX() {
        return this.positionVector3d.x;
    }

    public void getXYZ(double[] xyz) {
        this.positionVector3d.get(xyz);
    }

    public final int getXYZIndex() {
        return this.xyzindex;
    }

    public final double getY() {
        return this.positionVector3d.y;
    }

    public final double getZ() {
        return this.positionVector3d.z;
    }

    @Override
    public final int hashCode() {
        int ret = HashCodeUtil.hash(1023, this.xyzindex);
        return ret;
    }

    private void initSphere(List<BranchGroup> newShapes) {
        if (this.appearance == null) {
            this.appearance = RendererCache.appearanceFactory(this.currentCol, RendererCache.ViewModel.FILL);
        }
        if (this.transform3D == null) {
            this.transform3D = RendererCache.transform3DFactory(this.positionVector3d, this.scale);
        } else {
            this.transform3D.setTranslation(this.positionVector3d);
            this.transform3D.setScale(this.scale);
        }
        this.detail = RendererCache.detail;
        this.branchGroup = RendererCache.sphereFactory(this.appearance, this.detail, this.transform3D);
        this.transformGroup = (TransformGroup)this.branchGroup.getChild(0);
        this.sphere = (Shape3D)this.transformGroup.getChild(0);
        this.sphere.setUserData((Object)this);
        newShapes.add(this.branchGroup);
    }

    public void initVector(List<BranchGroup> newShapes) {
        this.appearance = RendererCache.appearanceFactory(this.currentCol, RendererCache.ViewModel.FILL);
        this.detail = RendererCache.detail;
        this.cylinder = RendererCache.createCylinder(this.appearance, this.detail);
        this.cylinder.setUserData((Object)this);
        this.cylT3D = new Transform3D();
        this.cylTG = new TransformGroup(this.cylT3D);
        this.cylTG.setCapability(17);
        this.cylTG.setCapability(18);
        this.cylTG.addChild((Node)this.cylinder);
        this.cone = RendererCache.coneFactory(this.appearance, this.detail);
        this.cone.setUserData((Object)this);
        this.coneT3D = new Transform3D();
        this.coneT3D.setScale(0.1);
        this.coneTG = new TransformGroup(this.coneT3D);
        this.coneTG.setCapability(17);
        this.coneTG.setCapability(18);
        this.coneTG.addChild((Node)this.cone);
        this.vectorBranchGroup = new BranchGroup();
        this.vectorBranchGroup.addChild((Node)this.cylTG);
        this.vectorBranchGroup.addChild((Node)this.coneTG);
        newShapes.add(this.vectorBranchGroup);
        this.updateVector();
    }

    public final boolean isBonded(Atom a) {
        for (Bond bond : this.bonds) {
            if (bond.get1_2(a) != this) continue;
            return true;
        }
        return false;
    }

    public boolean isDangeling() {
        Integer hybrid = hybridTable.get("" + this.atomType.atomicNumber);
        if (hybrid == null) {
            return false;
        }
        int result = hybrid.compareTo(this.bonds.size());
        return result > 0;
    }

    public boolean isStale() {
        return this.stale;
    }

    public boolean isVisible() {
        return this.viewModel != RendererCache.ViewModel.INVISIBLE || this.vectorType != RendererCache.ViewModel.INVISIBLE;
    }

    public void move(double[] d) {
        this.positionVector3d.x += d[0];
        this.positionVector3d.y += d[1];
        this.positionVector3d.z += d[2];
        this.stale = true;
    }

    public void moveTo(double x, double y, double z) {
        this.positionVector3d.set(x, y, z);
        this.stale = true;
    }

    public void moveTo(double[] d) {
        this.positionVector3d.set(d);
        this.stale = true;
    }

    public void moveTo(Vector3d newPosition) {
        this.positionVector3d.set((Tuple3d)newPosition);
        this.stale = true;
    }

    @Override
    public final void print() {
        this.logger.info(this.toString());
    }

    @Override
    public void removeFromParent() {
        super.removeFromParent();
        if (this.angles != null) {
            this.angles.clear();
        }
        if (this.dihedrals != null) {
            this.dihedrals.clear();
        }
        if (this.trajectory != null) {
            this.trajectory.clear();
        }
        this.trajectory = null;
        this.stale = false;
        this.viewModel = RendererCache.ViewModel.INVISIBLE;
        this.vectorType = RendererCache.ViewModel.HIDEVECTORS;
        this.vectorLength = RendererCache.ViewModel.UNIT;
        RendererCache.poolTransform3D(this.transform3D);
        if (this.branchGroup != null) {
            this.branchGroup.detach();
            this.branchGroup.setUserData(null);
            RendererCache.poolSphere(this.branchGroup);
            this.branchGroup = null;
        }
    }

    public void setAcceleration(double x, double y, double z) {
        if (this.acceleration == null) {
            this.acceleration = new double[3];
        }
        this.acceleration[0] = x;
        this.acceleration[1] = y;
        this.acceleration[2] = z;
        this.accelMag = VectorMath.r(this.acceleration);
        if (this.accelMag > maxAccel) {
            maxAccel = this.accelMag;
        }
        this.stale = true;
    }

    public void setAngle(Angle a) {
        if (this.angles == null) {
            this.angles = new ArrayList();
        }
        this.angles.add(a);
    }

    public void setBond(Bond b) {
        if (this.bonds == null) {
            this.bonds = new ArrayList();
        }
        this.bonds.add(b);
    }

    public void setOccupancy(double o) {
        this.occupancy = o;
    }

    public void setBFactor(double b) {
        this.bfactor = b;
    }

    public void setBornRadius(double bornRadius) {
        this.bornRadius = bornRadius;
    }

    @Override
    public void setColor(RendererCache.ColorModel newColorModel, Color3f newCol, Material newMat) {
        switch (newColorModel) {
            case CPK: {
                newCol = RendererCache.getColor(this, RendererCache.ColorModel.CPK);
                if (newCol == this.currentCol) {
                    return;
                }
                this.colorModel = newColorModel;
                this.currentCol = this.previousCol = newCol;
                break;
            }
            case USERCOLOR: {
                this.colorModel = newColorModel;
                this.currentCol = this.previousCol = this.userColor;
                break;
            }
            case APPLYUSERCOLOR: {
                this.currentCol = this.previousCol = (this.userColor = RendererCache.userColor);
                break;
            }
            case MONOCHROME: {
                this.colorModel = newColorModel;
                this.currentCol = this.previousCol = RendererCache.WHITE;
                break;
            }
            case SELECT: {
                if (this.isSelected()) {
                    newCol = RendererCache.selectionColor;
                    if (newCol != this.currentCol) {
                        this.currentCol = newCol;
                        break;
                    }
                    return;
                }
                this.currentCol = this.previousCol;
                break;
            }
            case PICK: {
                newCol = RendererCache.pickingColor;
                if (newCol != this.currentCol) {
                    this.currentCol = newCol;
                    break;
                }
                return;
            }
            case REVERT: {
                if (RendererCache.highlightSelections && this.isSelected()) {
                    this.currentCol = RendererCache.selectionColor;
                    break;
                }
                this.currentCol = this.previousCol;
                break;
            }
            case PARTIALCHARGE: {
                newCol = RendererCache.getColor(this, RendererCache.ColorModel.PARTIALCHARGE);
                if (newCol == this.currentCol) {
                    return;
                }
                this.colorModel = newColorModel;
                this.currentCol = this.previousCol = newCol;
                break;
            }
            case VECTORMAGNITUDE: {
                newCol = RendererCache.getColor(this, newColorModel);
                if (newCol == this.currentCol) {
                    return;
                }
                this.colorModel = newColorModel;
                this.currentCol = this.previousCol = newCol;
                break;
            }
            default: {
                if (newCol == this.currentCol || newCol == null) {
                    return;
                }
                this.colorModel = newColorModel;
                this.currentCol = this.previousCol = newCol;
            }
        }
        this.appearance = RendererCache.appearanceFactory(this.currentCol, this.polygonType);
        if (this.branchGroup != null && this.viewModel != RendererCache.ViewModel.INVISIBLE) {
            this.sphere.setAppearance(this.appearance);
        }
        if (this.vectorBranchGroup != null && this.vectorType != RendererCache.ViewModel.HIDEVECTORS) {
            this.cylinder.setAppearance(this.appearance);
            this.cone.setAppearance(this.appearance);
        }
        if (this.bonds != null) {
            for (Bond bond : this.bonds) {
                bond.setColor(this);
            }
        }
    }

    public void setCurrentCycle(int cycle) {
        if (this.trajectory == null) {
            return;
        }
        if (cycle <= 0 || cycle > this.trajectory.size()) {
            return;
        }
        this.positionVector3d = this.trajectory.get(cycle - 1);
        this.stale = true;
    }

    public void setCurrentVector() {
        switch (this.vectorType) {
            case FORCE: {
                if (this.force == null) break;
                this.currentVector = this.force;
                this.currentMag = this.forceMag;
                this.currentMax = maxForce;
                return;
            }
            case INDUCEDDIPOLE: {
                if (this.induced == null) break;
                this.currentVector = this.induced;
                this.currentMag = this.inducedMag;
                this.currentMax = maxInduced;
                return;
            }
            case VELOCITY: {
                if (this.velocity == null) break;
                this.currentVector = this.velocity;
                this.currentMag = this.velMag;
                this.currentMax = maxVel;
                return;
            }
            case ACCELERATION: {
                if (this.acceleration == null) break;
                this.currentVector = this.acceleration;
                this.currentMag = this.accelMag;
                this.currentMax = maxAccel;
                return;
            }
        }
        this.vectorType = RendererCache.ViewModel.HIDEVECTORS;
        this.currentVector = null;
        this.currentMag = 0.0;
        this.currentMax = 1.0;
    }

    public void setDihedral(Dihedral d) {
        if (this.dihedrals == null) {
            this.dihedrals = new ArrayList();
        }
        this.dihedrals.add(d);
    }

    public void setForce(double x, double y, double z) {
        if (this.force == null) {
            this.force = new double[3];
        }
        this.force[0] = x;
        this.force[1] = y;
        this.force[2] = z;
        this.forceMag = VectorMath.r(this.force);
        if (this.forceMag > maxVel) {
            maxForce = this.forceMag;
        }
        this.stale = true;
    }

    public void setGlobalMultipole(double[] dipole, double[][] quadrupole) {
        if (this.globalDipole == null) {
            this.globalDipole = new double[3];
        }
        if (this.globalQuadrupole == null) {
            this.globalQuadrupole = new double[3][3];
        }
        for (int i = 0; i < 3; ++i) {
            this.globalDipole[i] = dipole[i];
            for (int j = 0; j < 3; ++j) {
                this.globalQuadrupole[i][j] = quadrupole[i][j];
            }
        }
    }

    public void setInducedDipole(double x, double y, double z) {
        if (this.induced == null) {
            this.induced = new double[3];
        }
        this.induced[0] = x;
        this.induced[1] = y;
        this.induced[2] = z;
        this.inducedMag = VectorMath.r(this.induced);
        if (this.inducedMag > maxInduced) {
            maxInduced = this.inducedMag;
        }
        this.stale = true;
    }

    public void setMultipoleType(MultipoleType multipoleType, Atom[] multipoleReferenceSites) {
        this.multipoleType = multipoleType;
        this.multipoleReferenceSites = multipoleReferenceSites;
    }

    @Override
    public void setSelected(boolean b) {
        this.selected = b;
    }

    public void setSphereVisible(boolean sphereVisible, List<BranchGroup> newShapes) {
        if (!sphereVisible) {
            if (this.branchGroup != null) {
                this.sphere.setPickable(false);
                this.sphere.setAppearance(RendererCache.nullAp);
            }
        } else {
            if (this.branchGroup == null) {
                this.initSphere(newShapes);
            }
            this.sphere.setAppearance(this.appearance);
            this.sphere.setPickable(true);
            this.updateSphere();
        }
    }

    public void setVeclocity(double x, double y, double z) {
        if (this.velocity == null) {
            this.velocity = new double[3];
        }
        this.velocity[0] = x;
        this.velocity[1] = y;
        this.velocity[2] = z;
        this.velMag = VectorMath.r(this.velocity);
        if (this.velMag > maxVel) {
            maxVel = this.velMag;
        }
        this.stale = true;
    }

    public void setVectorLength() {
        switch (this.vectorLength) {
            case UNIT: {
                this.currentLength = 1.0;
                return;
            }
            case RELATIVE: {
                this.currentLength = this.currentMag / this.currentMax;
                return;
            }
            case ABSOLUTE: {
                this.currentLength = this.currentMag;
                return;
            }
        }
        this.currentLength = 0.0;
    }

    public void setVectorVisible(boolean vectorVisible, List<BranchGroup> newShapes) {
        if (!vectorVisible) {
            if (this.vectorBranchGroup != null) {
                this.cylinder.setAppearance(RendererCache.nullAp);
                this.cylinder.setPickable(false);
                this.cone.setAppearance(RendererCache.nullAp);
                this.cone.setPickable(false);
            }
        } else if (this.vectorType != RendererCache.ViewModel.HIDEVECTORS) {
            if (this.vectorBranchGroup == null) {
                this.initVector(newShapes);
            }
            this.cylinder.setAppearance(vectorAppearance);
            this.cylinder.setPickable(true);
            this.cone.setAppearance(vectorAppearance);
            this.cone.setPickable(true);
            this.updateVector();
        }
    }

    @Override
    public void setView(RendererCache.ViewModel newViewModel, List<BranchGroup> newShapes) {
        switch (newViewModel) {
            case INVISIBLE: {
                this.viewModel = RendererCache.ViewModel.INVISIBLE;
                this.vectorType = RendererCache.ViewModel.HIDEVECTORS;
                this.setSphereVisible(false, newShapes);
                this.setVectorVisible(false, newShapes);
                break;
            }
            case WIREFRAME: {
                this.viewModel = RendererCache.ViewModel.INVISIBLE;
                this.setSphereVisible(false, newShapes);
                break;
            }
            case SPACEFILL: {
                this.viewModel = RendererCache.ViewModel.SPACEFILL;
                this.scale = (double)AtomVDW.get(this.atomType.atomicNumber).floatValue() * this.radius;
                this.setSphereVisible(true, newShapes);
                break;
            }
            case RMIN: {
                this.viewModel = RendererCache.ViewModel.RMIN;
                this.scale = 1.0 * this.radius;
                this.setSphereVisible(true, newShapes);
                break;
            }
            case BALLANDSTICK: {
                this.viewModel = RendererCache.ViewModel.BALLANDSTICK;
                this.scale = (double)AtomVDW.get(this.atomType.atomicNumber).floatValue() / 5.0 * this.radius;
                this.setSphereVisible(true, newShapes);
                break;
            }
            case TUBE: {
                this.viewModel = RendererCache.ViewModel.TUBE;
                this.scale = RendererCache.radius * 0.2;
                this.setSphereVisible(true, newShapes);
                break;
            }
            case FORCE: 
            case INDUCEDDIPOLE: 
            case VELOCITY: 
            case ACCELERATION: {
                this.vectorType = newViewModel;
                this.setVectorVisible(true, newShapes);
                break;
            }
            case HIDEVECTORS: {
                this.vectorType = RendererCache.ViewModel.HIDEVECTORS;
                this.setVectorVisible(false, newShapes);
                break;
            }
            case UNIT: 
            case RELATIVE: 
            case ABSOLUTE: {
                this.vectorLength = newViewModel;
                this.setVectorVisible(true, newShapes);
                break;
            }
            case SHOWHYDROGENS: {
                if (this.atomType.atomicNumber != 1) break;
                return;
            }
            case HIDEHYDROGENS: {
                if (this.atomType.atomicNumber != 1) break;
                this.viewModel = RendererCache.ViewModel.INVISIBLE;
                this.vectorType = RendererCache.ViewModel.HIDEVECTORS;
                this.setSphereVisible(false, newShapes);
                this.setVectorVisible(false, newShapes);
                return;
            }
            case RESTRICT: {
                if (this.isSelected()) break;
                this.viewModel = RendererCache.ViewModel.INVISIBLE;
                this.vectorType = RendererCache.ViewModel.HIDEVECTORS;
                this.setSphereVisible(false, newShapes);
                this.setVectorVisible(false, newShapes);
                return;
            }
            case DETAIL: {
                double newradius;
                int newdetail = RendererCache.detail;
                if (newdetail != this.detail) {
                    this.detail = newdetail;
                    if (this.sphere != null) {
                        Geometry geom = RendererCache.getSphereGeom(this.detail);
                        this.sphere.removeAllGeometries();
                        this.sphere.addGeometry(geom);
                    }
                }
                if ((newradius = RendererCache.radius) == this.radius) break;
                this.radius = newradius;
                this.setView(this.viewModel, newShapes);
                break;
            }
            case FILL: 
            case POINTS: 
            case LINES: {
                this.polygonType = newViewModel;
                this.appearance = RendererCache.appearanceFactory(this.currentCol, this.polygonType);
                if (this.viewModel != RendererCache.ViewModel.INVISIBLE) {
                    this.setSphereVisible(true, newShapes);
                }
                if (this.vectorType == RendererCache.ViewModel.HIDEVECTORS) break;
                this.setVectorVisible(true, newShapes);
            }
        }
    }

    public void setXYZIndex(int index) {
        this.xyzindex = index;
    }

    public String toMultipoleString() {
        if (this.multipoleType == null || this.globalDipole == null || this.globalQuadrupole == null) {
            return null;
        }
        StringBuffer multipoleBuffer = new StringBuffer(this.toString());
        multipoleBuffer.append(String.format("\n%11$s % 7.5f\n%11$s % 7.5f % 7.5f % 7.5f\n%11$s % 7.5f\n%11$s % 7.5f % 7.5f\n%11$s % 7.5f % 7.5f % 7.5f", this.multipoleType.charge, this.globalDipole[0], this.globalDipole[1], this.globalDipole[2], this.globalQuadrupole[0][0], this.globalQuadrupole[1][0], this.globalQuadrupole[1][1], this.globalQuadrupole[2][0], this.globalQuadrupole[2][1], this.globalQuadrupole[2][2], "                 "));
        return multipoleBuffer.toString();
    }

    public String toShortString() {
        StringBuffer s = new StringBuffer("" + this.xyzindex);
        s.append("-");
        s.append(this.id);
        return s.toString();
    }

    @Override
    public String toString() {
        return String.format("%7d - %s (%7.3f, %7.3f, %7.3f)", this.xyzindex, this.id, this.positionVector3d.x, this.positionVector3d.y, this.positionVector3d.z);
    }

    @Override
    public void update() {
        if (this.stale) {
            this.updateSphere();
            this.updateVector();
            this.stale = false;
        }
    }

    public void updateSphere() {
        if (this.branchGroup != null && this.viewModel != RendererCache.ViewModel.INVISIBLE) {
            this.transform3D.setTranslation(this.positionVector3d);
            this.transform3D.setScale(this.scale);
            this.transformGroup.setTransform(this.transform3D);
            if (this.colorModel == RendererCache.ColorModel.VECTORMAGNITUDE) {
                this.setColor(this.colorModel, null, null);
            }
        }
    }

    public void updateVector() {
        if (this.vectorBranchGroup != null && this.vectorType != RendererCache.ViewModel.HIDEVECTORS) {
            this.setCurrentVector();
            if (this.vectorType == RendererCache.ViewModel.HIDEVECTORS) {
                return;
            }
            double[] v = this.currentVector;
            this.setVectorLength();
            double mag = this.currentLength * RendererCache.vectorScale;
            angle = VectorMath.angle(v, y);
            VectorMath.cross(y, v, ycrossv);
            Atom.ycrossv[3] = angle;
            axisAngle.set(ycrossv);
            this.cylT3D.setRotation(axisAngle);
            VectorMath.norm(v, shapeVector);
            VectorMath.scalar(shapeVector, mag * 0.5, shapeVector);
            transV3D.set(shapeVector);
            transV3D.add((Tuple3d)this.positionVector3d);
            this.cylT3D.setTranslation(transV3D);
            scaleV3D.set(0.05, mag, 0.05);
            this.cylT3D.setScale(scaleV3D);
            this.cylTG.setTransform(this.cylT3D);
            this.coneT3D.setRotation(axisAngle);
            VectorMath.norm(shapeVector, shapeVector);
            VectorMath.scalar(shapeVector, mag + 0.05, shapeVector);
            transV3D.set(shapeVector);
            transV3D.add((Tuple3d)this.positionVector3d);
            this.coneT3D.setTranslation(transV3D);
            this.coneTG.setTransform(this.coneT3D);
        }
    }

    static {
        int i;
        vectorAppearance = null;
        point3d = new Point3d();
        point2d = new Point2d();
        y = new double[]{0.0, 1.0, 0.0};
        ycrossv = new double[4];
        shapeVector = new double[3];
        scaleV3D = new Vector3d();
        transV3D = new Vector3d();
        axisAngle = new AxisAngle4d();
        AtomColor = new Hashtable();
        AtomVDW = new Hashtable();
        hybridTable = new Hashtable();
        AtomColor.put(0, RendererCache.RED);
        AtomColor.put(1, RendererCache.WHITE);
        AtomColor.put(2, RendererCache.GREEN);
        AtomColor.put(3, RendererCache.MAGENTA);
        AtomColor.put(4, RendererCache.MAGENTA);
        AtomColor.put(5, RendererCache.MAGENTA);
        AtomColor.put(6, RendererCache.GRAY);
        AtomColor.put(7, RendererCache.BLUE);
        AtomColor.put(8, RendererCache.RED);
        AtomColor.put(9, RendererCache.GREEN);
        AtomColor.put(10, RendererCache.GREEN);
        AtomColor.put(11, RendererCache.MAGENTA);
        AtomColor.put(12, RendererCache.MAGENTA);
        AtomColor.put(13, RendererCache.MAGENTA);
        AtomColor.put(14, RendererCache.GRAY);
        AtomColor.put(15, RendererCache.ORANGE);
        AtomColor.put(16, RendererCache.YELLOW);
        AtomColor.put(17, RendererCache.GREEN);
        AtomColor.put(18, RendererCache.GREEN);
        for (i = 19; i < 109; ++i) {
            if (i != 36 && i != 54 && i != 86) {
                AtomColor.put(i, RendererCache.MAGENTA);
                continue;
            }
            AtomColor.put(i, RendererCache.GREEN);
        }
        AtomVDW.put(0, Float.valueOf(1.0f));
        AtomVDW.put(1, Float.valueOf(1.2f));
        AtomVDW.put(2, Float.valueOf(1.22f));
        AtomVDW.put(3, Float.valueOf(0.78f));
        AtomVDW.put(4, Float.valueOf(0.34f));
        AtomVDW.put(5, Float.valueOf(2.08f));
        AtomVDW.put(6, Float.valueOf(1.85f));
        AtomVDW.put(7, Float.valueOf(1.54f));
        AtomVDW.put(8, Float.valueOf(1.4f));
        AtomVDW.put(9, Float.valueOf(1.35f));
        AtomVDW.put(10, Float.valueOf(1.6f));
        AtomVDW.put(11, Float.valueOf(0.98f));
        AtomVDW.put(12, Float.valueOf(0.78f));
        AtomVDW.put(13, Float.valueOf(0.57f));
        AtomVDW.put(14, Float.valueOf(2.0f));
        AtomVDW.put(15, Float.valueOf(1.9f));
        AtomVDW.put(16, Float.valueOf(1.85f));
        AtomVDW.put(17, Float.valueOf(1.81f));
        AtomVDW.put(18, Float.valueOf(1.91f));
        AtomVDW.put(19, Float.valueOf(1.33f));
        AtomVDW.put(20, Float.valueOf(1.06f));
        AtomVDW.put(21, Float.valueOf(0.91f));
        AtomVDW.put(22, Float.valueOf(0.83f));
        AtomVDW.put(23, Float.valueOf(0.82f));
        AtomVDW.put(24, Float.valueOf(2.0f));
        AtomVDW.put(25, Float.valueOf(2.0f));
        AtomVDW.put(26, Float.valueOf(2.0f));
        AtomVDW.put(27, Float.valueOf(2.0f));
        AtomVDW.put(28, Float.valueOf(2.0f));
        AtomVDW.put(29, Float.valueOf(2.0f));
        AtomVDW.put(30, Float.valueOf(2.0f));
        AtomVDW.put(31, Float.valueOf(2.0f));
        AtomVDW.put(32, Float.valueOf(2.0f));
        AtomVDW.put(33, Float.valueOf(2.0f));
        AtomVDW.put(34, Float.valueOf(2.0f));
        AtomVDW.put(35, Float.valueOf(1.95f));
        AtomVDW.put(36, Float.valueOf(1.89f));
        for (i = 37; i < 109; ++i) {
            AtomVDW.put(i, Float.valueOf(2.0f));
        }
        hybridTable.put("1", 1);
        hybridTable.put("6", 4);
        hybridTable.put("7", 3);
        hybridTable.put("8", 2);
        hybridTable.put("15", 4);
        hybridTable.put("16", 2);
        hybridTable.put("19", 0);
        hybridTable.put("26", 8);
    }

    public static enum AtomName {
        H,
        He,
        Li,
        Be,
        B,
        C,
        N,
        O,
        F,
        Ne,
        Na,
        Mg,
        Al,
        Si,
        P,
        S,
        Cl,
        Ar,
        K,
        Ca,
        Sc,
        Ti,
        V,
        Cr,
        Mn,
        Fe,
        Co,
        Ni,
        Cu,
        Zn,
        Ga,
        Ge,
        As,
        Se,
        Br,
        Kr,
        Rb,
        Sr,
        Y,
        Zr,
        Nb,
        Mo,
        Tc,
        Ru,
        Rh,
        Pd,
        Ag,
        Cd,
        In,
        Sn,
        Sb,
        Te,
        I,
        Xe,
        Cs,
        Ba,
        La,
        Ce,
        Pr,
        Nd,
        Pm,
        Sm,
        Eu,
        Gd,
        Tb,
        Dy,
        Ho,
        Er,
        Tm,
        Yb,
        Lu,
        Hf,
        Ta,
        W,
        Re,
        Os,
        Ir,
        Pt,
        Au,
        Hg,
        Tl,
        Pb,
        Po,
        At,
        Rn,
        Fr,
        Ra,
        Ac,
        Th,
        Pa,
        U,
        Np,
        Pu,
        Am,
        Cm,
        Bk,
        Cf,
        Es,
        Fm,
        Md,
        No,
        Lr;

    }
}

