/*
 * Decompiled with CFR 0.152.
 */
package ffe.lang;

import ffe.lang.Atom;
import ffe.lang.Bond;
import ffe.lang.ValenceTerm;
import ffe.lang.VectorMath;

public class Angle
extends ValenceTerm {
    private static final long serialVersionUID = 1L;
    private static double[] vi = new double[3];
    private static double[] vj = new double[3];
    private static double[] vk = new double[3];

    public Angle(Bond b1, Bond b2) {
        this.bonds = new Bond[2];
        this.bonds[0] = b1;
        this.bonds[1] = b2;
        b1.setAngleWith(b2);
        b2.setAngleWith(b1);
        Atom a2 = b1.getCommonAtom(b2);
        Atom a1 = b1.get1_2(a2);
        Atom a3 = b2.get1_2(a2);
        this.atoms = new Atom[3];
        this.atoms[0] = a1;
        this.atoms[1] = a2;
        this.atoms[2] = a3;
        a1.setAngle(this);
        a2.setAngle(this);
        a3.setAngle(this);
        this.setID_Key(false);
    }

    public Atom get1_3(Atom a) {
        if (a == this.atoms[0]) {
            return this.atoms[2];
        }
        if (a == this.atoms[2]) {
            return this.atoms[0];
        }
        return null;
    }

    public Bond getCommonBond(Angle a) {
        if (a == this || a == null) {
            return null;
        }
        if (a.bonds[0] == this.bonds[0]) {
            return this.bonds[0];
        }
        if (a.bonds[0] == this.bonds[1]) {
            return this.bonds[1];
        }
        if (a.bonds[1] == this.bonds[0]) {
            return this.bonds[0];
        }
        if (a.bonds[1] == this.bonds[1]) {
            return this.bonds[1];
        }
        return null;
    }

    public Bond getOtherBond(Bond b) {
        if (b == this.bonds[0]) {
            return this.bonds[1];
        }
        if (b == this.bonds[1]) {
            return this.bonds[0];
        }
        return null;
    }

    @Override
    public void update() {
        this.atoms[0].getXYZ(vi);
        this.atoms[1].getXYZ(vj);
        this.atoms[2].getXYZ(vk);
        this.setValue(Math.toDegrees(VectorMath.bondAngle(vi, vj, vk)));
    }
}

