/*
 * Decompiled with CFR 0.152.
 */
package ffe.core;

import ffe.core.MainPanel;
import ffe.lang.MolecularAssembly;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class Trajectory
implements ActionListener {
    private MolecularAssembly molecularSystem;
    private MainPanel mainPanel;
    private Timer timer;
    private int delay = 50;
    private int desiredspeed = 20;
    private int cycle = 1;
    private int sign = 1;
    private int skip = 1;
    private boolean oscillate = false;

    public Trajectory(MolecularAssembly mol, MainPanel f) {
        this.molecularSystem = mol;
        this.mainPanel = f;
        this.timer = new Timer(this.delay, this);
        this.timer.setCoalesce(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.mainPanel.getGraphics3D().isCacheFull()) {
            return;
        }
        this.cycle = this.advance(this.skip * this.sign);
        this.setFrame(this.cycle);
    }

    private int advance(int adv) {
        if (this.molecularSystem != null) {
            this.cycle = this.molecularSystem.getCurrentCycle();
            int frame = this.cycle + adv;
            if (frame <= 0) {
                this.sign = 1;
                frame = this.oscillate ? -adv - this.cycle : this.molecularSystem.getCycles() + (adv + this.cycle);
            } else if (frame > this.molecularSystem.getCycles()) {
                if (this.oscillate) {
                    frame = this.molecularSystem.getCycles() + (-adv + this.cycle);
                    this.sign = -1;
                } else {
                    this.sign = 1;
                    frame = this.cycle - this.molecularSystem.getCycles() + adv;
                }
            }
            return frame;
        }
        return 0;
    }

    public void back() {
        this.setFrame(this.getFrame() - 1);
    }

    public void forward() {
        this.setFrame(this.getFrame() + 1);
    }

    public int getFrame() {
        return this.molecularSystem.getCurrentCycle();
    }

    public MolecularAssembly getFSystem() {
        return this.molecularSystem;
    }

    public boolean getOscillate() {
        return this.oscillate;
    }

    public int getRate() {
        return this.desiredspeed;
    }

    public int getSkip() {
        return this.skip;
    }

    public void rewind() {
        this.setFrame(1);
    }

    public void setFrame(int f) {
        if (this.molecularSystem != null) {
            this.molecularSystem.setCurrentCycle(f);
            this.mainPanel.getGraphics3D().updateScene(this.molecularSystem, true, false, null, false, null);
            this.mainPanel.getHierarchy().updateStatus();
        }
    }

    public void setOscillate(boolean o) {
        this.oscillate = o;
    }

    public void setRate(int s) {
        if (s > 0 && s <= 100) {
            this.desiredspeed = s;
            this.delay = 1000 / s;
            this.timer.setDelay(this.delay);
        }
    }

    public void setSkip(int s) {
        if (s < 1) {
            return;
        }
        this.skip = s % this.molecularSystem.getAtomList().size();
    }

    public void start() {
        this.timer.start();
    }

    public void stop() {
        this.timer.stop();
    }
}

