/*
 * Decompiled with CFR 0.152.
 */
package ffe.core;

import ffe.core.FFESystem;
import ffe.core.FileOpener;
import ffe.core.MainPanel;
import ffe.lang.Atom;
import ffe.tinker.FFEClient;
import ffe.tinker.SimulationFilter;
import ffe.tinker.TinkerSystem;
import ffe.tinker.TinkerUpdate;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import javax.swing.Timer;

public class TinkerSimulation
implements ActionListener {
    private FFEClient client;
    private SimulationFilter simulationFilter;
    private InetSocketAddress address;
    private Thread job = null;
    private boolean finished = false;
    private Thread reader;
    private MainPanel mainPanel;
    private FFESystem system;
    private TinkerUpdate tinkerUpdate = null;
    private boolean firstUpdate = true;
    private Timer timer;
    private int delay = 10;
    private double time = 0.0;
    private int step = 0;

    public TinkerSimulation(FFESystem s, Thread j, MainPanel f, InetSocketAddress a) {
        this.system = s;
        this.job = j;
        this.mainPanel = f;
        this.address = a;
        if (this.address == null) {
            this.finished = true;
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.connect()) {
            return;
        }
        if (this.system == null) {
            TinkerSystem sys = this.client.getSystem();
            if (sys != null) {
                if (this.simulationFilter == null) {
                    if (this.system == null) {
                        this.system = new FFESystem("Simulation", null, null, true);
                    }
                    this.simulationFilter = new SimulationFilter(sys, this.system);
                    FileOpener openFile = new FileOpener(this.simulationFilter, this.mainPanel);
                    this.reader = new Thread(openFile);
                    this.reader.start();
                } else if (this.simulationFilter.fileRead()) {
                    this.system = (FFESystem)this.simulationFilter.getMolecularSystem();
                    this.simulationFilter = null;
                }
            }
        } else {
            if (this.tinkerUpdate == null || this.tinkerUpdate.read) {
                this.tinkerUpdate = this.client.getUpdate();
            }
            if (this.tinkerUpdate != null && !this.tinkerUpdate.read && !this.mainPanel.getGraphics3D().isSceneRendering()) {
                this.update();
            }
        }
    }

    public boolean connect() {
        if (this.isFinished()) {
            return false;
        }
        if (this.isConnected()) {
            return true;
        }
        if (this.timer == null) {
            this.timer = new Timer(this.delay, this);
            this.timer.setCoalesce(true);
            this.timer.setDelay(5);
            this.timer.start();
        }
        if (this.client == null) {
            this.client = new FFEClient(this.address);
        }
        this.client.connect();
        if (this.client.isConnected()) {
            this.timer.setDelay(this.delay);
            return true;
        }
        return false;
    }

    public FFESystem getFSystem() {
        return this.system;
    }

    public boolean isConnected() {
        return this.client != null && this.client.isConnected();
    }

    public boolean isFinished() {
        if (this.client != null && this.client.isClosed()) {
            this.finished = true;
        }
        if (this.job != null && !this.job.isAlive()) {
            this.finished = true;
        }
        if (this.finished) {
            if (this.timer != null) {
                this.timer.stop();
            }
            this.update();
            this.release();
        }
        return this.finished;
    }

    public void release() {
        this.finished = true;
        if (this.timer != null) {
            this.timer.stop();
        }
        if (this.client != null) {
            this.client.release();
        }
        if (this.system != null) {
            this.system.setSimulation(TinkerUpdate.NONE);
        }
        this.mainPanel.getMainMenu().setConnect(true);
    }

    private void update() {
        if (this.system.isStale()) {
            return;
        }
        if (this.tinkerUpdate == null || this.tinkerUpdate.read) {
            return;
        }
        this.system.setSimulation(this.tinkerUpdate.type);
        ArrayList<Atom> atoms = this.system.getAtomList();
        int n = atoms.size();
        if (this.tinkerUpdate.numatoms != n) {
            return;
        }
        this.system.setEnergy(this.tinkerUpdate.energy);
        if (this.tinkerUpdate.type == TinkerUpdate.SIMULATION) {
            if (this.tinkerUpdate.time == this.time) {
                this.tinkerUpdate.read = true;
                return;
            }
            this.time = this.tinkerUpdate.time;
            this.system.setTime(this.time);
            this.system.setTemperature(this.tinkerUpdate.temperature);
        } else if (this.tinkerUpdate.type == TinkerUpdate.OPTIMIZATION) {
            if (this.tinkerUpdate.step == this.step) {
                this.tinkerUpdate.read = true;
                return;
            }
            this.step = this.tinkerUpdate.step;
            this.system.setStep(this.step);
        }
        Atom.setMaxForce(0.0);
        Atom.setMaxAcceleration(0.0);
        Atom.setMaxVelocity(0.0);
        Atom.setMaxInduced(0.0);
        double[] d = new double[3];
        for (Atom a : atoms) {
            int index = a.getXYZIndex() - 1;
            d[0] = this.tinkerUpdate.coordinates[0][index];
            d[1] = this.tinkerUpdate.coordinates[1][index];
            d[2] = this.tinkerUpdate.coordinates[2][index];
            a.moveTo(d);
            if (this.tinkerUpdate.amoeba) {
                a.setInducedDipole(-1.0 * this.tinkerUpdate.induced[0][index], -1.0 * this.tinkerUpdate.induced[1][index], -1.0 * this.tinkerUpdate.induced[2][index]);
            }
            if (this.tinkerUpdate.type == TinkerUpdate.SIMULATION) {
                a.setVeclocity(this.tinkerUpdate.velocity[0][index], this.tinkerUpdate.velocity[1][index], this.tinkerUpdate.velocity[2][index]);
                a.setAcceleration(this.tinkerUpdate.acceleration[0][index], this.tinkerUpdate.acceleration[1][index], this.tinkerUpdate.acceleration[2][index]);
                continue;
            }
            if (this.tinkerUpdate.type != TinkerUpdate.OPTIMIZATION) continue;
            a.setForce(-1.0 * this.tinkerUpdate.gradients[0][index], -1.0 * this.tinkerUpdate.gradients[1][index], -1.0 * this.tinkerUpdate.gradients[2][index]);
        }
        if (this.firstUpdate) {
            this.system.center();
            this.firstUpdate = false;
        }
        this.mainPanel.getGraphics3D().updateScene(this.system, true, false, null, false, null);
        this.mainPanel.getHierarchy().updateStatus();
        this.mainPanel.getHierarchy().repaint();
        this.tinkerUpdate.read = true;
        this.tinkerUpdate = this.client.getUpdate();
    }
}

