/*
 * Decompiled with CFR 0.152.
 */
package ffe.core;

import ffe.core.MainPanel;
import ffe.shell.Console;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class ModelingShell
extends Console {
    private static final long serialVersionUID = 1L;
    private MainPanel mainPanel;

    public ModelingShell(MainPanel m) {
        this.mainPanel = m;
        this.setVariable("dat", this.mainPanel.getHierarchy());
        this.setVariable("cmd", this.mainPanel);
        this.setVariable("vis", this.mainPanel.getGraphics3D());
        this.setVariable("job", this.mainPanel.getModelingPanel());
        this.setVariable("sh", this);
        this.setVariable("ffe", MainPanel.ffeDir.getAbsolutePath());
        this.setVariable("tinker", MainPanel.tinkerDir.getAbsolutePath());
        this.run();
        JFrame frame = this.getFrame();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ModelingShell.this.mainPanel.exit();
                System.exit(0);
            }
        });
        URL iconURL = this.getClass().getClassLoader().getResource("ffe/icons/icon64.png");
        ImageIcon icon = new ImageIcon(iconURL);
        ((Frame)frame).setIconImage(icon.getImage());
        this.loadPrefs();
    }

    public void loadPrefs() {
        Preferences prefs = Preferences.userNodeForPackage(ModelingShell.class);
        int fontSize = prefs.getInt("ModelingShell_fontSize", 12);
        String[] b = prefs.get("ModelingShell_background", "0 0 0").split(" +");
        String[] f = prefs.get("ModelingShell_foreground", "255 255 255").split(" +");
    }

    public void savePrefs() {
        Preferences prefs = Preferences.userNodeForPackage(ModelingShell.class);
    }

    public void setMeasurement(String measurement, double d) {
        try {
            this.appendOutput(measurement, this.getOutputStyle());
        }
        catch (Exception e) {
            System.err.println(" " + String.valueOf(e));
        }
    }

    public void sync() {
    }

    public String toString() {
        return "Modeling Shell";
    }
}

