/*
 * Decompiled with CFR 0.152.
 */
package ffe.core;

import ffe.core.FFEExec;
import ffe.core.FFESystem;
import ffe.core.MainPanel;
import ffe.lang.Keyword;
import ffe.lang.Residue;
import ffe.lang.Utilities;
import ffe.parsers.SystemFilter;
import ffe.tinker.DTDResolver;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.SystemUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ModelingPanel
extends JPanel
implements ActionListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    private MainPanel mainPanel;
    private Logger logger = Logger.getLogger("ffe");
    private FFESystem activeSystem = null;
    private Utilities.FileType activeFileType = null;
    private String activeCommand = null;
    private Vector<Utilities.FileType> commandFileTypes = new Vector();
    private String commandActions = "NONE";
    private Vector<Thread> executingCommands = new Vector();
    private JComboBox logSettings = new JComboBox();
    private String logString = null;
    private NodeList commandList;
    private JComboBox xyzCommands;
    private JComboBox intCommands;
    private JComboBox arcCommands;
    private JComboBox pdbCommands;
    private JComboBox anyCommands;
    private JComboBox currentCommandBox;
    private JPanel commandPanel;
    private JToolBar toolBar;
    private JSplitPane splitPane;
    private JLabel statusLabel;
    private JTabbedPane optionsTabbedPane;
    private JScrollPane descriptScrollPane;
    private JTextArea descriptTextArea;
    private JCheckBoxMenuItem descriptCheckBox;
    private Vector<JLabel> conditionals = new Vector();
    private JTextArea commandTextArea;
    private JComboBox acidComboBox = new JComboBox();
    private JComboBox conformationComboBox;
    private JTextField acidTextField = new JTextField();
    private JTextArea acidTextArea = new JTextArea();
    private JScrollPane acidScrollPane = null;
    private JPanel aminoPanel = null;
    private JPanel nucleicPanel = null;
    private FlowLayout flowLayout = new FlowLayout(0, 5, 5);
    private BorderLayout borderLayout = new BorderLayout();
    private Border etchedBorder = BorderFactory.createEtchedBorder(0);
    private JTextField sizer = new JTextField(20);

    public ModelingPanel(MainPanel f) {
        this.mainPanel = f;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent evt) {
        ModelingPanel modelingPanel = this;
        synchronized (modelingPanel) {
            String actionCommand = evt.getActionCommand();
            if (actionCommand == "TinkerCommand") {
                JComboBox jcb = (JComboBox)this.toolBar.getComponentAtIndex(3);
                String com = jcb.getSelectedItem().toString();
                if (!com.equals(this.activeCommand)) {
                    this.activeCommand = com.toLowerCase();
                    this.loadCommand();
                }
            } else if (actionCommand == "LogSettings") {
                this.loadLogSettings();
                this.statusLabel.setText("  " + this.createCommandInput());
            } else if (actionCommand == "Launch") {
                this.executeCommand();
            } else if (actionCommand == "NUCLEIC" || actionCommand == "PROTEIN") {
                this.builderCommandEvent(evt);
            } else if (actionCommand == "Conditional") {
                this.conditionalCommandEvent(evt);
            } else if (actionCommand == "End") {
                this.setEnd();
            } else if (actionCommand == "Delete") {
                this.deleteLogs();
            } else if (actionCommand == "Description") {
                JCheckBoxMenuItem box = (JCheckBoxMenuItem)evt.getSource();
                this.setDivider(box.isSelected());
            } else {
                this.logger.warning("ModelingPanel ActionCommand not recognized: " + String.valueOf(evt));
            }
        }
    }

    private void builderCommandEvent(ActionEvent evt) {
        Object s;
        int i;
        JButton button = (JButton)evt.getSource();
        String arg = evt.getActionCommand();
        int index = this.acidComboBox.getSelectedIndex();
        String selected = (String)this.acidComboBox.getItemAt(index);
        if (button.getText() == "Remove") {
            if (this.acidComboBox.getItemCount() > 0) {
                this.acidComboBox.removeItemAt(index);
                --index;
            }
        } else if (button.getText() == "Edit") {
            String entry = new String(this.acidTextField.getText());
            if (!entry.equals("")) {
                String[] s2 = entry.trim().split(" +");
                String newResidue = s2[0].toUpperCase();
                if (arg == "NUCLEIC") {
                    try {
                        Residue.NA3.valueOf(newResidue);
                        this.acidComboBox.removeItemAt(index);
                        this.acidComboBox.insertItemAt(index + " " + entry, index);
                    }
                    catch (Exception exception) {}
                } else {
                    try {
                        Residue.AA3.valueOf(newResidue);
                        this.acidComboBox.removeItemAt(index);
                        this.acidComboBox.insertItemAt(index + " " + entry, index);
                    }
                    catch (Exception exception) {}
                }
            }
        } else if (button.getText() == "Reset") {
            this.acidComboBox.removeAllItems();
            this.acidTextArea.setText("");
        } else {
            String newResidue = new String(button.getText());
            if (arg == "PROTEIN") {
                String c = (String)this.conformationComboBox.getSelectedItem();
                if (!c.toUpperCase().startsWith("DEFAULT")) {
                    c = c.substring(c.indexOf("[") + 1, c.indexOf("]"));
                    newResidue = new String(newResidue + " " + c);
                }
                this.acidComboBox.insertItemAt(index + " " + newResidue, index + 1);
                ++index;
            } else if (!newResidue.equalsIgnoreCase("MOL")) {
                this.acidComboBox.insertItemAt(index + " " + newResidue, index + 1);
                ++index;
            } else if (!selected.equalsIgnoreCase("MOL")) {
                this.acidComboBox.insertItemAt(index + " " + newResidue, index + 1);
                ++index;
            }
        }
        StringBuffer sequence = new StringBuffer();
        for (i = 0; i < this.acidComboBox.getItemCount(); ++i) {
            s = ((String)this.acidComboBox.getItemAt(i)).trim().toUpperCase().split(" +");
            if (((String[])s).length <= 1) continue;
            if (s[1].equalsIgnoreCase("MOL")) {
                sequence.append((String)s[1] + "\n");
                continue;
            }
            sequence.append((String)s[1] + " ");
        }
        this.acidTextArea.setText(sequence.toString());
        for (i = 0; i < this.acidComboBox.getItemCount(); ++i) {
            s = (String)this.acidComboBox.getItemAt(i);
            s = ((String)s).substring(((String)s).indexOf(" "), ((String)s).length()).trim();
            this.acidComboBox.removeItemAt(i);
            this.acidComboBox.insertItemAt(i + 1 + " " + (String)s, i);
        }
        if (index < 0) {
            index = 0;
        }
        if (index > this.acidComboBox.getItemCount() - 1) {
            index = this.acidComboBox.getItemCount() - 1;
        }
        this.acidComboBox.setSelectedIndex(index);
        String s3 = (String)this.acidComboBox.getItemAt(index);
        if (s3 != null) {
            this.acidTextField.setText(s3.substring(s3.indexOf(" "), s3.length()).trim());
        } else {
            this.acidTextField.setText("");
        }
    }

    private void conditionalCommandEvent(ActionEvent evt) {
        Object source = evt.getSource();
        if (source instanceof JRadioButton) {
            JRadioButton jrb = (JRadioButton)source;
            String selection = jrb.getText().toLowerCase();
            Enumeration<JLabel> e = this.conditionals.elements();
            while (e.hasMoreElements()) {
                JLabel label = e.nextElement();
                JTextField jtf = (JTextField)label.getLabelFor();
                String cupon = label.getName().toLowerCase();
                if (cupon.indexOf(selection) >= 0 && jrb.isSelected()) {
                    label.setEnabled(true);
                    jtf.setEnabled(true);
                    continue;
                }
                label.setEnabled(false);
                jtf.setEnabled(false);
            }
        } else if (source instanceof JCheckBox) {
            JCheckBox jcb = (JCheckBox)source;
            String selection = jcb.getText().toLowerCase();
            Enumeration<JLabel> e = this.conditionals.elements();
            while (e.hasMoreElements()) {
                JLabel label = e.nextElement();
                String cupon = label.getName().toLowerCase();
                JTextField jtf = (JTextField)label.getLabelFor();
                if (cupon.indexOf(selection) >= 0 && jcb.isSelected()) {
                    label.setEnabled(true);
                    jtf.setEnabled(true);
                    continue;
                }
                label.setEnabled(false);
                jtf.setEnabled(false);
            }
        }
        this.statusLabel.setText("  " + this.createCommandInput());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String createCommandInput() {
        StringBuffer commandlineparams = new StringBuffer(MainPanel.tinkerDir.getAbsolutePath() + File.separator + "bin" + File.separator + this.activeCommand.toLowerCase());
        if (SystemUtils.IS_OS_WINDOWS) {
            commandlineparams.insert(0, "\"\"");
            commandlineparams.append('\"');
        } else {
            for (int i = 1; i < commandlineparams.length(); ++i) {
                if (commandlineparams.charAt(i) != ' ' || commandlineparams.charAt(i - 1) == '\\') continue;
                commandlineparams.insert(i, '\\');
                ++i;
            }
        }
        commandlineparams.append(' ');
        if (!this.activeCommand.equalsIgnoreCase("Protein") && !this.activeCommand.equalsIgnoreCase("Nucleic")) {
            File file = this.activeSystem.getFile();
            if (file == null) return null;
            String absolutePath = file.getAbsolutePath();
            commandlineparams.append("\"" + absolutePath + "\" ");
        } else if (this.activeCommand.equalsIgnoreCase("Protein")) {
            commandlineparams.append(" < protein.in ");
        } else if (this.activeCommand.equalsIgnoreCase("Nucleic")) {
            commandlineparams.append(" < nucleic.in ");
        }
        this.commandTextArea.setText("");
        int numparams = this.optionsTabbedPane.getTabCount();
        for (int i = 0; i < numparams; ++i) {
            boolean newLine = true;
            StringBuffer optionString = new StringBuffer();
            JPanel optionPanel = (JPanel)this.optionsTabbedPane.getComponentAt(i);
            int numOptions = optionPanel.getComponentCount();
            String title = this.optionsTabbedPane.getTitleAt(i);
            if (title.equalsIgnoreCase("Sequence")) {
                for (int k = 0; k < this.acidComboBox.getItemCount(); ++k) {
                    if (k != 0) {
                        optionString.append("\n");
                    }
                    String s = (String)this.acidComboBox.getItemAt(k);
                    s = s.substring(s.indexOf(" "), s.length()).trim();
                    optionString.append(s);
                }
                if (this.activeCommand.equalsIgnoreCase("NUCLEIC")) {
                    optionString.append("\n");
                }
            } else {
                JTextField jtf;
                JPanel valuePanel = (JPanel)optionPanel.getComponent(numOptions - 1);
                int numValues = valuePanel.getComponentCount();
                for (int j = 0; j < numValues; ++j) {
                    Component value = valuePanel.getComponent(j);
                    if (value instanceof JCheckBox) {
                        JCheckBox jcbox = (JCheckBox)value;
                        if (!jcbox.isSelected()) continue;
                        optionString.append(jcbox.getText());
                        continue;
                    }
                    if (value instanceof JTextField) {
                        JTextField jtfield = (JTextField)value;
                        if (jtfield.getName() != null) {
                            if (jtfield.getName().equalsIgnoreCase("APPEND")) {
                                newLine = false;
                                optionString.append(jtfield.getText());
                                optionString.append(" ");
                                continue;
                            }
                            if (jtfield.getName().equalsIgnoreCase("SPLIT")) {
                                String[] inputs;
                                for (String input : inputs = jtfield.getText().split(" +")) {
                                    optionString.append(input + "\n");
                                }
                                continue;
                            }
                            optionString.append(jtfield.getText());
                            continue;
                        }
                        optionString.append(jtfield.getText());
                        continue;
                    }
                    if (value instanceof JComboBox) {
                        FFESystem system;
                        File file;
                        JComboBox jcb = (JComboBox)value;
                        Object object = jcb.getSelectedItem();
                        if (!(object instanceof FFESystem) || (file = (system = (FFESystem)object).getFile()) == null) continue;
                        String absolutePath = file.getAbsolutePath();
                        optionString.append(absolutePath);
                        continue;
                    }
                    if (!(value instanceof JRadioButton)) continue;
                    JRadioButton jrbutton = (JRadioButton)value;
                    if (jrbutton.isSelected()) {
                        if (!jrbutton.getText().equalsIgnoreCase("NONE")) {
                            optionString.append(jrbutton.getText());
                        }
                        if (title.equalsIgnoreCase("C-CAP")) {
                            optionString.append("\n");
                        }
                    }
                    if (jrbutton.getName() == null || !jrbutton.getName().equalsIgnoreCase("APPEND")) continue;
                    newLine = false;
                    optionString.append(" ");
                }
                if (optionPanel.getComponentCount() == 3 && (jtf = (JTextField)(valuePanel = (JPanel)optionPanel.getComponent(1)).getComponent(1)).isEnabled()) {
                    String conditionalInput = jtf.getText();
                    String postProcess = jtf.getName();
                    if (postProcess != null && postProcess.equalsIgnoreCase("ATOMPAIRS")) {
                        String[] tokens = conditionalInput.split(" +");
                        StringBuffer atomPairs = new StringBuffer();
                        int atomNumber = 0;
                        for (String token : tokens) {
                            atomPairs.append(token);
                            if (atomNumber++ % 2 == 0) {
                                atomPairs.append(" ");
                                continue;
                            }
                            atomPairs.append("\n");
                        }
                        conditionalInput = atomPairs.toString();
                    }
                    optionString.append("\n" + conditionalInput);
                }
            }
            if (optionString.length() <= 0) continue;
            this.commandTextArea.append(optionString.toString());
            if (!newLine) continue;
            this.commandTextArea.append("\n");
        }
        String commandInput = this.commandTextArea.getText();
        if (commandInput != null && !commandInput.trim().equalsIgnoreCase("") && this.activeSystem != null && this.activeSystem.getParent() != null) {
            commandlineparams.append(" < \"" + this.activeSystem.getKeyFile().getParent() + File.separator + this.activeCommand.toLowerCase() + ".in\" ");
        }
        if (this.activeSystem == null && (this.activeCommand.equalsIgnoreCase("Protein") || this.activeCommand.equalsIgnoreCase("Nucleic"))) {
            commandlineparams.append(" < \"/Users/ponder/MolecularTools" + File.separator + this.activeCommand.toLowerCase() + ".in\" ");
        }
        if (!this.commandFileTypes.contains((Object)Utilities.FileType.ANY) && this.activeSystem != null && this.activeSystem.getKeyFile() != null) {
            commandlineparams.append(" -k \"" + this.activeSystem.getKeyFile().getAbsolutePath() + "\"");
        }
        commandlineparams.append(this.logString);
        if (!SystemUtils.IS_OS_WINDOWS) return commandlineparams.toString();
        commandlineparams.append('\"');
        return commandlineparams.toString();
    }

    public FFEExec executeCommand() {
        File f;
        FFESystem s = this.mainPanel.getHierarchy().getActive();
        String dir = MainPanel.getCWD().getAbsolutePath();
        if (s != null && (f = s.getFile()) != null) {
            dir = f.getParent();
        }
        return this.launch(this.statusLabel.getText(), dir);
    }

    private JPanel getAminoAcidPanel() {
        if (this.aminoPanel != null) {
            return this.aminoPanel;
        }
        JPanel buttonPanel = new JPanel(new GridLayout(4, 5, 2, 2));
        Residue.AA3[] a = Residue.AA3.values();
        for (int i = 0; i < 20; ++i) {
            JButton button = new JButton(a[i].name());
            button.setActionCommand("PROTEIN");
            button.addActionListener(this);
            buttonPanel.add(button);
        }
        buttonPanel.setMaximumSize(buttonPanel.getPreferredSize());
        this.aminoPanel = new JPanel();
        this.aminoPanel.setLayout(new BoxLayout(this.aminoPanel, 1));
        this.aminoPanel.add(buttonPanel);
        this.conformationComboBox = new JComboBox<String>(Residue.Ramachandran);
        this.conformationComboBox.setFont(Font.decode("Monospaced"));
        this.conformationComboBox.setMaximumSize(buttonPanel.getPreferredSize());
        this.aminoPanel.add(this.conformationComboBox);
        return this.aminoPanel;
    }

    public ArrayList<String> getAvailableCommands() {
        ArrayList<String> availableCommands = new ArrayList<String>();
        for (int i = 0; i < this.currentCommandBox.getItemCount(); ++i) {
            availableCommands.add((String)this.currentCommandBox.getItemAt(i));
        }
        return availableCommands;
    }

    public String getCommand() {
        return this.activeCommand;
    }

    private String getLogString(File currentLog) {
        String currentMode = (String)this.logSettings.getSelectedItem();
        if (currentMode.startsWith("Create")) {
            currentLog = SystemFilter.version(currentLog);
            return new String(" > \"" + currentLog.getAbsolutePath() + "\"");
        }
        if (currentMode.startsWith("Append")) {
            return new String(" >> \"" + currentLog.getAbsolutePath() + "\"");
        }
        return new String(" > \"" + currentLog.getAbsolutePath() + "\"");
    }

    public Vector<Thread> getModelingJobs() {
        return this.executingCommands;
    }

    private JPanel getNucleicAcidPanel() {
        if (this.nucleicPanel != null) {
            return this.nucleicPanel;
        }
        this.nucleicPanel = new JPanel(new GridLayout(3, 4, 2, 2));
        Residue.NA3[] a = Residue.NA3.values();
        for (int i = 0; i < 8; ++i) {
            JButton button = new JButton(a[i].name());
            button.setActionCommand("NUCLEIC");
            button.addActionListener(this);
            this.nucleicPanel.add(button);
        }
        JButton button = new JButton("MOL");
        button.setActionCommand("NUCLEIC");
        button.addActionListener(this);
        this.nucleicPanel.add(button);
        this.nucleicPanel.add(Box.createHorizontalBox());
        this.nucleicPanel.add(Box.createHorizontalBox());
        this.nucleicPanel.add(Box.createHorizontalBox());
        this.nucleicPanel.setMaximumSize(this.nucleicPanel.getPreferredSize());
        return this.nucleicPanel;
    }

    private void initCommandComboBox(JComboBox commands) {
        commands.setActionCommand("TinkerCommand");
        commands.setMaximumSize(this.xyzCommands.getPreferredSize());
        commands.setEditable(false);
        commands.setToolTipText("Select a Modeling Command");
        commands.setSelectedIndex(0);
        commands.addActionListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        this.descriptTextArea = new JTextArea();
        this.descriptTextArea.setEditable(false);
        this.descriptTextArea.setLineWrap(true);
        this.descriptTextArea.setWrapStyleWord(true);
        this.descriptTextArea.setDoubleBuffered(true);
        Insets insets = this.descriptTextArea.getInsets();
        insets.set(5, 5, 5, 5);
        this.descriptTextArea.setMargin(insets);
        this.descriptScrollPane = new JScrollPane(this.descriptTextArea, 22, 31);
        this.descriptScrollPane.setBorder(this.etchedBorder);
        this.commandTextArea = new JTextArea();
        this.commandTextArea.setEditable(false);
        this.commandTextArea.setLineWrap(true);
        this.commandTextArea.setWrapStyleWord(true);
        this.commandTextArea.setDoubleBuffered(true);
        this.commandTextArea.setMargin(insets);
        this.optionsTabbedPane = new JTabbedPane();
        this.statusLabel = new JLabel();
        this.statusLabel.setBorder(this.etchedBorder);
        this.statusLabel.setToolTipText("  Modeling command that will be executed");
        this.commandPanel = new JPanel(this.flowLayout);
        this.commandPanel.add(this.optionsTabbedPane);
        this.splitPane = new JSplitPane(0, this.commandPanel, this.descriptScrollPane);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setResizeWeight(1.0);
        this.splitPane.setOneTouchExpandable(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitPane, "Center");
        this.add((Component)this.statusLabel, "South");
        this.acidComboBox.setEditable(false);
        this.acidComboBox.setMaximumSize(this.sizer.getPreferredSize());
        this.acidComboBox.setPreferredSize(this.sizer.getPreferredSize());
        this.acidComboBox.setMinimumSize(this.sizer.getPreferredSize());
        this.acidComboBox.setFont(Font.decode("Monospaced"));
        this.acidTextField.setMaximumSize(this.sizer.getPreferredSize());
        this.acidTextField.setMinimumSize(this.sizer.getPreferredSize());
        this.acidTextField.setPreferredSize(this.sizer.getPreferredSize());
        this.acidTextArea.setEditable(false);
        this.acidTextArea.setWrapStyleWord(true);
        this.acidTextArea.setLineWrap(true);
        this.acidTextArea.setFont(Font.decode("Monospaced"));
        this.acidScrollPane = new JScrollPane(this.acidTextArea);
        Dimension d = new Dimension(300, 400);
        this.acidScrollPane.setPreferredSize(d);
        this.acidScrollPane.setMaximumSize(d);
        this.acidScrollPane.setVerticalScrollBarPolicy(22);
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver(new DTDResolver());
            URL comURL = this.getClass().getClassLoader().getResource("ffe/tinker/commands.xml");
            Document doc = db.parse(comURL.openStream());
            NodeList nodelist = doc.getChildNodes();
            Node commandroot = null;
            for (int i = 0; !(i >= nodelist.getLength() || (commandroot = nodelist.item(i)).getNodeName().equals("TinkerCommands") && commandroot instanceof Element); ++i) {
            }
            if (commandroot == null || !(commandroot instanceof Element)) {
                this.commandList = null;
            }
            this.commandList = ((Element)commandroot).getElementsByTagName("Command");
        }
        catch (ParserConfigurationException e) {
            System.err.println(e);
        }
        catch (SAXException e) {
            System.err.println(e);
        }
        catch (IOException e) {
            System.err.println(e);
        }
        finally {
            if (this.commandList == null) {
                System.out.println("ffe.tinker.commands.xml Could Not Be Parsed");
                this.logger.severe("Force Field Explorer Will Exit");
                System.exit(-1);
            }
        }
        this.xyzCommands = new JComboBox();
        this.intCommands = new JComboBox();
        this.arcCommands = new JComboBox();
        this.pdbCommands = new JComboBox();
        this.anyCommands = new JComboBox();
        int numcommands = this.commandList.getLength();
        for (int i = 0; i < numcommands; ++i) {
            String[] types;
            Element command = (Element)this.commandList.item(i);
            String name = command.getAttribute("name");
            String temp = command.getAttribute("fileType");
            if (temp.indexOf("ANY") >= 0) {
                temp = "XYZ INT ARC PDB";
                this.anyCommands.addItem(name);
            }
            for (String type : types = temp.split(" +")) {
                if (type.indexOf("XYZ") >= 0) {
                    this.xyzCommands.addItem(name);
                }
                if (type.indexOf("INT") >= 0) {
                    this.intCommands.addItem(name);
                }
                if (type.indexOf("ARC") >= 0) {
                    this.arcCommands.addItem(name);
                }
                if (type.indexOf("PDB") < 0) continue;
                this.pdbCommands.addItem(name);
            }
        }
        this.initCommandComboBox(this.xyzCommands);
        this.initCommandComboBox(this.intCommands);
        this.initCommandComboBox(this.arcCommands);
        this.initCommandComboBox(this.pdbCommands);
        this.initCommandComboBox(this.anyCommands);
        this.currentCommandBox = this.anyCommands;
        this.activeCommand = (String)this.anyCommands.getSelectedItem();
        this.loadCommand();
        this.logSettings.setActionCommand("LogSettings");
        this.loadLogSettings();
        this.toolBar = new JToolBar("Modeling Commands", 0);
        this.toolBar.setLayout(new FlowLayout(0));
        JButton jblaunch = new JButton(new ImageIcon(this.getClass().getClassLoader().getResource("ffe/icons/launch.png")));
        jblaunch.setActionCommand("Launch");
        jblaunch.setToolTipText("Launch the Tinker Command");
        jblaunch.addActionListener(this);
        jblaunch.setBorderPainted(false);
        insets.set(2, 2, 2, 2);
        jblaunch.setMargin(insets);
        this.toolBar.add(jblaunch);
        JButton jbend = new JButton(new ImageIcon(this.getClass().getClassLoader().getResource("ffe/icons/cancel.png")));
        jbend.setActionCommand("End");
        jbend.setToolTipText("Toggle the Existence of a Tinker END File");
        jbend.addActionListener(this);
        jbend.setBorderPainted(false);
        jbend.setMargin(insets);
        this.toolBar.add(jbend);
        this.toolBar.addSeparator();
        this.toolBar.add(this.anyCommands);
        this.currentCommandBox = this.anyCommands;
        this.toolBar.addSeparator();
        this.toolBar.add(this.logSettings);
        JButton jbdelete = new JButton(new ImageIcon(this.getClass().getClassLoader().getResource("ffe/icons/delete.png")));
        jbdelete.setActionCommand("Delete");
        jbdelete.setToolTipText("Delete Log Files");
        jbdelete.addActionListener(this);
        jbdelete.setBorderPainted(false);
        jbdelete.setMargin(insets);
        this.toolBar.add(jbdelete);
        this.toolBar.addSeparator();
        ImageIcon icinfo = new ImageIcon(this.getClass().getClassLoader().getResource("ffe/icons/info.png"));
        this.descriptCheckBox = new JCheckBoxMenuItem(icinfo);
        this.descriptCheckBox.addActionListener(this);
        this.descriptCheckBox.setActionCommand("Description");
        this.descriptCheckBox.setToolTipText("Show/Hide Modeling Command Descriptions");
        this.descriptCheckBox.setMargin(insets);
        this.toolBar.add(this.descriptCheckBox);
        this.toolBar.add(new JLabel(""));
        this.toolBar.setBorderPainted(false);
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.add((Component)this.toolBar, "North");
        Preferences prefs = Preferences.userNodeForPackage(ModelingPanel.class);
        this.descriptCheckBox.setSelected(!prefs.getBoolean("JobPanel_description", true));
        this.descriptCheckBox.doClick();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FFEExec launch(String command, String dir) {
        this.logger.info("Active Command to Launch\nCOMMAND: " + command + "\nDIR: " + dir);
        ModelingPanel modelingPanel = this;
        synchronized (modelingPanel) {
            String path = new File(MainPanel.tinkerDir.getAbsolutePath() + File.separator + "bin").getAbsolutePath();
            File exe = new File(path + File.separator + this.activeCommand.toLowerCase());
            if (!exe.exists() && !(exe = new File(exe.getAbsolutePath() + ".exe")).exists()) {
                String message = new String("The " + this.activeCommand + " executable was not found in " + path + ". Please use the 'Set Tinker...' Dialog to Change the Tinker Directory");
                JOptionPane.showMessageDialog(null, message, "Could not launch " + this.activeCommand, 0);
                return null;
            }
            File dirf = new File(dir);
            if (!dirf.exists()) {
                this.logger.warning("Directory doesn't exist: " + dirf.getAbsolutePath());
                return null;
            }
            if (!this.commandFileTypes.contains((Object)Utilities.FileType.ANY)) {
                if (this.activeSystem == null) {
                    return null;
                }
                this.activeFileType = this.activeSystem.getFileType();
                if (!this.commandFileTypes.contains((Object)this.activeFileType)) {
                    String message = new String(this.activeCommand.toUpperCase() + " does not execute on " + String.valueOf((Object)this.activeFileType) + " files.");
                    JOptionPane.showMessageDialog(null, message, "Could not launch " + this.activeCommand, 0);
                    return null;
                }
                if (this.activeSystem.getKeyFile() == null) {
                    this.mainPanel.createKeyFile(this.activeSystem);
                    if (this.activeSystem.getKeyFile() == null) {
                        return null;
                    }
                }
            } else {
                int dot;
                command = this.createCommandInput();
                String structureName = this.commandTextArea.getText().trim();
                if (!(structureName == null && structureName.equalsIgnoreCase("") || (structureName = structureName.split("\n")[0]) == null || (dot = (structureName = structureName.trim()).lastIndexOf(".")) <= 0)) {
                    structureName = structureName.substring(0, dot);
                }
                if (structureName == null) {
                    structureName = this.activeCommand.toLowerCase();
                }
                File file = new File(dir + File.separator + structureName + ".xyz");
                file = SystemFilter.version(file);
                this.activeSystem = new FFESystem(structureName, null, file, true);
                File logFile = new File(file.getParent() + File.separator + structureName + ".log");
                this.activeSystem.setLogFile(logFile);
                this.loadLogSettings();
                this.activeFileType = Utilities.FileType.ANY;
                this.mainPanel.openKey(this.activeSystem, true);
                if (this.activeSystem.getKeyFile() == null) {
                    return null;
                }
            }
            if (((String)this.logSettings.getSelectedItem()).startsWith("Create")) {
                File newLog = SystemFilter.version(this.activeSystem.getLogFile());
                this.activeSystem.setLogFile(newLog);
            }
            String logName = this.activeSystem.getLogFile().getAbsolutePath();
            command = this.createCommandInput();
            File newFile = null;
            if (this.commandActions.toUpperCase().indexOf("LOAD") >= 0) {
                int dot;
                Object fileName;
                File oldFile = this.activeSystem.getFile();
                if (this.commandActions.toUpperCase().indexOf("LOADXYZ") >= 0) {
                    fileName = oldFile.getAbsolutePath();
                    dot = ((String)fileName).lastIndexOf(".");
                    if (dot > 0) {
                        fileName = ((String)fileName).substring(0, dot) + ".xyz";
                    }
                    oldFile = new File((String)fileName);
                } else if (this.commandActions.toUpperCase().indexOf("LOADINT") >= 0) {
                    fileName = oldFile.getAbsolutePath();
                    dot = ((String)fileName).lastIndexOf(".");
                    if (dot > 0) {
                        fileName = ((String)fileName).substring(0, dot) + ".int";
                    }
                    oldFile = new File((String)fileName);
                } else if (this.commandActions.toUpperCase().indexOf("LOADPDB") >= 0) {
                    fileName = oldFile.getAbsolutePath();
                    dot = ((String)fileName).lastIndexOf(".");
                    if (dot > 0) {
                        fileName = ((String)fileName).substring(0, dot) + ".pdb";
                    }
                    oldFile = new File((String)fileName);
                }
                newFile = SystemFilter.version(oldFile);
            }
            this.mainPanel.getKeywordPanel().saveChanges();
            this.removeEnd();
            String commandInput = this.commandTextArea.getText();
            if (commandInput != null && !commandInput.trim().equalsIgnoreCase("")) {
                File inputFile = new File(dir + File.separator + this.activeCommand.toLowerCase() + ".in");
                inputFile.deleteOnExit();
                try {
                    FileWriter fw = new FileWriter(inputFile);
                    fw.write(commandInput);
                    fw.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            boolean openOnto = false;
            if (this.commandActions.toUpperCase().indexOf("CONNECT") >= 0) {
                if (newFile != null) {
                    openOnto = true;
                }
                this.mainPanel.open(this.activeSystem.getFile(), this.activeCommand);
                try {
                    while (this.mainPanel.isOpening()) {
                        this.wait(10L);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
                this.activeSystem = this.mainPanel.getHierarchy().getActive();
            }
            FFEExec tinkerExec = new FFEExec(this.activeSystem, logName, command, dir, this.mainPanel, newFile, openOnto);
            Thread tinkerThread = new Thread(tinkerExec);
            tinkerThread.setPriority(5);
            tinkerThread.setName(logName);
            if (this.commandActions.toUpperCase().indexOf("CONNECT") >= 0) {
                this.mainPanel.connectToTinker(this.activeSystem, tinkerThread);
            } else {
                tinkerThread.start();
            }
            if (!this.commandActions.equalsIgnoreCase("NONE")) {
                this.executingCommands.add(tinkerThread);
                this.mainPanel.getLogPanel().refreshStatus();
            }
            return tinkerExec;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadActive(FFESystem active) {
        ModelingPanel modelingPanel = this;
        synchronized (modelingPanel) {
            this.activeSystem = active;
            Utilities.FileType fileType = Utilities.FileType.UNK;
            if (this.activeSystem == null || this.activeSystem.isClosing()) {
                this.currentCommandBox = this.anyCommands;
                this.activeCommand = (String)this.anyCommands.getSelectedItem();
                this.statusLabel.setText("  ");
                fileType = Utilities.FileType.ANY;
            } else {
                fileType = active.getFileType();
            }
            if (fileType != this.activeFileType) {
                this.activeFileType = fileType;
                this.toolBar.remove(3);
                if (this.activeFileType == Utilities.FileType.XYZ) {
                    this.toolBar.add(this.xyzCommands);
                    this.currentCommandBox = this.xyzCommands;
                } else if (this.activeFileType == Utilities.FileType.INT) {
                    this.toolBar.add(this.intCommands);
                    this.currentCommandBox = this.intCommands;
                } else if (this.activeFileType == Utilities.FileType.ARC) {
                    this.toolBar.add(this.arcCommands);
                    this.currentCommandBox = this.arcCommands;
                } else if (this.activeFileType == Utilities.FileType.PDB) {
                    this.toolBar.add(this.pdbCommands);
                    this.currentCommandBox = this.pdbCommands;
                } else {
                    this.toolBar.add(this.anyCommands);
                    this.currentCommandBox = this.anyCommands;
                }
                this.toolBar.add((Component)this.currentCommandBox, 3);
                this.toolBar.validate();
                this.toolBar.repaint();
                this.activeCommand = (String)this.currentCommandBox.getSelectedItem();
            }
            this.loadCommand();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCommand() {
        ModelingPanel modelingPanel = this;
        synchronized (modelingPanel) {
            String name;
            this.commandPanel.removeAll();
            this.optionsTabbedPane.removeAll();
            this.conditionals.clear();
            String currentCommand = (String)this.currentCommandBox.getSelectedItem();
            if (currentCommand == null) {
                this.commandPanel.validate();
                this.commandPanel.repaint();
                return;
            }
            Element command = null;
            for (int i = 0; i < this.commandList.getLength() && !(name = (command = (Element)this.commandList.item(i)).getAttribute("name")).equalsIgnoreCase(currentCommand); ++i) {
            }
            int div = this.splitPane.getDividerLocation();
            this.descriptTextArea.setText(currentCommand.toUpperCase() + ": " + command.getAttribute("description"));
            this.splitPane.setBottomComponent(this.descriptScrollPane);
            this.splitPane.setDividerLocation(div);
            this.commandActions = command.getAttribute("action").trim();
            String string = command.getAttribute("fileType").trim();
            String[] types = string.split(" +");
            this.commandFileTypes.clear();
            for (String type : types) {
                if (type.indexOf("XYZ") >= 0) {
                    this.commandFileTypes.add(Utilities.FileType.XYZ);
                }
                if (type.indexOf("INT") >= 0) {
                    this.commandFileTypes.add(Utilities.FileType.INT);
                }
                if (type.indexOf("ARC") >= 0) {
                    this.commandFileTypes.add(Utilities.FileType.ARC);
                }
                if (type.indexOf("PDB") >= 0) {
                    this.commandFileTypes.add(Utilities.FileType.PDB);
                }
                if (type.indexOf("ANY") < 0) continue;
                this.commandFileTypes.add(Utilities.FileType.ANY);
            }
            NodeList options = command.getElementsByTagName("Option");
            int length = options.getLength();
            for (int i = 0; i < length; ++i) {
                JButton remove;
                JPanel comboPanel;
                Element value;
                NodeList values;
                boolean isEnabled = true;
                Element option = (Element)options.item(i);
                NodeList conditionalList = option.getElementsByTagName("Conditional");
                Element conditional = conditionalList != null ? (Element)conditionalList.item(0) : null;
                String optionDescript = option.getAttribute("description");
                JTextArea optionTextArea = new JTextArea("  " + optionDescript.trim());
                optionTextArea.setEditable(false);
                optionTextArea.setLineWrap(true);
                optionTextArea.setWrapStyleWord(true);
                optionTextArea.setBorder(this.etchedBorder);
                String defaultOption = option.getAttribute("default");
                String postProcess = option.getAttribute("postProcess");
                JPanel optionPanel = new JPanel(new BorderLayout());
                optionPanel.add((Component)optionTextArea, "North");
                String swing = option.getAttribute("gui");
                JPanel optionValuesPanel = new JPanel(new FlowLayout());
                optionValuesPanel.setBorder(this.etchedBorder);
                ButtonGroup bg = null;
                if (swing.equalsIgnoreCase("CHECKBOXES")) {
                    values = option.getElementsByTagName("Value");
                    for (int j = 0; j < values.getLength(); ++j) {
                        value = (Element)values.item(j);
                        JCheckBox jcb = new JCheckBox(value.getAttribute("name"));
                        jcb.addMouseListener(this);
                        if (defaultOption != null && jcb.getActionCommand().equalsIgnoreCase(defaultOption)) {
                            jcb.setSelected(true);
                        }
                        optionValuesPanel.add(jcb);
                    }
                } else if (swing.equalsIgnoreCase("TEXTFIELD")) {
                    JTextField jtf = new JTextField(20);
                    jtf.addMouseListener(this);
                    if (defaultOption != null && defaultOption.equals("ATOMS")) {
                        FFESystem sys = this.mainPanel.getHierarchy().getActive();
                        if (sys != null) {
                            jtf.setText("" + sys.getAtomList().size());
                        }
                    } else if (defaultOption != null) {
                        jtf.setText(defaultOption);
                    }
                    if (postProcess != null) {
                        jtf.setName(postProcess);
                    }
                    optionValuesPanel.add(jtf);
                } else if (swing.equalsIgnoreCase("RADIOBUTTONS")) {
                    bg = new ButtonGroup();
                    values = option.getElementsByTagName("Value");
                    for (int j = 0; j < values.getLength(); ++j) {
                        value = (Element)values.item(j);
                        JRadioButton jrb = new JRadioButton(value.getAttribute("name"));
                        jrb.addMouseListener(this);
                        bg.add(jrb);
                        if (defaultOption != null && jrb.getActionCommand().equalsIgnoreCase(defaultOption)) {
                            jrb.setSelected(true);
                        }
                        optionValuesPanel.add(jrb);
                        if (postProcess == null) continue;
                        jrb.setName(postProcess);
                    }
                } else if (swing.equalsIgnoreCase("PROTEIN")) {
                    optionValuesPanel.setLayout(new BoxLayout(optionValuesPanel, 1));
                    optionValuesPanel.add(Box.createRigidArea(new Dimension(0, 5)));
                    optionValuesPanel.add(this.getAminoAcidPanel());
                    optionValuesPanel.add(Box.createRigidArea(new Dimension(0, 5)));
                    this.acidComboBox.removeAllItems();
                    JButton add = new JButton("Edit");
                    add.setActionCommand("PROTEIN");
                    add.addActionListener(this);
                    add.setAlignmentX(0.5f);
                    comboPanel = new JPanel(new FlowLayout(1));
                    comboPanel.add(this.acidTextField);
                    comboPanel.add(add);
                    optionValuesPanel.add(comboPanel);
                    optionValuesPanel.add(Box.createRigidArea(new Dimension(0, 5)));
                    remove = new JButton("Remove");
                    add.setMinimumSize(remove.getPreferredSize());
                    add.setPreferredSize(remove.getPreferredSize());
                    remove.setActionCommand("PROTEIN");
                    remove.addActionListener(this);
                    remove.setAlignmentX(0.5f);
                    comboPanel = new JPanel(new FlowLayout(1));
                    comboPanel.add(this.acidComboBox);
                    comboPanel.add(remove);
                    optionValuesPanel.add(comboPanel);
                    optionValuesPanel.add(Box.createRigidArea(new Dimension(0, 5)));
                    optionValuesPanel.add(this.acidScrollPane);
                    optionValuesPanel.add(Box.createRigidArea(new Dimension(0, 5)));
                    JButton reset = new JButton("Reset");
                    reset.setActionCommand("PROTEIN");
                    reset.addActionListener(this);
                    reset.setAlignmentX(0.5f);
                    optionValuesPanel.add(reset);
                    optionValuesPanel.add(Box.createRigidArea(new Dimension(0, 5)));
                    this.acidTextArea.setText("");
                    this.acidTextField.setText("");
                } else if (swing.equalsIgnoreCase("NUCLEIC")) {
                    optionValuesPanel.setLayout(new BoxLayout(optionValuesPanel, 1));
                    optionValuesPanel.add(Box.createRigidArea(new Dimension(0, 5)));
                    optionValuesPanel.add(this.getNucleicAcidPanel());
                    optionValuesPanel.add(Box.createRigidArea(new Dimension(0, 5)));
                    this.acidComboBox.removeAllItems();
                    JButton add = new JButton("Edit");
                    add.setActionCommand("NUCLEIC");
                    add.addActionListener(this);
                    add.setAlignmentX(0.5f);
                    comboPanel = new JPanel(new FlowLayout(1));
                    comboPanel.add(this.acidTextField);
                    comboPanel.add(add);
                    optionValuesPanel.add(comboPanel);
                    optionValuesPanel.add(Box.createRigidArea(new Dimension(0, 5)));
                    remove = new JButton("Remove");
                    add.setMinimumSize(remove.getPreferredSize());
                    add.setPreferredSize(remove.getPreferredSize());
                    remove.setActionCommand("NUCLEIC");
                    remove.addActionListener(this);
                    remove.setAlignmentX(0.5f);
                    comboPanel = new JPanel(new FlowLayout(1));
                    comboPanel.add(this.acidComboBox);
                    comboPanel.add(remove);
                    optionValuesPanel.add(comboPanel);
                    optionValuesPanel.add(Box.createRigidArea(new Dimension(0, 5)));
                    optionValuesPanel.add(this.acidScrollPane);
                    optionValuesPanel.add(Box.createRigidArea(new Dimension(0, 5)));
                    JButton button = new JButton("Reset");
                    button.setActionCommand("NUCLEIC");
                    button.addActionListener(this);
                    button.setAlignmentX(0.5f);
                    optionValuesPanel.add(button);
                    optionValuesPanel.add(Box.createRigidArea(new Dimension(0, 5)));
                    this.acidTextArea.setText("");
                    this.acidTextField.setText("");
                } else if (swing.equalsIgnoreCase("SYSTEMS")) {
                    JComboBox<FFESystem> jcb = new JComboBox<FFESystem>(this.mainPanel.getHierarchy().getNonActiveSystems());
                    jcb.setSize(jcb.getMaximumSize());
                    jcb.addActionListener(this);
                    optionValuesPanel.add(jcb);
                }
                if (conditional != null) {
                    isEnabled = false;
                    String conditionalName = conditional.getAttribute("name");
                    String conditionalValues = conditional.getAttribute("value");
                    String cDescription = conditional.getAttribute("description");
                    String cpostProcess = conditional.getAttribute("postProcess");
                    if (conditionalName.toUpperCase().startsWith("KEYWORD")) {
                        optionPanel.setName(conditionalName);
                        String[] keywords = conditionalValues.split(" +");
                        if (this.activeSystem != null) {
                            Hashtable<String, Keyword> systemKeywords = this.activeSystem.getKeywords();
                            for (String key : keywords) {
                                if (!systemKeywords.containsKey(key.toUpperCase())) continue;
                                isEnabled = true;
                            }
                        }
                    } else if (conditionalName.toUpperCase().startsWith("VALUE")) {
                        isEnabled = true;
                        for (int j = 0; j < optionValuesPanel.getComponentCount(); ++j) {
                            JToggleButton jtb = (JToggleButton)optionValuesPanel.getComponent(j);
                            jtb.addActionListener(this);
                            jtb.setActionCommand("Conditional");
                        }
                        JPanel condpanel = new JPanel();
                        condpanel.setBorder(this.etchedBorder);
                        JLabel condlabel = new JLabel(cDescription);
                        condlabel.setEnabled(false);
                        condlabel.setName(conditionalValues);
                        JTextField condtext = new JTextField(10);
                        condlabel.setLabelFor(condtext);
                        if (cpostProcess != null) {
                            condtext.setName(cpostProcess);
                        }
                        condtext.setEnabled(false);
                        condpanel.add(condlabel);
                        condpanel.add(condtext);
                        this.conditionals.add(condlabel);
                        optionPanel.add((Component)condpanel, "South");
                    } else if (conditionalName.toUpperCase().startsWith("REFLECTION")) {
                        JRadioButton jrbmi;
                        String[] condModifiers = null;
                        if (conditionalValues.equalsIgnoreCase("AltLoc")) {
                            condModifiers = this.activeSystem.getAltLocations();
                            if (condModifiers != null && condModifiers.length > 1) {
                                isEnabled = true;
                                bg = new ButtonGroup();
                                for (int j = 0; j < condModifiers.length; ++j) {
                                    jrbmi = new JRadioButton(condModifiers[j]);
                                    jrbmi.addMouseListener(this);
                                    bg.add(jrbmi);
                                    optionValuesPanel.add(jrbmi);
                                    if (j != 0) continue;
                                    jrbmi.setSelected(true);
                                }
                            }
                        } else if (conditionalValues.equalsIgnoreCase("Chains") && (condModifiers = this.activeSystem.getChainNames()) != null && condModifiers.length > 0) {
                            isEnabled = true;
                            for (int j = 0; j < condModifiers.length; ++j) {
                                jrbmi = new JRadioButton(condModifiers[j]);
                                jrbmi.addMouseListener(this);
                                bg.add(jrbmi);
                                optionValuesPanel.add((Component)jrbmi, j);
                            }
                        }
                    }
                }
                optionPanel.add((Component)optionValuesPanel, "Center");
                optionPanel.setPreferredSize(optionPanel.getPreferredSize());
                this.optionsTabbedPane.addTab(option.getAttribute("name"), optionPanel);
                this.optionsTabbedPane.setEnabledAt(this.optionsTabbedPane.getTabCount() - 1, isEnabled);
            }
        }
        this.optionsTabbedPane.setPreferredSize(this.optionsTabbedPane.getPreferredSize());
        this.commandPanel.setLayout(this.borderLayout);
        this.commandPanel.add((Component)this.optionsTabbedPane, "Center");
        this.commandPanel.validate();
        this.commandPanel.repaint();
        this.loadLogSettings();
        this.statusLabel.setText("  " + this.createCommandInput());
    }

    private void loadLogSettings() {
        String selected = (String)this.logSettings.getSelectedItem();
        this.logSettings.removeActionListener(this);
        this.logSettings.removeAllItems();
        File currentLog = null;
        Object fileName = null;
        File logDir = null;
        File systemDir = null;
        if (this.activeSystem == null) {
            fileName = ((String)this.currentCommandBox.getSelectedItem()).toLowerCase() + ".log";
            currentLog = new File(String.valueOf(MainPanel.getCWD()) + File.separator + (String)fileName);
            logDir = currentLog.getParentFile();
            systemDir = MainPanel.getCWD();
        } else {
            currentLog = this.activeSystem.getLogFile();
            fileName = currentLog.getName();
            logDir = currentLog.getParentFile();
            systemDir = this.activeSystem.getFile().getParentFile();
        }
        File tempLog = null;
        File newLog = null;
        if (logDir == null || !logDir.equals(systemDir)) {
            tempLog = new File(systemDir.getAbsolutePath() + File.separator + (String)fileName);
            if (!this.commandFileTypes.contains((Object)Utilities.FileType.ANY)) {
                this.activeSystem.setLogFile(tempLog);
            }
        } else {
            tempLog = currentLog;
        }
        String createNew = null;
        if (!tempLog.exists()) {
            createNew = new String("Create " + (String)fileName);
            this.logSettings.addItem(createNew);
            this.logSettings.setSelectedItem(createNew);
            this.logString = this.getLogString(tempLog);
            this.logSettings.addActionListener(this);
            if (!this.commandFileTypes.contains((Object)Utilities.FileType.ANY)) {
                this.activeSystem.setLogFile(tempLog);
            }
            return;
        }
        newLog = SystemFilter.version(tempLog);
        tempLog = SystemFilter.previousVersion(newLog);
        fileName = tempLog.getName();
        String append = new String("Append to " + (String)fileName);
        String overwrite = new String("Overwrite " + (String)fileName);
        this.logSettings.addItem(append);
        this.logSettings.addItem(overwrite);
        if (!newLog.equals(tempLog)) {
            createNew = new String("Create " + newLog.getName());
            this.logSettings.addItem(createNew);
        }
        if (selected == null) {
            this.logSettings.setSelectedIndex(0);
            this.logString = null;
        } else if (selected.startsWith("Append")) {
            this.logSettings.setSelectedItem(append);
            this.logString = this.getLogString(tempLog);
        } else if (selected.startsWith("Overwrite")) {
            this.logSettings.setSelectedItem(overwrite);
            this.logString = this.getLogString(tempLog);
        } else if (createNew != null) {
            this.logSettings.setSelectedItem(createNew);
            this.logString = this.getLogString(newLog);
        } else {
            this.logString = this.getLogString(tempLog);
            this.logSettings.setSelectedItem(append);
        }
        this.logSettings.addActionListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        this.statusLabel.setText("  " + this.createCommandInput());
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
        this.mouseClicked(evt);
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        this.mouseClicked(evt);
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.mouseClicked(evt);
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        this.mouseClicked(evt);
    }

    private void removeEnd() {
        FFESystem m = this.mainPanel.getHierarchy().getActive();
        if (m == null) {
            return;
        }
        File f = m.getFile();
        if (f == null) {
            return;
        }
        File end = null;
        try {
            if (f.getName().indexOf(".") > 0) {
                String name = f.getName().substring(0, f.getName().lastIndexOf("."));
                end = new File(f.getParent(), name.toString() + ".end");
            } else {
                end = new File(f.getParent(), f.getName() + ".end");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (end != null && end.exists()) {
            end.delete();
        }
    }

    public void savePrefs() {
        Preferences prefs = Preferences.userNodeForPackage(ModelingPanel.class);
        prefs.putBoolean("JobPanel_description", this.descriptCheckBox.isSelected());
    }

    public void selected() {
        this.loadLogSettings();
        this.setDivider(this.descriptCheckBox.isSelected());
        this.validate();
        this.repaint();
    }

    public boolean setCommand(String command) {
        if (command == null) {
            return false;
        }
        command = command.toLowerCase();
        command = command.replaceFirst(command.substring(0, 1), command.toUpperCase().substring(0, 1));
        this.currentCommandBox.setSelectedItem(command);
        this.mainPanel.setPanel(2);
        return this.currentCommandBox.getSelectedItem().equals(command);
    }

    private void setDivider(boolean b) {
        this.descriptCheckBox.setSelected(b);
        if (b) {
            int spDivider = (int)((float)this.getHeight() * 0.6f);
            this.splitPane.setDividerLocation(spDivider);
        } else {
            this.splitPane.setDividerLocation(1.0);
        }
    }

    private void setEnd() {
        if (this.activeSystem == null) {
            return;
        }
        File activeFile = this.activeSystem.getFile();
        if (activeFile == null) {
            return;
        }
        try {
            File end;
            if (activeFile.getName().indexOf(".") > 0) {
                String name = activeFile.getName().substring(0, activeFile.getName().lastIndexOf("."));
                end = new File(activeFile.getParent(), name.toString() + ".end");
            } else {
                end = new File(activeFile.getParent(), activeFile.getName() + ".end");
            }
            if (end.exists()) {
                int i = JOptionPane.showConfirmDialog(this, "Delete " + end.getName() + "?", "Delete Tinker END File", 0);
                if (i == 0) {
                    end.delete();
                }
            } else {
                int i = JOptionPane.showConfirmDialog(this, "Create " + end.getName() + "?", "Create Tinker END File", 0);
                if (i == 0) {
                    end.createNewFile();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logger.warning("\n Error changing the state of an END file");
            this.logger.warning("\n Force Field Explorer will continue...");
        }
    }

    public void setLogMode(String mode) {
        mode = mode.toUpperCase();
        for (int i = 0; i < this.logSettings.getItemCount(); ++i) {
            String logType = (String)this.logSettings.getItemAt(i);
            if (!logType.toUpperCase().startsWith(mode)) continue;
            this.logSettings.setSelectedIndex(i);
            break;
        }
        this.loadLogSettings();
    }

    public void deleteLogs() {
        String dir;
        File file;
        String name;
        int i;
        if (this.activeSystem != null && (i = JOptionPane.showConfirmDialog(this, "Delete all logs for " + (name = (file = this.activeSystem.getFile()).getName()) + " from " + (dir = file.getParent()) + " ?", "Delete Logs", 0, 2)) == 0) {
            try {
                File[] files;
                for (File f : files = this.activeSystem.getFile().getParentFile().listFiles()) {
                    name = FilenameUtils.getBaseName((String)f.getAbsolutePath());
                    if (!FilenameUtils.wildcardMatch((String)f.getName(), (String)(name + ".log*"))) continue;
                    this.mainPanel.getLogPanel().close(f.getAbsolutePath());
                    f.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.activeSystem.setLogFile(null);
            this.loadLogSettings();
        }
    }

    @Override
    public String toString() {
        return "Modeling Panel";
    }
}

