/*
 * Decompiled with CFR 0.152.
 */
package ffe.core;

import ffe.core.FFESystem;
import ffe.core.FileOpener;
import ffe.core.GraphicsCanvas;
import ffe.core.GraphicsPanel;
import ffe.core.Hierarchy;
import ffe.core.KeywordPanel;
import ffe.core.LogPanel;
import ffe.core.MainMenu;
import ffe.core.ModelingPanel;
import ffe.core.ModelingShell;
import ffe.core.TinkerSimulation;
import ffe.core.Trajectory;
import ffe.lang.Atom;
import ffe.lang.Bond;
import ffe.lang.Keyword;
import ffe.lang.MSNode;
import ffe.lang.MSRoot;
import ffe.lang.MolecularAssembly;
import ffe.lang.ROLS;
import ffe.lang.RendererCache;
import ffe.lang.Utilities;
import ffe.mm.ForceField;
import ffe.parsers.ARCFileFilter;
import ffe.parsers.DYNFileFilter;
import ffe.parsers.DYNFilter;
import ffe.parsers.ForceFieldFileFilter;
import ffe.parsers.ForceFieldFilter;
import ffe.parsers.INTFileFilter;
import ffe.parsers.INTFilter;
import ffe.parsers.InducedFileFilter;
import ffe.parsers.InducedFilter;
import ffe.parsers.KeyFileFilter;
import ffe.parsers.KeyFilter;
import ffe.parsers.MergeFilter;
import ffe.parsers.PDBFileFilter;
import ffe.parsers.PDBFilter;
import ffe.parsers.SystemFilter;
import ffe.parsers.XYZFileFilter;
import ffe.parsers.XYZFilter;
import ffe.properties.FFELocale;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.time.StopWatch;
import org.jogamp.java3d.GraphicsConfigTemplate3D;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.vecmath.Tuple3d;
import org.jogamp.vecmath.Vector3d;

public final class MainPanel
extends JPanel
implements ActionListener,
ChangeListener {
    private static JFileChooser fileChooser = null;
    private static File cwd;
    private static Logger logger;
    public static final int GRAPHICS = 0;
    public static final int KEYWORDS = 1;
    public static final int MODELING = 2;
    public static final int LOGS = 3;
    public static String classpath;
    public static File ffeDir;
    public static File tinkerDir;
    public static String ld_library_path;
    public static final XYZFileFilter xyzFileFilter;
    public static final ARCFileFilter arcFileFilter;
    public static final INTFileFilter intFileFilter;
    public static final DYNFileFilter dynFileFilter;
    public static final InducedFileFilter indFileFilter;
    public static final ForceFieldFileFilter forceFieldFileFilter;
    public static final PDBFileFilter pdbFileFilter;
    public static final KeyFileFilter keyfilefilter;
    public static StopWatch stopWatch;
    private JFrame frame;
    private MSRoot dataRoot;
    private Hierarchy hierarchy;
    private MainMenu menuMenu;
    private GraphicsPanel graphicsPanel;
    private ModelingPanel modelingPanel;
    private KeywordPanel keywordPanel;
    private LogPanel logPanel;
    private GraphicsCanvas graphicsCanvas;
    private JSplitPane splitPane;
    private int splitPaneDivider;
    private JTabbedPane tabbedPane;
    private JLabel statusLabel;
    private ForceFieldFilter forceFieldFilter;
    private FFELocale locale = null;
    private JDialog aboutDialog = null;
    private JTextArea aboutTextArea = null;
    private Thread openThread = null;
    private boolean oscillate = false;
    private TinkerSimulation simulation = null;
    private String ip = new String("");
    private int port = 2000;
    private InetAddress address = null;
    private InetSocketAddress socketAddress = new InetSocketAddress(this.port);
    private ModelingShell modelingShell = null;
    private boolean init = false;

    public static File getCWD() {
        if (cwd == null) {
            cwd = new File(System.getProperty("user.dir", FileSystemView.getFileSystemView().getDefaultDirectory().getAbsolutePath()));
        }
        return cwd;
    }

    public static JFileChooser getFileChooser() {
        if (fileChooser == null) {
            fileChooser = new JFileChooser();
        }
        fileChooser.resetChoosableFileFilters();
        fileChooser.setFileSelectionMode(0);
        fileChooser.setFileHidingEnabled(true);
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.setCurrentDirectory(MainPanel.getCWD());
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setSelectedFile(null);
        return fileChooser;
    }

    public MainPanel(JFrame f) {
        this.frame = f;
    }

    public void about() {
        if (this.aboutDialog == null) {
            this.aboutDialog = new JDialog(this.frame, "About FFE", true);
            URL tinkerURL = this.getClass().getClassLoader().getResource("ffe/icons/splash.png");
            ImageIcon logoIcon = new ImageIcon(tinkerURL);
            JLabel logoLabel = new JLabel(logoIcon);
            logoLabel.setBorder(BorderFactory.createEtchedBorder(0));
            Container contentpane = this.aboutDialog.getContentPane();
            contentpane.setLayout(new BorderLayout());
            if (this.aboutTextArea == null) {
                this.initAbout();
            }
            contentpane.add((Component)this.aboutTextArea, "South");
            contentpane.add((Component)logoLabel, "Center");
            this.aboutDialog.pack();
            Dimension dim = this.getToolkit().getScreenSize();
            Dimension ddim = this.aboutDialog.getSize();
            this.aboutDialog.setLocation((dim.width - ddim.width) / 2, (dim.height - ddim.height) / 2);
            this.aboutDialog.setResizable(false);
        }
        this.aboutDialog.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String arg = evt.getActionCommand();
        if (arg.equals("Open")) {
            this.open();
        } else if (arg.equals("DownloadFromPubChem")) {
            this.openFromPubChem();
        } else if (arg.equals("DownloadFromNCI")) {
            this.openFromNCI();
        } else if (arg.equals("DownloadFromPDB")) {
            this.openFromPDB();
        } else if (arg.equals("SaveAs")) {
            this.save(null);
        } else if (arg.equals("Close")) {
            this.close();
        } else if (arg.equals("CloseAll")) {
            this.closeAll();
        } else if (arg.equals("ChooseKeyFile")) {
            this.chooseKey();
        } else if (arg.equals("ChooseLogFile")) {
            this.chooseLog();
        } else if (arg.equals("LoadRestartData")) {
            this.openRestart();
        } else if (arg.equals("LoadInducedData")) {
            this.openInduced();
        } else if (arg.endsWith("ChooseTinkerLocation")) {
            this.chooseTinker();
        } else if (arg.equals("SelectAll")) {
            this.selectAll();
        } else if (arg.equals("MergeSelections")) {
            this.merge();
        } else if (arg.equals("HighlightSelections")) {
            this.highlightSelections(evt);
        } else if (arg.equals("Play")) {
            this.play();
        } else if (arg.equals("Stop")) {
            this.stop();
        } else if (arg.equals("StepForward")) {
            this.stepForward();
        } else if (arg.equals("StepBack")) {
            this.stepBack();
        } else if (arg.equals("Reset")) {
            this.reset();
        } else if (arg.equals("Oscillate")) {
            this.oscillate(evt);
        } else if (arg.equals("Frame")) {
            this.frame();
        } else if (arg.equals("Speed")) {
            this.speed();
        } else if (arg.equals("Skip")) {
            this.skip();
        } else if (arg.equals("ConnectToLocalJob")) {
            this.connectToTinker(null, null);
        } else if (arg.equals("ConnectToRemoteJob")) {
            this.connect();
        } else if (arg.equals("ReleaseJob")) {
            this.release();
        } else if (arg.equals("SetPort")) {
            this.setPort();
        } else if (arg.equals("SetRemoteJobAddress")) {
            this.setRemoteJobAddress();
        } else if (arg.equals("ShowToolBar")) {
            this.showToolBar(evt);
        } else if (arg.equals("ShowTree")) {
            this.showTree(evt);
        } else if (arg.equals("ShowGlobalAxes")) {
            this.showGlobalAxes(evt);
        } else if (arg.equals("ResetPanes")) {
            this.resetPanes();
        } else if (arg.equals("ResetConsole")) {
            this.resetShell();
        } else if (arg.equals("OceanLookAndFeel")) {
            this.oceanLookAndFeel();
        } else if (arg.equals("WindowsLookAndFeel") || arg.equals("MacOSXLookAndFeel") || arg.equals("MotifLookAndFeel")) {
            this.platformLookAndFeel();
        } else if (arg.equals("ShrinkGraphicsWindow")) {
            this.resizePanes(20);
        } else if (arg.equals("ExpandGraphicsWindow")) {
            this.resizePanes(-20);
        } else if (arg.equals("About")) {
            this.about();
        } else if (arg.equals("GarbageCollect")) {
            Runtime.getRuntime().runFinalization();
            Runtime.getRuntime().gc();
        } else if (arg.equals("Exit")) {
            this.exit();
        } else {
            System.err.println("MainPanel - Menu command not found: " + arg.toString());
        }
    }

    private void chooseKey() {
        JFileChooser d = MainPanel.getFileChooser();
        d.setFileFilter(new KeyFileFilter());
        d.setAcceptAllFileFilterUsed(false);
        FFESystem sys = this.getHierarchy().getActive();
        if (sys != null) {
            File newCWD = sys.getFile();
            if (newCWD != null && newCWD.getParentFile() != null) {
                d.setCurrentDirectory(newCWD.getParentFile());
            }
        } else {
            return;
        }
        int result = d.showOpenDialog(this);
        if (result == 0) {
            File f = d.getSelectedFile();
            sys.setKeyFile(f);
            sys.setKeywords(KeyFilter.open(f));
            this.getKeywordPanel().loadActive(sys);
        }
    }

    private void chooseLog() {
        File f;
        JFileChooser d = MainPanel.getFileChooser();
        FFESystem sys = this.getHierarchy().getActive();
        if (sys != null) {
            File cwd = sys.getFile();
            if (cwd != null && cwd.getParentFile() != null) {
                d.setCurrentDirectory(cwd.getParentFile());
            }
        } else {
            return;
        }
        d.setDialogTitle("Select a log file");
        d.setAcceptAllFileFilterUsed(true);
        int result = d.showOpenDialog(this);
        if (result == 0 && (f = d.getSelectedFile()) != null) {
            sys.setLogFile(f);
            this.setCWD(d.getCurrentDirectory());
            this.getModelingPanel().selected();
        }
    }

    private void chooseTinker() {
        JFileChooser d = MainPanel.getFileChooser();
        d.setDialogTitle("Select the Tinker Directory");
        d.setSelectedFile(tinkerDir);
        d.setFileSelectionMode(1);
        int result = d.showOpenDialog(this);
        if (result == 0) {
            tinkerDir = d.getSelectedFile();
        }
        d.setFileSelectionMode(0);
    }

    public void close() {
        FFESystem m = this.hierarchy.getActive();
        this.close(m);
    }

    public void close(FFESystem closedModel) {
        if (closedModel != null && closedModel.getParent() != null) {
            Trajectory traj = closedModel.getTrajectory();
            if (traj != null) {
                traj.stop();
            }
            if (this.simulation != null && this.simulation.getFSystem() == closedModel) {
                this.release();
            }
            this.hierarchy.removeTreeNode(closedModel);
        }
    }

    public void closeAll() {
        while (this.hierarchy.getActive() != null) {
            this.close();
        }
    }

    private void connect() {
        if (this.simulation == null || this.simulation.isFinished()) {
            if (this.simulation != null) {
                this.simulation.release();
            }
            this.simulation = new TinkerSimulation(null, null, this, this.socketAddress);
            this.simulation.connect();
            this.menuMenu.setConnect(false);
            this.setPanel(0);
        }
    }

    public void connectToTinker(FFESystem system, Thread modelingThread) {
        if (this.simulation == null || this.simulation.isFinished()) {
            if (this.simulation != null) {
                this.simulation.release();
            }
            InetSocketAddress tempAddress = null;
            try {
                if (SystemUtils.IS_OS_MAC) {
                    Process p = Runtime.getRuntime().exec("ipconfig getifaddr en0");
                    BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    String line = null;
                    String myIP = null;
                    while ((line = input.readLine()) != null) {
                        myIP = line;
                    }
                    p.waitFor();
                    tempAddress = new InetSocketAddress(myIP, this.port);
                } else {
                    tempAddress = new InetSocketAddress(InetAddress.getLocalHost(), this.port);
                }
            }
            catch (Exception e) {
                try {
                    tempAddress = new InetSocketAddress(InetAddress.getByName(null), this.port);
                }
                catch (Exception ex) {
                    System.err.println("Could not determine Local Host: " + String.valueOf(ex));
                    return;
                }
            }
            this.simulation = new TinkerSimulation(system, modelingThread, this, tempAddress);
            if (modelingThread != null) {
                modelingThread.start();
            }
            this.simulation.connect();
            this.menuMenu.setConnect(false);
            this.setPanel(0);
        }
    }

    public boolean createKeyFile(FFESystem system) {
        String message = new String("Please select a parameter file and a Tinker Key file will be created.");
        String params = (String)JOptionPane.showInputDialog(this, message, "Parameter File", 3, null, this.keywordPanel.getParamFiles(), null);
        if (params != null) {
            if (params.equalsIgnoreCase("Use an Existing Tinker KEY file")) {
                File keyfile;
                JFileChooser fc = MainPanel.getFileChooser();
                fc.setDialogTitle("Choose a KEY File");
                fc.setCurrentDirectory(cwd);
                fc.setSelectedFile(null);
                fc.setFileFilter(keyfilefilter);
                int result = fc.showOpenDialog(this);
                if (result == 0 && (keyfile = fc.getSelectedFile()).exists()) {
                    Hashtable<String, Keyword> keywordHash = KeyFilter.open(keyfile);
                    if (keywordHash == null) {
                        return false;
                    }
                    system.setKeywords(keywordHash);
                    system.setKeyFile(keyfile);
                    system.setForceField(null);
                    return true;
                }
            } else {
                File tempFile = system.getFile();
                if (tempFile.getParentFile().canWrite()) {
                    String path = system.getFile().getParent() + File.separatorChar;
                    String keyFileName = system.getName() + ".key";
                    File keyfile = new File(path + keyFileName);
                    try {
                        FileWriter fw = new FileWriter(keyfile);
                        BufferedWriter bw = new BufferedWriter(fw);
                        bw.write("\n");
                        bw.write("# Force Field Selection\n");
                        Object tempParm = this.keywordPanel.getParamPath(params);
                        if (((String)tempParm).indexOf(" ") > 0) {
                            tempParm = "\"" + this.keywordPanel.getParamPath(params) + "\"";
                        }
                        bw.write("PARAMETERS        " + (String)tempParm + "\n");
                        bw.close();
                        fw.close();
                        Hashtable<String, Keyword> keywordHash = KeyFilter.open(keyfile);
                        if (keywordHash == null) {
                            return false;
                        }
                        system.setKeywords(keywordHash);
                        system.setKeyFile(keyfile);
                        system.setForceField(null);
                        return true;
                    }
                    catch (Exception e) {
                        logger.warning(String.valueOf(e));
                        message = new String("There was an error creating " + keyfile.getAbsolutePath());
                        JOptionPane.showMessageDialog(this, message);
                    }
                } else {
                    message = new String("Could not create a Key file because " + cwd.getAbsolutePath() + " is not writable");
                    JOptionPane.showMessageDialog(this, message);
                }
            }
        }
        return false;
    }

    public void exit() {
        this.savePrefs();
        System.exit(0);
    }

    public void frame() {
        Trajectory trajectory = this.getTrajectory();
        if (trajectory == null) {
            return;
        }
        String frameNumber = new String("" + trajectory.getFrame());
        frameNumber = JOptionPane.showInputDialog("Enter the Frame Number", (Object)frameNumber);
        try {
            int f = Integer.parseInt(frameNumber);
            trajectory.setFrame(f);
        }
        catch (NumberFormatException e) {
            return;
        }
    }

    public MSRoot getDataRoot() {
        return this.dataRoot;
    }

    public FFELocale getFFELocale() {
        return this.locale;
    }

    public GraphicsCanvas getGraphics3D() {
        return this.graphicsCanvas;
    }

    public Hierarchy getHierarchy() {
        return this.hierarchy;
    }

    public KeywordPanel getKeywordPanel() {
        return this.keywordPanel;
    }

    public LogPanel getLogPanel() {
        return this.logPanel;
    }

    public MainMenu getMainMenu() {
        return this.menuMenu;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public ModelingPanel getModelingPanel() {
        return this.modelingPanel;
    }

    public ModelingShell getModelingShell() {
        if (this.modelingShell == null) {
            this.modelingShell = new ModelingShell(this);
        }
        return this.modelingShell;
    }

    public JLabel getStatusBar() {
        return this.statusLabel;
    }

    public Trajectory getTrajectory() {
        FFESystem system = this.hierarchy.getActive();
        if (system == null) {
            return null;
        }
        if (system.getFileType() != Utilities.FileType.ARC) {
            return null;
        }
        Trajectory trajectory = system.getTrajectory();
        if (trajectory != null) {
            return trajectory;
        }
        trajectory = new Trajectory(system, this);
        trajectory.setOscillate(this.oscillate);
        system.setTrajectory(trajectory);
        return trajectory;
    }

    public void highlightSelections(ActionEvent evt) {
        if (evt.getSource() instanceof JCheckBoxMenuItem) {
            JCheckBoxMenuItem jcb = (JCheckBoxMenuItem)evt.getSource();
            if (jcb.isSelected()) {
                this.hierarchy.setHighlighting(true);
            } else {
                this.hierarchy.setHighlighting(false);
            }
        } else {
            boolean highlighting = RendererCache.highlightSelections;
            if (highlighting) {
                this.hierarchy.setHighlighting(false);
                this.menuMenu.setHighlighting(false);
            } else {
                this.hierarchy.setHighlighting(true);
                this.menuMenu.setHighlighting(true);
            }
        }
    }

    private void initAbout() {
        this.aboutTextArea = new JTextArea("  Copyright (c) Michael Schnieders & Jay Ponder, 2004-2025\n  All Rights Reserved\n  Email to: ponder@dasher.wustl.edu\n");
        this.aboutTextArea.setBorder(BorderFactory.createEtchedBorder(0));
        this.aboutTextArea.setEditable(false);
    }

    public void initialize() {
        if (this.init) {
            return;
        }
        this.init = true;
        String dir = System.getProperty("user.dir", FileSystemView.getFileSystemView().getDefaultDirectory().getAbsolutePath());
        if (!SystemUtils.IS_OS_WINDOWS) {
            Object tdir = "";
            for (int i = 0; i < dir.length(); ++i) {
                char tchar = dir.charAt(i);
                tdir = tchar == ' ' ? (String)tdir + "\\ " : (String)tdir + tchar;
            }
            dir = tdir;
        }
        String topdir = dir.replaceAll("ffe", "");
        this.setCWD(new File(topdir));
        this.locale = new FFELocale("en", "US");
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog splashScreen = new JDialog((Frame)this.frame, false);
        ClassLoader loader = this.getClass().getClassLoader();
        ImageIcon logo = new ImageIcon(loader.getResource("ffe/icons/splash.png"));
        JLabel tinkerLabel = new JLabel(logo);
        tinkerLabel.setBorder(BorderFactory.createEtchedBorder(0));
        Container contentpane = splashScreen.getContentPane();
        contentpane.setLayout(new BorderLayout());
        contentpane.add((Component)tinkerLabel, "Center");
        splashScreen.setUndecorated(true);
        splashScreen.pack();
        Dimension screenDimension = this.getToolkit().getScreenSize();
        Dimension splashDimension = splashScreen.getSize();
        splashScreen.setLocation((screenDimension.width - splashDimension.width) / 2, (screenDimension.height - splashDimension.height) / 2);
        splashScreen.setResizable(false);
        splashScreen.setDefaultCloseOperation(2);
        splashScreen.setVisible(true);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        this.dataRoot = new MSRoot();
        Border bb = BorderFactory.createEtchedBorder(0);
        this.statusLabel = new JLabel("  ");
        JLabel stepLabel = new JLabel("  ");
        stepLabel.setHorizontalAlignment(4);
        JLabel energyLabel = new JLabel("  ");
        energyLabel.setHorizontalAlignment(4);
        JPanel statusPanel = new JPanel(new GridLayout(1, 3));
        statusPanel.setBorder(bb);
        statusPanel.add(this.statusLabel);
        statusPanel.add(stepLabel);
        statusPanel.add(energyLabel);
        GraphicsConfigTemplate3D template3D = new GraphicsConfigTemplate3D();
        template3D.setDoubleBuffer(2);
        GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration((GraphicsConfigTemplate)template3D);
        this.graphicsCanvas = new GraphicsCanvas(gc, this);
        this.graphicsPanel = new GraphicsPanel(this.graphicsCanvas, statusPanel);
        this.hierarchy = new Hierarchy(this);
        this.hierarchy.setStatus(this.statusLabel, stepLabel, energyLabel);
        this.keywordPanel = new KeywordPanel(this);
        this.modelingPanel = new ModelingPanel(this);
        this.logPanel = new LogPanel(this);
        JPanel treePane = new JPanel(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(this.hierarchy, 22, 32);
        treePane.add((Component)scrollPane, "Center");
        treePane.add((Component)this.logPanel.getProgressBar(), "South");
        ImageIcon graphicsIcon = new ImageIcon(loader.getResource("ffe/icons/display.png"));
        ImageIcon keywordIcon = new ImageIcon(loader.getResource("ffe/icons/keywords.png"));
        ImageIcon modelingIcon = new ImageIcon(loader.getResource("ffe/icons/commands.png"));
        ImageIcon logIcon = new ImageIcon(loader.getResource("ffe/icons/data.png"));
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab(this.locale.getValue("Graphics"), graphicsIcon, this.graphicsPanel);
        this.tabbedPane.addTab(this.locale.getValue("KeywordEditor"), keywordIcon, this.keywordPanel);
        this.tabbedPane.addTab(this.locale.getValue("ModelingCommands"), modelingIcon, this.modelingPanel);
        this.tabbedPane.addTab(this.locale.getValue("Logs"), logIcon, this.logPanel);
        this.tabbedPane.addChangeListener(this);
        this.splitPane = new JSplitPane(1, false, treePane, this.tabbedPane);
        this.splitPane.setResizeWeight(0.25);
        this.splitPane.setOneTouchExpandable(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitPane, "Center");
        this.menuMenu = new MainMenu(this);
        this.add((Component)this.menuMenu.getToolBar(), "North");
        this.getModelingShell();
        this.loadPrefs();
        SwingUtilities.updateComponentTreeUI(SwingUtilities.getRoot(this));
        splashScreen.dispose();
        stopWatch.start();
    }

    public boolean isOpening() {
        return this.openThread != null && this.openThread.isAlive();
    }

    public void loadPrefs() {
        JFrame frame1 = (JFrame)SwingUtilities.getRoot(this);
        Toolkit toolkit = this.getToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        Preferences prefs = Preferences.userNodeForPackage(MainPanel.class);
        int x = prefs.getInt("MainPanel_x", screenSize.width / 8);
        int y = prefs.getInt("MainPanel_y", screenSize.height / 8);
        int width = prefs.getInt("MainPanel_width", screenSize.width * 3 / 4);
        int height = prefs.getInt("MainPanel_height", screenSize.height * 3 / 4);
        if ((double)width > (double)screenSize.width * 0.4 && (double)width < (double)screenSize.width * 0.8 && (double)height > (double)screenSize.height * 0.4 && (double)height < (double)screenSize.height * 0.8) {
            frame1.setSize(width, height);
        } else {
            frame1.setSize(screenSize.width * 4 / 5, screenSize.height * 4 / 5);
        }
        if (x > 0 && x < screenSize.width / 2 && y > 0 && y < screenSize.height / 2) {
            frame1.setLocation(x, y);
        } else {
            frame1.setLocation(screenSize.width / 8, screenSize.height / 8);
        }
        this.splitPaneDivider = prefs.getInt("MainPanel_divider", 200);
        if ((float)this.splitPaneDivider < (float)frame1.getWidth() * 0.25f) {
            this.splitPaneDivider = (int)((float)frame1.getWidth() * 0.25f);
        }
        this.splitPane.setDividerLocation(this.splitPaneDivider);
        if (!prefs.getBoolean("MainPanel_system", true)) {
            this.menuMenu.setSystemShowing(false);
            this.splitPane.setDividerLocation(0);
        } else {
            this.menuMenu.setSystemShowing(true);
        }
        if (!prefs.getBoolean("MainPanel_menu", true)) {
            this.remove(this.menuMenu.getToolBar());
            this.menuMenu.setMenuShowing(false);
            this.validate();
        } else {
            this.menuMenu.setMenuShowing(true);
        }
        try {
            this.port = prefs.getInt("MainPanel_port", 2000);
            this.ip = prefs.get("MainPanel_ip", InetAddress.getLocalHost().getHostAddress());
            if (this.ip != null) {
                this.address = InetAddress.getByName(this.ip);
                this.socketAddress = new InetSocketAddress(this.address, this.port);
            } else {
                this.socketAddress = new InetSocketAddress(this.port);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.toString());
        }
        this.graphicsCanvas.loadPrefs();
    }

    public void merge() {
        ArrayList<MSNode> activeNodes = this.hierarchy.getActiveNodes();
        if (activeNodes.size() >= 2) {
            this.merge(activeNodes);
        }
    }

    public void merge(ArrayList<MSNode> nodesToMerge) {
        ArrayList<MSNode> activeNodes = new ArrayList<MSNode>();
        for (MSNode node : nodesToMerge) {
            if (node == null || node instanceof MSRoot) continue;
            activeNodes.add(node);
        }
        if (activeNodes.size() <= 1) {
            return;
        }
        FFESystem active = this.hierarchy.getActive();
        File file = SystemFilter.version(this.hierarchy.getActive().getFile());
        FFESystem system = new FFESystem(active.getName(), "Merge Result", file, true);
        system.setKeyFile(active.getKeyFile());
        system.setKeywords(KeyFilter.open(active.getKeyFile()));
        system.setFileType(active.getFileType());
        ArrayList<Atom> mergedAtoms = new ArrayList<Atom>();
        ArrayList<Bond> mergedBonds = new ArrayList<Bond>();
        ArrayList<FFESystem> systems = new ArrayList<FFESystem>();
        TransformGroup parentTransformGroup = null;
        Transform3D parentTransform3D = new Transform3D();
        Vector3d parentPosition = new Vector3d();
        Vector3d atomPosition = new Vector3d();
        int atomNum = 1;
        Vector3d zero = new Vector3d(0.0, 0.0, 0.0);
        for (MSNode m : activeNodes) {
            FFESystem parentSystem = (FFESystem)m.getMSNode(FFESystem.class);
            if (parentSystem == null) {
                return;
            }
            if (!systems.contains(parentSystem)) {
                this.graphicsCanvas.updateSceneWait(parentSystem, false, true, RendererCache.ViewModel.WIREFRAME, false, null);
                systems.add(parentSystem);
            }
            parentTransformGroup = parentSystem.getOriginToRot();
            parentTransformGroup.getTransform(parentTransform3D);
            parentTransform3D.get(parentPosition);
            parentTransform3D.setTranslation(zero);
            ArrayList<Atom> atoms = m.getAtomList();
            ArrayList<ROLS> bonds = m.getBondList();
            for (Atom atom : atoms) {
                atom.removeFromParent();
                atom.setXYZIndex(atomNum++);
                mergedAtoms.add(atom);
                atom.getV3D(atomPosition);
                parentTransform3D.transform(atomPosition);
                atomPosition.add((Tuple3d)parentPosition);
                atom.moveTo(atomPosition);
            }
            for (ROLS msm : bonds) {
                Bond bond = (Bond)msm;
                bond.removeFromParent();
                mergedBonds.add((Bond)msm);
            }
        }
        for (FFESystem sys : systems) {
            this.close(sys);
        }
        MergeFilter mergeFilter = new MergeFilter(system, mergedAtoms, mergedBonds);
        FileOpener fileOpener = new FileOpener(mergeFilter, this);
        Thread thread = new Thread(fileOpener);
        thread.start();
    }

    public void merge(MSNode[] nodesToMerge) {
        ArrayList<MSNode> activeNodes = new ArrayList<MSNode>();
        for (MSNode node : nodesToMerge) {
            if (node == null) continue;
            activeNodes.add(node);
        }
        if (activeNodes.size() > 1) {
            this.merge(activeNodes);
        }
    }

    public void oceanLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            SwingUtilities.updateComponentTreeUI(SwingUtilities.getRoot(this));
        }
        catch (Exception e) {
            return;
        }
    }

    private void open() {
        if (this.openThread != null && this.openThread.isAlive()) {
            return;
        }
        JFileChooser fc = MainPanel.getFileChooser();
        fc.setDialogTitle("Choose XYZ/Archive File");
        fc.setAcceptAllFileFilterUsed(true);
        fc.addChoosableFileFilter(xyzFileFilter);
        fc.addChoosableFileFilter(pdbFileFilter);
        fc.addChoosableFileFilter(intFileFilter);
        fc.addChoosableFileFilter(arcFileFilter);
        int result = fc.showOpenDialog(this);
        if (result == 0) {
            File file = fc.getSelectedFile();
            this.open(file, null);
        }
    }

    public void open(File file, String commandDescription) {
        if (file == null || !file.isFile() || !file.canRead()) {
            return;
        }
        file = new File(FilenameUtils.normalize((String)file.getAbsolutePath()));
        this.setCWD(file.getParentFile());
        String fileName = FilenameUtils.getBaseName((String)file.getName());
        FFESystem newSystem = new FFESystem(fileName, commandDescription, file, false);
        SystemFilter systemFilter = null;
        if (xyzFileFilter.acceptDeep(file)) {
            newSystem.setFileType(Utilities.FileType.XYZ);
            systemFilter = new XYZFilter(newSystem);
        } else if (intFileFilter.acceptDeep(file)) {
            newSystem.setFileType(Utilities.FileType.INT);
            systemFilter = new INTFilter(newSystem);
        } else {
            newSystem.setFileType(Utilities.FileType.PDB);
            systemFilter = new PDBFilter(newSystem);
        }
        if (this.openKey(newSystem, true)) {
            Keyword parameters = newSystem.getKeyword("PARAMETERS");
            if (parameters != null) {
                Object parmname = parameters.getEntry(0);
                File parameterFile = null;
                if (parmname != null && !((String)parmname).equalsIgnoreCase("NONE")) {
                    File keyFile;
                    if (!((String)(parmname = ((String)parmname).replaceAll("\"", ""))).endsWith(".prm")) {
                        parmname = (String)parmname + ".prm";
                    }
                    if (!(parameterFile = new File((String)parmname)).exists() && (keyFile = newSystem.getKeyFile()) != null) {
                        parameterFile = new File(keyFile.getParent() + File.separator + (String)parmname);
                    }
                }
                this.forceFieldFilter = new ForceFieldFilter(parameterFile, newSystem.getKeyFile());
                ForceField forceField = this.forceFieldFilter.parse();
                newSystem.setForceField(forceField);
                systemFilter.setForceField(forceField);
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            FileOpener openFile = new FileOpener(systemFilter, this);
            this.openThread = new Thread(openFile);
            this.openThread.start();
            this.setPanel(0);
        }
    }

    public void open(String name) {
        if (name == null) {
            return;
        }
        File f = new File(name);
        if (!f.exists() && !(f = new File(String.valueOf(cwd) + File.separator + name)).exists()) {
            logger.warning(name + ": could not be found.");
            return;
        }
        this.open(f, null);
    }

    private void openInduced() {
        FFESystem active = this.hierarchy.getActive();
        JFileChooser fileChooser = MainPanel.getFileChooser();
        fileChooser.setCurrentDirectory(cwd);
        fileChooser.setSelectedFile(active.getFile());
        fileChooser.setDialogTitle("Choose Induced Dipole File");
        fileChooser.addChoosableFileFilter(indFileFilter);
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.setFileFilter(indFileFilter);
        int result = fileChooser.showOpenDialog(this);
        if (result == 0) {
            File f = fileChooser.getSelectedFile();
            InducedFilter indFilter = new InducedFilter(active, f);
            indFilter.read();
        }
    }

    public boolean openKey(FFESystem newSystem, boolean createKey) {
        String keyFileName = null;
        String temp = newSystem.getFile().getName();
        int dot = temp.lastIndexOf(".");
        keyFileName = dot > 0 ? temp.substring(0, dot) + ".key" : temp + ".key";
        String path = newSystem.getFile().getParent() + File.separator;
        File keyfile = new File(path + keyFileName);
        if (keyfile.exists()) {
            Hashtable<String, Keyword> keywordHash = KeyFilter.open(keyfile);
            if (keywordHash == null) {
                return false;
            }
            newSystem.setKeywords(keywordHash);
            newSystem.setKeyFile(keyfile);
            newSystem.setForceField(null);
            return true;
        }
        keyfile = new File(path + "tinker.key");
        if (keyfile.exists()) {
            logger.info("Using tinker.key: " + String.valueOf(keyfile));
            Hashtable<String, Keyword> keywordHash = KeyFilter.open(keyfile);
            if (keywordHash == null) {
                return false;
            }
            newSystem.setKeywords(keywordHash);
            newSystem.setKeyFile(keyfile);
            newSystem.setForceField(null);
            return true;
        }
        if (createKey) {
            return this.createKeyFile(newSystem);
        }
        return false;
    }

    public void openOn(File f, FFESystem oldSystem, String command) {
        if (oldSystem.getFileType() != Utilities.FileType.XYZ) {
            this.open(f, command);
            return;
        }
        XYZFilter.readOnto(f, oldSystem);
        oldSystem.setCommandDescription(command);
        this.graphicsCanvas.updateScene(oldSystem, true, false, null, false, null);
        this.getHierarchy().updateStatus();
        this.getHierarchy().repaint();
    }

    private void openRestart() {
        FFESystem active = this.hierarchy.getActive();
        JFileChooser fileChooser = MainPanel.getFileChooser();
        fileChooser.setCurrentDirectory(cwd);
        fileChooser.setSelectedFile(this.hierarchy.getActive().getFile());
        fileChooser.setDialogTitle("Choose Restart File");
        fileChooser.addChoosableFileFilter(dynFileFilter);
        fileChooser.setAcceptAllFileFilterUsed(true);
        int result = fileChooser.showOpenDialog(this);
        if (result == 0) {
            File f = fileChooser.getSelectedFile();
            DYNFilter dynFilter = new DYNFilter(active, f);
            dynFilter.read();
        }
    }

    public void oscillate(ActionEvent evt) {
        this.oscillate = ((JCheckBoxMenuItem)evt.getSource()).isSelected();
        FFESystem[] systems = this.getHierarchy().getSystems();
        for (int i = 0; i < systems.length; ++i) {
            Trajectory trajectory = systems[i].getTrajectory();
            if (trajectory == null) continue;
            trajectory.setOscillate(this.oscillate);
        }
    }

    public void platformLookAndFeel() {
        try {
            if (SystemUtils.IS_OS_LINUX) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
            } else {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            SwingUtilities.updateComponentTreeUI(SwingUtilities.getRoot(this));
        }
        catch (Exception e) {
            logger.warning("Can't Set Look and Feel: " + String.valueOf(e));
        }
    }

    public void play() {
        Trajectory trajectory = this.getTrajectory();
        if (trajectory == null) {
            return;
        }
        trajectory.start();
    }

    private void release() {
        if (this.simulation != null) {
            this.simulation.release();
            this.simulation = null;
            this.menuMenu.setConnect(true);
        }
    }

    public void reset() {
        Trajectory trajectory = this.getTrajectory();
        if (trajectory == null) {
            return;
        }
        trajectory.stop();
        trajectory.rewind();
    }

    public void resetPanes() {
        this.resizePanes(0);
    }

    public void resetShell() {
        this.modelingShell = this.getModelingShell();
        this.modelingShell.savePrefs();
        this.modelingShell = new ModelingShell(this);
    }

    public void resizePanes(int move) {
        if (move == 0) {
            this.splitPaneDivider = 0;
            this.menuMenu.setMenuShowing(false);
            this.menuMenu.menuClick();
            this.menuMenu.setSystemShowing(false);
            this.menuMenu.systemClick();
        } else {
            this.splitPane.setDividerLocation(this.splitPane.getDividerLocation() + move);
        }
    }

    public void save(File file) {
        FFESystem system = this.hierarchy.getActive();
        if (system != null && !system.isClosing()) {
            if (system.getFileType() != Utilities.FileType.XYZ) {
                return;
            }
            XYZFilter filter = new XYZFilter();
            File savefile = null;
            if (file != null) {
                savefile = file;
            } else {
                JFileChooser fileChooser = MainPanel.getFileChooser();
                fileChooser.setCurrentDirectory(cwd);
                fileChooser.setAcceptAllFileFilterUsed(true);
                int result = fileChooser.showSaveDialog(this);
                if (result == 0) {
                    savefile = fileChooser.getSelectedFile();
                    cwd = savefile.getParentFile();
                }
            }
            if (savefile != null) {
                filter.setMolecularSystem(system);
                if (((SystemFilter)filter).writeFile()) {
                    system.setFile(savefile);
                    system.setName(savefile.getName());
                    this.hierarchy.setActive(system);
                }
            }
        }
    }

    private void savePrefs() {
        Preferences prefs = Preferences.userNodeForPackage(MainPanel.class);
        JFrame frame = (JFrame)SwingUtilities.getRoot(this);
        prefs.putInt("MainPanel_x", frame.getLocation().x);
        prefs.putInt("MainPanel_y", frame.getLocation().y);
        prefs.putInt("MainPanel_width", frame.getWidth());
        prefs.putInt("MainPanel_height", frame.getHeight());
        prefs.putBoolean("MainPanel_system", this.menuMenu.isSystemShowing());
        prefs.putInt("MainPanel_divider", this.splitPane.getDividerLocation());
        prefs.putBoolean("MainPanel_menu", this.menuMenu.isMenuShowing());
        prefs.putBoolean("MainPanel_axis", this.menuMenu.isAxisShowing());
        if (this.ip == null) {
            this.ip = new String("");
        }
        if (this.address != null) {
            String s = this.address.getHostAddress();
            if (s != null) {
                prefs.put("MainPanel_ip", s);
            }
            prefs.putInt("MainPanel_port", this.socketAddress.getPort());
        }
        prefs.put("MainPanel_cwd", cwd.toString());
        this.modelingPanel.savePrefs();
        this.keywordPanel.savePrefs();
        this.modelingShell.savePrefs();
        if (this.graphicsCanvas != null) {
            this.graphicsCanvas.savePrefs();
        }
    }

    public void selectAll() {
        if (this.dataRoot.getChildCount() == 0) {
            return;
        }
        this.hierarchy.selectAll();
    }

    public void setCWD(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        cwd = file;
    }

    public void setPanel(int panel) {
        this.tabbedPane.setSelectedIndex(panel);
    }

    public void setPort() {
        int temp;
        String s = new String("" + this.port);
        if ((s = JOptionPane.showInputDialog("Enter a port number", (Object)s)) == null) {
            return;
        }
        try {
            temp = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return;
        }
        this.port = temp;
        this.socketAddress = new InetSocketAddress(this.address, this.port);
    }

    public void setRemoteJobAddress() {
        InetSocketAddress newSocketAddress;
        InetAddress newAddress;
        if (this.address == null) {
            try {
                this.address = InetAddress.getLocalHost();
            }
            catch (Exception e) {
                try {
                    this.address = InetAddress.getByName(null);
                }
                catch (Exception ex) {
                    return;
                }
            }
        }
        String s = new String(this.address.getHostAddress());
        if ((s = JOptionPane.showInputDialog("Enter an IP Address (XXX.XXX.XXX.XXX)", (Object)s)) == null) {
            return;
        }
        try {
            newAddress = InetAddress.getByName(s);
            newSocketAddress = new InetSocketAddress(newAddress, this.port);
        }
        catch (NumberFormatException e) {
            return;
        }
        catch (Exception e) {
            return;
        }
        this.address = newAddress;
        this.socketAddress = newSocketAddress;
    }

    public void showGlobalAxes(ActionEvent evt) {
        JCheckBoxMenuItem showAxesCheckBox = (JCheckBoxMenuItem)evt.getSource();
        this.graphicsCanvas.setAxisShowing(showAxesCheckBox.isSelected());
    }

    public void showToolBar(ActionEvent evt) {
        JCheckBoxMenuItem toolBarCheckBox = (JCheckBoxMenuItem)evt.getSource();
        if (toolBarCheckBox.isSelected()) {
            this.add((Component)this.menuMenu.getToolBar(), "North");
            this.frame.validate();
        } else {
            this.remove(this.menuMenu.getToolBar());
            this.frame.validate();
        }
    }

    public void showTree(ActionEvent evt) {
        JCheckBoxMenuItem showTreeCheckBox = (JCheckBoxMenuItem)evt.getSource();
        if (showTreeCheckBox.isSelected()) {
            if ((float)this.splitPaneDivider < (float)this.frame.getWidth() * 0.25f) {
                this.splitPaneDivider = (int)((float)this.frame.getWidth() * 0.25f);
            }
            this.splitPane.setDividerLocation(this.splitPaneDivider);
        } else {
            this.splitPaneDivider = this.splitPane.getDividerLocation();
            this.splitPane.setDividerLocation(0.0);
        }
    }

    public void skip() {
        Trajectory trajectory = this.getTrajectory();
        if (trajectory == null) {
            return;
        }
        String skip = new String("" + trajectory.getSkip());
        skip = JOptionPane.showInputDialog("Enter the Number of Frames to Skip", (Object)skip);
        try {
            int f = Integer.parseInt(skip);
            trajectory.setSkip(f);
        }
        catch (NumberFormatException e) {
            return;
        }
    }

    public void speed() {
        Trajectory trajectory = this.getTrajectory();
        if (trajectory == null) {
            return;
        }
        String frame = new String("" + trajectory.getRate());
        frame = JOptionPane.showInputDialog("Enter the Frame Rate (1-100)", (Object)frame);
        try {
            int f = Integer.parseInt(frame);
            trajectory.setRate(f);
        }
        catch (NumberFormatException e) {
            return;
        }
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        JTabbedPane jtp = (JTabbedPane)evt.getSource();
        int index = jtp.getSelectedIndex();
        if (index == 0) {
            this.graphicsCanvas.selected();
        } else if (index == 1) {
            this.keywordPanel.selected();
        } else if (index == 2) {
            this.modelingPanel.selected();
        } else if (index == 3) {
            this.logPanel.selected();
        }
    }

    public void stepBack() {
        Trajectory trajectory = this.getTrajectory();
        if (trajectory == null) {
            return;
        }
        trajectory.stop();
        trajectory.back();
    }

    public void stepForward() {
        Trajectory trajectory = this.getTrajectory();
        if (trajectory == null) {
            return;
        }
        trajectory.stop();
        trajectory.forward();
    }

    public void stop() {
        Trajectory trajectory = this.getTrajectory();
        if (trajectory == null) {
            return;
        }
        trajectory.stop();
    }

    @Override
    public String toString() {
        return "Program Control";
    }

    public void openFromPDB() {
        if (this.openThread != null && this.openThread.isAlive()) {
            return;
        }
        String code = JOptionPane.showInputDialog("Enter the 4-Character PDB ID:", (Object)"");
        if ((code = code.trim()) == null || code.length() != 4) {
            return;
        }
        System.out.println("Request: " + code);
        System.out.println("Database: PDB");
        String pdbAddress = "https://www.rcsb.org/pdb/download/downloadFile.do?fileFormat=pdb&compression=NO&structureId=" + code;
        logger.log(Level.INFO, pdbAddress);
        try {
            String path = MainPanel.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            String decodedPath = URLDecoder.decode(path, "UTF-8");
            decodedPath = decodedPath.replaceAll("ffe/lib/.*jar", "");
            String PDBDir = decodedPath + "PDBdownloads/";
            String fileName = code + ".pdb";
            File pdbFile = new File(PDBDir + fileName);
            File directory = new File(PDBDir);
            if (!directory.exists()) {
                directory.mkdir();
            }
            FFESystem newSystem = new FFESystem(code, null, pdbFile, false);
            PDBFilter pdbFilter = new PDBFilter((MolecularAssembly)newSystem, pdbAddress);
            this.setCursor(Cursor.getPredefinedCursor(3));
            FileOpener openFile = new FileOpener(pdbFilter, this);
            this.openThread = new Thread(openFile);
            this.openThread.start();
            this.setPanel(0);
        }
        catch (Exception e) {
            return;
        }
    }

    public void openFromPubChem() {
        String databaseName = "PubChem";
        JTextField moleculeName = new JTextField();
        String result = JOptionPane.showInputDialog(null, "Enter the Molecule Name:", "", 1);
        System.out.println("Request: " + result);
        if (result != null) {
            this.xyzFromURL(result, databaseName);
        }
    }

    public void openFromNCI() {
        String databaseName = "NCI";
        JTextField moleculeName = new JTextField();
        String result = JOptionPane.showInputDialog(null, "Enter the Molecule Name:", "", 1);
        System.out.println("Request: " + result);
        if (result != null) {
            this.xyzFromURL(result, databaseName);
        }
    }

    public void xyzFromURL(String moleculeName, String databaseName) {
        try {
            int linecount;
            int bonds;
            String path = MainPanel.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            String decodedPath = URLDecoder.decode(path, "UTF-8");
            decodedPath = decodedPath.replaceAll("ffe/lib/.*jar", "");
            String NIHDir = decodedPath + "NIHdownloads/";
            File directory = new File(NIHDir);
            if (!directory.exists()) {
                directory.mkdir();
            }
            System.out.println("Database: " + databaseName);
            URL url = new URL("https://pubchem.ncbi.nlm.nih.gov/rest/pug/compound/name/" + moleculeName + "/record/SDF/?record_type=3d&response_type=display");
            if (databaseName == "NCI") {
                url = new URL("https://cactus.nci.nih.gov/chemical/structure/" + moleculeName + "/sdf");
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            Scanner scan = new Scanner(in);
            scan.nextLine();
            scan.nextLine();
            scan.nextLine();
            int atoms = scan.nextInt();
            if (atoms > 99) {
                bonds = atoms % 1000;
                atoms /= 1000;
            } else {
                bonds = scan.nextInt();
            }
            scan.nextLine();
            float[] x = new float[atoms];
            float[] y = new float[atoms];
            float[] z = new float[atoms];
            String[] atom = new String[atoms];
            int[] bondatom = new int[bonds * 2];
            for (linecount = 0; linecount < atoms; ++linecount) {
                x[linecount] = scan.nextFloat();
                y[linecount] = scan.nextFloat();
                z[linecount] = scan.nextFloat();
                atom[linecount] = scan.next();
                scan.nextLine();
            }
            linecount = 0;
            while (linecount < bonds * 2) {
                bondatom[linecount] = Integer.parseInt(scan.next());
                if (bondatom[linecount] > 99) {
                    bondatom[linecount + 1] = bondatom[linecount] % 1000;
                    bondatom[linecount] = bondatom[linecount] / 1000;
                    linecount += 2;
                    scan.nextLine();
                    continue;
                }
                bondatom[++linecount] = Integer.parseInt(scan.next());
                scan.nextLine();
                ++linecount;
            }
            in.close();
            scan.close();
            File keyfile = new File(NIHDir + moleculeName + ".key");
            FileWriter keyfilewrite = new FileWriter(keyfile);
            BufferedWriter keyoutput = new BufferedWriter(keyfilewrite);
            Object PRMDir = NIHDir.replaceAll("NIHdownloads/", "") + "tinker/params/";
            PRMDir = ((String)PRMDir).replaceAll("/C:", "C:");
            keyoutput.append("\n# Force Field Selection\nPARAMETERS        " + (String)PRMDir + "basic.prm\n");
            keyoutput.close();
            File file = new File(NIHDir + moleculeName + ".xyz");
            FileWriter filewrite = new FileWriter(file);
            BufferedWriter output = new BufferedWriter(filewrite);
            output.append(atoms + "\t" + moleculeName + "\n");
            int[] numberofbonds = new int[atoms];
            int[] atomtype = new int[atoms];
            for (linecount = 0; linecount < atoms; ++linecount) {
                int bondcount;
                output.append(linecount + 1 + "\t");
                output.append(atom[linecount] + "\t");
                output.append(x[linecount] + "\t \t");
                output.append(y[linecount] + "\t \t");
                output.append(z[linecount] + "\t \t");
                for (bondcount = 0; bondcount < bonds * 2; ++bondcount) {
                    if (bondatom[bondcount] != linecount + 1) continue;
                    int n = linecount;
                    numberofbonds[n] = numberofbonds[n] + 1;
                }
                atomtype[linecount] = atom[linecount].contains("Cl") ? 170 + numberofbonds[linecount] : (atom[linecount].contains("Si") ? 140 + numberofbonds[linecount] : (atom[linecount].contains("Br") ? 350 + numberofbonds[linecount] : (atom[linecount].contains("C") ? 60 + numberofbonds[linecount] : (atom[linecount].contains("H") ? 10 + numberofbonds[linecount] : (atom[linecount].contains("O") ? 80 + numberofbonds[linecount] : (atom[linecount].contains("N") ? 70 + numberofbonds[linecount] : (atom[linecount].contains("S") ? 160 + numberofbonds[linecount] : (atom[linecount].contains("P") ? 150 + numberofbonds[linecount] : (atom[linecount].contains("B") ? 50 + numberofbonds[linecount] : (atom[linecount].contains("I") ? 530 + numberofbonds[linecount] : (atom[linecount].contains("F") ? 90 + numberofbonds[linecount] : 70 + numberofbonds[linecount])))))))))));
                output.append(atomtype[linecount] + "\t");
                for (bondcount = 0; bondcount < bonds * 2; ++bondcount) {
                    if (bondatom[bondcount] != linecount + 1) continue;
                    if (bondcount % 2 == 0) {
                        output.append(bondatom[bondcount + 1] + "\t");
                        continue;
                    }
                    output.append(bondatom[bondcount - 1] + "\t");
                }
                output.append("\n");
            }
            output.close();
            this.open(file, null);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    static {
        logger = Logger.getLogger("ffe");
        xyzFileFilter = new XYZFileFilter();
        arcFileFilter = new ARCFileFilter();
        intFileFilter = new INTFileFilter();
        dynFileFilter = new DYNFileFilter();
        indFileFilter = new InducedFileFilter();
        forceFieldFileFilter = new ForceFieldFileFilter();
        pdbFileFilter = new PDBFileFilter();
        keyfilefilter = new KeyFileFilter();
        stopWatch = new StopWatch();
        try {
            String ffeString = System.getenv("FFE_HOME");
            if (ffeString == null) {
                ffeString = ".";
            }
            ffeString = System.getProperty("ffe.dir", ffeString);
            ffeDir = new File(ffeString);
            if (SystemUtils.IS_OS_LINUX) {
                System.load(ffeDir.getAbsolutePath() + "/native/linux/libffe.so");
            } else if (SystemUtils.IS_OS_MAC) {
                System.load(ffeDir.getAbsolutePath() + "/native/macos/libffe.jnilib");
            } else if (SystemUtils.IS_OS_WINDOWS) {
                System.load(ffeDir.getAbsolutePath() + "/native/windows/ffe.dll");
            }
            String tinkerString = System.getenv("TINKER_HOME");
            if (tinkerString == null) {
                tinkerString = ".";
            }
            tinkerString = System.getProperty("ffe.tinker.dir", tinkerString);
            tinkerDir = new File(tinkerString);
            classpath = System.getProperty("java.class.path");
            ld_library_path = System.getProperty("java.library.path");
            cwd = MainPanel.getCWD();
            logger.info("\nCLASSPATH: " + classpath + "\nld_library_path: " + ld_library_path + "\nFFE_HOME: " + ffeDir.getAbsolutePath() + "\nTINKER_HOME: " + tinkerDir.getAbsolutePath() + "\nCURRENT_DIRECTORY: " + String.valueOf(cwd) + "\n");
        }
        catch (Exception e) {
            logger.severe("FFE/Tinker Directories Could Not be Found\n" + String.valueOf(e));
        }
    }
}

