/*
 * Decompiled with CFR 0.152.
 */
package ffe.core;

import ffe.core.GraphicsCanvas;
import ffe.core.MainPanel;
import ffe.properties.FFELocale;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.apache.commons.lang.SystemUtils;

public class MainMenu
extends JMenuBar {
    private static final long serialVersionUID = 1L;
    private static int keyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private MainPanel mainPanel;
    private GraphicsCanvas graphics;
    private FFELocale locale;
    private ClassLoader loader;
    private JToolBar toolBar;
    private Insets insets;
    private ImageIcon blankIcon;
    private JCheckBoxMenuItem highlightCBMI;
    private JCheckBoxMenuItem labelResiduesMI;
    private JCheckBoxMenuItem labelAtomsMI;
    private JRadioButtonMenuItem activeRBMI;
    private JRadioButtonMenuItem mouseRBMI;
    private ButtonGroup dragModeButtonGroup;
    private ButtonGroup leftMouseButtonGroup;
    private JRadioButtonMenuItem rotateRBMI;
    private JRadioButtonMenuItem translateRBMI;
    private JRadioButtonMenuItem zoomRBMI;
    private JCheckBoxMenuItem pickingCBMI;
    private JRadioButtonMenuItem atomRBMI;
    private JRadioButtonMenuItem bondRBMI;
    private JRadioButtonMenuItem angleRBMI;
    private JRadioButtonMenuItem dihedralRBMI;
    private JRadioButtonMenuItem residueRBMI;
    private JRadioButtonMenuItem polymerRBMI;
    private JRadioButtonMenuItem moleculeRBMI;
    private JRadioButtonMenuItem systemRBMI;
    private JRadioButtonMenuItem measureDistanceRBMI;
    private JRadioButtonMenuItem measureAngleRBMI;
    private JRadioButtonMenuItem measureDihedralRBMI;
    private ButtonGroup levelBG;
    private JCheckBoxMenuItem oscillateCBMI;
    private JMenuItem localMI;
    private JMenuItem remoteMI;
    private JMenuItem releaseMI;
    private ButtonGroup captureFormatButtonGroup;
    private JCheckBoxMenuItem systemsCBMI;
    private JCheckBoxMenuItem toolBarCBMI;
    private JCheckBoxMenuItem globalAxisCBMI;
    private JRadioButtonMenuItem javaRBMI;
    private JRadioButtonMenuItem nativeRBMI;
    private ButtonGroup skinButtonGroup;

    public MainMenu(MainPanel f) {
        this.mainPanel = f;
        this.graphics = this.mainPanel.getGraphics3D();
        this.locale = this.mainPanel.getFFELocale();
        this.loader = this.getClass().getClassLoader();
        this.blankIcon = new ImageIcon(this.loader.getResource("ffe/icons/blank.gif"));
        JMenu fileMenu = this.addMenu("File", 'F');
        JMenu selectionMenu = this.addMenu("Selection", 'E');
        JMenu displayMenu = this.addMenu("Display", 'D');
        JMenu colorMenu = this.addMenu("Color", 'C');
        JMenu optionsMenu = this.addMenu("Options", 'O');
        JMenu pickingMenu = this.addMenu("Picking", 'P');
        JMenu trajectoryMenu = this.addMenu("Trajectory", 'T');
        JMenu simulationMenu = this.addMenu("Simulation", 'S');
        JMenu exportMenu = this.addMenu("Export", 'X');
        JMenu windowMenu = this.addMenu("Window", 'W');
        this.addMenuItem(fileMenu, "open", "Open", 'O', 79, this.mainPanel);
        this.addMenuItem(fileMenu, "saveAs", "SaveAs", 'S', 83, this.mainPanel);
        this.addMenuItem(fileMenu, "close", "Close", 'C', -1, this.mainPanel);
        this.addMenuItem(fileMenu, "BLANK", "CloseAll", 'A', -1, this.mainPanel);
        fileMenu.addSeparator();
        this.addMenuItem(fileMenu, "BLANK", "DownloadFromPubChem", 'M', -1, this.mainPanel);
        this.addMenuItem(fileMenu, "BLANK", "DownloadFromNCI", 'M', -1, this.mainPanel);
        this.addMenuItem(fileMenu, "BLANK", "DownloadFromPDB", 'M', -1, this.mainPanel);
        fileMenu.addSeparator();
        this.addMenuItem(fileMenu, "BLANK", "ChooseKeyFile", 'R', -1, this.mainPanel);
        this.addMenuItem(fileMenu, "BLANK", "ChooseLogFile", 'I', -1, this.mainPanel);
        this.addMenuItem(fileMenu, "BLANK", "LoadRestartData", 'R', -1, this.mainPanel);
        this.addMenuItem(fileMenu, "BLANK", "LoadInducedData", 'I', -1, this.mainPanel);
        fileMenu.addSeparator();
        this.addMenuItem(fileMenu, "BLANK", "ChooseTinkerLocation", 'I', -1, this.mainPanel);
        fileMenu.addSeparator();
        this.addMenuItem(fileMenu, "exit", "Exit", 'E', -1, this.mainPanel);
        this.addMenuItem(selectionMenu, "BLANK", "SelectAll", 'A', 65, this.mainPanel);
        this.addMenuItem(selectionMenu, "BLANK", "RestrictToSelections", 'R', -1, this.graphics);
        this.addMenuItem(selectionMenu, "BLANK", "MergeSelections", 'M', -1, this.mainPanel);
        selectionMenu.addSeparator();
        this.highlightCBMI = this.addCBMenuItem(selectionMenu, "highlight", "HighlightSelections", 'H', 72, this.mainPanel);
        this.addMenuItem(selectionMenu, "color", "SetSelectionColor", 'S', -1, this.graphics);
        selectionMenu.addSeparator();
        this.labelAtomsMI = this.addCBMenuItem(selectionMenu, "BLANK", "LabelSelectedAtoms", 'O', -1, this.graphics);
        this.labelResiduesMI = this.addCBMenuItem(selectionMenu, "BLANK", "LabelSelectedResidues", 'R', -1, this.graphics);
        this.addMenuItem(selectionMenu, "BLANK", "SetLabelFontSize", 'Z', -1, this.graphics);
        this.addMenuItem(selectionMenu, "color", "SetLabelFontColor", 'C', -1, this.graphics);
        this.highlightCBMI.setSelected(false);
        this.labelAtomsMI.setSelected(false);
        this.labelResiduesMI.setSelected(false);
        this.addMenuItem(displayMenu, "BLANK", "Wireframe", 'W', -1, this.graphics);
        this.addMenuItem(displayMenu, "BLANK", "Tube", 'T', -1, this.graphics);
        this.addMenuItem(displayMenu, "BLANK", "Spacefill", 'S', -1, this.graphics);
        this.addMenuItem(displayMenu, "BLANK", "BallAndStick", 'B', -1, this.graphics);
        this.addMenuItem(displayMenu, "BLANK", "Invisible", 'I', -1, this.graphics);
        this.addMenuItem(displayMenu, "BLANK", "RMIN", 'R', -1, this.graphics);
        displayMenu.addSeparator();
        this.addMenuItem(displayMenu, "BLANK", "ShowHydrogens", 'H', -1, this.graphics);
        this.addMenuItem(displayMenu, "BLANK", "HideHydrogens", 'Y', -1, this.graphics);
        JMenu vectorTypeMenu = this.addSubMenu(displayMenu, "VectorType", 'T');
        this.addMenuItem(vectorTypeMenu, "BLANK", "InducedDipole", 'I', -1, this.graphics);
        this.addMenuItem(vectorTypeMenu, "BLANK", "Force", 'F', -1, this.graphics);
        this.addMenuItem(vectorTypeMenu, "BLANK", "Velocity", 'V', -1, this.graphics);
        this.addMenuItem(vectorTypeMenu, "BLANK", "Acceleration", 'A', -1, this.graphics);
        this.addMenuItem(vectorTypeMenu, "BLANK", "HideVectors", 'I', -1, this.graphics);
        JMenu vectorLengthMenu = this.addSubMenu(displayMenu, "VectorLength", 'L');
        this.addMenuItem(vectorLengthMenu, "BLANK", "Unit", 'U', -1, this.graphics);
        this.addMenuItem(vectorLengthMenu, "BLANK", "Relative", 'R', -1, this.graphics);
        this.addMenuItem(vectorLengthMenu, "BLANK", "Absolute", 'A', -1, this.graphics);
        displayMenu.addSeparator();
        this.addMenuItem(displayMenu, "BLANK", "Fill", 'F', -1, this.graphics);
        this.addMenuItem(displayMenu, "BLANK", "Points", 'P', -1, this.graphics);
        this.addMenuItem(displayMenu, "BLANK", "Lines", 'I', -1, this.graphics);
        displayMenu.addSeparator();
        this.addMenuItem(displayMenu, "settings", "Preferences", 'P', -1, this.graphics);
        this.addMenuItem(colorMenu, "BLANK", "Monochrome", 'M', -1, this.graphics);
        this.addMenuItem(colorMenu, "BLANK", "CPK", 'C', -1, this.graphics);
        this.addMenuItem(colorMenu, "BLANK", "Residue", 'R', -1, this.graphics);
        this.addMenuItem(colorMenu, "BLANK", "Structure", 'S', -1, this.graphics);
        this.addMenuItem(colorMenu, "BLANK", "Polymer", 'M', -1, this.graphics);
        this.addMenuItem(colorMenu, "BLANK", "PartialCharge", 'P', -1, this.graphics);
        this.addMenuItem(colorMenu, "BLANK", "VectorMagnitude", 'V', -1, this.graphics);
        this.addMenuItem(colorMenu, "BLANK", "UserColor", 'U', -1, this.graphics);
        colorMenu.addSeparator();
        this.addMenuItem(colorMenu, "BLANK", "ApplyUserColor", 'A', -1, this.graphics);
        this.addMenuItem(colorMenu, "BLANK", "SetUserColor", 'C', -1, this.graphics);
        this.dragModeButtonGroup = new ButtonGroup();
        this.activeRBMI = this.addBGMI(this.dragModeButtonGroup, optionsMenu, "active", "ActiveSystem", 'A', 65, this.graphics);
        this.mouseRBMI = this.addBGMI(this.dragModeButtonGroup, optionsMenu, "mouse", "SystemBelowMouse", 'S', 77, this.graphics);
        this.activeRBMI.setSelected(true);
        optionsMenu.addSeparator();
        JMenu leftMouseMenu = this.addSubMenu(optionsMenu, "LeftMouseButton", 'M');
        this.leftMouseButtonGroup = new ButtonGroup();
        this.rotateRBMI = this.addBGMI(this.leftMouseButtonGroup, leftMouseMenu, "BLANK", "Rotate", 'R', 82, this.graphics);
        this.translateRBMI = this.addBGMI(this.leftMouseButtonGroup, leftMouseMenu, "BLANK", "Translate", 'T', 84, this.graphics);
        this.zoomRBMI = this.addBGMI(this.leftMouseButtonGroup, leftMouseMenu, "BLANK", "Zoom", 'Z', 90, this.graphics);
        this.rotateRBMI.setSelected(true);
        optionsMenu.addSeparator();
        this.addMenuItem(optionsMenu, "BLANK", "ResetRotation", 'R', -1, this.graphics);
        this.addMenuItem(optionsMenu, "BLANK", "ResetTranslation", 'T', -1, this.graphics);
        this.addMenuItem(optionsMenu, "BLANK", "ResetRotationAndTranslation", 'E', -1, this.graphics);
        this.addMenuItem(optionsMenu, "BLANK", "RotateAboutCenter", 'C', 67, this.graphics);
        this.addMenuItem(optionsMenu, "BLANK", "RotateAboutPick", 'P', 80, this.graphics);
        optionsMenu.addSeparator();
        this.addMenuItem(optionsMenu, "BLANK", "ResetGlobalRotation", 'N', -1, this.graphics);
        this.addMenuItem(optionsMenu, "BLANK", "ResetGlobalTranslation", 'O', -1, this.graphics);
        this.addMenuItem(optionsMenu, "BLANK", "ResetGlobalZoom", 'Z', -1, this.graphics);
        this.addMenuItem(optionsMenu, "globalReset", "ResetGlobalView", 'V', -1, this.graphics);
        optionsMenu.addSeparator();
        this.addMenuItem(optionsMenu, "fullScreen", "FullScreen", 'F', 70, this.graphics);
        this.addMenuItem(optionsMenu, "background", "SetBackgroundColor", 'S', -1, this.graphics);
        this.levelBG = new ButtonGroup();
        this.pickingCBMI = this.addCBMenuItem(pickingMenu, "picking", "GraphicsPicking", 'G', 48, this.graphics);
        this.pickingCBMI.setSelected(false);
        pickingMenu.addSeparator();
        this.atomRBMI = this.addBGMI(this.levelBG, pickingMenu, "BLANK", "PickAtom", 'A', 49, this.graphics);
        this.bondRBMI = this.addBGMI(this.levelBG, pickingMenu, "BLANK", "PickBond", 'B', 50, this.graphics);
        this.angleRBMI = this.addBGMI(this.levelBG, pickingMenu, "BLANK", "PickAngle", 'N', 51, this.graphics);
        this.dihedralRBMI = this.addBGMI(this.levelBG, pickingMenu, "BLANK", "PickDihedral", 'D', 52, this.graphics);
        this.residueRBMI = this.addBGMI(this.levelBG, pickingMenu, "BLANK", "PickResidue", 'R', 53, this.graphics);
        this.polymerRBMI = this.addBGMI(this.levelBG, pickingMenu, "BLANK", "PickPolymer", 'P', 54, this.graphics);
        this.moleculeRBMI = this.addBGMI(this.levelBG, pickingMenu, "BLANK", "PickMolecule", 'M', 55, this.graphics);
        this.systemRBMI = this.addBGMI(this.levelBG, pickingMenu, "BLANK", "PickSystem", 'S', 56, this.graphics);
        pickingMenu.addSeparator();
        this.measureDistanceRBMI = this.addBGMI(this.levelBG, pickingMenu, "BLANK", "MeasureDistance", 'I', -1, this.graphics);
        this.measureAngleRBMI = this.addBGMI(this.levelBG, pickingMenu, "BLANK", "MeasureAngle", 'L', -1, this.graphics);
        this.measureDihedralRBMI = this.addBGMI(this.levelBG, pickingMenu, "BLANK", "MeasureDihedral", 'H', -1, this.graphics);
        this.atomRBMI.setSelected(true);
        pickingMenu.addSeparator();
        this.addMenuItem(pickingMenu, "color", "SetGraphicsPickingColor", 'S', -1, this.graphics);
        this.oscillateCBMI = this.addCBMenuItem(trajectoryMenu, "oscillate", "Oscillate", 'O', -1, this.mainPanel);
        this.oscillateCBMI.setSelected(false);
        this.addMenuItem(trajectoryMenu, "BLANK", "Frame", 'A', -1, this.mainPanel);
        this.addMenuItem(trajectoryMenu, "BLANK", "Speed", 'E', -1, this.mainPanel);
        this.addMenuItem(trajectoryMenu, "BLANK", "Skip", 'K', -1, this.mainPanel);
        trajectoryMenu.addSeparator();
        this.addMenuItem(trajectoryMenu, "play", "Play", 'P', -1, this.mainPanel);
        this.addMenuItem(trajectoryMenu, "stop", "Stop", 'S', -1, this.mainPanel);
        this.addMenuItem(trajectoryMenu, "forward", "StepForward", 'F', -1, this.mainPanel);
        this.addMenuItem(trajectoryMenu, "back", "StepBack", 'B', -1, this.mainPanel);
        this.addMenuItem(trajectoryMenu, "start", "Reset", 'R', -1, this.mainPanel);
        this.releaseMI = this.addMenuItem(simulationMenu, "release", "ReleaseJob", 'E', -1, this.mainPanel);
        this.localMI = this.addMenuItem(simulationMenu, "local", "ConnectToLocalJob", 'L', 76, this.mainPanel);
        simulationMenu.addSeparator();
        this.remoteMI = this.addMenuItem(simulationMenu, "network", "ConnectToRemoteJob", 'R', -1, this.mainPanel);
        this.addMenuItem(simulationMenu, "BLANK", "SetRemoteJobAddress", 'A', -1, this.mainPanel);
        simulationMenu.addSeparator();
        this.addMenuItem(simulationMenu, "BLANK", "SetPort", 'P', -1, this.mainPanel);
        this.addMenuItem(exportMenu, "capture", "CaptureGraphics", 'C', 71, this.graphics);
        exportMenu.addSeparator();
        this.captureFormatButtonGroup = new ButtonGroup();
        this.addBGMI(this.captureFormatButtonGroup, exportMenu, "BLANK", "PNG", 'P', -1, this.graphics).setSelected(true);
        this.addBGMI(this.captureFormatButtonGroup, exportMenu, "BLANK", "JPEG", 'J', -1, this.graphics);
        this.addBGMI(this.captureFormatButtonGroup, exportMenu, "BLANK", "BMP", 'B', -1, this.graphics);
        this.addBGMI(this.captureFormatButtonGroup, exportMenu, "BLANK", "WBMP", 'W', -1, this.graphics);
        this.addBGMI(this.captureFormatButtonGroup, exportMenu, "BLANK", "GIF", 'G', -1, this.graphics);
        this.addMenuItem(windowMenu, "resetPanes", "ResetPanes", 'R', -1, this.mainPanel);
        windowMenu.addSeparator();
        this.systemsCBMI = this.addCBMenuItem(windowMenu, "active", "ShowTree", 'T', -1, this.mainPanel);
        this.toolBarCBMI = this.addCBMenuItem(windowMenu, "showToolBar", "ShowToolBar", 'B', -1, this.mainPanel);
        this.globalAxisCBMI = this.addCBMenuItem(windowMenu, "BLANK", "ShowGlobalAxes", 'C', -1, this.mainPanel);
        this.addMenuItem(windowMenu, "refresh", "ResetConsole", 'L', -1, this.mainPanel);
        this.globalAxisCBMI.setSelected(true);
        windowMenu.addSeparator();
        this.skinButtonGroup = new ButtonGroup();
        this.javaRBMI = this.addBGMI(this.skinButtonGroup, windowMenu, "java", "OceanLookAndFeel", 'J', -1, this.mainPanel);
        if (!SystemUtils.IS_OS_LINUX && !SystemUtils.IS_OS_MAC && SystemUtils.IS_OS_WINDOWS) {
            this.nativeRBMI = this.addBGMI(this.skinButtonGroup, windowMenu, "win", "WindowsLookAndFeel", 'W', -1, this.mainPanel);
            this.javaRBMI.setSelected(true);
        }
        this.toolBar = new JToolBar("Toolbar", 0);
        this.toolBar.setBorderPainted(false);
        this.toolBar.setRollover(true);
        JButton temp = new JButton();
        this.insets = temp.getInsets();
        this.insets.set(0, 0, 0, 0);
        this.addButton("open2", this.mainPanel, "Open", "Open");
        this.addButton("saveAs2", this.mainPanel, "SaveAs", "Save As");
        this.addButton("close2", this.mainPanel, "Close", "Close");
        this.toolBar.addSeparator();
        this.addButton("highlight2", this.mainPanel, "HighlightSelections", "Highlight");
        this.toolBar.addSeparator();
        this.addButton("globalReset2", this.graphics, "ResetGlobalView", "Reset");
        this.addButton("zoomOut2", this.graphics, "ZoomOut", "Out");
        this.addButton("zoomIn2", this.graphics, "ZoomIn", "In");
        this.toolBar.addSeparator();
        this.addButton("picking2", this.graphics, "GraphicsPicking", "Pick");
        this.toolBar.addSeparator();
        this.addButton("forward2", this.mainPanel, "StepForward", "Forward");
        this.addButton("play2", this.mainPanel, "Play", "Play");
        this.addButton("stop2", this.mainPanel, "Stop", "Stop");
        this.addButton("back2", this.mainPanel, "StepBack", "Back");
        this.addButton("start2", this.mainPanel, "Reset", "Reset");
        this.toolBar.addSeparator();
        this.addButton("local2", this.mainPanel, "ConnectToLocalJob", "Local");
        this.addButton("network2", this.mainPanel, "ConnectToRemoteJob", "Remote");
        this.addButton("release2", this.mainPanel, "ReleaseJob", "Release");
        this.toolBar.addSeparator();
        this.addButton("capture2", this.graphics, "CaptureGraphics", "Capture");
        this.addButton("left2", this.mainPanel, "ExpandGraphicsWindow", "Left");
        this.addButton("right2", this.mainPanel, "ShrinkGraphicsWindow", "Right");
    }

    private JRadioButtonMenuItem addBGMI(ButtonGroup buttonGroup, JMenu menu, String icon, String actionCommand, char mnemonic, int accelerator, ActionListener actionListener) {
        ImageIcon imageIcon = null;
        imageIcon = icon != "BLANK" ? new ImageIcon(this.loader.getResource("ffe/icons/" + icon + ".png")) : this.blankIcon;
        JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(this.locale.getValue(actionCommand), imageIcon);
        menuItem.setActionCommand(actionCommand);
        buttonGroup.add(menuItem);
        menu.add(menuItem);
        this.setMenuOptions(menuItem, mnemonic, accelerator, actionListener);
        return menuItem;
    }

    private void addButton(String icon, ActionListener al, String actionCommand) {
        ImageIcon imageIcon = null;
        imageIcon = icon != "BLANK" ? new ImageIcon(this.loader.getResource("ffe/icons/" + icon + ".png")) : this.blankIcon;
        JButton button = new JButton(imageIcon);
        this.toolBar.add(button);
        button.addActionListener(al);
        button.setFont(new Font("Arial", 0, 8));
        button.setVerticalTextPosition(3);
        button.setHorizontalTextPosition(0);
        button.setBorderPainted(false);
        button.setOpaque(false);
        button.setActionCommand(actionCommand);
        button.setToolTipText(this.locale.getValue(actionCommand));
    }

    private void addButton(String icon, ActionListener al, String actionCommand, String helpText) {
        ImageIcon imageIcon = null;
        imageIcon = icon != "BLANK" ? new ImageIcon(this.loader.getResource("ffe/icons/" + icon + ".png")) : this.blankIcon;
        JButton button = new JButton(imageIcon);
        this.toolBar.add(button);
        button.addActionListener(al);
        button.setText(helpText);
        button.setFont(new Font("Arial", 0, 8));
        button.setVerticalTextPosition(3);
        button.setHorizontalTextPosition(0);
        button.setBorderPainted(false);
        button.setOpaque(false);
        button.setActionCommand(actionCommand);
        button.setToolTipText(this.locale.getValue(actionCommand));
    }

    private JCheckBoxMenuItem addCBMenuItem(JMenu menu, String icon, String actionCommand, char mnemonic, int accelerator, ActionListener actionListener) {
        ImageIcon imageIcon = null;
        imageIcon = icon != "BLANK" ? new ImageIcon(this.loader.getResource("ffe/icons/" + icon + ".png")) : this.blankIcon;
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(this.locale.getValue(actionCommand), imageIcon);
        menuItem.setActionCommand(actionCommand);
        menu.add(menuItem);
        this.setMenuOptions(menuItem, mnemonic, accelerator, actionListener);
        return menuItem;
    }

    private JMenu addMenu(String name, char mnemonic) {
        JMenu menu = new JMenu(this.locale.getValue(name));
        this.add(menu);
        if (mnemonic != '.') {
            menu.setMnemonic(mnemonic);
        }
        return menu;
    }

    private JMenuItem addMenuItem(JMenu menu, String icon, String actionCommand, char mnemonic, int accelerator, ActionListener actionListener) {
        ImageIcon imageIcon = null;
        imageIcon = icon != "BLANK" ? new ImageIcon(this.loader.getResource("ffe/icons/" + icon + ".png")) : this.blankIcon;
        JMenuItem menuItem = new JMenuItem(this.locale.getValue(actionCommand), imageIcon);
        menuItem.setActionCommand(actionCommand);
        menu.add(menuItem);
        this.setMenuOptions(menuItem, mnemonic, accelerator, actionListener);
        return menuItem;
    }

    private JMenu addSubMenu(JMenu parent, String name, char mnemonic) {
        JMenu menu = new JMenu(this.locale.getValue(name));
        parent.add(menu);
        if (mnemonic != '.') {
            menu.setMnemonic(mnemonic);
        }
        menu.setIcon(this.blankIcon);
        return menu;
    }

    public boolean getHighlighting() {
        return this.highlightCBMI.isSelected();
    }

    public GraphicsCanvas.MouseMode getMouseMode() {
        if (this.activeRBMI.isSelected()) {
            return GraphicsCanvas.MouseMode.ACTIVESYSTEM;
        }
        return GraphicsCanvas.MouseMode.SYSTEMBELOWMOUSE;
    }

    public boolean getPicking() {
        return this.pickingCBMI.isSelected();
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public boolean isAxisShowing() {
        return this.globalAxisCBMI.isSelected();
    }

    public boolean isMenuShowing() {
        return this.toolBarCBMI.isSelected();
    }

    public boolean isPickingActive() {
        return this.pickingCBMI.isSelected();
    }

    public boolean isSystemShowing() {
        return this.systemsCBMI.isSelected();
    }

    public void menuClick() {
        this.toolBarCBMI.doClick();
    }

    public void setAtomLabels(boolean b) {
        this.labelAtomsMI.setSelected(b);
    }

    public void setAxisShowing(boolean b) {
        this.globalAxisCBMI.setSelected(b);
    }

    public void setConnect(boolean b) {
        this.localMI.setEnabled(b);
        this.remoteMI.setEnabled(b);
        this.releaseMI.setEnabled(!b);
    }

    public void setHighlighting(boolean h) {
        this.highlightCBMI.setSelected(h);
    }

    private void setMenuOptions(JMenuItem menuItem, char mnemonic, int accelerator, ActionListener actionListener) {
        if (mnemonic != '.' && !SystemUtils.IS_OS_MAC) {
            menuItem.setMnemonic(mnemonic);
        }
        if (accelerator != -1) {
            menuItem.setAccelerator(KeyStroke.getKeyStroke(accelerator, keyMask));
        }
        if (actionListener != null) {
            menuItem.addActionListener(actionListener);
        }
    }

    public void setMenuShowing(boolean b) {
        this.toolBarCBMI.setSelected(b);
    }

    public void setMouseMode(GraphicsCanvas.MouseMode m) {
        if (m == GraphicsCanvas.MouseMode.ACTIVESYSTEM) {
            this.activeRBMI.doClick();
        } else {
            this.mouseRBMI.doClick();
        }
    }

    public void setPickBehavior(boolean pick) {
        this.pickingCBMI.setSelected(pick);
    }

    public void setPickLevel(String arg) {
        if (arg.equals("PickAtom")) {
            this.atomRBMI.doClick();
        } else if (arg.equals("PickBond")) {
            this.bondRBMI.doClick();
        } else if (arg.equals("PickAngle")) {
            this.angleRBMI.doClick();
        } else if (arg.equals("PickDihedral")) {
            this.dihedralRBMI.doClick();
        } else if (arg.equals("PickResidue")) {
            this.residueRBMI.doClick();
        } else if (arg.equals("PickPolymer")) {
            this.polymerRBMI.doClick();
        } else if (arg.equals("PickMolecule")) {
            this.moleculeRBMI.doClick();
        } else if (arg.equals("PickSystem")) {
            this.systemRBMI.doClick();
        } else if (arg.equals("MeasureDistance")) {
            this.measureDistanceRBMI.doClick();
        } else if (arg.equals("MeasureAngle")) {
            this.measureAngleRBMI.doClick();
        } else if (arg.equals("MeasureDihedral")) {
            this.measureDihedralRBMI.doClick();
        }
    }

    public void setResidueLabels(boolean b) {
        this.labelResiduesMI.setSelected(b);
    }

    public void setSystemShowing(boolean b) {
        this.systemsCBMI.setSelected(b);
    }

    public void systemClick() {
        this.systemsCBMI.doClick();
    }
}

