/*
 * Decompiled with CFR 0.152.
 */
package ffe.core;

import ffe.core.MainPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;

public class LogPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private Logger logger = Logger.getLogger("ffe");
    private MainPanel mainPanel;
    private Vector<Thread> tinkerThreads;
    private Hashtable<String, JTextArea> logFiles = new Hashtable();
    private JToolBar toolBar;
    private JTabbedPane resultsTabbedPane = new JTabbedPane(3);
    private JProgressBar statusProgressBar;
    private JLabel status = new JLabel("  ");
    private Font font;
    private JLabel noLogsLabel = new JLabel("Tinker logs are displayed here");
    private JPanel noLogsPanel = new JPanel(new FlowLayout(0, 5, 5));
    EtchedBorder eb = new EtchedBorder(0);

    public LogPanel(MainPanel f) {
        this.mainPanel = f;
        this.tinkerThreads = this.mainPanel.getModelingPanel().getModelingJobs();
        this.initToolBar();
        this.setLayout(new BorderLayout());
        Border eb = BorderFactory.createEtchedBorder(0);
        this.statusProgressBar = new JProgressBar();
        this.statusProgressBar.setBorder(eb);
        this.statusProgressBar.setStringPainted(true);
        ClassLoader loader = this.getClass().getClassLoader();
        ImageIcon icon = new ImageIcon(loader.getResource("ffe/icons/data.png"));
        this.noLogsLabel.setIcon(icon);
        this.noLogsPanel.add(this.noLogsLabel);
        this.noLogsPanel.setBorder(eb);
        this.status.setBorder(eb);
        this.add((Component)this.toolBar, "North");
        this.add((Component)this.noLogsPanel, "Center");
        this.add((Component)this.status, "South");
        this.font = Font.decode("Monospaced");
        this.refreshStatus();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() instanceof Timer) {
            if (this.resultsTabbedPane.getTabCount() > 0) {
                this.refresh();
            }
            return;
        }
        String arg = evt.getActionCommand();
        if (arg == null) {
            return;
        }
        if (arg.equalsIgnoreCase("Refresh")) {
            this.refresh();
        } else if (arg.equalsIgnoreCase("Close")) {
            this.close();
        } else if (arg.equalsIgnoreCase("Close All")) {
            this.closeAll();
        } else if (arg.equalsIgnoreCase("Open...")) {
            JFileChooser d = MainPanel.getFileChooser();
            d.setAcceptAllFileFilterUsed(true);
            d.setDialogTitle("Open Log File");
            int result = d.showOpenDialog(this);
            if (result == 0) {
                File f = d.getSelectedFile();
                this.addPane(f);
            }
        } else if (arg.equalsIgnoreCase("Save")) {
            this.saveSelected();
        } else if (arg.equalsIgnoreCase("Save As...")) {
            this.saveSelectedAs();
        }
    }

    private void addPane(File logFile) {
        if (!logFile.exists()) {
            return;
        }
        JTextArea logTextArea = new JTextArea();
        logTextArea.setEditable(logFile.canWrite());
        logTextArea.setFont(this.font);
        this.logFiles.put(logFile.getAbsolutePath(), logTextArea);
        JScrollPane scrollPane = new JScrollPane(logTextArea, 22, 32);
        scrollPane.setBorder(this.eb);
        this.resultsTabbedPane.add((Component)scrollPane, logFile.getAbsolutePath());
        this.resultsTabbedPane.setSelectedIndex(this.resultsTabbedPane.getComponentCount() - 1);
        if (this.resultsTabbedPane.getComponentCount() == 1) {
            this.remove(this.noLogsPanel);
            this.add((Component)this.resultsTabbedPane, "Center");
            this.validate();
            this.repaint();
        }
        this.loadText(logTextArea, logFile);
    }

    public void close() {
        int index = this.resultsTabbedPane.getSelectedIndex();
        if (index >= 0) {
            String title = this.resultsTabbedPane.getTitleAt(index);
            this.resultsTabbedPane.remove(index);
            this.logFiles.remove(title);
            for (Thread t : this.tinkerThreads) {
                String name = t.getName();
                if (!name.equals(title)) continue;
                this.tinkerThreads.remove(t);
                break;
            }
            if (this.resultsTabbedPane.getComponentCount() == 0) {
                this.remove(this.resultsTabbedPane);
                this.add((Component)this.noLogsPanel, "Center");
            }
            this.validate();
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(String file) {
        LogPanel logPanel = this;
        synchronized (logPanel) {
            int index = -1;
            for (int i = 0; i < this.resultsTabbedPane.getTabCount(); ++i) {
                String title = this.resultsTabbedPane.getTitleAt(i);
                if (!file.equals(title)) continue;
                index = i;
                break;
            }
            if (index < 0) {
                return;
            }
            String title = this.resultsTabbedPane.getTitleAt(index);
            this.resultsTabbedPane.remove(index);
            this.logFiles.remove(title);
            for (Thread t : this.tinkerThreads) {
                String name = t.getName();
                if (!name.equals(title)) continue;
                this.tinkerThreads.remove(t);
                break;
            }
            if (this.resultsTabbedPane.getComponentCount() == 0) {
                this.remove(this.resultsTabbedPane);
                this.add((Component)this.noLogsPanel, "Center");
            }
            this.validate();
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() {
        LogPanel logPanel = this;
        synchronized (logPanel) {
            this.resultsTabbedPane.removeAll();
            this.logFiles.clear();
            this.tinkerThreads.clear();
        }
    }

    public JProgressBar getProgressBar() {
        return this.statusProgressBar;
    }

    private void initToolBar() {
        this.toolBar = new JToolBar("Results");
        this.toolBar.setLayout(new FlowLayout(0));
        JButton jbrefresh = new JButton(new ImageIcon(this.getClass().getClassLoader().getResource("ffe/icons/refresh.png")));
        jbrefresh.setActionCommand("Refresh");
        jbrefresh.setToolTipText("Refresh the Logs Panel");
        jbrefresh.addActionListener(this);
        jbrefresh.setBorderPainted(false);
        Insets insets = jbrefresh.getInsets();
        insets.top = 2;
        insets.bottom = 2;
        insets.left = 2;
        insets.right = 2;
        jbrefresh.setMargin(insets);
        this.toolBar.add(jbrefresh);
        this.toolBar.addSeparator();
        JButton jbopen = new JButton(new ImageIcon(this.getClass().getClassLoader().getResource("ffe/icons/open.png")));
        jbopen.setActionCommand("Open...");
        jbopen.setToolTipText("Open any Text File");
        jbopen.addActionListener(this);
        jbopen.setBorderPainted(false);
        jbopen.setMargin(insets);
        this.toolBar.add(jbopen);
        JButton jbsave = new JButton(new ImageIcon(this.getClass().getClassLoader().getResource("ffe/icons/save.png")));
        jbsave.setActionCommand("Save");
        jbsave.setToolTipText("Save the Active File");
        jbsave.addActionListener(this);
        jbsave.setBorderPainted(false);
        jbsave.setMargin(insets);
        this.toolBar.add(jbsave);
        JButton jbsaveas = new JButton(new ImageIcon(this.getClass().getClassLoader().getResource("ffe/icons/saveAs.png")));
        jbsaveas.setActionCommand("Save As...");
        jbsaveas.setToolTipText("Save the Active Text File Under a New Name");
        jbsaveas.addActionListener(this);
        jbsaveas.setBorderPainted(false);
        jbsaveas.setMargin(insets);
        this.toolBar.add(jbsaveas);
        JButton jbclose = new JButton(new ImageIcon(this.getClass().getClassLoader().getResource("ffe/icons/close.png")));
        jbclose.setActionCommand("Close");
        jbclose.setToolTipText("Close the Active Text File");
        jbclose.addActionListener(this);
        jbclose.setBorderPainted(false);
        jbclose.setMargin(insets);
        this.toolBar.add(jbclose);
        JButton jbcloseall = new JButton(new ImageIcon(this.getClass().getClassLoader().getResource("ffe/icons/closeAll.png")));
        jbcloseall.setActionCommand("Close All");
        jbcloseall.setToolTipText("Close All Open Text Files");
        jbcloseall.addActionListener(this);
        jbcloseall.setBorderPainted(false);
        jbcloseall.setMargin(insets);
        this.toolBar.add(jbcloseall);
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.toolBar.setOrientation(0);
    }

    private void loadText(JTextArea logTextArea, File logFile) {
        if (logTextArea == null || !logFile.exists() || !logFile.canRead()) {
            return;
        }
        logTextArea.setText("");
        try {
            FileInputStream inputStream = new FileInputStream(logFile);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while (bufferedReader.ready()) {
                logTextArea.append(bufferedReader.readLine() + "\n");
            }
            bufferedReader.close();
            inputStream.close();
        }
        catch (IOException e) {
            this.logger.severe(String.valueOf(e));
        }
        this.mainPanel.setPanel(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Vector<Thread> vector = this.tinkerThreads;
        synchronized (vector) {
            for (Thread t : this.tinkerThreads) {
                File file = new File(t.getName());
                if (!file.exists()) continue;
                if (this.logFiles.containsKey(file.getAbsolutePath())) {
                    JTextArea ta = this.logFiles.get(file.getAbsolutePath());
                    this.loadText(ta, file);
                    continue;
                }
                this.addPane(file);
            }
        }
        this.refreshStatus();
        this.validate();
        this.repaint();
    }

    public void refreshStatus() {
        int count = this.tinkerThreads.size();
        if (count == 0) {
            this.statusProgressBar.setString("");
            this.statusProgressBar.setIndeterminate(false);
        } else if (count == 1) {
            this.statusProgressBar.setString("1 Job Running");
            this.statusProgressBar.setIndeterminate(true);
        } else {
            this.statusProgressBar.setString(count + " Jobs Running");
            this.statusProgressBar.setIndeterminate(true);
        }
    }

    private void saveSelected() {
        int index = this.resultsTabbedPane.getSelectedIndex();
        if (index < 0) {
            return;
        }
        String title = this.resultsTabbedPane.getTitleAt(index);
        JTextArea logTextArea = this.logFiles.get(title);
        File logFile = new File(title);
        if (logTextArea != null && logFile.exists() && logFile.canWrite()) {
            try {
                FileOutputStream outputStream = new FileOutputStream(logFile);
                BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(outputStream));
                bw.write(logTextArea.getText());
                bw.close();
                outputStream.close();
            }
            catch (IOException e) {
                this.logger.severe(String.valueOf(e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSelectedAs() {
        JTabbedPane jTabbedPane = this.resultsTabbedPane;
        synchronized (jTabbedPane) {
            int index = this.resultsTabbedPane.getSelectedIndex();
            if (index < 0) {
                return;
            }
            String title = this.resultsTabbedPane.getTitleAt(index);
            JTextArea logTextArea = this.logFiles.get(title);
            File logFile = new File(title);
            if (logTextArea != null && logFile.exists() && logFile.canWrite()) {
                JFileChooser fileChooser = MainPanel.getFileChooser();
                fileChooser.setSelectedFile(logFile);
                fileChooser.setAcceptAllFileFilterUsed(true);
                int result = fileChooser.showSaveDialog(this);
                if (result != 0) {
                    return;
                }
                logFile = fileChooser.getSelectedFile();
                try {
                    this.logFiles.remove(title);
                    FileOutputStream outputStream = new FileOutputStream(logFile);
                    BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(outputStream));
                    bw.write(logTextArea.getText());
                    bw.close();
                    outputStream.close();
                    this.resultsTabbedPane.setTitleAt(index, logFile.getAbsolutePath());
                    this.logFiles.put(logFile.getAbsolutePath(), logTextArea);
                }
                catch (IOException e) {
                    this.logger.severe(String.valueOf(e));
                }
            }
        }
    }

    public void selected() {
        this.validate();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDone(String logFileName) {
        LogPanel logPanel = this;
        synchronized (logPanel) {
            if (logFileName == null) {
                return;
            }
            File logFile = new File(logFileName);
            for (Thread thread : this.tinkerThreads) {
                String jobName = thread.getName();
                if (!jobName.equals(logFileName)) continue;
                this.tinkerThreads.remove(thread);
                break;
            }
            if (!logFile.exists()) {
                return;
            }
            if (this.logFiles.containsKey(logFile.getAbsolutePath())) {
                JTextArea logTextArea = this.logFiles.get(logFile.getAbsolutePath());
                this.loadText(logTextArea, logFile);
            } else {
                this.addPane(logFile);
            }
            this.resultsTabbedPane.setSelectedIndex(this.resultsTabbedPane.indexOfTab(logFile.getAbsolutePath()));
            this.refreshStatus();
        }
    }

    @Override
    public String toString() {
        return "Logging";
    }
}

